/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.tutorial;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CommDirectoryEntryAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyIntel;
import com.fs.starfarer.api.impl.campaign.intel.SystemBountyManager;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.submarkets.StoragePlugin;
import com.fs.starfarer.api.impl.campaign.tutorial.GalatianAcademyStipend;
import com.fs.starfarer.api.impl.campaign.tutorial.RogueMinerMiscFleetManager;
import com.fs.starfarer.api.impl.campaign.tutorial.SaveNagScript;
import com.fs.starfarer.api.impl.campaign.tutorial.TutorialLeashAssignmentAI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.ui.HintPanelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class TutorialMissionIntel
extends BaseIntelPlugin
implements EveryFrameScript {
    public static final String TUT_STAGE = "$tutStage";
    public static final String REASON = "tut";
    protected float elapsedDays = 0.0f;
    protected StarSystemAPI system;
    protected PlanetAPI ancyra;
    protected PlanetAPI pontus;
    protected PlanetAPI tetra;
    protected SectorEntityToken derinkuyu;
    protected SectorEntityToken probe;
    protected SectorEntityToken inner;
    protected SectorEntityToken fringe;
    protected SectorEntityToken detachment;
    protected SectorEntityToken relay;
    protected PersonAPI mainContact;
    protected PersonAPI dataContact;
    protected PersonAPI jangalaContact;
    protected PlanetAPI jangala;
    protected FactionAPI faction;
    protected TutorialMissionStage stage = TutorialMissionStage.INIT;
    protected int preRecoverFleetSize = 2;

    public static boolean isTutorialInProgress() {
        return Global.getSector().getMemoryWithoutUpdate().contains("$tutorialRespawn");
    }

    public TutorialMissionIntel() {
        this.faction = Global.getSector().getFaction("hegemony");
        this.system = Global.getSector().getStarSystem("galatia");
        this.ancyra = (PlanetAPI)this.system.getEntityById("ancyra");
        this.pontus = (PlanetAPI)this.system.getEntityById("pontus");
        this.tetra = (PlanetAPI)this.system.getEntityById("tetra");
        this.derinkuyu = this.system.getEntityById("derinkuyu_station");
        this.probe = this.system.getEntityById("galatia_probe");
        this.inner = this.system.getEntityById("galatia_jump_point_alpha");
        this.fringe = this.system.getEntityById("galatia_jump_point_fringe");
        this.detachment = this.system.getEntityById("tutorial_security_detachment");
        this.relay = this.system.getEntityById("ancyra_relay");
        this.mainContact = TutorialMissionIntel.createMainContact(this.ancyra);
        this.dataContact = Global.getSector().getFaction("independent").createRandomPerson();
        this.dataContact.setRankId(Ranks.AGENT);
        this.dataContact.setPostId(Ranks.POST_AGENT);
        this.derinkuyu.getMarket().getCommDirectory().addPerson(this.dataContact);
        this.mainContact.getMemoryWithoutUpdate().set("$tut_mainContact", true);
        this.mainContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
        Misc.makeImportant(this.mainContact, REASON);
        Global.getSector().getMemoryWithoutUpdate().set("$tut_jangalaContactName", this.mainContact.getNameString());
        this.updateStage(TutorialMissionStage.INIT, null);
        this.setImportant(true);
        Global.getSector().getIntelManager().addIntel(this);
        Global.getSector().addScript(this);
    }

    public static PersonAPI createMainContact(PlanetAPI ancyra) {
        PersonAPI mainContact = ancyra.getFaction().createRandomPerson();
        mainContact.setRankId(Ranks.CITIZEN);
        mainContact.setPostId(Ranks.POST_STATION_COMMANDER);
        ancyra.getMarket().getCommDirectory().addPerson(mainContact);
        ancyra.getMarket().addPerson(mainContact);
        return mainContact;
    }

    public static PersonAPI getJangalaContact() {
        StarSystemAPI corvus = Global.getSector().getStarSystem("Corvus");
        PlanetAPI jangala = (PlanetAPI)corvus.getEntityById("jangala");
        for (CommDirectoryEntryAPI entry : jangala.getMarket().getCommDirectory().getEntriesCopy()) {
            PersonAPI curr;
            if (entry.getType() != CommDirectoryEntryAPI.EntryType.PERSON || !(entry.getEntryData() instanceof PersonAPI) || !Ranks.POST_STATION_COMMANDER.equals((curr = (PersonAPI)entry.getEntryData()).getPostId())) continue;
            return curr;
        }
        return null;
    }

    public PersonAPI getMainContact() {
        return this.mainContact;
    }

    protected void updateStage(TutorialMissionStage stage, TextPanelAPI text) {
        this.stage = stage;
        Global.getSector().getMemoryWithoutUpdate().set(TUT_STAGE, stage.name());
        if (stage != TutorialMissionStage.INIT) {
            this.sendUpdateIfPlayerHasIntel((Object)stage, text);
        }
    }

    protected void endEvent() {
        this.endAfterDelay();
        Global.getSector().getMemoryWithoutUpdate().unset(TUT_STAGE);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
        Global.getSector().removeScript(this);
    }

    @Override
    protected void advanceImpl(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return;
        }
        this.elapsedDays += days;
        if (this.probe == null) {
            this.probe = this.system.getEntityById("galatia_probe");
        }
        if (this.tetra == null) {
            this.tetra = (PlanetAPI)this.system.getEntityById("tetra");
        }
        if (this.derinkuyu == null) {
            this.derinkuyu = this.system.getEntityById("derinkuyu_station");
        }
        if (this.inner == null) {
            this.inner = this.system.getEntityById("galatia_jump_point_alpha");
        }
        if (this.fringe == null) {
            this.fringe = this.system.getEntityById("galatia_jump_point_fringe");
        }
        if (this.detachment == null) {
            this.detachment = this.system.getEntityById("tutorial_security_detachment");
        }
        if (this.stage == TutorialMissionStage.GO_GET_AI_CORE) {
            int cores = (int)player.getCargo().getCommodityQuantity("gamma_core");
            float distToProbe = Misc.getDistance(player.getLocation(), this.probe.getLocation());
            if (cores > 0 && (!this.probe.isAlive() || distToProbe < 300.0f)) {
                Misc.makeImportant(this.mainContact, REASON);
                this.updateStage(TutorialMissionStage.GOT_AI_CORE, null);
            }
        }
        if (this.stage == TutorialMissionStage.GO_RECOVER_SHIPS) {
            int count = 0;
            for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
                ++count;
            }
            int wrecks = 0;
            for (SectorEntityToken entity : this.system.getEntitiesWithTag("salvageable")) {
                String id = entity.getCustomEntityType();
                if (id == null || !"wreck".equals(id)) continue;
                ++wrecks;
            }
            if (count >= this.preRecoverFleetSize + 2 || wrecks < 3) {
                Misc.makeImportant(this.mainContact, REASON);
                Misc.makeUnimportant(this.tetra, REASON);
                this.updateStage(TutorialMissionStage.RECOVERED_SHIPS, null);
            }
        }
        if (this.stage == TutorialMissionStage.GO_STABILIZE) {
            boolean fringeStable;
            boolean innerStable = this.inner.getMemoryWithoutUpdate().getExpire("$unstable") > 0.0f;
            boolean bl = fringeStable = this.fringe.getMemoryWithoutUpdate().getExpire("$unstable") > 0.0f;
            if (innerStable || fringeStable) {
                Misc.makeImportant(this.mainContact, REASON);
                Misc.makeUnimportant(this.inner, REASON);
                this.updateStage(TutorialMissionStage.STABILIZED, null);
            }
        }
    }

    @Override
    public boolean callEvent(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        if (action.equals("startGetData")) {
            this.dataContact.getMemoryWithoutUpdate().set("$tut_dataContact", true);
            this.dataContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
            Misc.makeImportant(this.dataContact, REASON);
            Misc.makeUnimportant(this.mainContact, REASON);
            this.detachment.getMemoryWithoutUpdate().set("$patrolAllowTOff", true);
            this.updateStage(TutorialMissionStage.GO_GET_DATA, text);
            Global.getSector().getMemoryWithoutUpdate().set("$tutMadeContactAtAncyra", true);
            this.saveNag();
        } else if (action.equals("endGetData")) {
            Misc.cleanUpMissionMemory(this.dataContact.getMemoryWithoutUpdate(), "tut_");
            Misc.makeUnimportant(this.dataContact, REASON);
            Misc.makeImportant(this.mainContact, REASON);
            this.updateStage(TutorialMissionStage.GOT_DATA, text);
        } else if (action.equals("goSalvage")) {
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.probe, REASON);
            this.updateStage(TutorialMissionStage.GO_GET_AI_CORE, text);
            this.saveNag();
        } else if (action.equals("goRecover")) {
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.tetra, REASON);
            FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "mudskipper_Standard");
            playerFleet.getFleetData().addFleetMember(member);
            AddRemoveCommodity.addFleetMemberGainText(member, dialog.getTextPanel());
            this.preRecoverFleetSize = playerFleet.getFleetData().getNumMembers();
            this.updateStage(TutorialMissionStage.GO_RECOVER_SHIPS, text);
        } else if (action.equals("goStabilize")) {
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.makeImportant(this.inner, REASON);
            this.addWeaponsToStorage();
            this.inner.getMemoryWithoutUpdate().set("$canStabilize", true);
            this.fringe.getMemoryWithoutUpdate().set("$canStabilize", true);
            this.updateStage(TutorialMissionStage.GO_STABILIZE, text);
            this.saveNag();
        } else if (action.equals("pickJangalaContact")) {
            StarSystemAPI corvus = Global.getSector().getStarSystem("Corvus");
            this.jangala = (PlanetAPI)corvus.getEntityById("jangala");
            this.jangalaContact = TutorialMissionIntel.getJangalaContact();
            MemoryAPI mem = this.mainContact.getMemoryWithoutUpdate();
            mem.set("$jangalaContactPost", this.jangalaContact.getPost().toLowerCase(), 0.0f);
            mem.set("$jangalaContactLastName", this.jangalaContact.getName().getLast(), 0.0f);
            float distLY = Misc.getDistanceLY(playerFleet.getLocationInHyperspace(), this.jangala.getLocationInHyperspace());
            float fuel = playerFleet.getLogistics().getFuelCostPerLightYear() * (distLY += 4.0f);
            fuel = (float)(Math.ceil(fuel / 10.0f) * 10.0);
            mem.set("$jangalaFuel", (int)fuel);
        } else if (action.equals("deliverReport")) {
            Misc.makeUnimportant(this.mainContact, REASON);
            Misc.cleanUpMissionMemory(this.mainContact.getMemoryWithoutUpdate(), "tut_");
            Misc.makeUnimportant(this.inner, REASON);
            this.jangalaContact.getMemoryWithoutUpdate().set("$tut_jangalaContact", true);
            this.jangalaContact.getMemoryWithoutUpdate().set("$tut_eventRef", this);
            Misc.makeImportant(this.jangalaContact, REASON);
            this.updateStage(TutorialMissionStage.DELIVER_REPORT, text);
            TutorialMissionIntel.endGalatiaPortionOfMission(true, true);
            Global.getSector().getMemoryWithoutUpdate().unset("$tutorialRespawn");
        } else if (action.equals("reportDelivered")) {
            Misc.makeUnimportant(this.jangalaContact, REASON);
            Misc.cleanUpMissionMemory(this.jangalaContact.getMemoryWithoutUpdate(), "tut_");
            this.updateStage(TutorialMissionStage.DONE, text);
            MarketAPI jangala = Global.getSector().getEconomy().getMarket("jangala");
            if (jangala != null) {
                SystemBountyManager.getInstance().addOrResetBounty(jangala);
            }
            this.endEvent();
        } else if (action.equals("doRepairs")) {
            for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
                member.getRepairTracker().setMothballed(false);
                member.getStatus().repairFully();
                float max = member.getRepairTracker().getMaxCR();
                max = Math.max(max, 0.7f);
                float curr = member.getRepairTracker().getBaseCR();
                if (!(max > curr)) continue;
                member.getRepairTracker().applyCREvent(max - curr, "Repaired at dockyard");
            }
        } else if (action.equals("printRefitHint")) {
            String refit = Global.getSettings().getControlStringForEnumName("CORE_REFIT");
            String autofit = Global.getSettings().getControlStringForEnumName("REFIT_MANAGE_VARIANTS");
            String transponder = "";
            if (!playerFleet.isTransponderOn()) {
                transponder = "\n\nAlso: you'll need to re-dock with your transponder turned on to take advantage of Ancyra's facilities.";
            }
            dialog.getTextPanel().addPara("(Once this conversation is over, press %s to open the refit screen. After selecting a specific ship, you can press %s to %s - pick a desired loadout, and the ship will be automatically refitted to match it, using what weapons are available." + transponder, Misc.getHighlightColor(), refit, autofit, "\"autofit\"");
            dialog.getTextPanel().addPara("In addition, you now have access to local storage at Ancyra, and some weapons and supplies have been placed there. To access it, click on the \"Storage\" button in the trade screen.)", Misc.getHighlightColor(), refit, autofit, "\"Storage\"");
        }
        return true;
    }

    public static void endGalatiaPortionOfMission(boolean withStipend, boolean didTutorial) {
        if (withStipend) {
            new GalatianAcademyStipend();
        }
        StarSystemAPI system = Global.getSector().getStarSystem("galatia");
        PlanetAPI ancyra = (PlanetAPI)system.getEntityById("ancyra");
        PlanetAPI pontus = (PlanetAPI)system.getEntityById("pontus");
        PlanetAPI tetra = (PlanetAPI)system.getEntityById("tetra");
        SectorEntityToken derinkuyu = system.getEntityById("derinkuyu_station");
        SectorEntityToken probe = system.getEntityById("galatia_probe");
        SectorEntityToken inner = system.getEntityById("galatia_jump_point_alpha");
        SectorEntityToken fringe = system.getEntityById("galatia_jump_point_fringe");
        SectorEntityToken relay = system.getEntityById("ancyra_relay");
        relay.getMemoryWithoutUpdate().unset("$objectiveNonFunctional");
        Global.getSector().getCharacterData().addAbility("transponder");
        Global.getSector().getCharacterData().addAbility("go_dark");
        Global.getSector().getCharacterData().addAbility("sensor_burst");
        Global.getSector().getCharacterData().addAbility("emergency_burn");
        Global.getSector().getCharacterData().addAbility("sustained_burn");
        Global.getSector().getCharacterData().addAbility("scavenge");
        Global.getSector().getCharacterData().addAbility("interdiction_pulse");
        Global.getSector().getCharacterData().addAbility("distress_call");
        FactionAPI hegemony = Global.getSector().getFaction("hegemony");
        if (hegemony.getRelToPlayer().getRel() < 0.0f) {
            hegemony.getRelToPlayer().setRel(0.0f);
        }
        Global.getSector().getEconomy().addMarket(ancyra.getMarket(), false);
        Global.getSector().getEconomy().addMarket(derinkuyu.getMarket(), false);
        HintPanelAPI hints = Global.getSector().getCampaignUI().getHintPanel();
        if (hints != null) {
            hints.clearHints(false);
        }
        if (!SystemBountyManager.getInstance().isActive(ancyra.getMarket())) {
            SystemBountyManager.getInstance().addActive(new SystemBountyIntel(ancyra.getMarket()));
        }
        RogueMinerMiscFleetManager script = new RogueMinerMiscFleetManager(derinkuyu);
        int i = 0;
        while (i < 20) {
            script.advance(1.0f);
            ++i;
        }
        system.addScript(script);
        for (CampaignFleetAPI fleet : system.getFleets()) {
            if (!"pirates".equals(fleet.getFaction().getId())) continue;
            fleet.removeScriptsOfClass(TutorialLeashAssignmentAI.class);
        }
        inner.getMemoryWithoutUpdate().unset("$unstable");
        inner.getMemoryWithoutUpdate().unset("$canStabilize");
        fringe.getMemoryWithoutUpdate().unset("$unstable");
        fringe.getMemoryWithoutUpdate().unset("$canStabilize");
        system.removeTag("system_cut_off_from_hyper");
        MarketAPI market = ancyra.getMarket();
        market.getMemoryWithoutUpdate().unset("$doNotInitCommListings");
        market.getStats().getDynamic().getMod("patrol_num_light_mod").unmodifyMult(REASON);
        market.getStats().getDynamic().getMod("patrol_num_medium_mod").unmodifyMult(REASON);
        market.getStats().getDynamic().getMod("patrol_num_heavy_mod").unmodifyMult(REASON);
        market.setEconGroup(null);
        derinkuyu.getMarket().setEconGroup(null);
    }

    protected void saveNag() {
        if (!Global.getSector().hasScript(SaveNagScript.class)) {
            Global.getSector().addScript(new SaveNagScript(10.0f));
        }
    }

    public void addWeaponsToStorage() {
        StoragePlugin plugin = (StoragePlugin)this.ancyra.getMarket().getSubmarket("storage").getPlugin();
        plugin.setPlayerPaidToUnlock(true);
        CargoAPI cargo = plugin.getCargo();
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
            if (!member.getVariant().hasTag("ship_recoverable")) continue;
            for (WeaponSlotAPI slot : member.getVariant().getHullSpec().getAllWeaponSlotsCopy()) {
                String weaponId = this.getWeaponForSlot(slot);
                if (weaponId == null) continue;
                cargo.addWeapons(weaponId, 1);
            }
        }
        cargo.addFighters("broadsword_wing", 1);
        cargo.addFighters("piranha_wing", 1);
        cargo.addSupplies(100.0f);
        cargo.sort();
    }

    public String getWeaponForSlot(WeaponSlotAPI slot) {
        switch (slot.getWeaponType()) {
            case BALLISTIC: 
            case UNIVERSAL: 
            case HYBRID: 
            case COMPOSITE: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("mark9", "hephag", "hellbore");
                    }
                    case MEDIUM: {
                        return this.pick("arbalest", "heavymortar", "shredder");
                    }
                    case SMALL: {
                        return this.pick("lightmg", "lightac", "lightmortar");
                    }
                }
                break;
            }
            case MISSILE: 
            case SYNERGY: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("hammerrack");
                    }
                    case MEDIUM: {
                        return this.pick("pilum", "annihilatorpod");
                    }
                    case SMALL: {
                        return this.pick("harpoon", "sabot", "annihilator");
                    }
                }
                break;
            }
            case ENERGY: {
                switch (slot.getSlotSize()) {
                    case LARGE: {
                        return this.pick("autopulse", "hil");
                    }
                    case MEDIUM: {
                        return this.pick("miningblaster", "gravitonbeam", "pulselaser");
                    }
                    case SMALL: {
                        return this.pick("mininglaser", "taclaser", "pdlaser", "ioncannon");
                    }
                }
            }
        }
        return null;
    }

    public String pick(String ... strings) {
        return strings[new Random().nextInt(strings.length)];
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.setParaSmallInsignia();
        info.addPara(this.getName(), c, 0.0f);
        info.setParaFontDefault();
        this.addBulletPoints(info, mode);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color c = this.getTitleColor(mode);
        float opad = 10.0f;
        float pad = 3.0f;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            pad = 10.0f;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        switch (this.stage) {
            case INIT: {
                info.addPara("Contact " + this.getMainContactPostName() + " at Ancyra", tc, pad);
                break;
            }
            case GO_GET_DATA: {
                info.addPara("Sneak into " + this.derinkuyu.getName(), tc, pad);
                info.addPara("Contact " + this.dataContact.getNameString() + " and retrieve data", tc, 0.0f);
                break;
            }
            case GOT_DATA: {
                info.addPara("Deliver data to " + this.getMainContactPostName() + " at Ancyra", tc, pad);
                break;
            }
            case GO_GET_AI_CORE: {
                info.addPara("Retrieve AI core from derelict probe beyond the orbit of Pontus", tc, pad);
                break;
            }
            case GOT_AI_CORE: {
                info.addPara("Deliver AI core to " + this.getMainContactPostName() + " at Ancyra", tc, pad);
                break;
            }
            case GO_RECOVER_SHIPS: {
                info.addPara("Recover at least %s ships at Tetra", pad, tc, h, "2");
                break;
            }
            case RECOVERED_SHIPS: {
                info.addPara("Return to " + this.getMainContactPostName() + " with the ships", tc, pad);
                break;
            }
            case GO_STABILIZE: {
                info.addPara("Stabilize the inner-system jump-point", tc, pad);
                break;
            }
            case STABILIZED: {
                info.addPara("Return to Ancyra and report your success", tc, pad);
                break;
            }
            case DELIVER_REPORT: {
                info.addPara("Deliver report to " + this.getJangalaContactPostName() + " at Jangala", tc, pad);
                break;
            }
            case DONE: {
                info.addPara("Completed", tc, pad);
            }
        }
        this.unindent(info);
    }

    @Override
    public String getName() {
        return "Stabilize the Jump-points";
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    protected String getMainContactPostName() {
        return String.valueOf(this.mainContact.getPost()) + " " + this.mainContact.getNameString();
    }

    protected String getJangalaContactPostName() {
        return String.valueOf(this.jangalaContact.getPost()) + " " + this.jangalaContact.getNameString();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        boolean addedBullets = false;
        switch (this.stage) {
            case INIT: {
                info.addPara("You receive a tight-beam communication from the system's main inhabited world, Ancyra.", opad);
                info.addPara("The message is brief and asks you to travel there and contact " + this.getMainContactPostName() + " as soon as possible.", opad);
                break;
            }
            case GO_GET_DATA: {
                info.addPara("Contact " + this.dataContact.getNameString() + " at Derinkuyu Mining Station " + "to acquire the raw jump-point readings.", opad);
                info.addPara("Contact must be made with the transponder off as the miners of Derinkuyu have turned pirate and your fleet will be attacked otherwise.", opad);
                info.addPara("Use %s to avoid detection, and %s to get away if you are seen.", opad, h, "Go Dark", "Emergency Burn");
                break;
            }
            case GOT_DATA: {
                info.addPara("Return to Ancyra and contact " + this.getMainContactPostName() + " to deliver the jump-point data.", opad);
                break;
            }
            case GO_GET_AI_CORE: {
                info.addPara("Analyzing the jump-point data requires an AI Core.", opad);
                info.addPara("There's a Domain-era survey probe outside the orbit of Pontus. If salvaged, it's likely to yield a gamma AI core, which should be sufficient for the task.", opad);
                info.addPara("Go to Pontus, head out towards the asteroid belt, and then use an %s to locate the probe. ", opad, h, "Active Sensor Burst");
                info.addPara("Approach the probe and salvage it to recover the gamma core.", opad);
                info.addPara("It's likely that you will have to overcome some automated defenses first.", opad);
                break;
            }
            case GOT_AI_CORE: {
                info.addPara("Return to Ancyra and contact " + this.getMainContactPostName() + " to deliver the AI core.", opad);
                break;
            }
            case GO_RECOVER_SHIPS: {
                info.addPara("Go to the ship graveyard around Tetra and recover as many ships as possible.", opad);
                info.addPara("Bring extra crew to man the recovered ships, and extra supplies to  help restore their combat readiness.", opad);
                break;
            }
            case RECOVERED_SHIPS: {
                info.addPara("Return to " + this.getMainContactPostName() + " at Ancyra for help with outfitting the recovered ships with weapons.", opad);
                break;
            }
            case GO_STABILIZE: {
                info.addPara("Use the hyperwave sequence produced by the AI core to stabilize the inner-system jump-point.", opad);
                info.addPara("You will have to defeat the pirates guarding it first.", opad);
                break;
            }
            case STABILIZED: {
                info.addPara("Galatia's connection with hyperspace has been restored, and trade fleets are once again able to enter and leave the system.", opad);
                info.addPara("The Derinkuyu leadership will surely soon be toppled by rank-and-file miners eager to get on the right side of the law once again.", opad);
                break;
            }
            case DELIVER_REPORT: {
                info.addPara(String.valueOf(Misc.ucFirst(this.getMainContactPostName())) + " has tasked you with delivering a report " + "detailing the recent events to the " + this.getJangalaContactPostName() + " at Jangala.", opad);
                info.addPara("Make sure you have enough fuel to make the trip successfully.", opad);
                break;
            }
            case DONE: {
                info.addPara("You have delivered the report and your standing with the Hegemony has increased substantially.", opad);
                info.addPara("Galatia's connection with hyperspace has been restored, and trade fleets are once again able to enter and leave the system.", opad);
            }
        }
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("campaignMissions", "tutorial");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Story");
        tags.add("hegemony");
        return tags;
    }

    @Override
    public String getCommMessageSound() {
        if (this.isSendingUpdate()) {
            return TutorialMissionIntel.getSoundStandardUpdate();
        }
        return TutorialMissionIntel.getSoundMajorPosting();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        switch (this.stage) {
            case INIT: {
                return this.ancyra;
            }
            case GO_GET_DATA: {
                return this.derinkuyu;
            }
            case GOT_DATA: {
                return this.ancyra;
            }
            case GO_GET_AI_CORE: {
                return this.pontus;
            }
            case GOT_AI_CORE: {
                return this.ancyra;
            }
            case GO_RECOVER_SHIPS: {
                return this.tetra;
            }
            case RECOVERED_SHIPS: {
                return this.ancyra;
            }
            case GO_STABILIZE: {
                return this.inner;
            }
            case STABILIZED: {
                return this.ancyra;
            }
            case DELIVER_REPORT: {
                return this.jangala;
            }
            case DONE: {
                return this.ancyra;
            }
        }
        return this.ancyra;
    }

    @Override
    public boolean canTurnImportantOff() {
        return this.isEnding();
    }

    @Override
    public IntelInfoPlugin.IntelSortTier getSortTier() {
        return IntelInfoPlugin.IntelSortTier.TIER_2;
    }

    @Override
    public String getSortString() {
        return this.getName();
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    public static enum TutorialMissionStage {
        INIT,
        GO_GET_DATA,
        GOT_DATA,
        GO_GET_AI_CORE,
        GOT_AI_CORE,
        GO_RECOVER_SHIPS,
        RECOVERED_SHIPS,
        GO_STABILIZE,
        STABILIZED,
        DELIVER_REPORT,
        DONE;

    }
}

