/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.BattleObjectiveEffect;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.FogOfWarAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseBattleObjectiveEffect
implements BattleObjectiveEffect {
    protected CombatEngineAPI engine;
    protected List<BattleObjectiveEffect.ShipStatusItem> itemsNAFrigates = new ArrayList<BattleObjectiveEffect.ShipStatusItem>();
    protected List<BattleObjectiveEffect.ShipStatusItem> itemsNAFighters = new ArrayList<BattleObjectiveEffect.ShipStatusItem>();
    protected BattleObjectiveAPI objective;
    private Map<BattleObjectiveAPI, Integer> prevOwners = new HashMap<BattleObjectiveAPI, Integer>();

    @Override
    public void init(CombatEngineAPI engine, BattleObjectiveAPI objective) {
        this.engine = engine;
        this.objective = objective;
        BattleObjectiveEffect.ShipStatusItem item = new BattleObjectiveEffect.ShipStatusItem(objective.getDisplayName(), "n / a to fighters", false);
        this.itemsNAFighters.add(item);
        item = new BattleObjectiveEffect.ShipStatusItem(objective.getDisplayName(), "n / a to frigates", false);
        this.itemsNAFrigates.add(item);
    }

    @Override
    public int getBonusDeploymentPoints() {
        int bs = Global.getSettings().getBattleSize();
        int bonus = Math.round((float)bs * this.objective.getBattleSizeFractionBonus());
        return bonus;
    }

    public void giveCommandPointsForCapturing(int points) {
        Integer prevOwner;
        int owner = this.objective.getOwner();
        CombatFleetManagerAPI fleetManager = this.engine.getFleetManager(owner);
        if (fleetManager != null && (prevOwner = this.prevOwners.get(this.objective)) != null && prevOwner != owner) {
            String bonusKey = String.valueOf(this.objective.getDisplayName()) + "_bonus_ " + (float)Math.random();
            fleetManager.getTaskManager(false).getCommandPointsStat().modifyFlat(bonusKey, points);
            fleetManager.getTaskManager(true).getCommandPointsStat().modifyFlat(bonusKey, points);
        }
        this.prevOwners.put(this.objective, owner);
    }

    public void revealArea(float radius) {
        FogOfWarAPI fog = this.engine.getFogOfWar(0);
        if (this.objective.getOwner() == 0) {
            fog.revealAroundPoint(this.objective, this.objective.getLocation().x, this.objective.getLocation().y, radius);
        }
        fog = this.engine.getFogOfWar(1);
        if (this.objective.getOwner() == 1) {
            fog.revealAroundPoint(this.objective, this.objective.getLocation().x, this.objective.getLocation().y, radius);
        }
    }
}

