/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.dweller.DwellerHullmod;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.HumanShipShroudCreator;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class HumanShipShroudedHullmod
extends DwellerHullmod {
    public static float CREW_CASUALTIES = 50.0f;
    public static DwellerShipCreator CREATOR = new HumanShipShroudCreator();
    public static boolean ALLOW_ON_PHASE_SHIPS = false;

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ALLOW_ON_PHASE_SHIPS || ship == null || !ship.getHullSpec().isPhase();
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        return "Can not be installed on a phase ship";
    }

    protected boolean increasesCrewCasualties() {
        return true;
    }

    @Override
    protected boolean addStrategyAI() {
        return false;
    }

    @Override
    protected DwellerShipCreator getShipCreator(String hullId) {
        return CREATOR;
    }

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        super.applyEffectsBeforeShipCreation(hullSize, stats, id);
        if (this.increasesCrewCasualties()) {
            stats.getCrewLossMult().modifyPercent(id, CREW_CASUALTIES);
        }
    }

    protected boolean skipFluxUseWhenOverloadedOrVenting() {
        return true;
    }

    protected boolean deductFlux(ShipAPI ship, float fluxCost) {
        if (this.skipFluxUseWhenOverloadedOrVenting() && ship.getFluxTracker().isOverloadedOrVenting()) {
            return true;
        }
        return ship.getFluxTracker().increaseFlux(fluxCost, false);
    }

    public void addCrewCasualties(TooltipMakerAPI tooltip, float opad) {
        tooltip.addPara("Crew casualties in combat are increased by %s.", opad, Misc.getHighlightColor(), (int)CREW_CASUALTIES + "%");
    }
}

