/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.dweller.BaseDwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatPlugin;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipPart;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.loading.ProjectileWeaponSpecAPI;
import com.fs.starfarer.api.util.ListMap;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedMaelstromShipCreator
extends BaseDwellerShipCreator {
    public static float FLUX_COST_MULT = 1.0f;
    public static float RANGE_BONUS = 200.0f;

    @Override
    public void initBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        super.initBeforeShipCreation(hullSize, stats, id);
        stats.getBallisticWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
        stats.getEnergyWeaponRangeBonus().modifyPercent(id, RANGE_BONUS);
    }

    @Override
    protected DwellerCombatPlugin createPlugin(ShipAPI ship) {
        DwellerCombatPlugin plugin = super.createPlugin(ship);
        plugin.setPlugin(new DwellerCombatPlugin.DCPPlugin(){
            ListMap<WeaponAPI> weapons = new ListMap();
            int[] currIndex = new int[10];
            float[] currElapsed = new float[10];

            @Override
            public void advance(DwellerCombatPlugin plugin, float amount) {
                CombatEntityAPI attachedTo = plugin.getAttachedTo();
                if (attachedTo instanceof ShipAPI) {
                    ShipAPI ship = (ShipAPI)attachedTo;
                    if (this.weapons.isEmpty()) {
                        for (WeaponAPI w : ship.getAllWeapons()) {
                            if (w.isDecorative()) continue;
                            this.weapons.add(w.getId(), w);
                        }
                    }
                    int i = 0;
                    for (List list : this.weapons.values()) {
                        WeaponAPI w = (WeaponAPI)list.get(0);
                        float delay = ((ProjectileWeaponSpecAPI)w.getSpec()).getRefireDelay() / (float)list.size();
                        int n = i;
                        this.currElapsed[n] = this.currElapsed[n] + amount;
                        while (this.currElapsed[i] > delay) {
                            int n2 = i;
                            this.currElapsed[n2] = this.currElapsed[n2] - delay;
                            int n3 = i;
                            this.currIndex[n3] = this.currIndex[n3] + 1;
                            int n4 = i;
                            this.currIndex[n4] = this.currIndex[n4] % list.size();
                        }
                        int index = 0;
                        for (WeaponAPI curr : list) {
                            if (index != this.currIndex[i]) {
                                curr.setForceDisabled(true);
                            } else {
                                curr.setForceDisabled(false);
                            }
                            ++index;
                        }
                        ++i;
                    }
                }
            }
        });
        List<DwellerShipPart> parts = plugin.getParts();
        float scale = 1.0f;
        scale = 1.33f;
        float spinMult = 1.0f;
        spinMult = 0.5f;
        spinMult = 0.125f;
        DwellerCombatPlugin.WobblyPart part = new DwellerCombatPlugin.WobblyPart("shrouded_vortex_base2", 3.0f * scale, 3, 3, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        part.setSpin(540.0f * spinMult, 720.0f * spinMult, 270.0f * spinMult);
        part.alphaMult = 0.5f;
        parts.add(part);
        part = new DwellerCombatPlugin.WobblyPart("shrouded_vortex_base2", 2.0f * scale, 3, 3, 1.0f, new Vector2f(0.0f, 0.0f), 180.0f);
        part.setSpin(540.0f * spinMult, 720.0f * spinMult, 270.0f * spinMult);
        part.alphaMult = 0.4f;
        parts.add(part);
        Color glow = DwellerCombatPlugin.STANDARD_PART_GLOW_COLOR;
        part = new DwellerCombatPlugin.WobblyPart("shrouded_eye_cluster1", 1.2f * scale, 5, 5, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        part.setSpin(100.0f * spinMult, 180.0f * spinMult, 320.0f * spinMult);
        part.color = glow;
        part.additiveBlend = true;
        parts.add(part);
        part = new DwellerCombatPlugin.WobblyPart("shrouded_eye_cluster2", 1.2f * scale, 5, 5, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        part.setSpin(120.0f * spinMult, 200.0f * spinMult, 320.0f * spinMult);
        part.color = glow;
        part.additiveBlend = true;
        parts.add(part);
        part = new DwellerCombatPlugin.WobblyPart("shrouded_eye_cluster3", 1.2f * scale, 5, 5, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        part.setSpin(140.0f * spinMult, 220.0f * spinMult, 320.0f * spinMult);
        part.color = glow;
        part.additiveBlend = true;
        parts.add(part);
        part = new DwellerCombatPlugin.WobblyPart("shrouded_maelstrom_base", 1.8f * scale, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        part.setSpin(600.0f * spinMult, 680.0f * spinMult, 320.0f * spinMult);
        parts.add(part);
        return plugin;
    }

    @Override
    protected void modifyBaselineShroudParams(ShipAPI ship, DwellerShroud.DwellerShroudParams params) {
        params.maxOffset = 200.0f;
        params.baseMembersToMaintain = params.initialMembers = 200;
        params.numToRespawn = 2;
        params.numToFlash = 3;
        params.maxOffset = 250.0f;
        params.numToFlash = 4;
        params.baseSpriteSize *= 1.33f;
        params.spawnOffsetMultForInitialSpawn = params.spawnOffsetMult = 0.67f;
        params.offsetModifier = new RoilingSwarmEffect.SwarmMemberOffsetModifier(){

            @Override
            public void modifyOffset(RoilingSwarmEffect.SwarmMember p) {
                p.offset.x *= 0.85f;
                p.offset.y *= 1.25f;
            }
        };
    }
}

