/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.impl.combat.threat.BaseFragmentMissileEffect;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class KineticFragmentMissileEffect
extends BaseFragmentMissileEffect {
    public static Color FRINGE_COLOR = new Color(235, 255, 215, 235);
    public static Color CORE_COLOR = new Color(225, 255, 205, 200);
    public static float OTHER_FRAGMENT_DAMAGE = 100.0f;

    @Override
    protected void configureMissileSwarmParams(RoilingSwarmEffect.RoilingSwarmParams params) {
        params.maxOffset = 40.0f;
        params.maxSpeed = this.missile.getMaxSpeed() + 10.0f;
        params.outspeedAttachedEntityBy = 0.0f;
        params.flashFringeColor = FRINGE_COLOR;
        params.flashCoreColor = CORE_COLOR;
        params.flashCoreRadiusMult = 0.0f;
        params.flashRadius = 30.0f;
        params.autoscale = true;
    }

    @Override
    protected void swarmCreated(MissileAPI missile, RoilingSwarmEffect missileSwarm, RoilingSwarmEffect sourceSwarm) {
        boolean first = true;
        for (RoilingSwarmEffect.SwarmMember p : missileSwarm.members) {
            p.scaler.setBrightness(p.scale);
            if (first) {
                p.scaler.setBounceDown(false);
                p.scaler.fadeIn();
            } else {
                p.keepScale = true;
            }
            p.flash = null;
            p.flash();
            p.flash.setBounceDown(false);
            first = false;
        }
    }

    @Override
    protected int getNumOtherMembersToTransfer() {
        return 4;
    }

    @Override
    protected int getEMPResistance() {
        return 3;
    }

    @Override
    protected boolean explodeOnFizzling() {
        return false;
    }

    @Override
    protected boolean shouldMakeMissileFaceTargetOnSpawnIfAny() {
        return true;
    }

    @Override
    protected BaseFragmentMissileEffect.FragmentBehaviorOnImpact getOtherFragmentBehaviorOnImpact() {
        return BaseFragmentMissileEffect.FragmentBehaviorOnImpact.STOP_AND_FADE;
    }

    @Override
    protected void reportFragmentHit(MissileAPI missile, RoilingSwarmEffect.SwarmMember p, RoilingSwarmEffect swarm, CombatEntityAPI target) {
        CombatEngineAPI engine = Global.getCombatEngine();
        Color color = FRINGE_COLOR;
        float size = 80.0f;
        engine.addHitParticle(p.loc, new Vector2f(), size, 0.5f, color);
        engine.addHitParticle(p.loc, new Vector2f(), size * 0.25f, 1.0f, CORE_COLOR);
        float mult = p.fader.getBrightness();
        if (mult > 0.8f) {
            mult = 1.0f;
        }
        engine.applyDamage(target, p.loc, OTHER_FRAGMENT_DAMAGE * mult, DamageType.KINETIC, 0.0f, false, false, missile.getSource(), true);
    }
}

