/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ThreatShipConstructionScript
extends BaseEveryFrameCombatPlugin {
    public static String SWARM_CONSTRUCTING_SHIP = "swarm_constructing_ship";
    public static String SHIP_UNDER_CONSTRUCTION = "ship_under_construction";
    public static float FADE_IN_RATE_MULT_WHEN_DESTROYED = 10.0f;
    protected float elapsed = 0.0f;
    protected ShipAPI ship = null;
    protected CollisionClass collisionClass;
    protected String variantId;
    protected ShipAPI source;
    protected float delay;
    protected float fadeInTime;
    protected float origMaxSpeed = 500.0f;
    protected List<ShipAPI> explodedPieces = new ArrayList<ShipAPI>();
    protected IntervalUtil interval = new IntervalUtil(0.075f, 0.125f);
    protected float hulkFor = 0.0f;

    public ThreatShipConstructionScript(String variantId, ShipAPI source, float delay, float fadeInTime) {
        this.variantId = variantId;
        this.source = source;
        this.delay = delay;
        this.fadeInTime = fadeInTime;
        this.interval.forceIntervalElapsed();
        this.spawnShip();
    }

    public ShipAPI getShip() {
        return this.ship;
    }

    protected void spawnShip() {
        FactionAPI faction;
        float facing = this.source.getFacing() + 15.0f * ((float)Math.random() - 0.5f);
        Vector2f loc = new Vector2f((ReadableVector2f)this.source.getLocation());
        CombatEngineAPI engine = Global.getCombatEngine();
        CombatFleetManagerAPI fleetManager = engine.getFleetManager(this.source.getOriginalOwner());
        boolean wasSuppressed = fleetManager.isSuppressDeploymentMessages();
        fleetManager.setSuppressDeploymentMessages(true);
        this.ship = engine.getFleetManager(this.source.getOriginalOwner()).spawnShipOrWing(this.variantId, loc, facing, 0.0f, null);
        if ((Global.getCombatEngine().isInCampaign() || Global.getCombatEngine().isInCampaignSim()) && (faction = Global.getSector().getFaction("threat")) != null) {
            String name = faction.pickRandomShipName();
            this.ship.setName(name);
        }
        fleetManager.setSuppressDeploymentMessages(wasSuppressed);
        this.collisionClass = this.ship.getCollisionClass();
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(this.ship);
        RoilingSwarmEffect sourceSwarm = RoilingSwarmEffect.getSwarmFor(this.source);
        if (swarm != null) {
            swarm.params.withInitialMembers = false;
            swarm.params.withRespawn = false;
        }
        if (sourceSwarm != null) {
            this.origMaxSpeed = sourceSwarm.params.maxSpeed;
            sourceSwarm.params.outspeedAttachedEntityBy = 0.0f;
            if (swarm != null) {
                swarm.params.withInitialMembers = false;
                swarm.params.flashFringeColor = sourceSwarm.params.flashFringeColor;
            }
        }
        this.ship.addTag(SHIP_UNDER_CONSTRUCTION);
        this.source.addTag(SWARM_CONSTRUCTING_SHIP);
        this.source.setCollisionClass(CollisionClass.NONE);
        this.source.getMutableStats().getHullDamageTakenMult().modifyMult("ThreatShipConstructionScript", 0.0f);
        this.ship.setShipAI(null);
        for (WeaponGroupAPI g : this.ship.getWeaponGroupsCopy()) {
            g.toggleOff();
        }
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (this.ship.isHulk()) {
            this.hulkFor += amount;
            amount *= FADE_IN_RATE_MULT_WHEN_DESTROYED;
            if (this.explodedPieces.isEmpty() || this.hulkFor < 0.25f) {
                this.explodedPieces.clear();
                for (ShipAPI curr : Global.getCombatEngine().getShips()) {
                    if (curr.getFleetMember() != this.ship.getFleetMember() && (curr.getParentPieceId() == null || !curr.getParentPieceId().equals(this.ship.getId()))) continue;
                    this.explodedPieces.add(curr);
                }
            }
        }
        this.elapsed += amount;
        if (this.elapsed < this.delay) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        float progress = (this.elapsed - this.delay) / this.fadeInTime;
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        float remaining = this.fadeInTime - (this.elapsed - this.delay);
        this.ship.setAlphaMult(progress);
        for (ShipAPI curr : this.explodedPieces) {
            curr.setAlphaMult(progress);
        }
        this.ship.getMutableStats().getEffectiveArmorBonus().modifyMult("ThreatShipConstructionScript", progress * progress);
        Global.getSoundPlayer().playLoop("construction_swarm_loop", this.ship, 1.0f, 1.0f, this.ship.getLocation(), this.ship.getVelocity());
        if (remaining > 1.0f) {
            Vector2f deltaLoc = Vector2f.sub((Vector2f)this.ship.getLocation(), (Vector2f)this.source.getLocation(), (Vector2f)new Vector2f());
            this.source.getLocation().set((ReadableVector2f)this.ship.getLocation());
            RoilingSwarmEffect sourceSwarm = RoilingSwarmEffect.getSwarmFor(this.source);
            if (sourceSwarm != null) {
                for (RoilingSwarmEffect.SwarmMember p : sourceSwarm.members) {
                    Vector2f.add((Vector2f)p.loc, (Vector2f)deltaLoc, (Vector2f)p.loc);
                }
            }
            this.ship.giveCommand(ShipCommand.DECELERATE, null, 0);
        }
        float jitterLevel = progress;
        jitterLevel = this.fadeInTime <= 4.0f ? (jitterLevel < 0.5f ? (jitterLevel *= 2.0f) : (1.0f - jitterLevel) * 2.0f) : (jitterLevel < 0.5f ? (jitterLevel *= 2.0f) : (remaining <= 2.0f ? remaining / 2.0f : 1.0f));
        jitterLevel = (float)Math.sqrt(jitterLevel);
        float jitterRange = 1.0f;
        jitterRange = remaining < 2.0f ? remaining / 2.0f : (this.elapsed - this.delay) / Math.max(1.0f, this.fadeInTime - 2.0f);
        float maxRangeBonus = 25.0f;
        float jitterRangeBonus = jitterRange * maxRangeBonus;
        Color c = VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR;
        c = Misc.setAlpha(c, 127);
        this.ship.setJitter(this, c, jitterLevel, 3, 0.0f, jitterRangeBonus);
        this.ship.getEngineController().fadeToOtherColor(this, Misc.zeroColor, Misc.zeroColor, 1.0f, 1.0f);
        RoilingSwarmEffect sourceSwarm = RoilingSwarmEffect.getSwarmFor(this.source);
        if (sourceSwarm != null) {
            float speedMult = 0.25f + 0.75f * Math.max(0.0f, 1.0f - (this.elapsed - this.delay) / 2.0f);
            sourceSwarm.params.maxSpeed = this.origMaxSpeed * speedMult;
            if (remaining > 3.0f) {
                float numFragMult = (float)sourceSwarm.params.initialMembers / 150.0f;
                if (numFragMult < 0.25f) {
                    numFragMult = 0.25f;
                }
                if (numFragMult > 1.0f) {
                    numFragMult = 1.0f;
                }
                sourceSwarm.params.flashFrequency = 5.0f * progress * 2.0f * numFragMult;
                sourceSwarm.params.flashProbability = 1.0f;
                sourceSwarm.params.flashFringeColor = VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR;
                sourceSwarm.params.flashFringeColor = Misc.setAlpha(sourceSwarm.params.flashFringeColor, 200);
                sourceSwarm.params.flashCoreRadiusMult = 1.5f;
                sourceSwarm.params.flashRadius = 50.0f;
                sourceSwarm.params.renderFlashOnSameLayer = true;
            } else {
                sourceSwarm.params.flashFrequency = 1.0f;
                sourceSwarm.params.flashProbability = 0.0f;
            }
        }
        this.spawnParticles(amount);
        if (this.elapsed > this.fadeInTime + this.delay) {
            RoilingSwarmEffect swarm;
            this.ship.setDefaultAI(null);
            this.ship.removeTag(SHIP_UNDER_CONSTRUCTION);
            this.ship.setAlphaMult(1.0f);
            this.ship.setHoldFire(false);
            this.ship.setCollisionClass(this.collisionClass);
            this.ship.getMutableStats().getEffectiveArmorBonus().unmodifyMult("ThreatShipConstructionScript");
            engine.removePlugin(this);
            if (sourceSwarm != null) {
                sourceSwarm.getParams().despawnSound = null;
            }
            if ((swarm = RoilingSwarmEffect.getSwarmFor(this.ship)) != null && sourceSwarm != null) {
                int transfer = Math.min(swarm.params.baseMembersToMaintain, sourceSwarm.getNumActiveMembers());
                sourceSwarm.transferMembersTo(swarm, transfer);
            }
            if (swarm != null) {
                swarm.params.withRespawn = true;
                swarm.params.withInitialMembers = true;
            }
            this.source.setHitpoints(0.0f);
            this.source.setSpawnDebris(false);
            engine.applyDamage(this.source, this.source.getLocation(), 100.0f, DamageType.ENERGY, 0.0f, true, false, this.source, false);
        }
    }

    protected void spawnParticles(float amount) {
        if (this.ship == null) {
            return;
        }
        float remaining = this.fadeInTime - (this.elapsed - this.delay);
        this.interval.advance(amount);
        if (this.interval.intervalElapsed() && remaining > 1.0f) {
            RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(this.source);
            if (swarm != null) {
                for (RoilingSwarmEffect.SwarmMember p : swarm.members) {
                    if (!((float)Math.random() > 0.9f)) continue;
                    p.rollOffset(swarm.params, this.ship);
                }
            }
            CombatEngineAPI engine = Global.getCombatEngine();
            Color c = RiftLanceEffect.getColorForDarkening(VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR);
            c = Misc.setAlpha(c, 50);
            float baseDuration = 2.0f;
            Vector2f vel = new Vector2f((ReadableVector2f)this.ship.getVelocity());
            float size = this.ship.getCollisionRadius() * 0.33f;
            float extraDur = 0.0f;
            if (remaining < 1.0f) {
                extraDur = 1.0f;
            }
            int i = 0;
            while (i < 11) {
                Vector2f point = new Vector2f((ReadableVector2f)this.ship.getLocation());
                point = Misc.getPointWithinRadiusUniform(point, this.ship.getCollisionRadius() * 0.75f, Misc.random);
                float dur = baseDuration + baseDuration * (float)Math.random();
                dur += extraDur;
                float nSize = size;
                Vector2f pt = Misc.getPointWithinRadius(point, nSize * 0.5f);
                Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
                v.scale(nSize + nSize * (float)Math.random() * 0.5f);
                v.scale(0.2f);
                Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
                float maxSpeed = nSize * 1.5f * 0.2f;
                float minSpeed = nSize * 1.0f * 0.2f;
                float overMin = v.length() - minSpeed;
                if (overMin > 0.0f) {
                    float durMult = 1.0f - overMin / (maxSpeed - minSpeed);
                    if (durMult < 0.1f) {
                        durMult = 0.1f;
                    }
                    dur *= 0.5f + 0.5f * durMult;
                }
                engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f, 2.0f, 0.5f / dur, 0.0f, dur, c);
                ++i;
            }
        }
    }
}

