/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.anim.func;

import com.fs.graphics.anim.BaseAnimation;

public class Oscillator
extends BaseAnimation {
    private float value;
    private float min = 0.0f;
    private float max = 1.0f;
    private float period = 1.0f;
    private float random = 0.0f;
    private float lastElapsedTotal = 0.0f;

    public Oscillator(float f, float f2, long l, boolean bl) {
        this.min = f;
        this.max = f2;
        this.period = l;
        if (bl) {
            this.random = (float)(Math.random() * (double)l);
        }
        this.advance(0.0f);
    }

    @Override
    public void advance(float f) {
        float f2 = this.getElapsed();
        float f3 = (float)((double)(f2 + this.random) / (double)this.period * Math.PI);
        float f4 = (float)Math.cos(f3);
        this.value = this.min + f4 * (this.max - this.min);
        this.lastElapsedTotal = f2;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public float getValue() {
        return this.value;
    }

    public void resetToMidpoint() {
        this.random = -this.lastElapsedTotal + this.period / 3.0f;
    }
}

