/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat;

import com.fs.starfarer.api.combat.StatBonus;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class MutableStat {
    public float base;
    public float modified;
    private LinkedHashMap<String, StatMod> flatMods;
    private LinkedHashMap<String, StatMod> percentMods;
    private LinkedHashMap<String, StatMod> multMods;
    private transient boolean needsRecompute = false;
    private transient float flatMod;
    private transient float percentMod;
    private transient float mult = 1.0f;

    public MutableStat(float base) {
        this.base = base;
        this.modified = base;
    }

    protected Object readResolve() {
        if (this.flatMods == null) {
            this.flatMods = new LinkedHashMap();
        }
        if (this.percentMods == null) {
            this.percentMods = new LinkedHashMap();
        }
        if (this.multMods == null) {
            this.multMods = new LinkedHashMap();
        }
        this.mult = 1.0f;
        this.needsRecompute = true;
        return this;
    }

    public MutableStat createCopy() {
        MutableStat copy = new MutableStat(this.getBaseValue());
        copy.applyMods(this);
        return copy;
    }

    protected Object writeReplace() {
        return this;
    }

    public void applyMods(MutableStat other) {
        this.getFlatMods().putAll(other.getFlatMods());
        this.getPercentMods().putAll(other.getPercentMods());
        this.getMultMods().putAll(other.getMultMods());
        this.needsRecompute = true;
    }

    public void applyMods(StatBonus other) {
        this.getFlatMods().putAll(other.getFlatBonuses());
        this.getPercentMods().putAll(other.getPercentBonuses());
        this.getMultMods().putAll(other.getMultBonuses());
        this.needsRecompute = true;
    }

    public boolean isUnmodified() {
        return !(this.flatMods != null && !this.getFlatMods().isEmpty() || this.multMods != null && !this.getMultMods().isEmpty() || this.percentMods != null && !this.getPercentMods().isEmpty());
    }

    public HashMap<String, StatMod> getFlatMods() {
        if (this.flatMods == null) {
            this.flatMods = new LinkedHashMap();
        }
        return this.flatMods;
    }

    public HashMap<String, StatMod> getPercentMods() {
        if (this.percentMods == null) {
            this.percentMods = new LinkedHashMap();
        }
        return this.percentMods;
    }

    public HashMap<String, StatMod> getMultMods() {
        if (this.multMods == null) {
            this.multMods = new LinkedHashMap();
        }
        return this.multMods;
    }

    public StatMod getFlatStatMod(String source) {
        return this.getFlatMods().get(source);
    }

    public StatMod getPercentStatMod(String source) {
        return this.getPercentMods().get(source);
    }

    public StatMod getMultStatMod(String source) {
        return this.getMultMods().get(source);
    }

    public void modifyFlat(String source, float value) {
        this.modifyFlat(source, value, null);
    }

    public void modifyFlat(String source, float value, String desc) {
        StatMod mod = this.getFlatMods().get(source);
        if (mod == null && value == 0.0f) {
            return;
        }
        if (mod != null && mod.value == value) {
            mod.desc = desc;
            return;
        }
        mod = new StatMod(source, StatModType.FLAT, value, desc);
        this.getFlatMods().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyPercent(String source, float value) {
        this.modifyPercent(source, value, null);
    }

    public void modifyPercent(String source, float value, String desc) {
        StatMod mod = this.getPercentMods().get(source);
        if (mod == null && value == 0.0f) {
            return;
        }
        if (mod != null && mod.value == value) {
            mod.desc = desc;
            return;
        }
        mod = new StatMod(source, StatModType.PERCENT, value, desc);
        this.getPercentMods().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyPercentAlways(String source, float value, String desc) {
        StatMod mod = new StatMod(source, StatModType.PERCENT, value, desc);
        this.getPercentMods().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyMult(String source, float value) {
        this.modifyMult(source, value, null);
    }

    public void modifyMult(String source, float value, String desc) {
        StatMod mod = this.getMultMods().get(source);
        if (mod == null && value == 1.0f) {
            return;
        }
        if (mod != null && mod.value == value) {
            mod.desc = desc;
            return;
        }
        mod = new StatMod(source, StatModType.MULT, value, desc);
        this.getMultMods().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyMultAlways(String source, float value, String desc) {
        StatMod mod = new StatMod(source, StatModType.MULT, value, desc);
        this.getMultMods().put(source, mod);
        this.needsRecompute = true;
    }

    public void modifyFlatAlways(String source, float value, String desc) {
        StatMod mod = new StatMod(source, StatModType.FLAT, value, desc);
        this.getFlatMods().put(source, mod);
        this.needsRecompute = true;
    }

    public void unmodify() {
        if (this.flatMods != null) {
            this.getFlatMods().clear();
        }
        if (this.percentMods != null) {
            this.getPercentMods().clear();
        }
        if (this.multMods != null) {
            this.getMultMods().clear();
        }
        this.needsRecompute = true;
    }

    public void unmodify(String source) {
        StatMod mod;
        if (this.flatMods != null && (mod = this.getFlatMods().remove(source)) != null && mod.value != 0.0f) {
            this.needsRecompute = true;
        }
        if (this.percentMods != null && (mod = this.getPercentMods().remove(source)) != null && mod.value != 0.0f) {
            this.needsRecompute = true;
        }
        if (this.multMods != null && (mod = this.getMultMods().remove(source)) != null && mod.value != 1.0f) {
            this.needsRecompute = true;
        }
    }

    public void unmodifyFlat(String source) {
        if (this.flatMods == null) {
            return;
        }
        StatMod mod = this.getFlatMods().remove(source);
        if (mod != null && mod.value != 0.0f) {
            this.needsRecompute = true;
        }
    }

    public void unmodifyPercent(String source) {
        if (this.percentMods == null) {
            return;
        }
        StatMod mod = this.getPercentMods().remove(source);
        if (mod != null && mod.value != 0.0f) {
            this.needsRecompute = true;
        }
    }

    public void unmodifyMult(String source) {
        if (this.multMods == null) {
            return;
        }
        StatMod mod = this.getMultMods().remove(source);
        if (mod != null && mod.value != 1.0f) {
            this.needsRecompute = true;
        }
    }

    private void recompute() {
        this.flatMod = 0.0f;
        this.percentMod = 0.0f;
        this.mult = 1.0f;
        if (this.percentMods != null) {
            for (StatMod mod : this.getPercentMods().values()) {
                this.percentMod += mod.value;
            }
        }
        if (this.flatMods != null) {
            for (StatMod mod : this.getFlatMods().values()) {
                this.flatMod += mod.value;
            }
        }
        if (this.multMods != null) {
            for (StatMod mod : this.getMultMods().values()) {
                this.mult *= mod.value;
            }
        }
        this.modified = this.base + this.base * this.percentMod / 100.0f + this.flatMod;
        this.modified *= this.mult;
        this.needsRecompute = false;
    }

    public float getFlatMod() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return this.flatMod;
    }

    public float getPercentMod() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return this.percentMod;
    }

    public float getMult() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return this.mult;
    }

    public float computeMultMod() {
        if (this.multMods == null) {
            return 1.0f;
        }
        float mult = 1.0f;
        for (StatMod mod : this.getMultMods().values()) {
            mult *= mod.value;
        }
        return mult;
    }

    public float getModifiedValue() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return this.modified;
    }

    public int getModifiedInt() {
        if (this.needsRecompute) {
            this.recompute();
        }
        return Math.round(this.modified);
    }

    public float getBaseValue() {
        return this.base;
    }

    public void setBaseValue(float base) {
        if (this.base != base) {
            this.needsRecompute = true;
        }
        this.base = base;
    }

    public boolean isPositive() {
        return this.getModifiedValue() > this.getBaseValue();
    }

    public boolean isNegative() {
        return this.getModifiedValue() < this.getBaseValue();
    }

    public static class StatMod {
        public String source;
        public String desc = null;
        public float value;

        public StatMod(String source, StatModType type, float value) {
            this.source = source;
            this.value = value;
        }

        public StatMod(String source, StatModType type, float value, String desc) {
            this.source = source;
            this.desc = desc;
            this.value = value;
        }

        public String getSource() {
            return this.source;
        }

        public float getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum StatModType {
        PERCENT,
        FLAT,
        MULT;

    }
}

