/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionDoctrineAPI;
import com.fs.starfarer.api.campaign.FactionSpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipSystemSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.intel.misc.SimUpdateIntel;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantOfficerGeneratorPlugin;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.plugins.AutofitPlugin;
import com.fs.starfarer.api.plugins.SimulatorPlugin;
import com.fs.starfarer.api.plugins.impl.CoreAutofitPlugin;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SimulatorPluginImpl
implements SimulatorPlugin,
AutofitPlugin.AutofitPluginDelegate {
    public static boolean INCLUDE_PLAYER_BLUEPRINTS = false;
    public static boolean REQUIRE_AI_CORES = true;
    public static boolean REQUIRE_AI_CORES_IN_CARGO = Global.getSettings().getBoolean("requireAICoresInCargoForSimulator");
    public static String UNLOCKS_DATA_FILE = "core_sim_unlocks.json";
    public static String CUSTOM_OPPONENTS_FILE = "core_sim_custom_opponents.json";
    public static String UI_STATE_DATA_FILE = "core_sim_settings.json";
    public static String DEFAULT_CAT_ID = "cat_default";
    public static String CUSTOM_CAT_ID = "cat_custom";
    public static String OTHER_CAT_ID = "cat_other";
    public static String CIV_CAT_ID = "cat_civ";
    public static String DEV_CAT_ID = "cat_dev";
    public static String AGGRO_ID = "aggro";
    public static String AGGRO_ID_CORES_ONLY = "aggro_cores";
    public static String AGGRO_DEFAULT = "default";
    public static String AGGRO_CAUTIOUS = "cautious";
    public static String AGGRO_STEADY = "steady";
    public static String AGGRO_AGGRESSIVE = "aggressive";
    public static String AGGRO_RECKLESS = "reckless";
    public static String AGGRO_NORMAL = "normal";
    public static String AGGRO_DO_NOTHING = "do_nothing";
    public static String AGGRO_DEFENSES = "defenses_only";
    public static String AGGRO_STATIONARY = "stationary";
    public static String OFFICERS_CUSTOM_ID = "officers_custom";
    public static String OFFICERS_CUSTOM_NONE = "none";
    public static String OFFICERS_CUSTOM_SOME = "some";
    public static String OFFICERS_CUSTOM_5 = "level5";
    public static String OFFICERS_CUSTOM_6 = "level6";
    public static String OFFICERS_ID = "officers";
    public static String OFFICERS_NONE = "none";
    public static String OFFICERS_DEFAULT = "default";
    public static String OFFICERS_ALL = "all";
    public static String QUALITY_ID = "quality";
    public static String QUALITY_MAX_DMODS = "max_dmods";
    public static String QUALITY_SOME_DMODS = "some_dmods";
    public static String QUALITY_NO_DMODS = "no_dmods";
    public static String QUALITY_SOME_SDMODS = "some_smods";
    public static String QUALITY_MANY_SMODS = "many_smods";
    public static String AI_CORES_ID = "ai_cores";
    public static String AI_CORES_DERELICT_ID = "ai_cores_derelict";
    public static String AI_CORES_OMEGA_ID = "ai_cores_omega";
    public static String AI_CORES_DEV_ID = "ai_cores_dev";
    public static String AI_CORES_NONE = "none";
    public static String AI_CORES_SOME = "some";
    public static String AI_CORES_GAMMA = "gamma";
    public static String AI_CORES_BETA = "beta";
    public static String AI_CORES_ALPHA = "alpha";
    public static String AI_CORES_OMEGA = "omega";
    public static String RANDOMIZE_VARIANTS_ID = "randomize_variants";
    public static String INTEGRATE_CORES_ID = "integrate_cores";
    protected SimulatorPlugin.SimUIStateData uiStateData = new SimulatorPlugin.SimUIStateData();
    protected Set<String> defaultOpponents = new LinkedHashSet<String>();
    protected Set<String> customOpponents = new LinkedHashSet<String>();
    protected boolean loadedStuff = false;
    protected SimUnlocksData unlocksData = new SimUnlocksData();

    public static boolean isShowDevCategories() {
        return Global.getSettings().isDevMode() && !Global.getSettings().getBoolean("playtestingMode") || !Global.getCombatEngine().isInCampaignSim() && !Global.getCombatEngine().isInMissionSim();
    }

    public static boolean isSimFullyUnlocked() {
        return Global.getSettings().isDevMode() && !Global.getSettings().getBoolean("playtestingMode") || !Global.getCombatEngine().isInCampaignSim() && !Global.getCombatEngine().isInMissionSim();
    }

    public static boolean isAllStandardStuffUnlocked() {
        return Global.getSettings().getBoolean("allStandardShipsAndFactionsUnlockedInSimulator");
    }

    public SimulatorPluginImpl() {
        this.loadUIStateData();
    }

    public boolean coreReqsMet(String coreId) {
        if (!REQUIRE_AI_CORES || !Global.getCombatEngine().isInCampaignSim()) {
            return true;
        }
        if (SimulatorPluginImpl.isSimFullyUnlocked()) {
            return true;
        }
        return Global.getSector().getPlayerFleet().getCargo().getQuantity(CargoAPI.CargoItemType.RESOURCES, coreId) > 0.0f;
    }

    public boolean isRequireAICoresInCargo() {
        if (!REQUIRE_AI_CORES_IN_CARGO) {
            return false;
        }
        if (SimulatorPluginImpl.isSimFullyUnlocked()) {
            return false;
        }
        return Global.getCombatEngine().isInCampaignSim();
    }

    @Override
    public void addCustomOpponents(List<String> variants) {
        this.customOpponents.addAll(variants);
    }

    @Override
    public void removeCustomOpponents(List<String> variants) {
        this.customOpponents.removeAll(variants);
    }

    public void clearCustomOpponents() {
        this.customOpponents = new LinkedHashSet<String>();
    }

    @Override
    public void loadCustomOpponents() {
        try {
            if (Global.getSettings().fileExistsInCommon(CUSTOM_OPPONENTS_FILE)) {
                this.customOpponents = new LinkedHashSet<String>();
                JSONObject json = Global.getSettings().readJSONFromCommon(CUSTOM_OPPONENTS_FILE, true);
                JSONArray arr = json.optJSONArray("opponents");
                if (arr != null) {
                    int i = 0;
                    while (i < arr.length()) {
                        String variantId = arr.getString(i);
                        if (Global.getSettings().getVariant(variantId) != null) {
                            this.customOpponents.add(variantId);
                        }
                        ++i;
                    }
                }
            } else {
                this.clearCustomOpponents();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveCustomOpponents() {
        try {
            JSONObject json = new JSONObject();
            JSONArray arr = new JSONArray();
            for (String variantId : this.customOpponents) {
                arr.put((Object)variantId);
            }
            json.put("opponents", (Object)arr);
            Global.getSettings().writeJSONToCommon(CUSTOM_OPPONENTS_FILE, json, true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resetToDefaults(boolean withSave) {
        this.uiStateData.settings.clear();
        this.uiStateData.settings.put(AGGRO_ID, AGGRO_DEFAULT);
        this.uiStateData.settings.put(OFFICERS_CUSTOM_ID, OFFICERS_NONE);
        this.uiStateData.settings.put(OFFICERS_ID, OFFICERS_NONE);
        this.uiStateData.settings.put(QUALITY_ID, QUALITY_NO_DMODS);
        this.uiStateData.settings.put(AI_CORES_ID, AI_CORES_NONE);
        this.uiStateData.settings.put(AI_CORES_DERELICT_ID, AI_CORES_NONE);
        this.uiStateData.settings.put(AI_CORES_OMEGA_ID, AI_CORES_NONE);
        this.uiStateData.settings.put(RANDOMIZE_VARIANTS_ID, "false");
        this.uiStateData.settings.put(INTEGRATE_CORES_ID, "false");
        this.uiStateData.groupSize = 0;
        if (withSave) {
            this.saveUIStateData();
        }
    }

    @Override
    public void loadUIStateData() {
        try {
            if (Global.getSettings().fileExistsInCommon(UI_STATE_DATA_FILE)) {
                JSONObject json = Global.getSettings().readJSONFromCommon(UI_STATE_DATA_FILE, true);
                this.uiStateData.fromJSON(json);
            } else {
                this.uiStateData.selectedCategory = DEFAULT_CAT_ID;
                this.uiStateData.showAdvanced = false;
                this.resetToDefaults(false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveUIStateData() {
        try {
            JSONObject json = this.uiStateData.toJSON();
            Global.getSettings().writeJSONToCommon(UI_STATE_DATA_FILE, json, true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SimulatorPlugin.SimUIStateData getUIStateData() {
        return this.uiStateData;
    }

    public void loadUnlocksData() {
        try {
            this.defaultOpponents.clear();
            this.defaultOpponents.addAll(Global.getSettings().getSimOpponents());
            if (Global.getSettings().fileExistsInCommon(UNLOCKS_DATA_FILE)) {
                JSONObject json = Global.getSettings().readJSONFromCommon(UNLOCKS_DATA_FILE, true);
                this.unlocksData.fromJSON(json);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void saveUnlocksData() {
        try {
            JSONObject json = this.unlocksData.toJSON();
            Global.getSettings().writeJSONToCommon(UNLOCKS_DATA_FILE, json, true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SimUnlocksData getUnlocksData() {
        return this.unlocksData;
    }

    @Override
    public List<SimulatorPlugin.AdvancedSimOption> getSimOptions(SimulatorPlugin.SimCategoryData category) {
        boolean integrateCores;
        ArrayList<SimulatorPlugin.AdvancedSimOption> result = new ArrayList<SimulatorPlugin.AdvancedSimOption>();
        boolean custom = CUSTOM_CAT_ID.equals(category.id);
        boolean other = OTHER_CAT_ID.equals(category.id);
        boolean defaultCat = DEFAULT_CAT_ID.equals(category.id);
        boolean civ = CIV_CAT_ID.equals(category.id);
        boolean dev = DEV_CAT_ID.equals(category.id);
        boolean customFaction = custom || civ || dev || defaultCat || other;
        JSONObject json = category.faction.getCustom().optJSONObject("simulatorData");
        boolean standardAICores = json != null && json.optBoolean("standardAICores");
        boolean derelictAICores = json != null && json.optBoolean("derelictAICores");
        boolean omegaAICores = json != null && json.optBoolean("omegaAICores");
        boolean noOfficers = json != null && json.optBoolean("noOfficers");
        boolean showOfficers = !standardAICores && !derelictAICores && !omegaAICores && !noOfficers;
        boolean bl = integrateCores = standardAICores || derelictAICores || dev || custom || other;
        if (custom || defaultCat || other) {
            showOfficers = true;
            standardAICores = true;
            integrateCores = true;
        }
        String aggroExtra = "";
        String aiExtra = "";
        if (custom || defaultCat || dev || other) {
            aggroExtra = "\n\nDoes not affect AI cores or automated ships.";
            aiExtra = "\n\nOnly affects automated ships.";
        }
        String aggroTitle = "Aggression / behavior";
        String aggroId = AGGRO_ID;
        if (!showOfficers) {
            aggroTitle = "Behavior";
            aggroId = AGGRO_ID_CORES_ONLY;
        }
        SimulatorPlugin.SimOptionSelectorData aggro = new SimulatorPlugin.SimOptionSelectorData(aggroId, aggroTitle, true);
        if (showOfficers) {
            if (custom || defaultCat || civ || dev || other) {
                aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_DEFAULT, "Default (steady)", String.valueOf(Global.getSettings().getPersonaltySpec("steady").getDescription().replaceAll("officer", "aggression level")) + aggroExtra, "behavior_default"));
            } else {
                aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_DEFAULT, "Faction default", "Default aggression level for the selected faction." + aggroExtra, "behavior_default"));
            }
            aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_CAUTIOUS, "Cautious", String.valueOf(Global.getSettings().getPersonaltySpec("cautious").getDescription().replaceAll("officer", "aggression level")) + aggroExtra, "behavior_cautious"));
            aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_STEADY, "Steady", String.valueOf(Global.getSettings().getPersonaltySpec("steady").getDescription().replaceAll("officer", "aggression level")) + aggroExtra, "behavior_steady"));
            aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_AGGRESSIVE, "Aggressive", String.valueOf(Global.getSettings().getPersonaltySpec("aggressive").getDescription().replaceAll("officer", "aggression level")) + aggroExtra, "behavior_aggressive"));
            aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_RECKLESS, "Reckless", String.valueOf(Global.getSettings().getPersonaltySpec("reckless").getDescription().replaceAll("officer", "aggression level")) + aggroExtra, "behavior_reckelss"));
        } else {
            aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_NORMAL, "Normal", "Opposing ships will behave normally.", "behavior_default"));
        }
        aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_DO_NOTHING, "Do nothing", "Opposing ships will not move, use shields, fire weapons, or take any other actions.", "behavior_passive"));
        if (showOfficers) {
            aggro.options.get((int)(aggro.options.size() - 1)).extraPad = 10.0f;
        }
        aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_DEFENSES, "Stationary, defenses only", "Opposing ships will not move, but will use shields/phase cloak/other defenses and defensive ship systems, if any.", "behavior_defensive"));
        aggro.options.add(new SimulatorPlugin.SimOptionData(AGGRO_STATIONARY, "Stationary", "Opposing ships will not move, but will otherwise behave normally.", "behavior_stationary"));
        aggro.compact = false;
        result.add(aggro);
        if (showOfficers) {
            if (customFaction) {
                officers = new SimulatorPlugin.SimOptionSelectorData(OFFICERS_CUSTOM_ID, "Officers", true);
                officers.options.add(new SimulatorPlugin.SimOptionData(OFFICERS_CUSTOM_NONE, "None", "No officers on any opposing ships.", "officers_none"));
                officers.options.add(new SimulatorPlugin.SimOptionData(OFFICERS_CUSTOM_SOME, "Some", "Some officers, up to level 5.", "officers_some"));
                officers.options.add(new SimulatorPlugin.SimOptionData(OFFICERS_CUSTOM_5, "All ships, level 5", "Level 5 officers on all opposing ships.", "officers_all"));
                officers.options.add(new SimulatorPlugin.SimOptionData(OFFICERS_CUSTOM_6, "All ships, level 6", "Level 6 officers on all opposing ships.", "officers_high"));
                result.add(officers);
            } else {
                officers = new SimulatorPlugin.SimOptionSelectorData(OFFICERS_ID, "Officers", true);
                officers.options.add(new SimulatorPlugin.SimOptionData(OFFICERS_NONE, "None", "No officers on any opposing ships.", "officers_none"));
                officers.options.add(new SimulatorPlugin.SimOptionData(OFFICERS_DEFAULT, "Faction default", "Default number and level of officers for the selected faction.", "officers_some"));
                officers.options.add(new SimulatorPlugin.SimOptionData(OFFICERS_ALL, "All ships", "Maximum level officers on all opposing ships.", "officers_high"));
                result.add(officers);
            }
        }
        if (standardAICores || derelictAICores || omegaAICores || custom || defaultCat || dev || other) {
            String coresId = AI_CORES_ID;
            if (dev) {
                coresId = AI_CORES_DEV_ID;
            } else if (omegaAICores) {
                coresId = AI_CORES_OMEGA_ID;
            } else if (derelictAICores) {
                coresId = AI_CORES_DERELICT_ID;
            }
            SimulatorPlugin.SimOptionSelectorData cores = new SimulatorPlugin.SimOptionSelectorData(coresId, "AI cores", false);
            cores.options.add(new SimulatorPlugin.SimOptionData(AI_CORES_NONE, "None", "No AI cores on any opposing ships.", "cores_none"));
            boolean enableAlpha = this.coreReqsMet("alpha_core");
            boolean enableBeta = this.coreReqsMet("beta_core") || enableAlpha;
            boolean enableGamma = this.coreReqsMet("gamma_core") || enableBeta;
            boolean enableMixed = enableAlpha || derelictAICores && enableGamma;
            String reqGamma = null;
            if (!enableGamma) {
                reqGamma = "Requires a Gamma Core or better in your cargo.";
            }
            String reqBeta = null;
            if (!enableBeta) {
                reqBeta = "Requires a Beta Core or better in your cargo.";
            }
            String reqAlpha = null;
            if (!enableAlpha) {
                reqAlpha = "Requires an Alpha Core in your cargo.";
            }
            String reqMixed = null;
            if (!enableMixed) {
                reqMixed = derelictAICores ? "Requires a Gamma Core or better in your cargo." : "Requires an Alpha Core in your cargo.";
            }
            String coresCargoNote = "";
            String ifPossible = "";
            if (this.isRequireAICoresInCargo()) {
                boolean canUseCores;
                coresCargoNote = " The AI cores used are limited to the total number and type of cores in your cargo (and storage, if docked).";
                ifPossible = ", if possible";
                boolean bl2 = canUseCores = enableGamma || enableBeta || enableAlpha || enableMixed;
                if (canUseCores) {
                    enableMixed = true;
                    enableAlpha = true;
                    enableBeta = true;
                    enableGamma = true;
                    reqMixed = null;
                    reqAlpha = null;
                    reqBeta = null;
                    reqGamma = null;
                } else {
                    enableMixed = false;
                    enableAlpha = false;
                    enableBeta = false;
                    enableGamma = false;
                    reqMixed = "No AI cores in cargo (or storage, if docked).";
                    reqAlpha = "No AI cores in cargo (or storage, if docked).";
                    reqBeta = "No AI cores in cargo (or storage, if docked).";
                    reqGamma = "No AI cores in cargo (or storage, if docked).";
                }
            }
            if (standardAICores || derelictAICores || dev) {
                cores.options.add(new SimulatorPlugin.SimOptionData(AI_CORES_SOME, "Mixed", "A mix of AI cores on some of the opposing ships, based on the number and size of opponents deployed." + coresCargoNote + aiExtra, enableMixed, reqMixed, "cores_mixed"));
                cores.options.add(new SimulatorPlugin.SimOptionData(AI_CORES_GAMMA, "Gamma cores on all ships", "A gamma core on every opposing ship" + ifPossible + "." + coresCargoNote + aiExtra, enableGamma, reqGamma, "cores_gamma"));
                if (standardAICores || dev) {
                    cores.options.add(new SimulatorPlugin.SimOptionData(AI_CORES_BETA, "Beta cores on all ships", "A beta core on every opposing ship" + ifPossible + "." + coresCargoNote + aiExtra, enableBeta, reqBeta, "cores_beta"));
                    cores.options.add(new SimulatorPlugin.SimOptionData(AI_CORES_ALPHA, "Alpha cores on all ships", "An alpha core on every opposing ship" + ifPossible + "." + coresCargoNote + aiExtra, enableAlpha, reqAlpha, "cores_alpha"));
                }
            }
            if (dev || omegaAICores) {
                cores.options.add(new SimulatorPlugin.SimOptionData(AI_CORES_OMEGA, "Omega cores on all ships", "An omega core on every opposing ship." + aiExtra, "cores_omega"));
            }
            if (!omegaAICores) {
                cores.padAfter = 10.0f;
            }
            result.add(cores);
        }
        if (integrateCores) {
            String iTooltipExtra = "";
            if (dev) {
                iTooltipExtra = "\n\nDoes not affect omega cores.";
            }
            SimulatorPlugin.SimOptionCheckboxData integrate = new SimulatorPlugin.SimOptionCheckboxData(INTEGRATE_CORES_ID, "Integrate AI cores", "AI cores will be integrated into opposing ships, increasing each core's level by 1." + iTooltipExtra);
            result.add(integrate);
        }
        SimulatorPlugin.SimOptionSelectorData quality = new SimulatorPlugin.SimOptionSelectorData(QUALITY_ID, "Ship quality", true);
        quality.options.add(new SimulatorPlugin.SimOptionData(QUALITY_MAX_DMODS, "Maximum d-mods", "Five d-mods on all opposing ships.", "quality_lowest"));
        quality.options.add(new SimulatorPlugin.SimOptionData(QUALITY_SOME_DMODS, "Some d-mods", "Two to four d-mods on all opposing ships.", "quality_low"));
        quality.options.add(new SimulatorPlugin.SimOptionData(QUALITY_NO_DMODS, "No d-mods", "No d-mods on any opposing ships.", "quality_no_dmods"));
        quality.options.add(new SimulatorPlugin.SimOptionData(QUALITY_SOME_SDMODS, "Some s-mods", "One or two s-mods on all opposing ships.", "quality_high"));
        quality.options.add(new SimulatorPlugin.SimOptionData(QUALITY_MANY_SMODS, "Many s-mods", "Two or three s-mods on all opposing ships.", "quality_highest"));
        result.add(quality);
        String rTooltipExtra = "";
        if (customFaction) {
            rTooltipExtra = "\n\nFor the selected category, uses a broader set of weapons than is available to most factions.";
        }
        SimulatorPlugin.SimOptionCheckboxData loadouts = new SimulatorPlugin.SimOptionCheckboxData(RANDOMIZE_VARIANTS_ID, "Randomized loadouts", "Opposing ships have randomized loadouts when this setting is enabled." + rTooltipExtra);
        result.add(loadouts);
        return result;
    }

    @Override
    public boolean showGroupDeploymentWidget(SimulatorPlugin.SimCategoryData category) {
        boolean customFaction;
        boolean custom = CUSTOM_CAT_ID.equals(category.id);
        boolean other = OTHER_CAT_ID.equals(category.id);
        boolean defaultCat = DEFAULT_CAT_ID.equals(category.id);
        boolean civ = CIV_CAT_ID.equals(category.id);
        boolean dev = DEV_CAT_ID.equals(category.id);
        boolean bl = customFaction = custom || civ || dev || defaultCat;
        return !civ;
    }

    @Override
    public SimulatorPlugin.SimCategoryData getCustomCategory() {
        SimulatorPlugin.SimCategoryData custom = new SimulatorPlugin.SimCategoryData();
        custom.id = CUSTOM_CAT_ID;
        custom.name = "Custom";
        custom.custom = true;
        custom.nonFactionCategory = true;
        custom.nameColor = Misc.getBasePlayerColor();
        custom.iconName = Global.getSettings().getSpriteName("simulator", "customPlayerCrest");
        custom.data = null;
        custom.faction = SimulatorPluginImpl.createCustomFaction();
        custom.variants = SimulatorPluginImpl.getVariantIDList(SimulatorPluginImpl.sortVariantList(SimulatorPluginImpl.getVariantList(this.customOpponents)));
        return custom;
    }

    @Override
    public List<SimulatorPlugin.SimCategoryData> getCategories() {
        if (!this.loadedStuff) {
            this.loadCustomOpponents();
            this.loadUnlocksData();
            this.loadedStuff = true;
        }
        boolean fullUnlock = SimulatorPluginImpl.isSimFullyUnlocked() || SimulatorPluginImpl.isAllStandardStuffUnlocked();
        ArrayList<SimulatorPlugin.SimCategoryData> result = new ArrayList<SimulatorPlugin.SimCategoryData>();
        LinkedHashSet<String> civilian = new LinkedHashSet<String>();
        LinkedHashSet<String> other = new LinkedHashSet<String>(this.unlocksData.variants);
        if (Global.getCombatEngine().isInCampaignSim() && INCLUDE_PLAYER_BLUEPRINTS) {
            FactionAPI player = Global.getSector().getPlayerFaction();
            for (String string : SimulatorPluginImpl.getAllRoles()) {
                Set<String> variants = player.getVariantsForRole(string);
                if (variants == null) continue;
                other.addAll(variants);
            }
        }
        for (FactionSpecAPI spec : Global.getSettings().getAllFactionSpecs()) {
            JSONObject json;
            if (spec == null || spec.getCustom() == null || (json = spec.getCustom().optJSONObject("simulatorData")) == null) continue;
            boolean show = json.optBoolean("showInSimulator");
            show |= SimulatorPluginImpl.isShowDevCategories() && json.optBoolean("showInSimulatorDevModeOnly");
            if (!(show &= fullUnlock || this.unlocksData.factions.contains(spec.getId()))) continue;
            boolean includeCiv = json.optBoolean("includeCivShipsWithFaction");
            SimulatorPlugin.SimCategoryData data = new SimulatorPlugin.SimCategoryData();
            data.id = spec.getId();
            data.name = Misc.ucFirst(spec.getDisplayName());
            data.nameColor = spec.getBaseUIColor();
            data.iconName = spec.getCrest();
            data.data = spec;
            data.variants = this.getVariants(spec, includeCiv, false, false);
            data.maxVariants = this.getVariants(spec, includeCiv, false, true).size();
            data.faction = Global.getSettings().createBaseFaction(spec.getId());
            if (!includeCiv) {
                civilian.addAll(this.getVariants(spec, true, true, false));
            }
            if (data.variants == null || data.variants.isEmpty()) continue;
            other.removeAll(data.variants);
            result.add(data);
        }
        other.removeAll(civilian);
        Collections.sort(result, new Comparator<SimulatorPlugin.SimCategoryData>(){

            @Override
            public int compare(SimulatorPlugin.SimCategoryData o1, SimulatorPlugin.SimCategoryData o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        SimulatorPlugin.SimCategoryData custom = this.getCustomCategory();
        result.add(0, custom);
        SimulatorPlugin.SimCategoryData simCategoryData = new SimulatorPlugin.SimCategoryData();
        simCategoryData.id = DEFAULT_CAT_ID;
        simCategoryData.name = "Default";
        simCategoryData.nonFactionCategory = true;
        simCategoryData.nameColor = Misc.getBasePlayerColor();
        simCategoryData.iconName = Global.getSettings().getSpriteName("simulator", "defaultPlayerCrest");
        simCategoryData.data = null;
        simCategoryData.faction = SimulatorPluginImpl.createCustomFaction();
        simCategoryData.variants = SimulatorPluginImpl.getVariantIDList(SimulatorPluginImpl.sortVariantList(SimulatorPluginImpl.getVariantList(new LinkedHashSet<String>(Global.getSettings().getSimOpponents()))));
        result.add(0, simCategoryData);
        other.removeAll(simCategoryData.variants);
        if (!other.isEmpty()) {
            SimulatorPlugin.SimCategoryData otherCat = new SimulatorPlugin.SimCategoryData();
            otherCat.id = OTHER_CAT_ID;
            otherCat.name = "Other";
            otherCat.nonFactionCategory = true;
            otherCat.nameColor = Misc.getBasePlayerColor();
            otherCat.iconName = Global.getSettings().getSpriteName("simulator", "otherPlayerCrest");
            otherCat.data = null;
            otherCat.faction = SimulatorPluginImpl.createCustomFaction();
            otherCat.variants = SimulatorPluginImpl.getVariantIDList(SimulatorPluginImpl.sortVariantList(SimulatorPluginImpl.getVariantList(other)));
            otherCat.faction = SimulatorPluginImpl.createCustomFaction();
            if (!otherCat.variants.isEmpty()) {
                result.add(otherCat);
            }
        }
        if (!civilian.isEmpty()) {
            FactionSpecAPI neutral = Global.getSettings().getFactionSpec("neutral");
            SimulatorPlugin.SimCategoryData civ = new SimulatorPlugin.SimCategoryData();
            civ.id = CIV_CAT_ID;
            civ.name = "Civilian ships";
            civ.nonFactionCategory = true;
            civ.nameColor = neutral.getBaseUIColor();
            civ.iconName = neutral.getCrest();
            civ.data = null;
            civ.variants = SimulatorPluginImpl.getVariantIDList(SimulatorPluginImpl.sortVariantList(SimulatorPluginImpl.getVariantList(civilian)));
            civ.faction = SimulatorPluginImpl.createCustomFaction();
            if (!civ.variants.isEmpty()) {
                result.add(civ);
            }
        }
        if (SimulatorPluginImpl.isShowDevCategories()) {
            SimulatorPlugin.SimCategoryData dev = new SimulatorPlugin.SimCategoryData();
            dev.id = DEV_CAT_ID;
            dev.name = "DevMode stuff";
            dev.nonFactionCategory = true;
            dev.nameColor = Misc.getBasePlayerColor();
            dev.iconName = Global.getSettings().getSpriteName("simulator", "devModeVariantsIcon");
            dev.data = null;
            dev.faction = SimulatorPluginImpl.createCustomFaction();
            dev.variants = SimulatorPluginImpl.getVariantIDList(SimulatorPluginImpl.sortVariantList(SimulatorPluginImpl.getVariantList(new LinkedHashSet<String>(Global.getSettings().getSimOpponentsDev()))));
            result.add(1, dev);
        }
        return result;
    }

    public List<String> getVariants(FactionSpecAPI spec, boolean withCiv, boolean onlyCiv, boolean forceFullUnlock) {
        if (spec == null) {
            return new ArrayList<String>();
        }
        FactionAPI faction = Global.getSettings().createBaseFaction(spec.getId());
        boolean fullUnlock = SimulatorPluginImpl.isSimFullyUnlocked() || forceFullUnlock || SimulatorPluginImpl.isAllStandardStuffUnlocked();
        LinkedHashSet<String> seen = new LinkedHashSet<String>();
        ArrayList<ShipVariantAPI> variantList = new ArrayList<ShipVariantAPI>();
        for (String roleId : SimulatorPluginImpl.getAllRoles()) {
            Set<String> variants = faction.getVariantsForRole(roleId);
            if (variants == null) continue;
            for (String variantId : variants) {
                boolean civ;
                ShipVariantAPI v;
                if (seen.contains(variantId)) continue;
                seen.add(variantId);
                if (!fullUnlock && !this.unlocksData.variants.contains(variantId) && !this.defaultOpponents.contains(variantId) || !this.isAcceptableSimVariant(v = Global.getSettings().getVariant(variantId), false) || !v.isStockVariant() || (civ = v.isCivilian()) && !withCiv || !civ && onlyCiv) continue;
                variantList.add(v);
            }
        }
        SimulatorPluginImpl.sortVariantList(variantList);
        return SimulatorPluginImpl.getVariantIDList(variantList);
    }

    public static List<ShipVariantAPI> getVariantList(Set<String> variants) {
        ArrayList<ShipVariantAPI> variantList = new ArrayList<ShipVariantAPI>();
        for (String id : variants) {
            ShipVariantAPI v = Global.getSettings().getVariant(id);
            if (v == null || !v.isStockVariant()) continue;
            variantList.add(v);
        }
        return variantList;
    }

    public static List<String> getVariantIDList(List<ShipVariantAPI> variantList) {
        ArrayList<String> variants = new ArrayList<String>();
        for (ShipVariantAPI v : variantList) {
            variants.add(v.getHullVariantId());
        }
        return variants;
    }

    public static List<ShipVariantAPI> sortVariantList(List<ShipVariantAPI> variantList) {
        Collections.sort(variantList, new Comparator<ShipVariantAPI>(){

            @Override
            public int compare(ShipVariantAPI v1, ShipVariantAPI v2) {
                if (v1.isCivilian() && !v2.isCivilian()) {
                    return 1;
                }
                if (v2.isCivilian() && !v1.isCivilian()) {
                    return -1;
                }
                if (v1.getHullSize().ordinal() < v2.getHullSize().ordinal()) {
                    return 1;
                }
                if (v1.getHullSize().ordinal() > v2.getHullSize().ordinal()) {
                    return -1;
                }
                int diff = (int)(v1.getHullSpec().getSuppliesToRecover() - v2.getHullSpec().getSuppliesToRecover());
                if (diff != 0) {
                    return (int)Math.signum(-diff);
                }
                return v1.getHullSpec().getHullName().compareTo(v2.getHullSpec().getHullName());
            }
        });
        return variantList;
    }

    public static List<String> getAllRoles() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("combatSmall");
        result.add("combatMedium");
        result.add("combatLarge");
        result.add("combatCapital");
        result.add("combatFreighterSmall");
        result.add("combatFreighterMedium");
        result.add("combatFreighterLarge");
        result.add("civilianRandom");
        result.add("phaseSmall");
        result.add("phaseMedium");
        result.add("phaseLarge");
        result.add("phaseCapital");
        result.add("carrierSmall");
        result.add("carrierMedium");
        result.add("carrierLarge");
        result.add("freighterSmall");
        result.add("freighterMedium");
        result.add("freighterLarge");
        result.add("tankerSmall");
        result.add("tankerMedium");
        result.add("tankerLarge");
        result.add("personnelSmall");
        result.add("personnelMedium");
        result.add("personnelLarge");
        result.add("linerSmall");
        result.add("linerMedium");
        result.add("linerLarge");
        result.add("tug");
        result.add("crig");
        result.add("utility");
        return result;
    }

    @Override
    public void applySettingsToFleetMembers(List<FleetMemberAPI> members, SimulatorPlugin.SimCategoryData category, Map<String, String> settings) {
        boolean custom = CUSTOM_CAT_ID.equals(category.id);
        boolean defaultCat = DEFAULT_CAT_ID.equals(category.id);
        boolean civ = CIV_CAT_ID.equals(category.id);
        boolean dev = DEV_CAT_ID.equals(category.id);
        boolean customFaction = custom || civ || dev || defaultCat;
        FactionAPI faction = category.faction;
        String officers = settings.get(OFFICERS_ID);
        if (officers == null) {
            officers = settings.get(OFFICERS_CUSTOM_ID);
        }
        if (officers != null && !officers.equals(OFFICERS_NONE) && !officers.equals(OFFICERS_CUSTOM_NONE)) {
            CampaignFleetAPI fleetNonAuto = Global.getFactory().createEmptyFleet(faction, true);
            for (FleetMemberAPI member : members) {
                if (Misc.isAutomated(member)) continue;
                fleetNonAuto.getFleetData().addFleetMember(member);
            }
            FleetParamsV3 params = new FleetParamsV3();
            boolean all = false;
            if (officers.equals(OFFICERS_ALL)) {
                all = true;
                params.officerNumberBonus = 1000;
                params.officerLevelBonus = 10;
            } else if (officers.equals(OFFICERS_CUSTOM_5)) {
                all = true;
                params.officerNumberBonus = 1000;
                params.officerLevelBonus = 10;
                params.officerLevelLimit = 5;
            } else if (officers.equals(OFFICERS_CUSTOM_6)) {
                all = true;
                params.officerNumberBonus = 1000;
                params.officerLevelBonus = 10;
                params.commander = Global.getFactory().createPerson();
                params.commander.getStats().setSkillLevel("officer_training", 1.0f);
                params.officerLevelLimit = 6;
            }
            FleetFactoryV3.addCommanderAndOfficersV2(fleetNonAuto, params, new Random(), true, all);
        }
        String cores = settings.get(AI_CORES_ID);
        boolean derelict = false;
        if (cores == null && (cores = settings.get(AI_CORES_DERELICT_ID)) != null) {
            derelict = true;
        }
        if (cores == null) {
            cores = settings.get(AI_CORES_OMEGA_ID);
        }
        if (cores == null) {
            cores = settings.get(AI_CORES_DEV_ID);
        }
        if (cores != null && !cores.equals(AI_CORES_NONE)) {
            CampaignFleetAPI fleetAuto = Global.getFactory().createEmptyFleet(faction, true);
            for (FleetMemberAPI member : members) {
                if (!Misc.isAutomated(member)) continue;
                fleetAuto.getFleetData().addFleetMember(member);
            }
            FleetParamsV3 params = new FleetParamsV3();
            params.doNotIntegrateAICores = true;
            boolean all = false;
            boolean omega = false;
            if (cores.equals(AI_CORES_SOME)) {
                params.aiCores = derelict ? HubMissionWithTriggers.OfficerQuality.AI_GAMMA : HubMissionWithTriggers.OfficerQuality.AI_MIXED;
            } else if (cores.equals(AI_CORES_GAMMA)) {
                params.officerNumberBonus = 1000;
                params.aiCores = HubMissionWithTriggers.OfficerQuality.AI_GAMMA;
                all = true;
            } else if (cores.equals(AI_CORES_BETA)) {
                params.officerNumberBonus = 1000;
                params.aiCores = HubMissionWithTriggers.OfficerQuality.AI_BETA;
                all = true;
            } else if (cores.equals(AI_CORES_ALPHA)) {
                params.officerNumberBonus = 1000;
                params.aiCores = HubMissionWithTriggers.OfficerQuality.AI_ALPHA;
                all = true;
            } else if (cores.equals(AI_CORES_OMEGA)) {
                params.officerNumberBonus = 1000;
                params.aiCores = HubMissionWithTriggers.OfficerQuality.AI_OMEGA;
                all = true;
                omega = true;
            }
            RemnantOfficerGeneratorPlugin genPlugin = new RemnantOfficerGeneratorPlugin(false, 1.0f);
            if (settings.containsKey(INTEGRATE_CORES_ID) && settings.get(INTEGRATE_CORES_ID).toLowerCase().equals("true") && !omega) {
                genPlugin.setForceIntegrateCores(true);
            }
            genPlugin.setPutCoresOnCivShips(all);
            genPlugin.setForceNoCommander(true);
            genPlugin.addCommanderAndOfficers(fleetAuto, params, new Random());
            this.pruneAICoresToAvailable(members);
        }
        String personality = null;
        if (settings.containsKey(AGGRO_ID) || settings.containsKey(AGGRO_ID_CORES_ONLY)) {
            String aggro = settings.get(AGGRO_ID);
            if (aggro == null) {
                aggro = settings.get(AGGRO_ID_CORES_ONLY);
            }
            if (aggro.equals(AGGRO_CAUTIOUS)) {
                personality = "cautious";
            } else if (aggro.equals(AGGRO_STEADY)) {
                personality = "steady";
            } else if (aggro.equals(AGGRO_AGGRESSIVE)) {
                personality = "aggressive";
            } else if (aggro.equals(AGGRO_RECKLESS)) {
                personality = "reckless";
            }
        }
        if (personality != null) {
            for (FleetMemberAPI member : members) {
                if (Misc.isAutomated(member)) continue;
                PersonAPI captain = member.getCaptain();
                captain.setPersonality(personality);
                member.setPersonalityOverride(personality);
            }
        }
        CampaignFleetAPI fleet = Global.getFactory().createEmptyFleet(faction, true);
        for (FleetMemberAPI member : members) {
            fleet.getFleetData().addFleetMember(member);
        }
        if (settings.containsKey(RANDOMIZE_VARIANTS_ID) && settings.get(RANDOMIZE_VARIANTS_ID).toLowerCase().equals("true")) {
            DefaultFleetInflaterParams params = new DefaultFleetInflaterParams();
            params.quality = 2.0f;
            DefaultFleetInflater inflater = new DefaultFleetInflater(params);
            inflater.inflate(fleet);
        }
        if (settings.containsKey(QUALITY_ID)) {
            for (FleetMemberAPI member : members) {
                if (!member.getVariant().isStockVariant()) continue;
                ShipVariantAPI copy = member.getVariant().clone();
                copy.setSource(VariantSource.REFIT);
                member.setVariant(copy, false, false);
            }
            String quality = settings.get(QUALITY_ID);
            if (!quality.equals(QUALITY_NO_DMODS)) {
                if (quality.equals(QUALITY_MAX_DMODS)) {
                    for (FleetMemberAPI member : members) {
                        DModManager.addDMods(member, true, 5, null);
                    }
                } else if (quality.equals(QUALITY_SOME_DMODS)) {
                    random = new Random();
                    for (FleetMemberAPI member : members) {
                        int num = 2 + random.nextInt(3);
                        DModManager.addDMods(member, true, num, null);
                    }
                } else if (quality.equals(QUALITY_SOME_SDMODS)) {
                    random = new Random();
                    plugin = new CoreAutofitPlugin(null);
                    for (FleetMemberAPI member : members) {
                        int num = 1 + random.nextInt(2);
                        plugin.addSMods(member, num, this);
                    }
                } else if (quality.equals(QUALITY_MANY_SMODS)) {
                    random = new Random();
                    plugin = new CoreAutofitPlugin(null);
                    for (FleetMemberAPI member : members) {
                        int num = 2 + random.nextInt(2);
                        plugin.addSMods(member, num, this);
                    }
                }
            }
        }
        fleet.setCommander(Global.getFactory().createPerson());
    }

    @Override
    public void applySettingsToDeployed(List<DeployedFleetMemberAPI> deployed, Map<String, String> settings) {
        block3: {
            String aggro2;
            String aggro;
            block4: {
                if (!settings.containsKey(AGGRO_ID) && !settings.containsKey(AGGRO_ID_CORES_ONLY)) break block3;
                aggro = settings.get(AGGRO_ID);
                if (aggro == null) {
                    aggro = settings.get(AGGRO_ID_CORES_ONLY);
                }
                aggro2 = aggro;
                if (!aggro.equals(AGGRO_DO_NOTHING)) break block4;
                for (DeployedFleetMemberAPI member : deployed) {
                    final ShipAPI ship = member.getShip();
                    if (ship == null || ship.getOwner() == 0) continue;
                    ship.setShipAI(null);
                    ship.setHoldFire(true);
                    ship.getLocation().y -= 2000.0f;
                    Global.getCombatEngine().addPlugin(new BaseEveryFrameCombatPlugin(){
                        protected float elapsed = 0.0f;

                        @Override
                        public void advance(float amount, List<InputEventAPI> events) {
                            this.elapsed += amount;
                            if (ship.getTravelDrive() != null) {
                                ship.getTravelDrive().deactivate();
                            }
                            if (this.elapsed > 0.1f) {
                                ship.getVelocity().set(0.0f, 0.0f);
                                this.elapsed = -1.0E7f;
                            }
                            ship.giveCommand(ShipCommand.DECELERATE, null, 0);
                            if (ship.isHulk()) {
                                Global.getCombatEngine().removePlugin(this);
                            }
                        }
                    });
                }
                break block3;
            }
            if (!aggro.equals(AGGRO_DEFENSES) && !aggro.equals(AGGRO_STATIONARY)) break block3;
            final boolean defensesOnly = aggro.equals(AGGRO_DEFENSES);
            for (DeployedFleetMemberAPI member : deployed) {
                final ShipAPI ship = member.getShip();
                if (ship == null || ship.getOwner() == 0) continue;
                ship.getLocation().y -= 2000.0f;
                Global.getCombatEngine().addPlugin(new BaseEveryFrameCombatPlugin(){
                    protected float elapsed = 0.0f;

                    @Override
                    public void advance(float amount, List<InputEventAPI> events) {
                        this.elapsed += amount;
                        if (ship.getTravelDrive() != null && ship.getTravelDrive().isActive()) {
                            ship.getTravelDrive().deactivate();
                        }
                        if (this.elapsed > 0.1f) {
                            ship.getVelocity().set(0.0f, 0.0f);
                            this.elapsed = -1.0E7f;
                        }
                        ArrayList<ShipAPI> all = new ArrayList<ShipAPI>(ship.getChildModulesCopy());
                        all.add(ship);
                        for (ShipAPI curr : all) {
                            ShipSystemSpecAPI spec;
                            if (aggro2.equals(AGGRO_DEFENSES)) {
                                curr.setHoldFire(true);
                            }
                            curr.giveCommand(ShipCommand.DECELERATE, null, 0);
                            curr.blockCommandForOneFrame(ShipCommand.ACCELERATE);
                            curr.blockCommandForOneFrame(ShipCommand.ACCELERATE_BACKWARDS);
                            curr.blockCommandForOneFrame(ShipCommand.STRAFE_LEFT);
                            curr.blockCommandForOneFrame(ShipCommand.STRAFE_RIGHT);
                            if (defensesOnly) {
                                curr.blockCommandForOneFrame(ShipCommand.FIRE);
                                curr.blockCommandForOneFrame(ShipCommand.VENT_FLUX);
                                curr.blockCommandForOneFrame(ShipCommand.PULL_BACK_FIGHTERS);
                                curr.blockCommandForOneFrame(ShipCommand.TOGGLE_AUTOFIRE);
                                curr.blockCommandForOneFrame(ShipCommand.HOLD_FIRE);
                                if (curr.getSystem() == null || curr.getSystem().getSpecAPI() == null || (spec = curr.getSystem().getSpecAPI()).hasTag("defensive") && !spec.hasTag("offensive") && !spec.hasTag("movement")) continue;
                                curr.blockCommandForOneFrame(ShipCommand.USE_SYSTEM);
                                continue;
                            }
                            if (curr.getSystem() == null || curr.getSystem().getSpecAPI() == null || !(spec = curr.getSystem().getSpecAPI()).hasTag("movement")) continue;
                            curr.blockCommandForOneFrame(ShipCommand.USE_SYSTEM);
                        }
                        if (ship.isHulk()) {
                            Global.getCombatEngine().removePlugin(this);
                        }
                    }
                });
            }
        }
    }

    public static FactionAPI createCustomFaction() {
        FactionAPI faction = Global.getSettings().createBaseFaction("independent");
        FactionDoctrineAPI d = faction.getDoctrine();
        d.setAggression(2);
        d.setCarriers(2);
        d.setPhaseShips(1);
        d.setWarships(4);
        d.setAutofitRandomizeProbability(0.25f);
        d.setNumShips(3);
        d.setOfficerQuality(3);
        d.setShipSize(3);
        FactionAPI merc = Global.getSettings().createBaseFaction("mercenary");
        for (String id : merc.getKnownWeapons()) {
            faction.addKnownWeapon(id, false);
        }
        for (String id : merc.getKnownFighters()) {
            faction.addKnownFighter(id, false);
        }
        for (String id : merc.getKnownHullMods()) {
            faction.addKnownHullMod(id);
        }
        faction.getPriorityWeapons().clear();
        faction.getPriorityFighters().clear();
        faction.getHullFrequency().clear();
        return faction;
    }

    public static void makeFleetCommanderNormalOfficer(List<FleetMemberAPI> members) {
        PersonAPI captain;
        int maxLevel = (int)Global.getSettings().getFloat("officerMaxLevel");
        for (FleetMemberAPI member : members) {
            captain = member.getCaptain();
            if (member.isFlagship() || captain.isDefault()) continue;
            maxLevel = Math.max(maxLevel, captain.getStats().getLevel());
        }
        for (FleetMemberAPI member : members) {
            if (!member.isFlagship()) continue;
            captain = member.getCaptain();
            member.setFlagship(false, false);
            captain.getStats().setLevel(Math.min(captain.getStats().getLevel(), maxLevel));
            for (String skillId : Global.getSettings().getSkillIds()) {
                SkillSpecAPI skill = Global.getSettings().getSkillSpec(skillId);
                if (!skill.isAdmiralSkill()) continue;
                captain.getStats().setSkillLevel(skillId, 0.0f);
            }
        }
    }

    @Override
    public List<String> generateSelection(SimulatorPlugin.SimCategoryData category, int deploymentPoints) {
        ArrayList<String> result = new ArrayList<String>();
        if (category.variants.isEmpty()) {
            return result;
        }
        FactionAPI faction = Global.getSettings().createBaseFaction(category.faction.getId());
        category.faction.getDoctrine().copyToDoctrine(faction.getDoctrine());
        faction.clearShipRoleCache();
        faction.getRestrictToVariants().clear();
        faction.getKnownShips().clear();
        for (String variantId : category.variants) {
            ShipVariantAPI v = Global.getSettings().getVariant(variantId);
            if (v == null || !v.isStockVariant()) continue;
            faction.addKnownShip(v.getHullSpec().getHullId(), false);
            faction.getRestrictToVariants().add(variantId);
        }
        FleetParamsV3 params = new FleetParamsV3(null, "independent", Float.valueOf(2.0f), "patrolLarge", (float)deploymentPoints * 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        params.maxNumShips = 100;
        params.factionOverride = faction;
        params.ignoreMarketFleetSizeMult = true;
        params.withOfficers = false;
        params.modeOverride = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        SimulatorPluginImpl.pruneFleetDownToDP(fleet, deploymentPoints, new Random());
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            ShipVariantAPI v = member.getVariant();
            if (v == null || !v.isStockVariant()) continue;
            result.add(v.getHullVariantId());
        }
        return result;
    }

    @Override
    public void fitFighterInSlot(int index, AutofitPlugin.AvailableFighter fighter, ShipVariantAPI variant) {
    }

    @Override
    public void clearFighterSlot(int index, ShipVariantAPI variant) {
    }

    @Override
    public void fitWeaponInSlot(WeaponSlotAPI slot, AutofitPlugin.AvailableWeapon weapon, ShipVariantAPI variant) {
    }

    @Override
    public void clearWeaponSlot(WeaponSlotAPI slot, ShipVariantAPI variant) {
    }

    @Override
    public List<AutofitPlugin.AvailableWeapon> getAvailableWeapons() {
        return new ArrayList<AutofitPlugin.AvailableWeapon>();
    }

    @Override
    public List<AutofitPlugin.AvailableFighter> getAvailableFighters() {
        return new ArrayList<AutofitPlugin.AvailableFighter>();
    }

    @Override
    public boolean isPriority(WeaponSpecAPI weapon) {
        return false;
    }

    @Override
    public boolean isPriority(FighterWingSpecAPI wing) {
        return false;
    }

    @Override
    public void syncUIWithVariant(ShipVariantAPI variant) {
    }

    @Override
    public ShipAPI getShip() {
        return null;
    }

    @Override
    public FactionAPI getFaction() {
        return null;
    }

    @Override
    public boolean isAllowSlightRandomization() {
        return false;
    }

    @Override
    public boolean isPlayerCampaignRefit() {
        return false;
    }

    @Override
    public boolean canAddRemoveHullmodInPlayerCampaignRefit(String modId) {
        return true;
    }

    @Override
    public List<String> getAvailableHullmods() {
        ArrayList<String> ids = new ArrayList<String>();
        for (HullModSpecAPI mod : Global.getSettings().getAllHullModSpecs()) {
            ids.add(mod.getId());
        }
        return ids;
    }

    public static void pruneFleetDownToDP(CampaignFleetAPI fleet, float targetDP, Random random) {
        float currDP = SimulatorPluginImpl.getDP(fleet);
        if (currDP > targetDP) {
            fleet.getFleetData().sort();
            float fpRem = currDP - targetDP;
            while (fpRem > 0.0f) {
                List<FleetMemberAPI> copy = fleet.getFleetData().getMembersListCopy();
                CountingMap<ShipAPI.HullSize> counts = new CountingMap<ShipAPI.HullSize>();
                for (FleetMemberAPI curr : copy) {
                    counts.add(curr.getHullSpec().getHullSize());
                }
                WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>(random);
                for (FleetMemberAPI curr : copy) {
                    float dp = curr.getDeploymentPointsCost();
                    if (!(dp <= fpRem)) continue;
                    int count = counts.getCount(curr.getHullSpec().getHullSize());
                    float mult = 1.0f;
                    mult = count <= 1 ? 1.0E-4f : (float)count;
                    picker.add(curr, dp * mult);
                }
                FleetMemberAPI pick = (FleetMemberAPI)picker.pick();
                if (pick == null) break;
                float dp = pick.getDeploymentPointsCost();
                fpRem -= dp;
                fleet.getFleetData().removeFleetMember(pick);
            }
        }
    }

    public static float getDP(CampaignFleetAPI fleet) {
        float total = 0.0f;
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            total += member.getDeploymentPointsCost();
        }
        return total;
    }

    @Override
    public void reportPlayerBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (!this.loadedStuff) {
            this.loadCustomOpponents();
            this.loadUnlocksData();
            this.loadedStuff = true;
        }
        LinkedHashSet<String> addedFactions = new LinkedHashSet<String>();
        LinkedHashSet<String> addedVariants = new LinkedHashSet<String>();
        for (CampaignFleetAPI fleet : battle.getNonPlayerSideSnapshot()) {
            boolean show;
            JSONObject json;
            if (fleet.getFaction() == null || fleet.getFaction().getFactionSpec() == null || fleet.getFaction().getFactionSpec().getCustom() == null || (json = fleet.getFaction().getFactionSpec().getCustom().optJSONObject("simulatorData")) == null || !(show = json.optBoolean("showInSimulator"))) continue;
            List<FleetMemberAPI> members = Misc.getSnapshotMembersLost(fleet);
            String fid = this.findBestMatchingFaction(fleet.getFaction().getId(), members);
            if (!this.unlocksData.factions.contains(fid)) {
                this.unlocksData.factions.add(fid);
                addedFactions.add(fid);
            }
            for (FleetMemberAPI member : members) {
                String vid = this.getStockVariantId(member);
                if (vid == null || this.unlocksData.variants.contains(vid)) continue;
                this.unlocksData.variants.add(vid);
                addedVariants.add(vid);
            }
        }
        if (!addedVariants.isEmpty()) {
            addedVariants = new LinkedHashSet<String>(SimulatorPluginImpl.getVariantIDList(SimulatorPluginImpl.sortVariantList(SimulatorPluginImpl.getVariantList(new LinkedHashSet<String>(addedVariants)))));
        }
        if (!addedFactions.isEmpty() || !addedVariants.isEmpty()) {
            this.saveUnlocksData();
            new SimUpdateIntel(addedFactions, addedVariants);
        }
    }

    public boolean isAcceptableSimVariant(ShipVariantAPI v, boolean forLearning) {
        boolean allowAll;
        boolean bl = allowAll = SimulatorPluginImpl.isSimFullyUnlocked() && !forLearning;
        if (v == null) {
            return false;
        }
        if ((v.getHullSpec().hasTag("no_sim") || v.hasTag("no_sim")) && !allowAll) {
            return false;
        }
        if (v.getHullSpec().hasTag("restricted") && !allowAll) {
            return false;
        }
        return !v.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.STATION);
    }

    public String getStockVariantId(FleetMemberAPI member) {
        ShipVariantAPI v = member.getVariant();
        if (!this.isAcceptableSimVariant(v, true)) {
            return null;
        }
        String vid = null;
        if (v.isStockVariant()) {
            vid = v.getHullVariantId();
        }
        if (vid == null && v.getOriginalVariant() != null) {
            vid = v.getOriginalVariant();
        }
        return vid;
    }

    public String findBestMatchingFaction(String fleetFactionId, List<FleetMemberAPI> members) {
        List<String> roles = SimulatorPluginImpl.getAllRoles();
        FactionAPI best = null;
        float bestScore = 0.0f;
        for (FactionSpecAPI spec : Global.getSettings().getAllFactionSpecs()) {
            boolean show;
            JSONObject json;
            if (spec == null || spec.getCustom() == null || (json = spec.getCustom().optJSONObject("simulatorData")) == null || !(show = json.optBoolean("showInSimulator"))) continue;
            FactionAPI faction = Global.getSector().getFaction(spec.getId());
            LinkedHashSet<String> allVariants = new LinkedHashSet<String>();
            for (String roleId : roles) {
                allVariants.addAll(faction.getVariantsForRole(roleId));
            }
            float matches = 0.0f;
            float total = 0.0f;
            for (FleetMemberAPI member : members) {
                String vid = this.getStockVariantId(member);
                if (vid == null) continue;
                if (allVariants.contains(vid)) {
                    matches += 1.0f;
                }
                total += 1.0f;
            }
            total = Math.max(total, 1.0f);
            float score = matches / total;
            if (faction.getId().equals(fleetFactionId)) {
                score *= 1.1f;
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            best = faction;
        }
        if (best == null || bestScore <= 0.0f) {
            return fleetFactionId;
        }
        return best.getId();
    }

    public void pruneAICoresToAvailable(List<FleetMemberAPI> members) {
        if (!this.isRequireAICoresInCargo()) {
            return;
        }
        CountingMap<String> availableCores = this.getAvailableMinusDeployedAICores();
        CountingMap<Object> current = new CountingMap<Object>();
        for (FleetMemberAPI member : members) {
            String coreId = this.getCoreId(member);
            if (coreId == null) continue;
            current.add(coreId, 1);
        }
        CountingMap<String> remove = new CountingMap<String>();
        remove.putAll(current);
        for (String id : availableCores.keySet()) {
            remove.sub(id, availableCores.getCount(id));
        }
        if (remove.isEmpty()) {
            return;
        }
        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>();
        for (FleetMemberAPI member : members) {
            String coreId = this.getCoreId(member);
            if (coreId == null || remove.getCount(coreId) <= 0) continue;
            picker.add(member, member.getDeploymentPointsCost());
        }
        while (!remove.isEmpty() && !picker.isEmpty()) {
            FleetMemberAPI member;
            member = (FleetMemberAPI)picker.pickAndRemove();
            String coreId = this.getCoreId(member);
            if (remove.getCount(coreId) <= 0) continue;
            remove.sub(coreId, 1);
            member.setCaptain(Global.getFactory().createPerson());
        }
    }

    public String getCoreId(FleetMemberAPI member) {
        if (member == null) {
            return null;
        }
        PersonAPI captain = member.getCaptain();
        if (captain == null || captain.isDefault() || !captain.isAICore()) {
            return null;
        }
        return captain.getAICoreId();
    }

    public CountingMap<String> getAvailableMinusDeployedAICores() {
        CountingMap<String> cargoCores = this.getAvailableAICores();
        CountingMap<String> deployedCores = this.getDeployedAICores();
        CountingMap<String> availableCores = new CountingMap<String>();
        availableCores.putAll(cargoCores);
        for (String id : deployedCores.keySet()) {
            availableCores.sub(id, deployedCores.getCount(id));
        }
        return availableCores;
    }

    public CountingMap<String> getDeployedAICores() {
        CountingMap<String> map = new CountingMap<String>();
        for (DeployedFleetMemberAPI member : Global.getCombatEngine().getFleetManager(FleetSide.ENEMY).getDeployedCopyDFM()) {
            String coreId;
            PersonAPI captain;
            if (member.getShip() == null || (captain = member.getShip().getCaptain()) == null || captain.isDefault() || !captain.isAICore() || (coreId = captain.getAICoreId()) == null) continue;
            map.add(coreId, 1);
        }
        return map;
    }

    public CountingMap<String> getAvailableAICores() {
        CountingMap<String> map = new CountingMap<String>();
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        CargoAPI cargo = player.getCargo();
        map.add("alpha_core", Math.round(cargo.getCommodityQuantity("alpha_core")));
        map.add("beta_core", Math.round(cargo.getCommodityQuantity("beta_core")));
        map.add("gamma_core", Math.round(cargo.getCommodityQuantity("gamma_core")));
        cargo = Misc.getStorageCargo(Global.getSector().getCurrentlyOpenMarket());
        if (cargo != null) {
            map.add("alpha_core", Math.round(cargo.getCommodityQuantity("alpha_core")));
            map.add("beta_core", Math.round(cargo.getCommodityQuantity("beta_core")));
            map.add("gamma_core", Math.round(cargo.getCommodityQuantity("gamma_core")));
        }
        return map;
    }

    @Override
    public void appendToTooltip(TooltipMakerAPI info, float initPad, float width, SimulatorPlugin.AdvancedSimOption option, Object extra) {
        if (this.isRequireAICoresInCargo() && option.getId().equals(AI_CORES_ID) && extra != null && (extra.equals(AI_CORES_SOME) || extra.equals(AI_CORES_GAMMA) || extra.equals(AI_CORES_BETA) || extra.equals(AI_CORES_ALPHA))) {
            CountingMap<String> cores = this.getAvailableAICores();
            CargoAPI cargo = Global.getFactory().createCargo(true);
            for (String id : cores.keySet()) {
                cargo.addCommodity(id, cores.getCount(id));
            }
            float opad = 10.0f;
            info.addSectionHeading("AI cores in cargo & storage", Alignment.MID, initPad);
            if (cargo.isEmpty()) {
                info.addPara("      None", opad);
            } else {
                info.showCargo(cargo, 10, true, opad);
            }
            cores = this.getDeployedAICores();
            cargo = Global.getFactory().createCargo(true);
            for (String id : cores.keySet()) {
                cargo.addCommodity(id, cores.getCount(id));
            }
            info.addSectionHeading("Cores already in use in simulation", Alignment.MID, initPad);
            if (cargo.isEmpty()) {
                info.addPara("      None", opad);
            } else {
                info.showCargo(cargo, 10, true, opad);
            }
            cores = this.getAvailableMinusDeployedAICores();
            cargo = Global.getFactory().createCargo(true);
            for (String id : cores.keySet()) {
                cargo.addCommodity(id, cores.getCount(id));
            }
            info.addSectionHeading("Cores available to deploy", Alignment.MID, initPad);
            if (cargo.isEmpty()) {
                info.addPara("      None", opad);
            } else {
                info.showCargo(cargo, 10, true, opad);
            }
        }
    }

    @Override
    public MarketAPI getMarket() {
        return null;
    }

    @Override
    public FleetMemberAPI getFleetMember() {
        return null;
    }

    public static class SimUnlocksData {
        public LinkedHashSet<String> factions = new LinkedHashSet();
        public LinkedHashSet<String> variants = new LinkedHashSet();

        public void fromJSON(JSONObject json) {
            String value;
            int i;
            this.factions = new LinkedHashSet();
            JSONArray arr = json.optJSONArray("factions");
            if (arr != null) {
                i = 0;
                while (i < arr.length()) {
                    value = arr.optString(i);
                    if (value != null) {
                        this.factions.add(value);
                    }
                    ++i;
                }
            }
            this.variants = new LinkedHashSet();
            arr = json.optJSONArray("variants");
            if (arr != null) {
                i = 0;
                while (i < arr.length()) {
                    value = arr.optString(i);
                    if (value != null) {
                        this.variants.add(value);
                    }
                    ++i;
                }
            }
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject json = new JSONObject();
            JSONArray arr1 = new JSONArray();
            for (String value : this.factions) {
                arr1.put((Object)value);
            }
            JSONArray arr2 = new JSONArray();
            for (String value : this.variants) {
                arr2.put((Object)value);
            }
            json.put("factions", (Object)arr1);
            json.put("variants", (Object)arr2);
            return json;
        }
    }
}

