/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.impl.campaign.GenericCampaignEntitySprite;
import com.fs.starfarer.api.impl.campaign.procgen.DropGroupRow;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class DerelictShipEntityPlugin
extends BaseCustomEntityPlugin {
    public static float DEFAULT_SMOD_PROB = 0.05f;
    private DerelictShipData data;
    private transient GenericCampaignEntitySprite sprite;
    private transient FleetMemberAPI member;
    private transient float scale;
    private float angVel = 0.0f;
    protected float elapsed = 0.0f;
    protected Boolean expiring = null;

    public static float getDefaultSModProb() {
        return DEFAULT_SMOD_PROB;
    }

    public static DerelictShipData createHull(String hullId, Random random, float sModProb) {
        Object list = Global.getSettings().getHullIdToVariantListMap().get(hullId);
        WeightedRandomPicker picker = new WeightedRandomPicker(random);
        picker.addAll(list);
        String variantId = (String)picker.pick();
        if (variantId == null) {
            return null;
        }
        return DerelictShipEntityPlugin.createVariant(variantId, random, sModProb);
    }

    public static DerelictShipData createVariant(String variantId, Random random, float sModProb) {
        ShipRecoverySpecial.ShipCondition condition = DerelictShipEntityPlugin.pickDerelictCondition(random);
        ShipRecoverySpecial.PerShipData ship = new ShipRecoverySpecial.PerShipData(variantId, condition, sModProb);
        return new DerelictShipData(ship, true);
    }

    public static DerelictShipData createRandom(String factionId, DerelictType type, Random random) {
        return DerelictShipEntityPlugin.createRandom(factionId, type, random, 0.0f);
    }

    public static DerelictShipData createRandom(String factionId, DerelictType type, Random random, float sModProb) {
        if (random == null) {
            random = new Random();
        }
        if (type == null) {
            type = DerelictShipEntityPlugin.pickDerelictType(random);
        }
        String variantId = null;
        switch (type) {
            case CIVILIAN: {
                variantId = DerelictShipEntityPlugin.pickCivilianVariantId(factionId, random);
                break;
            }
            case LARGE: {
                variantId = DerelictShipEntityPlugin.pickLargeVariantId(factionId, random);
                break;
            }
            case MEDIUM: {
                variantId = DerelictShipEntityPlugin.pickMediumVariantId(factionId, random);
                break;
            }
            case SMALL: {
                variantId = DerelictShipEntityPlugin.pickSmallVariantId(factionId, random);
            }
        }
        if (variantId == null) {
            return null;
        }
        ShipRecoverySpecial.ShipCondition condition = DerelictShipEntityPlugin.pickDerelictCondition(random);
        ShipRecoverySpecial.PerShipData ship = new ShipRecoverySpecial.PerShipData(variantId, condition, sModProb);
        return new DerelictShipData(ship, true);
    }

    public static DerelictType pickDerelictType(Random random) {
        if (random == null) {
            random = new Random();
        }
        WeightedRandomPicker<DerelictType> picker = new WeightedRandomPicker<DerelictType>(random);
        picker.add(DerelictType.CIVILIAN, 10.0f);
        picker.add(DerelictType.LARGE, 5.0f);
        picker.add(DerelictType.MEDIUM, 10.0f);
        picker.add(DerelictType.SMALL, 20.0f);
        return (DerelictType)((Object)picker.pick());
    }

    public static ShipRecoverySpecial.ShipCondition pickDerelictCondition(Random random) {
        if (random == null) {
            random = new Random();
        }
        WeightedRandomPicker<ShipRecoverySpecial.ShipCondition> picker = new WeightedRandomPicker<ShipRecoverySpecial.ShipCondition>(random);
        picker.add(ShipRecoverySpecial.ShipCondition.WRECKED, 10.0f);
        picker.add(ShipRecoverySpecial.ShipCondition.BATTERED, 10.0f);
        picker.add(ShipRecoverySpecial.ShipCondition.AVERAGE, 7.0f);
        picker.add(ShipRecoverySpecial.ShipCondition.GOOD, 5.0f);
        picker.add(ShipRecoverySpecial.ShipCondition.PRISTINE, 1.0f);
        return (ShipRecoverySpecial.ShipCondition)((Object)picker.pick());
    }

    public static ShipRecoverySpecial.ShipCondition pickBadCondition(Random random) {
        if (random == null) {
            random = new Random();
        }
        WeightedRandomPicker<ShipRecoverySpecial.ShipCondition> picker = new WeightedRandomPicker<ShipRecoverySpecial.ShipCondition>(random);
        picker.add(ShipRecoverySpecial.ShipCondition.WRECKED, 10.0f);
        picker.add(ShipRecoverySpecial.ShipCondition.BATTERED, 10.0f);
        picker.add(ShipRecoverySpecial.ShipCondition.AVERAGE, 3.0f);
        return (ShipRecoverySpecial.ShipCondition)((Object)picker.pick());
    }

    public static String pickCivilianVariantId(String factionId, Random random) {
        String variantId = DerelictShipEntityPlugin.pickVariant(factionId, random, "civilianRandom", Float.valueOf(7.0f), "freighterSmall", Float.valueOf(10.0f), "freighterMedium", Float.valueOf(3.0f), "freighterLarge", Float.valueOf(1.0f), "linerSmall", Float.valueOf(10.0f), "linerMedium", Float.valueOf(3.0f), "linerLarge", Float.valueOf(1.0f), "tankerSmall", Float.valueOf(10.0f), "tankerMedium", Float.valueOf(3.0f), "tankerLarge", Float.valueOf(1.0f), "personnelSmall", Float.valueOf(10.0f), "personnelMedium", Float.valueOf(3.0f), "personnelLarge", Float.valueOf(1.0f));
        return variantId;
    }

    public static String pickSmallVariantId(String factionId, Random random) {
        String variantId = DerelictShipEntityPlugin.pickVariant(factionId, random, "combatSmall", Float.valueOf(10.0f), "combatFreighterSmall", Float.valueOf(3.0f), "freighterSmall", Float.valueOf(1.0f), "tankerSmall", Float.valueOf(1.0f), "linerSmall", Float.valueOf(1.0f), "personnelSmall", Float.valueOf(1.0f));
        return variantId;
    }

    public static String pickMediumVariantId(String factionId, Random random) {
        String variantId = DerelictShipEntityPlugin.pickVariant(factionId, random, "combatMedium", Float.valueOf(10.0f), "combatFreighterMedium", Float.valueOf(3.0f), "carrierSmall", Float.valueOf(1.0f), "freighterMedium", Float.valueOf(1.0f), "tankerMedium", Float.valueOf(1.0f), "linerMedium", Float.valueOf(1.0f), "personnelMedium", Float.valueOf(1.0f));
        return variantId;
    }

    public static String pickLargeVariantId(String factionId, Random random) {
        String variantId = DerelictShipEntityPlugin.pickVariant(factionId, random, "combatLarge", Float.valueOf(10.0f), "combatCapital", Float.valueOf(3.0f), "combatFreighterLarge", Float.valueOf(1.0f), "carrierMedium", Float.valueOf(1.0f), "freighterLarge", Float.valueOf(1.0f), "carrierLarge", Float.valueOf(1.0f), "tankerLarge", Float.valueOf(1.0f), "linerLarge", Float.valueOf(1.0f), "tankerMedium", Float.valueOf(1.0f), "personnelLarge", Float.valueOf(1.0f));
        return variantId;
    }

    public static String pickVariant(String factionId, Random random, Object ... shipRoles) {
        String role;
        if (random == null) {
            random = new Random();
        }
        FactionAPI faction = Global.getSector().getFaction(factionId);
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>(random);
        int i = 0;
        while (i < shipRoles.length) {
            role = (String)shipRoles[i];
            Float weight = (Float)shipRoles[i + 1];
            picker.add(role, weight.floatValue());
            i += 2;
        }
        Set<Object> variantsForRole = new HashSet();
        while (variantsForRole.isEmpty() && !picker.isEmpty()) {
            role = (String)picker.pickAndRemove();
            if (role == null) {
                return null;
            }
            variantsForRole = faction.getVariantsForRole(role);
        }
        picker.clear();
        picker.addAll(variantsForRole);
        String variantId = (String)picker.pick();
        return variantId;
    }

    @Override
    public void init(SectorEntityToken entity, Object params) {
        super.init(entity, params);
        this.data = (DerelictShipData)params;
        this.angVel = 5.0f + (float)Math.random() * 10.0f;
        this.angVel *= Math.signum((float)Math.random() - 0.5f);
        this.readResolve();
        entity.setSensorProfile(Float.valueOf(1.0f));
        entity.setDiscoverable(false);
        float range = DerelictShipEntityPlugin.getDetectedAtRange(this.member.getHullSpec().getHullSize());
        entity.getDetectedRangeMod().modifyFlat("gen", range);
        ((CustomCampaignEntityAPI)entity).setRadius(DerelictShipEntityPlugin.getRadius(this.member.getHullSpec().getHullSize()));
        SalvageEntityGenDataSpec.DropData data = new SalvageEntityGenDataSpec.DropData();
        data.group = "basic";
        data.value = (int)DerelictShipEntityPlugin.getBasicDropValue(this.member);
        entity.addDropValue(data);
        if (this.data.canHaveExtraCargo) {
            long seed = Misc.getSalvageSeed(entity);
            Random r = Misc.getRandom(seed, 2);
            float extraProb = 0.5f;
            if (r.nextFloat() < extraProb) {
                if (this.member.getVariant().isFreighter()) {
                    WeightedRandomPicker<DropGroupRow> picker = DropGroupRow.getPicker("freighter_cargo");
                    picker.setRandom(new Random(seed));
                    CargoAPI extraSalvage = Global.getFactory().createCargo(true);
                    int i = 0;
                    while (i < 3) {
                        DropGroupRow pick = picker.pick();
                        if (pick.isCommodity()) {
                            extraSalvage.addCommodity(pick.getCommodity(), (int)Math.ceil(this.member.getCargoCapacity() * (0.15f + 0.15f * r.nextFloat())));
                        }
                        ++i;
                    }
                    BaseSalvageSpecial.addExtraSalvage(extraSalvage, entity.getMemoryWithoutUpdate(), -1.0f);
                } else if (this.member.getVariant().isTanker()) {
                    CargoAPI extraSalvage = Global.getFactory().createCargo(true);
                    extraSalvage.addFuel((int)Math.ceil(this.member.getFuelCapacity() * (0.25f + 0.25f * r.nextFloat())));
                    BaseSalvageSpecial.addExtraSalvage(extraSalvage, entity.getMemoryWithoutUpdate(), -1.0f);
                }
            }
        }
        entity.setDiscoveryXP(Float.valueOf((float)data.value * 0.05f));
        entity.setSalvageXP(Float.valueOf((float)data.value * 0.15f));
    }

    public static float getRadius(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return 40.0f;
            }
            case CRUISER: {
                return 35.0f;
            }
            case DESTROYER: {
                return 30.0f;
            }
            case FRIGATE: {
                return 25.0f;
            }
        }
        return 20.0f;
    }

    public static float getBaseDuration(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return 50.0f;
            }
            case CRUISER: {
                return 40.0f;
            }
            case DESTROYER: {
                return 30.0f;
            }
            case FRIGATE: {
                return 25.0f;
            }
        }
        return 25.0f;
    }

    public static float getDetectedAtRange(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return 1700.0f;
            }
            case CRUISER: {
                return 1300.0f;
            }
            case DESTROYER: {
                return 1000.0f;
            }
            case FRIGATE: {
                return 800.0f;
            }
        }
        return 800.0f;
    }

    public static float getBasicDropValue(FleetMemberAPI member) {
        float value = member.getDeploymentCostSupplies() * 200.0f;
        return value;
    }

    Object readResolve() {
        this.member = this.data.ship.variantId != null ? Global.getFactory().createFleetMember(FleetMemberType.SHIP, this.data.ship.variantId) : Global.getFactory().createFleetMember(FleetMemberType.SHIP, this.data.ship.variant);
        this.scale = Misc.getCampaignShipScaleMult(this.member.getHullSpec().getHullSize());
        this.sprite = new GenericCampaignEntitySprite(this.entity, this.member.getHullSpec().getSpriteName(), this.scale);
        SpriteAPI base = Global.getSettings().getSprite(this.member.getHullSpec().getSpriteName());
        SpriteAPI overlay = Global.getSettings().getSprite("misc", "campaignDerelictOverlay");
        float w = base.getWidth();
        float h = base.getHeight();
        float size = Math.max(w, h) * 3.0f * this.scale;
        overlay.setSize(size, size);
        this.sprite.setOverlay(overlay);
        return this;
    }

    @Override
    public void advance(float amount) {
        if (this.entity.isInCurrentLocation()) {
            float turn = amount * this.angVel;
            this.entity.setFacing(Misc.normalizeAngle(this.entity.getFacing() + turn));
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsed += days;
        if (this.elapsed > this.data.durationDays && this.expiring == null) {
            boolean playerCanSee;
            SectorEntityToken.VisibilityLevel vis = this.entity.getVisibilityLevelToPlayerFleet();
            boolean bl = playerCanSee = this.entity.isInCurrentLocation() && (vis == SectorEntityToken.VisibilityLevel.COMPOSITION_AND_FACTION_DETAILS || vis == SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS);
            if (!playerCanSee) {
                Misc.fadeAndExpire(this.entity, 1.0f);
                this.expiring = true;
            }
        }
    }

    @Override
    public float getRenderRange() {
        return this.entity.getRadius() + 100.0f;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= this.entity.getSensorFaderBrightness();
        if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
            return;
        }
        this.sprite.render(0.0f, 0.0f, this.entity.getFacing(), alphaMult);
    }

    public DerelictShipData getData() {
        return this.data;
    }

    @Override
    public void appendToCampaignTooltip(TooltipMakerAPI tooltip, SectorEntityToken.VisibilityLevel level) {
    }

    public static class DerelictShipData {
        public ShipRecoverySpecial.PerShipData ship;
        public float durationDays = 1.0E7f;
        public boolean canHaveExtraCargo = false;

        public DerelictShipData(ShipRecoverySpecial.PerShipData ship, boolean canHaveExtraCargo) {
            this.ship = ship;
            this.canHaveExtraCargo = canHaveExtraCargo;
        }
    }

    public static enum DerelictType {
        SMALL,
        MEDIUM,
        LARGE,
        CIVILIAN;

    }
}

