/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class BaseLimitedFleetManager
implements EveryFrameScript,
FleetEventListener {
    public static Logger log = Global.getLogger(BaseLimitedFleetManager.class);
    protected List<ManagedFleetData> active = new ArrayList<ManagedFleetData>();
    protected IntervalUtil tracker;

    public BaseLimitedFleetManager() {
        float interval = 30.0f;
        this.tracker = new IntervalUtil(interval * 0.75f, interval * 1.25f);
        this.readResolve();
    }

    protected Object readResolve() {
        return this;
    }

    protected abstract int getMaxFleets();

    protected abstract CampaignFleetAPI spawnFleet();

    protected float getNextInterval() {
        return 30.0f * (0.75f + (float)Math.random() * 0.5f);
    }

    protected float getSpawnRateMult() {
        return 1.0f;
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days * this.getSpawnRateMult());
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        float next = this.getNextInterval();
        this.tracker.setInterval(next, next);
        Global.getSettings().profilerBegin(String.valueOf(this.getClass().getSimpleName()) + ".advance()");
        ArrayList<ManagedFleetData> remove = new ArrayList<ManagedFleetData>();
        for (ManagedFleetData data : this.active) {
            if (data.fleet.getContainingLocation() != null && data.fleet.getContainingLocation().getFleets().contains(data.fleet)) continue;
            remove.add(data);
            log.info((Object)("Cleaning up orphaned fleet [" + data.fleet.getNameWithFaction() + "]"));
        }
        this.active.removeAll(remove);
        int max = this.getMaxFleets();
        if (this.active.size() < max) {
            CampaignFleetAPI fleet = this.spawnFleet();
            if (fleet != null) {
                fleet.addEventListener(this);
                StarSystemAPI spawnLoc = null;
                if (this instanceof DisposableFleetManager) {
                    spawnLoc = ((DisposableFleetManager)this).getCurrSpawnLoc();
                }
                ManagedFleetData data = new ManagedFleetData(fleet, spawnLoc);
                this.active.add(data);
                log.info((Object)("Spawned fleet [" + fleet.getNameWithFaction() + "] at hyperloc " + fleet.getLocationInHyperspace()));
            }
        } else {
            log.debug((Object)("Maximum number of " + max + " fleets already in play for [" + this.getClass().getName() + "]"));
        }
        Global.getSettings().profilerEnd();
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        for (ManagedFleetData data : this.active) {
            if (data.fleet != fleet) continue;
            this.active.remove(data);
            break;
        }
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    public static class ManagedFleetData {
        public CampaignFleetAPI fleet;
        public LocationAPI spawnedFor;

        public ManagedFleetData(CampaignFleetAPI fleet, LocationAPI spawnedFor) {
            this.fleet = fleet;
            this.spawnedFor = spawnedFor;
        }
    }
}

