/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.SDFBase;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.MissionFleetAutoDespawn;
import org.lwjgl.util.vector.Vector2f;

public class SDFHegemony
extends SDFBase {
    @Override
    protected String getFactionId() {
        return "hegemony";
    }

    @Override
    protected OfficerManagerEvent.SkillPickPreference getCommanderShipSkillPreference() {
        return OfficerManagerEvent.SkillPickPreference.NO_ENERGY_YES_BALLISTIC_YES_MISSILE_YES_DEFENSE;
    }

    @Override
    protected MarketAPI getSourceMarket() {
        return Global.getSector().getEconomy().getMarket("coatl");
    }

    @Override
    protected String getDefeatTriggerToUse() {
        return "SDFHegemonyDefeated";
    }

    @Override
    public CampaignFleetAPI spawnFleet() {
        MarketAPI coatl = this.getSourceMarket();
        FleetCreatorMission m = new FleetCreatorMission(this.random);
        m.beginFleet();
        Vector2f loc = coatl.getLocationInHyperspace();
        m.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MAXIMUM, HubMissionWithTriggers.FleetQuality.SMOD_1, this.getFactionId(), "patrolLarge", loc);
        m.triggerSetFleetSizeFraction(1.25f);
        m.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.ALL_SHIPS, HubMissionWithTriggers.OfficerQuality.HIGHER);
        m.triggerSetFleetDoctrineComp(5, 0, 0);
        m.triggerSetFleetCommander(this.getPerson());
        m.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        m.triggerFleetAddCommanderSkill("tactical_drills", 1);
        m.triggerFleetAddCommanderSkill("crew_training", 1);
        m.triggerFleetAddCommanderSkill("carrier_group", 1);
        m.triggerFleetAddCommanderSkill("officer_training", 1);
        m.triggerSetPatrol();
        m.triggerSetFleetMemoryValue("$sourceMarket", coatl);
        m.triggerFleetSetName("Core Worlds Armada");
        m.triggerPatrolAllowTransponderOff();
        m.triggerOrderFleetPatrol(coatl.getStarSystem());
        CampaignFleetAPI fleet = m.createFleet();
        fleet.removeScriptsOfClass(MissionFleetAutoDespawn.class);
        coatl.getContainingLocation().addEntity(fleet);
        fleet.setLocation(coatl.getPlanetEntity().getLocation().x, coatl.getPlanetEntity().getLocation().y);
        fleet.setFacing(this.random.nextFloat() * 360.0f);
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.getHullId().equals("legion")) {
                member.setVariant(this.getVariant("legion_xiv_Elite"), false, false);
                continue;
            }
            if (member.getHullId().equals("onslaught")) {
                member.setVariant(this.getVariant("onslaught_xiv_Elite"), false, false);
                continue;
            }
            if (member.getHullId().equals("eagle")) {
                member.setVariant(this.getVariant("eagle_xiv_Elite"), false, false);
                continue;
            }
            if (member.getHullId().equals("falcon")) {
                if (this.random.nextFloat() < 0.5f) {
                    member.setVariant(this.getVariant("falcon_xiv_Elite"), false, false);
                    continue;
                }
                member.setVariant(this.getVariant("falcon_xiv_Escort"), false, false);
                continue;
            }
            if (member.getHullId().equals("dominator")) {
                member.setVariant(this.getVariant("dominator_XIV_Elite"), false, false);
                continue;
            }
            if (!member.getHullId().equals("enforcer")) continue;
            member.setVariant(this.getVariant("enforcer_XIV_Elite"), false, false);
        }
        return fleet;
    }
}

