/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.ghosts;

import com.fs.starfarer.api.impl.campaign.ghosts.BaseGhostBehavior;
import com.fs.starfarer.api.impl.campaign.ghosts.SensorGhost;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class GBGoInDirectionWithWobble
extends BaseGhostBehavior {
    protected float direction;
    protected int maxBurn;
    protected float phase = (float)Math.random();
    protected float wobbleRate;
    protected float maxWobble;

    public GBGoInDirectionWithWobble(float duration, float direction, float wobbleRate, float maxWobble, int maxBurn) {
        super(duration);
        this.direction = direction;
        this.wobbleRate = wobbleRate;
        this.maxWobble = maxWobble;
        this.maxBurn = maxBurn;
    }

    @Override
    public void advance(float amount, SensorGhost ghost) {
        super.advance(amount, ghost);
        float pi = (float)Math.PI;
        float sin = (float)Math.sin(this.phase * pi * 2.0f);
        this.phase += amount * this.wobbleRate;
        float maxAngleOffset = this.maxWobble;
        float angle = this.direction + sin * maxAngleOffset;
        Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
        loc.scale(10000.0f);
        Vector2f.add((Vector2f)loc, (Vector2f)ghost.getEntity().getLocation(), (Vector2f)loc);
        ghost.moveTo(loc, this.maxBurn);
    }
}

