/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MonthlyReport;
import com.fs.starfarer.api.campaign.listeners.EconomyTickListener;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.intel.events.SindrianDiktatHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.ui.ButtonAPI;
import com.fs.starfarer.api.ui.IntelUIAPI;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

public class SindrianDiktatFuelDeal
extends BaseIntelPlugin
implements EconomyTickListener {
    public static float REP_FOR_BREAKING_DEAL = 0.5f;
    public static String KEY = "$sindrianDiktatDeal_ref";
    public static String BUTTON_END = "End";
    public static String UPDATE_PARAM_ACCEPTED = "update_param_accepted";
    protected FactionAPI faction = Global.getSector().getFaction("sindrian_diktat");
    protected AgreementEndingType endType = null;

    public static SindrianDiktatFuelDeal get() {
        return (SindrianDiktatFuelDeal)Global.getSector().getMemoryWithoutUpdate().get(KEY);
    }

    public SindrianDiktatFuelDeal(InteractionDialogAPI dialog) {
        this.setImportant(true);
        SindrianDiktatHostileActivityFactor.setMadeDeal(true);
        TextPanelAPI text = null;
        if (dialog != null) {
            text = dialog.getTextPanel();
        }
        Global.getSector().getListenerManager().addListener(this);
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
        Global.getSector().getIntelManager().addIntel(this, true);
        this.sendUpdate(UPDATE_PARAM_ACCEPTED, text);
        HA_CMD.avertOrEndDiktatAttackAsNecessary();
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        SindrianDiktatHostileActivityFactor.setMadeDeal(false);
        Global.getSector().getListenerManager().removeListener(this);
        Global.getSector().getMemoryWithoutUpdate().unset(KEY);
    }

    @Override
    protected void notifyEnded() {
        super.notifyEnded();
    }

    protected Object readResolve() {
        return this;
    }

    public String getBaseName() {
        return "Sindrian Diktat Fuel Accord";
    }

    public String getAcceptedPostfix() {
        return "Accepted";
    }

    public String getBrokenPostfix() {
        return "Ended";
    }

    @Override
    public String getName() {
        String postfix = "";
        if (this.isEnding() && this.endType != null) {
            switch (this.endType) {
                case BROKEN: {
                    postfix = " - " + this.getBrokenPostfix();
                }
            }
        }
        if (this.isSendingUpdate() && this.getListInfoParam() == UPDATE_PARAM_ACCEPTED) {
            postfix = " - " + this.getAcceptedPostfix();
        }
        return String.valueOf(this.getBaseName()) + postfix;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return this.faction;
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        float initPad = pad;
        if (mode == IntelInfoPlugin.ListInfoMode.IN_DESC) {
            initPad = opad;
        }
        Color tc = this.getBulletColorForMode(mode);
        this.bullet(info);
        boolean isUpdate = this.getListInfoParam() != null;
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        if (this.isEnding() || this.isEnded()) {
            info.addPara("You are no longer abiding by your agreement with the Sindrian Diktat.", opad);
            return;
        }
        float feeFraction = Global.getSettings().getFloat("diktatFuelFeeFraction");
        LabelAPI label = info.addPara("You've made an agreement with the Sindrian Diktat, paying a sizeable fee, %s of your gross fuel exports, in exchange for them not bombarding your fuel production facilities from orbit.", opad, h, Math.round(feeFraction * 100.0f) + "%");
        label.setHighlight("Sindrian Diktat", Math.round(feeFraction * 100.0f) + "%");
        label.setHighlightColors(this.faction.getBaseUIColor(), h);
        info.addPara("You can end this agreement, but there would be no possibility of re-negotiating a similar one in the future.", opad);
        ButtonAPI button = info.addButton("End the agreement", BUTTON_END, this.getFactionForUIColors().getBaseUIColor(), this.getFactionForUIColors().getDarkUIColor(), (int)width, 20.0f, opad * 1.0f);
        button.setShortcut(22, true);
    }

    @Override
    public String getIcon() {
        return this.faction.getCrest();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.add("Agreements");
        tags.add(this.faction.getId());
        return tags;
    }

    @Override
    public String getImportantIcon() {
        return Global.getSettings().getSpriteName("intel", "important_accepted_mission");
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        return null;
    }

    public FactionAPI getFaction() {
        return this.faction;
    }

    public void endAgreement(AgreementEndingType type, InteractionDialogAPI dialog) {
        if (!this.isEnded() && !this.isEnding()) {
            this.endType = type;
            this.setImportant(false);
            this.endImmediately();
            if (dialog != null) {
                this.sendUpdate(new Object(), dialog.getTextPanel());
            }
            if (type == AgreementEndingType.BROKEN) {
                SindrianDiktatHostileActivityFactor.setBrokeDeal(true);
                TextPanelAPI text = dialog == null ? null : dialog.getTextPanel();
                Misc.adjustRep("sindrian_diktat", -REP_FOR_BREAKING_DEAL, text);
            }
        }
    }

    @Override
    public void buttonPressConfirmed(Object buttonId, IntelUIAPI ui) {
        if (buttonId == BUTTON_END) {
            this.endAgreement(AgreementEndingType.BROKEN, null);
        }
        super.buttonPressConfirmed(buttonId, ui);
    }

    @Override
    public void createConfirmationPrompt(Object buttonId, TooltipMakerAPI prompt) {
        if (buttonId == BUTTON_END) {
            prompt.addPara("The terms of the agreement are so onerous that your reputation at large would not suffer for unilaterally breaking it, though your standing with the Sindrian Diktat specifically would of course be affected.", 0.0f, this.faction.getBaseUIColor(), this.faction.getDisplayName());
        }
    }

    @Override
    public boolean doesButtonHaveConfirmDialog(Object buttonId) {
        if (buttonId == BUTTON_END) {
            return true;
        }
        return super.doesButtonHaveConfirmDialog(buttonId);
    }

    @Override
    public void reportEconomyMonthEnd() {
    }

    @Override
    public void reportEconomyTick(int iterIndex) {
        int numIter = Global.getSettings().getInt("economyIterPerMonth");
        if (iterIndex != numIter - 1) {
            return;
        }
        float feeFraction = Global.getSettings().getFloat("diktatFuelFeeFraction");
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
        if (marketsNode == null) {
            return;
        }
        float exportIncome = this.computeFuelExportIncome(marketsNode);
        int credits = (int)(exportIncome * feeFraction);
        if (credits <= 0) {
            return;
        }
        MonthlyReport.FDNode node = this.getMonthlyReportNode();
        node.upkeep += (float)credits;
    }

    public float computeFuelExportIncome(MonthlyReport.FDNode curr) {
        CommodityOnMarketAPI com;
        float total = 0.0f;
        if (curr.custom instanceof CommodityOnMarketAPI && (com = (CommodityOnMarketAPI)curr.custom).isFuel()) {
            total += curr.income;
        }
        for (MonthlyReport.FDNode child : curr.getChildren().values()) {
            total += this.computeFuelExportIncome(child);
        }
        return total;
    }

    public MonthlyReport.FDNode getMonthlyReportNode() {
        MonthlyReport report = SharedData.getData().getCurrentReport();
        MonthlyReport.FDNode marketsNode = report.getNode(MonthlyReport.OUTPOSTS);
        if (marketsNode.name == null) {
            marketsNode.name = "Colonies";
            marketsNode.custom = MonthlyReport.OUTPOSTS;
            marketsNode.tooltipCreator = report.getMonthlyReportTooltip();
        }
        MonthlyReport.FDNode paymentNode = report.getNode(marketsNode, "diktat_fuel_fees");
        paymentNode.name = "Sindrian Diktat fuel accord fees";
        paymentNode.icon = this.faction.getCrest();
        if (paymentNode.tooltipCreator == null) {
            paymentNode.tooltipCreator = new TooltipMakerAPI.TooltipCreator(){

                @Override
                public boolean isTooltipExpandable(Object tooltipParam) {
                    return false;
                }

                @Override
                public float getTooltipWidth(Object tooltipParam) {
                    return 450.0f;
                }

                @Override
                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    tooltip.addPara("Fees paid to the Sindrian Diktat in exchange for their refraining from interfering in your fuel production business. From orbit.", 0.0f);
                }
            };
        }
        return paymentNode;
    }

    public static enum AgreementEndingType {
        BROKEN;

    }
}

