/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.contacts.ContactIntel;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class CorruptPLClerkSuppliesBarEvent
extends BaseGetCommodityBarEvent {
    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        this.regen(market);
        if (!market.getFactionId().equals("persean")) {
            return false;
        }
        if (market.getId().equals("kazeron")) {
            return false;
        }
        if (market.getStabilityValue() > 7.0f) {
            return false;
        }
        return market.hasSpaceport();
    }

    @Override
    protected String getCommodityId() {
        return "supplies";
    }

    @Override
    protected void doExtraConfirmActions() {
        ContactIntel.addPotentialContact(this.person, this.market, this.text);
    }

    @Override
    protected void adjustPerson(PersonAPI person) {
        super.adjustPerson(person);
        person.setImportanceAndVoice(this.pickLowImportance(), this.random);
        person.addTag("trade");
    }

    @Override
    protected String getPersonPost() {
        return Ranks.POST_SUPPLY_MANAGER;
    }

    @Override
    protected String getPersonFaction() {
        return "persean";
    }

    @Override
    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    @Override
    protected int computeQuantity() {
        int quantity = 30 + 10 * this.random.nextInt(4);
        CommodityOnMarketAPI com = this.market.getCommodityData(this.commodity);
        int size = com.getAvailable();
        if (size < 1) {
            size = 1;
        }
        quantity = (int)((float)quantity * Math.max(1.0f, BaseIndustry.getSizeMult(size) - 2.0f));
        return quantity;
    }

    @Override
    protected float getPriceMult() {
        return 0.75f;
    }

    @Override
    protected String getPrompt() {
        return "A " + this.getManOrWoman() + " in the port authority uniform is discreetely trying to catch your eye.";
    }

    @Override
    protected String getOptionText() {
        return "Talk to the port authority official";
    }

    @Override
    protected String getMainText() {
        return "You relent and sit with the port clerk who smiles and offers to buy you a drink. \"I'm familiar with your cargo manifest, of course, and thought you might be interested in an opportunity.\" " + Misc.ucFirst(this.getHeOrShe()) + " looks around, then back at you," + " with a sly smile. \"Strictly off-the-books, of course. This job does allow me to, " + "shall we say, exercise personal judgment.\"\n\n" + "The port clerk speaks broadly about how cargo goes missing all the time. " + "Even a generous stock of %s supplies might go missing. \"It's earmarked, of course, " + "for the rich bastards from one of those Kazeron combines. " + "They can afford replacements on the open market, surely.\" " + Misc.ucFirst(this.getHeOrShe()) + " goes on to explain that %s per unit would be necessary for " + this.getHisOrHer() + " trouble, \"Think of it as a commission,\" " + this.getHeOrShe() + " says.";
    }

    @Override
    protected String[] getMainTextTokens() {
        return new String[]{Misc.getWithDGS(this.quantity), Misc.getDGSCredits(this.unitPrice)};
    }

    @Override
    protected Color[] getMainTextColors() {
        return new Color[]{Misc.getHighlightColor(), Misc.getHighlightColor()};
    }

    @Override
    protected String getConfirmText() {
        return "Accept and transfer " + Misc.getDGSCredits(this.unitPrice * this.quantity) + " to the TriAnon account provided";
    }

    @Override
    protected String getCancelText() {
        return "Decline, explaining that you don't wish to meddle in League affairs";
    }

    @Override
    protected String getAcceptText() {
        return "You leave the bar to find a message ping on your TriPad from the local port authority. It seems you've left %s of your supplies in cargo bay twelve, and the bay needs to be cleared out by the end of the next work-shift.";
    }

    @Override
    protected String[] getAcceptTextTokens() {
        return new String[]{Misc.getWithDGS(this.quantity)};
    }

    @Override
    protected Color[] getAcceptTextColors() {
        return new Color[]{Misc.getHighlightColor()};
    }
}

