/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bar.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.BaseGetCommodityBarEvent;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.ScientistAICoreIntel;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;

public class ScientistAICoreBarEvent
extends BaseGetCommodityBarEvent {
    protected transient boolean failed = false;

    @Override
    public boolean shouldShowAtMarket(MarketAPI market) {
        if (!super.shouldShowAtMarket(market)) {
            return false;
        }
        return !market.getFactionId().equals("luddic_church") && !market.getFactionId().equals("luddic_path");
    }

    @Override
    protected void regen(MarketAPI market) {
        if (this.market == market) {
            return;
        }
        super.regen(market);
    }

    @Override
    protected void doStandardConfirmActions() {
    }

    @Override
    protected void doConfirmActionsPreAcceptText() {
        StarSystemAPI system2;
        CargoAPI cargo = Global.getSector().getPlayerFleet().getCargo();
        TextPanelAPI text = this.dialog.getTextPanel();
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(this.random);
        for (StarSystemAPI system2 : Global.getSector().getStarSystems()) {
            float sinceVisit;
            if (system2.hasTag("theme_core_populated") || system2.hasTag("theme_remnant_main") || system2.hasTag("theme_remnant_resurgent") || system2.hasTag("theme_hidden") || (sinceVisit = Global.getSector().getClock().getElapsedDaysSince(system2.getLastPlayerVisitTimestamp())) < 60.0f) continue;
            picker.add(system2);
        }
        system2 = (StarSystemAPI)picker.pick();
        if (system2 == null) {
            this.doDataFail();
            return;
        }
        BaseThemeGenerator.EntityLocation loc = BaseThemeGenerator.pickHiddenLocationNotNearStar(this.random, system2, 100.0f, null);
        if (loc == null) {
            this.doDataFail();
            return;
        }
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addEntity(this.random, (LocationAPI)system2, loc, "technology_cache", "neutral");
        if (added == null || added.entity == null) {
            this.doDataFail();
            return;
        }
        added.entity.setDiscoverable(null);
        added.entity.setDiscoveryXP(null);
        added.entity.setSensorProfile(null);
        added.entity.addTag("expires");
        ScientistAICoreIntel intel = new ScientistAICoreIntel(added.entity, this);
        Global.getSector().getIntelManager().addIntel(intel, false, text);
    }

    protected void doDataFail() {
        this.failed = true;
    }

    @Override
    protected String getPersonFaction() {
        return "independent";
    }

    @Override
    protected String getPersonRank() {
        return Ranks.CITIZEN;
    }

    @Override
    protected String getPersonPost() {
        return Ranks.CITIZEN;
    }

    @Override
    protected float getPriceMult() {
        return 0.0f;
    }

    @Override
    protected String getPrompt() {
        return "A disheveled " + this.getManOrWoman() + " in academic uniform is bothering some of the " + "better-dressed spacers with " + this.getHisOrHer() + " glowing TriPad.";
    }

    @Override
    protected String getOptionText() {
        return "Flag down the academic with the TriPad";
    }

    @Override
    protected String getMainText() {
        return String.valueOf(Misc.ucFirst(this.getHeOrShe())) + " turns out to be a scientist, maybe a \"scientist\", " + "and is delighted to have someone finally listen to " + this.getHisOrHer() + " story. " + "You set your face to a practiced stern-but-receptive look as " + "you hear " + this.getHisOrHer() + " pitch through to the end.\n\n" + "\"The data doesn\u2019t lie!\" " + this.getHeOrShe() + " cries again and again, " + "though you can\u2019t make sense of the arcane tables scrolling " + "on " + this.getHisOrHer() + " greasy TriPad. \"There\u2019s an enormous stock of " + "unrecovered Domain-era technology in this system. No one else can see it! " + "All I ask is,\" " + this.getHisOrHer() + " voice drops to a whisper, " + "\"you retrieve for me the AI core hidden in the midst of the trove. " + "That, I get to keep. I\u2019ll tell you exactly where to look if you agree to my terms.\"";
    }

    @Override
    protected String[] getMainTextTokens() {
        return new String[0];
    }

    @Override
    protected Color[] getMainTextColors() {
        return new Color[0];
    }

    @Override
    protected String getConfirmText() {
        return "Accept and promise to ship the AI core to the given address in a specially shielded crate";
    }

    @Override
    protected String getCancelText() {
        return "Decline " + this.getHisOrHer() + " proposal and walk away";
    }

    @Override
    protected String getAcceptText() {
        if (this.failed) {
            return "Unfortunately, a closer analysis of the data brings to light several glaring inconsistencies. Looks like " + this.getHeOrShe() + " was a bit unhinged, after all - " + "there's nothing here worth investigating.";
        }
        return null;
    }

    @Override
    protected String getDeclineText() {
        return "You hear the scientist's offended, quavering voice at your back, \"The truth is out there! I won't be held back by small-minds like all of you!\" Most of the other patrons pretend extreme interest in their drinks, though at least one looses a mocking laugh.";
    }

    @Override
    protected boolean showCargoCap() {
        return false;
    }

    @Override
    protected void showTotalAndOptions() {
        super.showTotalAndOptions();
    }
}

