/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.bases;

import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Map;

public class PirateActivity
extends BaseMarketConditionPlugin {
    protected PirateBaseIntel intel;

    @Override
    public void setParam(Object param) {
        this.intel = (PirateBaseIntel)param;
    }

    @Override
    public void apply(String id) {
        float accessibility = this.intel.getAccessibilityPenalty();
        float stability = this.intel.getStabilityPenalty();
        String name = "Pirate activity";
        if (accessibility != 0.0f) {
            this.market.getAccessibilityMod().modifyFlat(id, -accessibility, name);
        }
        if (stability != 0.0f) {
            this.market.getStability().modifyFlat(id, -stability, name);
        }
    }

    @Override
    public void unapply(String id) {
        this.market.getAccessibilityMod().unmodifyFlat(id);
        this.market.getStability().unmodifyFlat(id);
    }

    @Override
    public void advance(float amount) {
        if (!this.intel.getMarket().isInEconomy()) {
            this.market.removeSpecificCondition(this.condition.getIdForPluginModifications());
        }
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        return super.getTokenReplacements();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void createTooltipAfterDescription(TooltipMakerAPI tooltip, boolean expanded) {
        Color h = Misc.getHighlightColor();
        Color n = Misc.getNegativeHighlightColor();
        float pad = 3.0f;
        float small = 5.0f;
        float opad = 10.0f;
        float accessibility = this.intel.getAccessibilityPenalty();
        float stability = this.intel.getStabilityPenalty();
        if (stability != 0.0f && accessibility != 0.0f) {
            tooltip.addPara("%s stability, %s accessibility.", opad, h, "-" + (int)stability, "-" + Math.round(accessibility * 100.0f) + "%");
        } else if (stability != 0.0f) {
            tooltip.addPara("%s stability.", opad, h, "-" + (int)stability);
        } else if (accessibility != 0.0f) {
            tooltip.addPara("%s accessibility.", opad, h, "-" + Math.round(accessibility * 100.0f) + "%");
        } else {
            tooltip.addPara("No perceptible impact on operations as of yet.", opad);
        }
    }

    @Override
    public float getTooltipWidth() {
        return super.getTooltipWidth();
    }

    @Override
    public boolean hasCustomTooltip() {
        return true;
    }

    @Override
    public boolean isTooltipExpandable() {
        return super.isTooltipExpandable();
    }

    public PirateBaseIntel getIntel() {
        return this.intel;
    }
}

