/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ColonyPlayerHostileActListener;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseOneTimeFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.TriTachyonStandardActivityCause;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRCommerceRaidersDestroyedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRIndustryDisruptedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRMercenariesDefeatedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRPoints;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TTCRTradeFleetsDestroyedFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.ttcr.TriTachyonCommerceRaiding;
import com.fs.starfarer.api.impl.campaign.intel.group.FGRaidAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.intel.group.TTMercenaryAttack;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.CountingMap;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class TriTachyonHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener,
FleetEventListener,
ColonyPlayerHostileActListener {
    public static String COUNTER_RAIDED_TRITACH = "$counterRaidedTriTach";
    public static String DEFEATED_MERC_ATTACK = "$defeatedTTMercAttack";
    public static String BRIBED_MERC_ATTACK = "$bribedTTMercAttack";
    public static String COMMERCE_RAIDER_FLEET = "$triTachCommerceRaider";
    public static float DEALT_WITH_MERC_PROGRESS_MULT = 0.25f;
    protected TimeoutTracker<Industry> recentlyDisrupted = new TimeoutTracker();

    public static boolean isPlayerCounterRaidedTriTach() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(COUNTER_RAIDED_TRITACH);
    }

    public static void setPlayerCounterRaidedTriTach() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(COUNTER_RAIDED_TRITACH, true);
    }

    public static boolean isPlayerDefeatedMercAttack() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_MERC_ATTACK);
    }

    public static void setPlayerDefeatedMercAttack() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_MERC_ATTACK, true);
    }

    public static boolean isDealtWithMercAttack() {
        return TriTachyonHostileActivityFactor.isPlayerDefeatedMercAttack() || TriTachyonHostileActivityFactor.isPlayerBribedMercAttack();
    }

    public static boolean isPlayerBribedMercAttack() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(BRIBED_MERC_ATTACK);
    }

    public static void setPlayerBribedMercAttack() {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(BRIBED_MERC_ATTACK, true);
    }

    public TriTachyonHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
        Global.getSector().getListenerManager().addListener(this);
    }

    protected Object readResolve() {
        if (this.recentlyDisrupted == null) {
            this.recentlyDisrupted = new TimeoutTracker();
        }
        return this;
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        if (!TriTachyonHostileActivityFactor.checkFactionExists("tritachyon", true)) {
            return 0;
        }
        return super.getProgress(intel);
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Tri-Tachyon Corporation";
    }

    @Override
    public String getNameForThreatList(boolean first) {
        return "Tri-Tachyon";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("tritachyon").getBaseUIColor();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Your independent polity has become enough of a presence in the Sector to start cutting into the profit margins of the Tri-Tachyon Corporation.", 0.0f);
                tooltip.addPara("Independent-flagged commerce raiders - little more than sanctioned pirates - have been sighted in your space, attacking trade fleets regardless of their factional allegiance.", opad);
                TriTachyonHostileActivityFactor.addDealtSectionToTooltip(tooltip, opad);
            }
        };
    }

    public static void addDealtSectionToTooltip(TooltipMakerAPI tooltip, float opad) {
        if (TriTachyonHostileActivityFactor.isDealtWithMercAttack()) {
            tooltip.addPara("You've dealt with the mercenary attack sent against you, and this has considerably cooled the enthusiasm for continued aggression. Commerce-raiding continues, but the event progress value is reduced by %s, and no further large-scale attacks are likely to be mounted.", opad, Misc.getHighlightColor(), "\u00d7" + DEALT_WITH_MERC_PROGRESS_MULT);
        }
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0;
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("tritachyon").getBaseUIColor();
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        return Global.getSettings().getInt("triTachyonMaxFleets");
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        float f = this.intel.getMarketPresenceFactor(system);
        int difficulty = 4 + Math.round(f * 4.0f);
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "tritachyon";
        if (random.nextFloat() < 0.5f) {
            factionId = "mercenary";
        }
        m.createQualityFleet(difficulty, factionId, loc);
        if (difficulty <= 5) {
            m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.SMOD_1);
        } else if (difficulty <= 7) {
            m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.SMOD_2);
        } else {
            m.triggerSetFleetQuality(HubMissionWithTriggers.FleetQuality.SMOD_3);
        }
        m.triggerSetFleetFaction("independent");
        m.triggerSetFleetType("commerceRaiders");
        m.triggerSetPirateFleet();
        m.triggerMakeNonHostileToFaction("tritachyon");
        m.triggerMakeHostileToAllTradeFleets();
        m.triggerMakeEveryoneJoinBattleAgainst();
        m.triggerMakeNonHostileToFaction("pirates");
        m.triggerMakeNoRepImpact();
        m.triggerFleetAllowLongPursuit();
        m.triggerFleetAddCommanderSkill("coordinated_maneuvers", 1);
        m.triggerFleetAddCommanderSkill("electronic_warfare", 1);
        m.triggerSetFleetFlag(COMMERCE_RAIDER_FLEET);
        int tugs = 0;
        if ("mercenary".equals(factionId)) {
            tugs = random.nextInt(3);
        }
        m.triggerFleetMakeFaster(true, tugs, true);
        m.triggerSetFleetMaxShipSize(3);
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color c = Global.getSector().getFaction("tritachyon").getBaseUIColor();
        info.addPara("Impending Tri-Tachyon mercenary attack", initPad, tc, c, "Tri-Tachyon");
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Tri-Tachyon mercenary attack averted", tc, initPad);
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        Color c = Global.getSector().getFaction("tritachyon").getBaseUIColor();
        Color h = Misc.getHighlightColor();
        info.addPara("You've received intel that the Tri-Tachyon Corporation is allocating funds to hire and equip a mercenary company to raid and disrupt your industrial base.", small, Misc.getNegativeHighlightColor(), "raid and disrupt your industrial base");
        info.addPara("If the mercenary attack is defeated, it will go a long way towards convincing the Tri-Tachyon Corporation to abandon its anti-competitive efforts.", opad, h, "abandon its anti-competitive efforts");
        stage.beginResetReqList(info, true, "crisis", opad);
        info.addPara("The %s is convinced that its efforts are unprofitable", 0.0f, c, "Tri-Tachyon Corporation");
        stage.endResetReqList(info, false, "crisis", -1, -1);
        this.addBorder(info, Global.getSector().getFaction("tritachyon").getBaseUIColor());
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("tritachyon").getCrest();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            return this.getDefaultEventTooltip("Tri-Tachyon mercenary attack", intel, stage);
        }
        return null;
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach() || TriTachyonHostileActivityFactor.getPrimaryTriTachyonSystem() == null) {
                return 0.0f;
            }
            if (TriTachyonHostileActivityFactor.isPlayerDefeatedMercAttack() || TriTachyonHostileActivityFactor.isPlayerBribedMercAttack()) {
                return 0.0f;
            }
            StarSystemAPI target = TriTachyonHostileActivityFactor.findExpeditionTarget(intel, stage);
            MarketAPI source = TriTachyonHostileActivityFactor.findExpeditionSource(intel, stage, target);
            if (target != null && source != null) {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        StarSystemAPI target = TriTachyonHostileActivityFactor.findExpeditionTarget(intel, stage);
        MarketAPI source = TriTachyonHostileActivityFactor.findExpeditionSource(intel, stage, target);
        if (source == null || target == null) {
            return false;
        }
        stage.rollData = null;
        return this.startMercenaryAttack(source, target, stage, intel, this.getRandomizedStageRandom(3));
    }

    public static StarSystemAPI findExpeditionTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        List<TriTachyonStandardActivityCause.CompetitorData> data = TriTachyonStandardActivityCause.computePlayerCompetitionData();
        CountingMap<StarSystemAPI> counts = new CountingMap<StarSystemAPI>();
        for (TriTachyonStandardActivityCause.CompetitorData curr : data) {
            for (MarketAPI market : curr.competitorProducers) {
                StarSystemAPI system = market.getStarSystem();
                if (system == null) continue;
                int weight = market.getCommodityData(curr.commodityId).getMaxSupply();
                counts.add(system, weight);
            }
        }
        return (StarSystemAPI)counts.getLargest();
    }

    public static MarketAPI findExpeditionSource(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, StarSystemAPI target) {
        if (TriTachyonHostileActivityFactor.getNortia() != null) {
            return TriTachyonHostileActivityFactor.getNortia();
        }
        CountingMap<MarketAPI> scores = new CountingMap<MarketAPI>();
        for (MarketAPI market : Misc.getFactionMarkets("tritachyon")) {
            int size;
            int weight = size = market.getSize();
            if (!Misc.isMilitary(market)) {
                weight += size * 10;
            }
            if (market.hasIndustry("orbitalworks")) {
                weight += size;
            }
            if (market.hasIndustry("heavyindustry")) {
                weight += size;
            }
            scores.add(market, weight);
        }
        return (MarketAPI)scores.getLargest();
    }

    public static MarketAPI getNortia() {
        MarketAPI nortia = Global.getSector().getEconomy().getMarket("nortia");
        if (nortia == null || nortia.hasCondition("decivilized") || !nortia.getFactionId().equals("independent")) {
            return null;
        }
        return nortia;
    }

    @Override
    public void reportFGIAborted(FleetGroupIntel intel) {
        TriTachyonHostileActivityFactor.setPlayerDefeatedMercAttack();
        TriTachyonCommerceRaiding.addFactorCreateIfNecessary(new TTCRMercenariesDefeatedFactor(), null);
    }

    @Override
    public void notifyFactorRemoved() {
        Global.getSector().getListenerManager().removeListener(this);
    }

    @Override
    public void notifyEventEnding() {
        this.notifyFactorRemoved();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Misc.getDays(amount);
        this.recentlyDisrupted.advance(days);
        BaseEventIntel.EventStageData stage = this.intel.getDataFor((Object)HostileActivityEventIntel.Stage.HA_EVENT);
        if (stage != null && stage.rollData instanceof HostileActivityEventIntel.HAERandomEventData && ((HostileActivityEventIntel.HAERandomEventData)stage.rollData).factor == this && TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach()) {
            this.intel.resetHA_EVENT();
        }
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach() && TTMercenaryAttack.get() != null) {
            TTMercenaryAttack.get().finish(false);
        }
    }

    public static StarSystemAPI getPrimaryTriTachyonSystem() {
        CountingMap<StarSystemAPI> counts = new CountingMap<StarSystemAPI>();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            int size;
            StarSystemAPI system;
            if (!"tritachyon".equals(market.getFactionId()) || (system = market.getStarSystem()) == null) continue;
            int weight = size = market.getSize();
            if (Misc.isMilitary(market)) {
                weight += size;
            }
            if (market.hasIndustry("orbitalworks")) {
                weight += size;
            }
            if (market.hasIndustry("heavyindustry")) {
                weight += size;
            }
            counts.add(system, weight);
        }
        return (StarSystemAPI)counts.getLargest();
    }

    public boolean startMercenaryAttack(MarketAPI source, StarSystemAPI target, BaseEventIntel.EventStageData stage, HostileActivityEventIntel intel, Random random) {
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach()) {
            return false;
        }
        if (source == null || target == null) {
            return false;
        }
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.makeFleetsHostile = false;
        params.source = source;
        params.prepDays = 21.0f + random.nextFloat() * 7.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = target;
        params.raidParams.type = FGRaidAction.FGRaidType.SEQUENTIAL;
        LinkedHashSet<String> disrupt = new LinkedHashSet<String>();
        for (MarketAPI market : Misc.getMarketsInLocation(target, "player")) {
            params.raidParams.allowedTargets.add(market);
            params.raidParams.allowNonHostileTargets = true;
            for (Industry ind : market.getIndustries()) {
                if (ind.getSpec().hasTag("unraidable")) continue;
                disrupt.add(ind.getId());
            }
        }
        params.raidParams.disrupt.addAll(disrupt);
        params.raidParams.raidsPerColony = Math.min(disrupt.size(), 4);
        if (disrupt.isEmpty()) {
            params.raidParams.raidsPerColony = 2;
        }
        if (params.raidParams.allowedTargets.isEmpty()) {
            return false;
        }
        params.factionId = "independent";
        params.style = FleetCreatorMission.FleetStyle.QUALITY;
        params.repImpact = HubMissionWithTriggers.ComplicationRepImpact.NONE;
        float fleetSizeMult = 1.0f;
        float f = intel.getMarketPresenceFactor(target);
        float totalDifficulty = fleetSizeMult * 50.0f * (0.5f + 0.5f * f);
        totalDifficulty -= 10.0f;
        params.fleetSizes.add(10);
        while (totalDifficulty > 0.0f) {
            int min = 3;
            int max = 8;
            int diff = min + random.nextInt(max - min + 1);
            params.fleetSizes.add(diff);
            totalDifficulty -= (float)diff;
        }
        TTMercenaryAttack attack = new TTMercenaryAttack(params);
        attack.setListener(this);
        Global.getSector().getIntelManager().addIntel(attack, false);
        return true;
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        int points;
        BaseOneTimeFactor factor;
        int points2;
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach()) {
            return;
        }
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (this.getProgress(null) <= 0 && TriTachyonCommerceRaiding.get() == null) {
            return;
        }
        int traderFP = 0;
        int raiderFP = 0;
        for (CampaignFleetAPI otherFleet : battle.getNonPlayerSideSnapshot()) {
            boolean trader = TriTachyonHostileActivityFactor.isTraderServingATTColony(otherFleet);
            boolean raider = TriTachyonHostileActivityFactor.isCommerceRaider(otherFleet);
            if (!trader && !raider) continue;
            int mult = 1;
            if (trader) {
                mult = TTCRPoints.TRADE_FLEET_FP_MULT;
            }
            for (FleetMemberAPI loss : Misc.getSnapshotMembersLost(otherFleet)) {
                int fp = loss.getFleetPointCost() * mult;
                if (trader) {
                    traderFP += fp;
                    continue;
                }
                if (!raider) continue;
                raiderFP += fp;
            }
        }
        if (traderFP > 0 && (points2 = TriTachyonHostileActivityFactor.computeTTCRProgressPoints(traderFP)) > 0) {
            factor = new TTCRTradeFleetsDestroyedFactor(points2);
            TriTachyonCommerceRaiding.addFactorCreateIfNecessary(factor, null);
        }
        if (raiderFP > 0 && (points = TriTachyonHostileActivityFactor.computeTTCRProgressPoints(raiderFP)) > 0) {
            factor = new TTCRCommerceRaidersDestroyedFactor(points);
            TriTachyonCommerceRaiding.addFactorCreateIfNecessary(factor, null);
        }
    }

    public static boolean isCommerceRaider(CampaignFleetAPI fleet) {
        return fleet.getMemoryWithoutUpdate().getBoolean(COMMERCE_RAIDER_FLEET);
    }

    public static boolean isTraderServingATTColony(CampaignFleetAPI fleet) {
        boolean trader = Misc.isTrader(fleet);
        boolean smuggler = Misc.isSmuggler(fleet);
        if (!trader && !smuggler) {
            return false;
        }
        RouteManager.RouteData route = RouteManager.getInstance().getRoute("econ", fleet);
        if (route == null) {
            return false;
        }
        EconomyFleetAssignmentAI.EconomyRouteData data = (EconomyFleetAssignmentAI.EconomyRouteData)route.getCustom();
        if (data == null) {
            return false;
        }
        if (data.from != null && "tritachyon".equals(data.from.getFactionId())) {
            return true;
        }
        return data.to != null && "tritachyon".equals(data.to.getFactionId());
    }

    public static int computeTTCRProgressPoints(float fleetPointsDestroyed) {
        if (fleetPointsDestroyed <= 0.0f) {
            return 0;
        }
        int points = Math.round(fleetPointsDestroyed / (float)TTCRPoints.FP_PER_POINT);
        if (points < 1) {
            points = 1;
        }
        return points;
    }

    public static int computeIndustryDisruptPoints(Industry ind) {
        float base = ind.getSpec().getDisruptDanger().disruptionDays;
        float per = TTCRPoints.BASE_POINTS_FOR_INDUSTRY_DISRUPT;
        float days = ind.getDisruptedDays();
        int points = Math.round(days / base * per);
        if (points > TTCRPoints.MAX_POINTS_FOR_INDUSTRY_DISRUPT) {
            points = TTCRPoints.MAX_POINTS_FOR_INDUSTRY_DISRUPT;
        }
        return points;
    }

    @Override
    public void reportRaidForValuablesFinishedBeforeCargoShown(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, CargoAPI cargo) {
    }

    @Override
    public void reportRaidToDisruptFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData, Industry industry) {
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach()) {
            return;
        }
        if (this.getProgress(null) <= 0 && TriTachyonCommerceRaiding.get() == null) {
            return;
        }
        if (market != null && "tritachyon".equals(market.getFactionId())) {
            this.applyIndustryDisruptionToTTCR(industry, dialog);
        }
    }

    @Override
    public void reportTacticalBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach()) {
            return;
        }
        if (this.getProgress(null) <= 0 && TriTachyonCommerceRaiding.get() == null) {
            return;
        }
        if (market != null && "tritachyon".equals(market.getFactionId())) {
            this.applyMassIndustryDisruptionToTTCR(market, dialog);
        }
    }

    @Override
    public void reportSaturationBombardmentFinished(InteractionDialogAPI dialog, MarketAPI market, MarketCMD.TempData actionData) {
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach()) {
            return;
        }
        if (this.getProgress(null) <= 0 && TriTachyonCommerceRaiding.get() == null) {
            return;
        }
        if (market != null && "tritachyon".equals(market.getFactionId())) {
            this.applyMassIndustryDisruptionToTTCR(market, dialog);
        }
    }

    public void applyMassIndustryDisruptionToTTCR(MarketAPI market, InteractionDialogAPI dialog) {
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach()) {
            return;
        }
        if (this.getProgress(null) <= 0 && TriTachyonCommerceRaiding.get() == null) {
            return;
        }
        int points = 0;
        for (Industry industry : market.getIndustries()) {
            int curr;
            if (this.recentlyDisrupted.contains(industry) || industry.getSpec().hasTag("unraidable") || (curr = TriTachyonHostileActivityFactor.computeIndustryDisruptPoints(industry)) <= 0) continue;
            points += curr;
            this.recentlyDisrupted.add(industry, industry.getDisruptedDays());
        }
        if (points > 0) {
            TTCRIndustryDisruptedFactor factor = new TTCRIndustryDisruptedFactor("Disrupted industries " + market.getOnOrAt() + " " + market.getName(), points);
            TriTachyonCommerceRaiding.addFactorCreateIfNecessary(factor, dialog);
        }
    }

    public void applyIndustryDisruptionToTTCR(Industry industry, InteractionDialogAPI dialog) {
        if (TriTachyonHostileActivityFactor.isPlayerCounterRaidedTriTach()) {
            return;
        }
        if (this.getProgress(null) <= 0 && TriTachyonCommerceRaiding.get() == null) {
            return;
        }
        if (!this.recentlyDisrupted.contains(industry)) {
            if (industry.getSpec().hasTag("unraidable")) {
                return;
            }
            MarketAPI market = industry.getMarket();
            if (market == null) {
                return;
            }
            int points = TriTachyonHostileActivityFactor.computeIndustryDisruptPoints(industry);
            if (points > 0) {
                TTCRIndustryDisruptedFactor factor = new TTCRIndustryDisruptedFactor(String.valueOf(industry.getCurrentName()) + " " + market.getOnOrAt() + " " + market.getName() + " disrupted", points);
                TriTachyonCommerceRaiding.addFactorCreateIfNecessary(factor, dialog);
                this.recentlyDisrupted.add(industry, industry.getDisruptedDays());
            }
        }
    }

    @Override
    public Color getNameColorForThreatList() {
        return super.getNameColorForThreatList();
    }
}

