/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class RuinsDataSwapMission
extends HubMissionWithBarEvent {
    public static float MISSION_DAYS = 120.0f;
    public static int RAID_DIFFICULTY = 60;
    public static int MARINES_REQUIRED = RAID_DIFFICULTY / 2;
    protected MarketAPI market;
    protected PersonAPI person;
    protected PlanetAPI planet;
    protected String targetWithArticle;
    protected String target;
    protected String megacorp;
    protected Variation variation;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$rdsm_ref")) {
            return false;
        }
        this.targetWithArticle = this.pickOne("a library", "a datavault", "an archive", "a laboratory");
        this.target = this.targetWithArticle.substring(this.targetWithArticle.indexOf(" ") + 1);
        this.megacorp = this.pickOne("Fabrique Orbitale", "Bhilai Exospace", "Hastaeus Industries", "Exogen Systems", "Ursa Group");
        this.resetSearch();
        this.requireSystemTags(ReqMode.ANY, "theme_remnant_suppressed", "theme_derelict", "theme_misc", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_special");
        this.requirePlanetUnpopulated();
        this.requirePlanetWithRuins();
        this.preferPlanetNotFullySurveyed();
        this.preferPlanetUnexploredRuins();
        this.preferPlanetInDirectionOfOtherMissions();
        this.planet = this.pickPlanet();
        if (this.planet == null) {
            return false;
        }
        this.person = this.getPerson();
        if (this.person == null) {
            return false;
        }
        this.market = this.person.getMarket();
        if (this.market == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_RUINS);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.makeImportant(this.planet, "$rdsm_targetPlanet", Stage.GO_TO_RUINS);
        this.makeImportant(this.person, "$rdsm_contact", Stage.RETURN);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_RUINS, (Object)Stage.RETURN, "$rdsm_gotData");
        this.connectWithGlobalFlag((Object)Stage.RETURN, (Object)Stage.COMPLETED, "$rdsm_returnedData");
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[]{Stage.RETURN});
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.variation = this.planet.hasCondition("decivilized") ? Variation.DECIV : Variation.BASIC;
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$rdsm_contactName", this.person.getNameString());
        this.set("$rdsm_megacorpName", this.megacorp);
        this.set("$rdsm_market", this.market.getName());
        this.set("$rdsm_target", this.target);
        this.set("$rdsm_planetId", this.planet.getId());
        this.set("$rdsm_planetName", this.planet.getName());
        this.set("$rdsm_systemName", this.planet.getStarSystem().getNameWithLowercaseType());
        this.set("$rdsm_dist", this.getDistanceLY(this.planet));
        this.set("$rdsm_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$rdsm_variation", (Object)this.variation);
        if (this.variation == Variation.DECIV) {
            this.set("$rdsm_marinesReq", MARINES_REQUIRED);
            this.set("$rdsm_raidDifficulty", RAID_DIFFICULTY);
        }
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_RUINS) {
            if (this.variation == Variation.DECIV) {
                info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + ", and swap the datacore from the " + this.megacorp + " " + this.target + " in the ruins there. There have " + "been reports of decivs so you should bring at least %s " + "marines to ensure the job goes smoothly.", opad, h, Misc.getWithDGS(MARINES_REQUIRED));
            } else {
                String extra = "";
                info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + ", and swap the datacore from the " + this.megacorp + " " + this.target + " in the ruins there with the one provided." + extra, opad);
            }
        } else if (this.currentStage == Stage.RETURN) {
            info.addPara(this.getReturnText(this.market), opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_RUINS) {
            info.addPara(this.getGoToPlanetTextShort(this.planet), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN) {
            info.addPara(this.getReturnTextShort(this.market), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Ruins Datacore Swap";
    }

    @Override
    public String getBlurbText() {
        return null;
    }

    public static enum Stage {
        GO_TO_RUINS,
        RETURN,
        COMPLETED,
        FAILED;

    }

    public static enum Variation {
        BASIC,
        DECIV;

    }
}

