/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.academy.GADepartments;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.missions.hub.ReqMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GADataFromRuins
extends GABaseMission {
    public static float PIRATE_PROB = 0.5f;
    public static float MISSION_DAYS = 120.0f;
    public static int RAID_DIFFICULTY = 100;
    public static int MARINES_REQUIRED = RAID_DIFFICULTY / 2;
    protected PlanetAPI planet;
    protected String targetWithArticle;
    protected String target;
    protected Variation variation;
    protected int piratePayment;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaData_ref")) {
            return false;
        }
        this.pickDepartment(GADepartments.INDUSTRIAL, GADepartments.SOCIAL);
        this.targetWithArticle = this.pickOne("a library", "a datavault", "an archive", "a laboratory");
        this.target = this.targetWithArticle.substring(this.targetWithArticle.indexOf(" ") + 1);
        this.resetSearch();
        this.requireSystemTags(ReqMode.ANY, "theme_remnant_resurgent", "theme_remnant_suppressed", "theme_derelict", "theme_misc", "theme_ruins");
        this.requireSystemTags(ReqMode.NOT_ANY, "theme_remnant_secondary");
        this.requirePlanetUnpopulated();
        this.requirePlanetWithRuins();
        this.preferPlanetNotFullySurveyed();
        this.preferPlanetUnexploredRuins();
        this.preferPlanetInDirectionOfOtherMissions();
        this.planet = this.pickPlanet();
        if (this.planet == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.GO_TO_RUINS);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.makeImportant(this.planet, "$gaData_targetPlanet", Stage.GO_TO_RUINS);
        this.connectWithGlobalFlag((Object)Stage.GO_TO_RUINS, (Object)Stage.GET_IN_COMMS_RANGE, "$gaData_gotData");
        this.connectWithInRangeOfCommRelay((Object)Stage.GET_IN_COMMS_RANGE, (Object)Stage.COMPLETED);
        this.setStageOnGlobalFlag((Object)Stage.FAILED, "$gaData_gaveCoordsToPirates");
        if (WITH_TIME_LIMIT) {
            this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, this.planet.getStarSystem(), new Object[]{Stage.GET_IN_COMMS_RANGE});
        }
        this.setCreditReward(BaseHubMission.CreditReward.AVERAGE);
        this.setDefaultGARepRewards();
        StarSystemAPI system = this.planet.getStarSystem();
        if (system.hasTag("theme_remnant")) {
            this.variation = Variation.REMNANTS;
            this.setCreditReward(BaseHubMission.CreditReward.HIGH);
        } else {
            this.variation = Misc.hasPulsar(system) ? Variation.PULSAR : (this.planet.hasCondition("decivilized") ? Variation.DECIV : Variation.BASIC);
        }
        if ((this.variation == Variation.BASIC || this.variation == Variation.DECIV) && this.rollProbability(PIRATE_PROB)) {
            this.beginWithinHyperspaceRangeTrigger(this.planet, 1.0f, false, new Object[]{Stage.GO_TO_RUINS});
            this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.DEFAULT, "pirates", "patrolMedium", this.planet);
            this.triggerAutoAdjustFleetStrengthMajor();
            this.triggerSetStandardAggroPirateFlags();
            this.triggerPickLocationAtInSystemJumpPoint(this.planet.getStarSystem());
            this.triggerSpawnFleetAtPickedLocation("$gaData_pirate", null);
            this.triggerOrderFleetPatrol(this.planet);
            this.triggerFleetMakeImportant(null, Stage.GO_TO_RUINS);
            this.endTrigger();
            this.piratePayment = this.genRoundNumber(5000, 15000);
        }
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        PlanetAPI pulsar;
        this.set("$gaData_department", this.department);
        this.set("$gaData_target", this.target);
        this.set("$gaData_planetId", this.planet.getId());
        this.set("$gaData_planetName", this.planet.getName());
        this.set("$gaData_systemName", this.planet.getStarSystem().getNameWithNoType());
        this.set("$gaData_dist", this.getDistanceLY(this.planet));
        this.set("$gaData_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$gaData_piratePayment", Misc.getWithDGS(this.piratePayment));
        this.set("$gaData_variation", (Object)this.variation);
        if (this.variation == Variation.DECIV) {
            this.set("$gaData_marinesReq", MARINES_REQUIRED);
            this.set("$gaData_raidDifficulty", RAID_DIFFICULTY);
        } else if (this.variation == Variation.PULSAR && (pulsar = Misc.getPulsarInSystem(this.planet.getStarSystem())) != null) {
            this.set("$gaData_pulsarName", this.planet.getStarSystem().getNameWithNoType());
        }
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_RUINS) {
            if (this.variation == Variation.DECIV) {
                info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + ", and retrieve the data from " + this.targetWithArticle + " found in the ruins there. Around %s " + "marines will be needed to perform the recovery.", opad, h, Misc.getWithDGS(MARINES_REQUIRED));
            } else {
                String extra = "";
                if (this.variation == Variation.REMNANTS) {
                    extra = " 'Autonomous weapon systems' may pose a danger.";
                }
                if (this.variation == Variation.PULSAR) {
                    extra = " Rapidly spinning jets of high energy charged particles are a once-in-a-lifetime sight.";
                }
                info.addPara(String.valueOf(this.getGoToPlanetTextPre(this.planet)) + ", and retrieve the data from " + this.targetWithArticle + " found in the ruins there." + extra, opad);
            }
        } else if (this.currentStage == Stage.GET_IN_COMMS_RANGE) {
            info.addPara(this.getGetWithinCommsRangeText(), opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.GO_TO_RUINS) {
            info.addPara(this.getGoToPlanetTextShort(this.planet), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GET_IN_COMMS_RANGE) {
            info.addPara(this.getGetWithinCommsRangeTextShort(), tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Ruins Data Recovery";
    }

    @Override
    public String getBlurbText() {
        return null;
    }

    public static enum Stage {
        GO_TO_RUINS,
        GET_IN_COMMS_RANGE,
        COMPLETED,
        FAILED;

    }

    public static enum Variation {
        BASIC,
        REMNANTS,
        PULSAR,
        DECIV;

    }
}

