/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.cb;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBDerelict;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBDeserter;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBEnemyStation;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBMerc;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBPather;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBPirate;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBRemnant;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBRemnantPlus;
import com.fs.starfarer.api.impl.campaign.missions.cb.CBRemnantStation;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;

public class CBStats {
    public static int BASE_REWARD = Global.getSettings().getInt("baseCustomBounty");
    public static int REWARD_PER_DIFFICULTY = Global.getSettings().getInt("personCustomBountyPerLevel");
    public static float DEFAULT_DAYS = 120.0f;
    public static float REMNANT_STATION_DAYS = 365.0f;
    public static float ENEMY_STATION_DAYS = 365.0f;
    public static float REMNANT_PLUS_DAYS = 0.0f;
    public static float PATHER_FREQ = 0.5f;
    public static float PIRATE_FREQ = 1.0f;
    public static float DESERTER_FREQ = 1.0f;
    public static float DERELICT_FREQ = 0.5f;
    public static float REMNANT_FREQ = 0.5f;
    public static float REMNANT_STATION_FREQ = 0.5f;
    public static float MERC_FREQ = 0.5f;
    public static float REMNANT_PLUS_FREQ = 1.0f;
    public static float ENEMY_STATION_FREQ = 0.5f;
    public static float PATHER_MULT = 0.8f;
    public static float PIRATE_MULT = 0.8f;
    public static float DESERTER_MULT = 1.0f;
    public static float DERELICT_MULT = 1.2f;
    public static float REMNANT_MULT = 1.75f;
    public static float REMNANT_STATION_MULT = 2.0f;
    public static float MERC_MULT = 2.0f;
    public static float REMNANT_PLUS_MULT = 3.0f;
    public static float ENEMY_STATION_MULT = 2.0f;
    public static Map<Class, Pair<Integer, Integer>> THRESHOLDS = new LinkedHashMap<Class, Pair<Integer, Integer>>();
    public static float TRADER_FREQ;
    public static float PATROL_FREQ;
    public static float TRADER_MULT;
    public static float PATROL_MULT;

    static {
        CBStats.setThresholds(CBPirate.class, 5, 8);
        CBStats.setThresholds(CBPather.class, 5, 8);
        CBStats.setThresholds(CBDeserter.class, 8, 12);
        CBStats.setThresholds(CBMerc.class, 12, 12);
        CBStats.setThresholds(CBDerelict.class, 12, 12);
        CBStats.setThresholds(CBRemnant.class, 12, 12);
        CBStats.setThresholds(CBRemnantPlus.class, 12, 12);
        CBStats.setThresholds(CBRemnantStation.class, 12, 12);
        CBStats.setThresholds(CBEnemyStation.class, 12, 12);
        TRADER_FREQ = 1.0f;
        PATROL_FREQ = 1.0f;
        TRADER_MULT = 0.5f;
        PATROL_MULT = 0.67f;
    }

    public static void setThresholds(Class bounty, int challenging, int normal) {
        THRESHOLDS.put(bounty, new Pair<Integer, Integer>(challenging, normal));
    }

    public static int getThresholdNotHigh(Class c) {
        int result = 12;
        if (!THRESHOLDS.containsKey(c)) {
            return result;
        }
        return (Integer)CBStats.THRESHOLDS.get((Object)c).one;
    }

    public static int getThresholdNotNormal(Class c) {
        int result = 12;
        if (!THRESHOLDS.containsKey(c)) {
            return result;
        }
        return (Integer)CBStats.THRESHOLDS.get((Object)c).two;
    }

    public static int getBaseBounty(int difficulty, float mult, BaseHubMission mission) {
        int baseReward = BASE_REWARD + difficulty * REWARD_PER_DIFFICULTY;
        baseReward = (int)((float)baseReward * mult);
        if (mission != null) {
            baseReward = (int)((float)baseReward * (0.9f + 0.2f * mission.getGenRandom().nextFloat()));
            baseReward = BaseHubMission.getRoundNumber(baseReward);
        }
        return baseReward;
    }
}

