/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainPlugin;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.NameGenData;
import com.fs.starfarer.api.impl.campaign.procgen.ProcgenUsedNames;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidBeltTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.NebulaTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.RingSystemTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class NameAssigner {
    private Constellation constellation;
    private ProcgenUsedNames.NamePick constellationName;
    private NamingTreeNode root;
    private float specialNamesProbability = 0.5f;
    private boolean renameSystem = true;
    private int structuralNameOffset = 0;

    public NameAssigner(Constellation constellation) {
        this.constellation = constellation;
    }

    public void setSpecialNamesProbability(float specialNamesProbability) {
        this.specialNamesProbability = specialNamesProbability;
    }

    public void setRenameSystem(boolean renameStar) {
        this.renameSystem = renameStar;
    }

    public void setStructuralNameOffset(int structuralNameOffset) {
        this.structuralNameOffset = structuralNameOffset;
    }

    public void assignNames(String name, String secondary) {
        if (this.constellation.getSystems().isEmpty()) {
            return;
        }
        if (name == null) {
            this.constellationName = ProcgenUsedNames.pickName("constellation", null, null);
        } else {
            NameGenData data = (NameGenData)Global.getSettings().getSpec(NameGenData.class, name, true);
            if (data == null) {
                data = new NameGenData(name, null);
            } else {
                ProcgenUsedNames.notifyUsed(name);
            }
            this.constellationName = new ProcgenUsedNames.NamePick(data, name, secondary);
        }
        if (!this.constellationName.spec.isReusable() && !this.constellation.isLeavePickedNameUnused()) {
            ProcgenUsedNames.notifyUsed(this.constellationName.nameWithRomanSuffixIfAny);
        }
        Global.getSettings().greekLetterReset();
        this.constellation.setNamePick(this.constellationName);
        Collections.sort(this.constellation.getSystems(), new Comparator<StarSystemAPI>(){

            @Override
            public int compare(StarSystemAPI o1, StarSystemAPI o2) {
                if (o1.getStar() == null || o2.getStar() != null) {
                    return 1;
                }
                if (o1.getStar() != null || o2.getStar() == null) {
                    return -1;
                }
                return (int)Math.signum(o1.getStar().getRadius() - o2.getStar().getRadius());
            }
        });
        for (StarSystemAPI system : this.constellation.getSystems()) {
            String base = this.constellationName.nameWithRomanSuffixIfAny;
            if (this.constellationName.secondaryWithRomanSuffixIfAny != null) {
                base = this.constellationName.secondaryWithRomanSuffixIfAny;
            }
            String n = String.valueOf(Global.getSettings().getNextGreekLetter(this.constellationName)) + " " + base;
            this.computeNamingTree(system);
            this.assignStructuralNames(system, n);
            if (StarSystemGenerator.random.nextFloat() < this.specialNamesProbability || this.constellation.systems.size() <= 1 && this.specialNamesProbability > 0.0f) {
                this.assignSpecialNames(this.root);
            }
            this.updateJumpPointDestinationNames(system);
        }
    }

    public void assignSpecialNames(NamingTreeNode curr) {
        String tag = null;
        CampaignTerrainPlugin plugin = null;
        if (curr.entity != null) {
            if (curr.isTerrain()) {
                CampaignTerrainAPI terrain = (CampaignTerrainAPI)curr.entity;
                plugin = terrain.getPlugin();
                if (plugin instanceof AsteroidFieldTerrainPlugin) {
                    tag = "asteroid_field";
                } else if (plugin instanceof AsteroidBeltTerrainPlugin) {
                    tag = "asteroid_belt";
                } else if (plugin instanceof RingSystemTerrainPlugin) {
                    RingSystemTerrainPlugin ringPlugin = (RingSystemTerrainPlugin)plugin;
                    if (ringPlugin.getNameForTooltip() != null && ringPlugin.getNameForTooltip().contains("Accretion")) {
                        tag = "accretion";
                    }
                } else if (plugin instanceof NebulaTerrainPlugin) {
                    tag = "nebula";
                } else if (plugin instanceof MagneticFieldTerrainPlugin) {
                    tag = "magnetic_field";
                }
            } else if (curr.isMoon()) {
                tag = "moon";
            } else if (curr.isPrimaryStar() || curr.isSecondaryStar() || curr.isTertiaryStar()) {
                tag = "star";
            } else if (curr.entity instanceof PlanetAPI) {
                tag = "planet";
            }
        }
        if (tag != null) {
            String parent = null;
            if (curr.parent != null && curr.parent.name != null) {
                parent = curr.parent.name.spec.getName();
            }
            if (curr == this.root) {
                parent = this.constellationName.spec.getName();
            }
            boolean noRename = curr.system.getStar() == curr.entity && !this.renameSystem;
            ProcgenUsedNames.NamePick pick = ProcgenUsedNames.pickName(tag, parent, curr.lagrangePointType);
            if (!pick.spec.isReusable() && !noRename) {
                ProcgenUsedNames.notifyUsed(pick.nameWithRomanSuffixIfAny);
            }
            if (pick != null) {
                if (noRename) {
                    name = curr.system.getBaseName();
                    NameGenData data = (NameGenData)Global.getSettings().getSpec(NameGenData.class, name, true);
                    if (data == null) {
                        data = new NameGenData(name, null);
                    } else {
                        ProcgenUsedNames.notifyUsed(name);
                    }
                    curr.name = new ProcgenUsedNames.NamePick(data, name, null);
                } else {
                    curr.name = pick;
                    name = pick.nameWithRomanSuffixIfAny;
                    List<SectorEntityToken> all = this.constellation.allEntitiesAdded.get(curr.entity);
                    for (SectorEntityToken entity : all) {
                        entity.setName(name);
                        if (entity.getMarket() != null) {
                            entity.getMarket().setName(name);
                        }
                        this.updateJumpPointNameFor(entity);
                        if (!(entity instanceof CampaignTerrainAPI)) continue;
                        ((CampaignTerrainAPI)entity).getPlugin().setTerrainName(name);
                    }
                    if (curr.system.getStar() == curr.entity) {
                        curr.system.setBaseName(name);
                    }
                }
            }
        }
        for (NamingTreeNode node : curr.children) {
            this.assignSpecialNames(node);
        }
    }

    public void assignStructuralNames(StarSystemAPI system, String name) {
        if (this.renameSystem) {
            system.setBaseName(name);
            if (system.getStar() != null) {
                system.getStar().setName(name);
                this.updateJumpPointNameFor(system.getStar());
            }
        } else {
            name = system.getBaseName();
        }
        int i = this.structuralNameOffset;
        for (NamingTreeNode node : this.root.children) {
            PlanetAPI planet;
            this.assignSNamesHelper(node, name, i);
            if (!(node.entity instanceof PlanetAPI) || (planet = (PlanetAPI)node.entity).isStar()) continue;
            ++i;
        }
    }

    public void assignSNamesHelper(NamingTreeNode curr, String parentName, int index) {
        if (parentName == null) {
            return;
        }
        String name = parentName;
        if (curr.entity != null) {
            CampaignTerrainAPI terrain = null;
            CampaignTerrainPlugin plugin = null;
            if (curr.entity instanceof CampaignTerrainAPI) {
                terrain = (CampaignTerrainAPI)curr.entity;
                plugin = terrain.getPlugin();
            }
            boolean rename = true;
            if (curr.isSecondaryStar()) {
                name = String.valueOf(name) + " B";
            } else if (curr.isTertiaryStar()) {
                name = String.valueOf(name) + " C";
            } else {
                String[] moonPostfixes = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N"};
                if (curr.isTerrain()) {
                    if (curr.lagrangePointType != null) {
                        name = String.valueOf(name) + " " + curr.lagrangePointType.name();
                        if (plugin instanceof AsteroidFieldTerrainPlugin) {
                            name = String.valueOf(name) + " Asteroid Field";
                        } else if (plugin instanceof NebulaTerrainPlugin) {
                            name = String.valueOf(name) + " Nebula";
                        }
                    } else {
                        rename = false;
                    }
                } else {
                    name = curr.isMoon() ? (curr.lagrangePointType != null ? String.valueOf(name) + "-" + curr.lagrangePointType.name() : String.valueOf(name) + "-" + moonPostfixes[index]) : String.valueOf(name) + " " + Global.getSettings().getRoman(index + 1);
                }
            }
            if (rename) {
                List<SectorEntityToken> all = this.constellation.allEntitiesAdded.get(curr.entity);
                for (SectorEntityToken entity : all) {
                    entity.setName(name);
                    if (entity.getMarket() != null) {
                        entity.getMarket().setName(name);
                    }
                    this.updateJumpPointNameFor(entity);
                    if (!(entity instanceof CampaignTerrainAPI)) continue;
                    ((CampaignTerrainAPI)entity).getPlugin().setTerrainName(name);
                }
            }
        }
        int i = 0;
        for (NamingTreeNode node : curr.children) {
            PlanetAPI planet;
            this.assignSNamesHelper(node, name, i);
            if (!(node.entity instanceof PlanetAPI) || (planet = (PlanetAPI)node.entity).isStar()) continue;
            ++i;
        }
    }

    public void updateJumpPointNameFor(SectorEntityToken entity) {
        if (!(entity instanceof PlanetAPI)) {
            return;
        }
        if (!(entity.getContainingLocation() instanceof StarSystemAPI)) {
            return;
        }
        StarSystemAPI system = (StarSystemAPI)entity.getContainingLocation();
        for (JumpPointAPI point : system.getAutogeneratedJumpPointsInHyper()) {
            if (point.getDestinationVisualEntity() != entity) continue;
            PlanetAPI planet = (PlanetAPI)entity;
            String name = null;
            if (planet.isGasGiant()) {
                name = String.valueOf(planet.getName()) + " Gravity Well";
            } else if (planet.isStar()) {
                name = String.valueOf(planet.getName()) + ", " + planet.getSpec().getName();
            }
            if (name == null) break;
            point.setName(name);
            break;
        }
    }

    public void updateJumpPointDestinationNames(StarSystemAPI system) {
        for (JumpPointAPI point : system.getAutogeneratedJumpPointsInHyper()) {
            for (JumpPointAPI.JumpDestination dest : point.getDestinations()) {
                String name = "the " + system.getNameWithLowercaseType();
                dest.setLabelInInteractionDialog(name);
            }
        }
    }

    public void computeNamingTree(StarSystemAPI system) {
        this.root = new NamingTreeNode(system);
        if (system.getStar() != null && system.getType() != StarSystemGenerator.StarSystemType.NEBULA) {
            this.root.entity = system.getStar();
        }
        for (PlanetAPI planet : system.getPlanets()) {
            if (!planet.isStar() || planet == system.getStar() || !this.constellation.allEntitiesAdded.containsKey(planet)) continue;
            NamingTreeNode node = new NamingTreeNode(system);
            node.entity = planet;
            node.parent = this.root;
            this.root.children.add(node);
        }
        this.addChildren(system, this.root);
        for (NamingTreeNode node : this.root.children) {
            this.addChildren(system, node);
        }
    }

    public void addChildren(StarSystemAPI system, NamingTreeNode curr) {
        float angle2;
        float angle1;
        NamingTreeNode node;
        PlanetAPI lagrangeParent;
        block0: for (PlanetAPI planet : system.getPlanets()) {
            boolean mainStarAndOrbitingSystemCenter;
            if (planet.isStar() || planet == curr.entity || !this.constellation.allEntitiesAdded.containsKey(planet)) continue;
            for (NamingTreeNode n : curr.children) {
                if (n.entity == planet) continue block0;
            }
            lagrangeParent = this.constellation.lagrangeParentMap.get(planet);
            boolean bl = mainStarAndOrbitingSystemCenter = curr.entity == curr.system.getStar() && planet.getOrbitFocus() == curr.system.getCenter() && lagrangeParent == null;
            if (!mainStarAndOrbitingSystemCenter && (planet.getOrbitFocus() != curr.entity || lagrangeParent != null) && lagrangeParent != curr.entity) continue;
            node = new NamingTreeNode(system);
            node.entity = planet;
            node.parent = curr;
            curr.children.add(node);
            if (lagrangeParent != null && planet.getOrbitFocus() != null) {
                angle1 = lagrangeParent.getCircularOrbitAngle();
                node.lagrangePointType = Misc.getClosestTurnDirection(angle1, angle2 = planet.getCircularOrbitAngle()) < 0.0f ? StarSystemGenerator.LagrangePointType.L4 : StarSystemGenerator.LagrangePointType.L5;
            }
            this.addChildren(system, node);
        }
        block2: for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
            boolean mainStarAndOrbitingSystemCenter;
            if (terrain == curr.entity || !this.constellation.allEntitiesAdded.containsKey(terrain)) continue;
            for (NamingTreeNode n : curr.children) {
                if (n.entity == terrain) continue block2;
            }
            lagrangeParent = this.constellation.lagrangeParentMap.get(terrain);
            boolean bl = mainStarAndOrbitingSystemCenter = curr.entity == curr.system.getStar() && terrain.getOrbitFocus() == curr.system.getCenter() && lagrangeParent == null;
            if (!mainStarAndOrbitingSystemCenter && (terrain.getOrbitFocus() != curr.entity || lagrangeParent != null) && lagrangeParent != curr.entity) continue;
            node = new NamingTreeNode(system);
            node.entity = terrain;
            node.parent = curr;
            curr.children.add(node);
            if (lagrangeParent != null && terrain.getOrbitFocus() != null) {
                angle1 = lagrangeParent.getCircularOrbitAngle();
                node.lagrangePointType = Misc.getClosestTurnDirection(angle1, angle2 = terrain.getCircularOrbitAngle()) < 0.0f ? StarSystemGenerator.LagrangePointType.L4 : StarSystemGenerator.LagrangePointType.L5;
            }
            this.addChildren(system, node);
        }
        Collections.sort(curr.children, new Comparator<NamingTreeNode>(){

            @Override
            public int compare(NamingTreeNode o1, NamingTreeNode o2) {
                Vector2f from = new Vector2f();
                if (o1.parent != null && o1.parent.entity != null) {
                    from = o1.parent.entity.getLocation();
                    if (o1.parent == o1.system.getStar()) {
                        from = o1.system.getCenter().getLocation();
                    }
                }
                float d1 = Misc.getDistance(from, o1.entity.getLocation());
                float d2 = Misc.getDistance(from, o2.entity.getLocation());
                return (int)Math.signum(d1 - d2);
            }
        });
    }

    public static boolean isNameSpecial(StarSystemAPI system) {
        if (system.getConstellation() == null) {
            return true;
        }
        String name = system.getBaseName();
        ProcgenUsedNames.NamePick constellationName = system.getConstellation().getNamePick();
        String base = constellationName.nameWithRomanSuffixIfAny;
        if (constellationName.secondaryWithRomanSuffixIfAny != null) {
            base = constellationName.secondaryWithRomanSuffixIfAny;
        }
        return !name.toLowerCase().contains(base.toLowerCase());
    }

    public static void assignSpecialNames(StarSystemAPI system) {
        Constellation actual = system.getConstellation();
        if (actual == null || actual.getNamePick() == null) {
            return;
        }
        Constellation c = new Constellation(Constellation.ConstellationType.NORMAL, actual.getAge());
        c.getSystems().add(system);
        c.setLagrangeParentMap(actual.getLagrangeParentMap());
        c.setAllEntitiesAdded(actual.getAllEntitiesAdded());
        c.setLeavePickedNameUnused(true);
        NameAssigner namer = new NameAssigner(c);
        namer.setSpecialNamesProbability(1.0f);
        namer.assignNames(actual.getNamePick().spec.getName(), actual.getNamePick().spec.getSecondary());
    }

    public static class NamingTreeNode {
        public NamingTreeNode parent;
        public StarSystemGenerator.LagrangePointType lagrangePointType = null;
        public ProcgenUsedNames.NamePick name;
        public SectorEntityToken entity;
        public List<NamingTreeNode> children = new ArrayList<NamingTreeNode>();
        public StarSystemAPI system;

        public NamingTreeNode(StarSystemAPI system) {
            this.system = system;
        }

        public boolean isPrimaryStar() {
            return this.entity == this.system.getStar();
        }

        public boolean isSecondaryStar() {
            return this.entity == this.system.getSecondary();
        }

        public boolean isTertiaryStar() {
            return this.entity == this.system.getTertiary();
        }

        public boolean isMoon() {
            return !this.isTerrain() && this.parent != null && this.parent.entity instanceof PlanetAPI && !((PlanetAPI)this.parent.entity).isStar();
        }

        public boolean isTerrain() {
            return this.entity instanceof CampaignTerrainAPI;
        }
    }
}

