/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCustomProductionPickerDelegateImpl;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FactionProductionAPI;
import com.fs.starfarer.api.campaign.FleetInflater;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.VisualPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.plugins.OfficerLevelupPlugin;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PlayerFleetGenPluginImpl
implements InteractionDialogPlugin {
    protected InteractionDialogAPI dialog;
    protected TextPanelAPI textPanel;
    protected OptionPanelAPI options;
    protected VisualPanelAPI visual;
    protected FleetGenData data = new FleetGenData();
    protected CampaignFleetAPI playerFleet;
    protected Set<String> ships = new LinkedHashSet<String>();
    protected Set<String> fighters = new LinkedHashSet<String>();
    protected Set<String> weapons = new LinkedHashSet<String>();
    protected Set<String> unrestrictedFighters = new LinkedHashSet<String>();
    protected Set<String> unrestrictedWeapons = new LinkedHashSet<String>();
    protected Set<String> hullmods = new LinkedHashSet<String>();
    protected static final Color HIGHLIGHT_COLOR = Global.getSettings().getColor("buttonShortcut");
    protected OptionId lastOptionMousedOver = null;

    @Override
    public void init(InteractionDialogAPI dialog) {
        this.dialog = dialog;
        this.textPanel = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        this.visual = dialog.getVisualPanel();
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.visual.setVisualFade(0.25f, 0.25f);
        this.initAvailable();
        dialog.setOptionOnEscape("Leave", (Object)OptionId.LEAVE);
        this.optionSelected(null, (Object)OptionId.INIT);
    }

    @Override
    public Map<String, MemoryAPI> getMemoryMap() {
        return null;
    }

    @Override
    public void backFromEngagement(EngagementResultAPI result) {
    }

    @Override
    public void optionSelected(String text, Object optionData) {
        if (optionData == null) {
            return;
        }
        OptionId option = (OptionId)((Object)optionData);
        if (text != null) {
            this.dialog.addOptionSelectedText((Object)option);
        }
        switch (option) {
            case INIT: {
                this.selectShipsAndWeapons();
                break;
            }
            case SELECT_SHIPS: {
                this.showBlueprintPicker();
                break;
            }
            case ADD_UNSELECTED_OFFICERS: {
                this.showOfficerSelector();
                break;
            }
            case OFFICERS_GO_BACK: {
                this.selectShipsAndWeapons();
                break;
            }
            case OFFICER_LEVEL_5: {
                this.addNoSkillOfficer(5);
                break;
            }
            case OFFICER_LEVEL_6: {
                this.addNoSkillOfficer(6);
                break;
            }
            case OFFICER_LEVEL_7: {
                this.addNoSkillOfficer(7);
                break;
            }
            case QUALITY_MAX_DMODS: {
                this.data.quality = FleetQuality.MAX_DMODS;
                this.selectOfficerLevel();
                break;
            }
            case QUALITY_NO_DMODS: {
                this.data.quality = FleetQuality.NO_DMODS;
                this.selectOfficerLevel();
                break;
            }
            case QUALITY_1_SMODS: {
                this.data.quality = FleetQuality.ONE_SMOD;
                this.selectOfficerLevel();
                break;
            }
            case QUALITY_2_SMODS: {
                this.data.quality = FleetQuality.TWO_SMODS;
                this.selectOfficerLevel();
                break;
            }
            case QUALITY_2_SMODS_OMEGA: {
                this.data.quality = FleetQuality.TWO_SMODS;
                this.data.allowOmega = true;
                this.selectOfficerLevel();
                break;
            }
            case QUALITY_3_SMODS: {
                this.data.quality = FleetQuality.THREE_SMODS;
                this.selectOfficerLevel();
                break;
            }
            case QUALITY_3_SMODS_OMEGA: {
                this.data.quality = FleetQuality.THREE_SMODS;
                this.data.allowOmega = true;
                this.selectOfficerLevel();
                break;
            }
            case NO_OFFICERS: {
                this.data.addOfficers = false;
                this.selectAppendOrReplace();
                break;
            }
            case ADD_OFFICERS: {
                this.data.addOfficers = true;
                this.selectAppendOrReplace();
                break;
            }
            case ADD_OFFICERS_NO_SKILLS: {
                this.data.addOfficers = true;
                this.data.keepOfficerPointsFree = true;
                this.selectAppendOrReplace();
                break;
            }
            case CREATE_ADD: {
                this.data.append = true;
                this.createFleet();
                this.dialog.dismiss();
                break;
            }
            case CREATE_REPLACE: {
                this.data.append = false;
                this.createFleet();
                this.dialog.dismiss();
                break;
            }
            case LEAVE: {
                this.dialog.dismiss();
                break;
            }
        }
    }

    protected MarketAPI getNearestMarket(boolean playerOnly) {
        MarketAPI nearest = null;
        float minDist = Float.MAX_VALUE;
        CampaignFleetAPI pf = Global.getSector().getPlayerFleet();
        for (MarketAPI curr : Global.getSector().getEconomy().getMarketsCopy()) {
            boolean nearer;
            if (curr.isHidden() || playerOnly && !curr.isPlayerOwned()) continue;
            float dist = Misc.getDistanceLY(pf, curr.getPrimaryEntity());
            boolean bl = nearer = dist < minDist;
            if (dist == minDist && dist == 0.0f && nearest != null) {
                float d2;
                float d1 = Misc.getDistance(pf, curr.getPrimaryEntity());
                boolean bl2 = nearer = d1 < (d2 = Misc.getDistance(pf, nearest.getPrimaryEntity()));
            }
            if (!nearer) continue;
            nearest = curr;
            minDist = dist;
        }
        return nearest;
    }

    protected void print(String str) {
        this.textPanel.appendToLastParagraph("\n" + str);
        System.out.println(str);
    }

    protected void selectShipsAndWeapons() {
        this.textPanel.addPara("--- QUICK PLAYER FLEET CREATOR ---");
        this.textPanel.addPara("Ship variants will be randomly picked from those available for a given hull.");
        this.textPanel.addPara("Selected weapons and fighters will be added to your cargo.");
        this.options.clearOptions();
        this.options.addOption("Select ships and weapons", (Object)OptionId.SELECT_SHIPS);
        this.options.addOption("Add officers with unselected skills", (Object)OptionId.ADD_UNSELECTED_OFFICERS);
        this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
    }

    protected void showOfficerSelector() {
        this.textPanel.addPara("Select option to instantly add an officer of that level with all unspent skills. The officer level will be 1 higher than selected and they will not have an initial skill.");
        this.options.clearOptions();
        this.options.addOption("Level 5", (Object)OptionId.OFFICER_LEVEL_5);
        this.options.addOption("Level 6", (Object)OptionId.OFFICER_LEVEL_6);
        this.options.addOption("Level 7", (Object)OptionId.OFFICER_LEVEL_7);
        this.options.addOption("Go back", (Object)OptionId.OFFICERS_GO_BACK);
    }

    protected void selectQuality() {
        this.textPanel.addPara("Select ship quality.");
        this.options.clearOptions();
        this.options.addOption("Maximum number of d-mods", (Object)OptionId.QUALITY_MAX_DMODS);
        this.options.addOption("No d-mods", (Object)OptionId.QUALITY_NO_DMODS);
        this.options.addOption("Average of 1 s-mod", (Object)OptionId.QUALITY_1_SMODS);
        this.options.addOption("Average of 2 s-mods", (Object)OptionId.QUALITY_2_SMODS);
        this.options.addOption("Average of 2 s-mods; allow some Omega weapons to be mounted", (Object)OptionId.QUALITY_2_SMODS_OMEGA);
        this.options.addOption("Average of 3 s-mods", (Object)OptionId.QUALITY_3_SMODS);
        this.options.addOption("Average of 3 s-mods; allow some Omega weapons to be mounted", (Object)OptionId.QUALITY_3_SMODS_OMEGA);
        this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
    }

    protected void selectOfficerLevel() {
        this.textPanel.addPara("The total number of officers and their level and elite skills will be based on your character's skills.");
        this.options.clearOptions();
        this.options.addOption("Add officers (number / level / elite skills based on your character's skills)", (Object)OptionId.ADD_OFFICERS);
        this.options.addOption("Do not add officers", (Object)OptionId.NO_OFFICERS);
        this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
    }

    protected void selectAppendOrReplace() {
        this.textPanel.addPara("Select fleet creation mode.");
        this.options.clearOptions();
        this.options.addOption("Replace current fleet with new ships", (Object)OptionId.CREATE_REPLACE);
        this.options.addOption("Add new ships to current fleet", (Object)OptionId.CREATE_ADD);
        this.options.addOption("Leave", (Object)OptionId.LEAVE, null);
    }

    @Override
    public void optionMousedOver(String optionText, Object optionData) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public Object getContext() {
        return null;
    }

    public void showBlueprintPicker() {
        this.dialog.showCustomProductionPicker(new BaseCustomProductionPickerDelegateImpl(){

            @Override
            public Set<String> getAvailableFighters() {
                return PlayerFleetGenPluginImpl.this.fighters;
            }

            @Override
            public Set<String> getAvailableShipHulls() {
                return PlayerFleetGenPluginImpl.this.ships;
            }

            @Override
            public Set<String> getAvailableWeapons() {
                return PlayerFleetGenPluginImpl.this.weapons;
            }

            @Override
            public float getCostMult() {
                return 0.001f;
            }

            @Override
            public float getMaximumValue() {
                return 1000000.0f;
            }

            @Override
            public boolean withQuantityLimits() {
                return false;
            }

            @Override
            public void notifyProductionSelected(FactionProductionAPI production) {
                PlayerFleetGenPluginImpl.this.data.prod = production;
                PlayerFleetGenPluginImpl.this.selectQuality();
            }
        });
    }

    protected void createFleet() {
        int maxOfficers;
        int add;
        FactionProductionAPI prod = this.data.prod;
        CargoAPI cargo = Global.getFactory().createCargo(true);
        Random random = Misc.random;
        float quality = 2.0f;
        if (this.data.quality == FleetQuality.MAX_DMODS) {
            quality = -2.0f;
        }
        CampaignFleetAPI ships = Global.getFactory().createEmptyFleet("player", "temp", true);
        ships.setCommander(Global.getSector().getPlayerPerson());
        DefaultFleetInflaterParams p = new DefaultFleetInflaterParams();
        p.quality = quality;
        p.mode = FactionAPI.ShipPickMode.PRIORITY_THEN_ALL;
        p.persistent = false;
        p.seed = random.nextLong();
        p.timestamp = null;
        p.rProb = Float.valueOf(0.0f);
        p.allWeapons = true;
        if (this.data.quality == FleetQuality.ONE_SMOD) {
            p.averageSMods = 1;
        } else if (this.data.quality == FleetQuality.TWO_SMODS) {
            p.averageSMods = 2;
        } else if (this.data.quality == FleetQuality.THREE_SMODS) {
            p.averageSMods = 3;
        }
        FleetInflater inflater = Misc.getInflater(ships, p);
        ships.setInflater(inflater);
        for (FactionProductionAPI.ItemInProductionAPI pick : prod.getCurrent()) {
            int count = pick.getQuantity();
            if (pick.getType() == FactionProductionAPI.ProductionItemType.SHIP) {
                Object variants = Global.getSettings().getHullIdToVariantListMap().get(pick.getSpecId());
                if (variants.isEmpty()) {
                    variants.add(String.valueOf(pick.getSpecId()) + "_Hull");
                }
                int i = 0;
                while (i < count) {
                    int index = random.nextInt(variants.size());
                    ships.getFleetData().addFleetMember((String)variants.get(index));
                    ++i;
                }
            } else if (pick.getType() == FactionProductionAPI.ProductionItemType.FIGHTER) {
                cargo.addFighters(pick.getSpecId(), count);
            } else if (pick.getType() == FactionProductionAPI.ProductionItemType.WEAPON) {
                cargo.addWeapons(pick.getSpecId(), count);
            }
            prod.removeItem(pick.getType(), pick.getSpecId(), count);
        }
        FactionAPI pf = Global.getSector().getPlayerFaction();
        ArrayList<String> addedWeapons = new ArrayList<String>();
        ArrayList<String> addedFighters = new ArrayList<String>();
        ArrayList<String> addedHullmods = new ArrayList<String>();
        if (this.data.allowOmega) {
            for (String id : this.weapons) {
                WeaponSpecAPI spec;
                if (this.unrestrictedWeapons.contains(id) || !(spec = Global.getSettings().getWeaponSpec(id)).hasTag("omega")) continue;
                this.unrestrictedWeapons.add(id);
            }
        }
        for (String id : this.unrestrictedWeapons) {
            if (pf.knowsWeapon(id)) continue;
            addedWeapons.add(id);
            pf.addKnownWeapon(id, false);
        }
        for (String id : this.unrestrictedFighters) {
            if (pf.knowsFighter(id)) continue;
            addedFighters.add(id);
            pf.addKnownFighter(id, false);
        }
        for (String id : this.hullmods) {
            if (pf.knowsHullMod(id)) continue;
            addedHullmods.add(id);
            pf.addKnownHullMod(id);
        }
        ships.inflateIfNeeded();
        for (String id : addedWeapons) {
            pf.removeKnownWeapon(id);
        }
        for (String id : addedFighters) {
            pf.removeKnownFighter(id);
        }
        for (String id : addedHullmods) {
            pf.removeKnownHullMod(id);
        }
        if (!this.data.append && !ships.isEmpty()) {
            this.playerFleet.getFleetData().clear();
            if (this.data.addOfficers) {
                for (OfficerDataAPI od : this.playerFleet.getFleetData().getOfficersCopy()) {
                    this.playerFleet.getFleetData().removeOfficer(od.getPerson());
                }
            }
        }
        this.playerFleet.getCargo().addAll(cargo);
        for (FleetMemberAPI member : ships.getFleetData().getMembersListCopy()) {
            this.playerFleet.getFleetData().addFleetMember(member);
        }
        if (this.data.addOfficers && (add = (maxOfficers = Misc.getMaxOfficers(this.playerFleet)) - this.playerFleet.getFleetData().getOfficersCopy().size()) > 0) {
            FleetParamsV3 fp = new FleetParamsV3();
            fp.commander = this.playerFleet.getCommander();
            fp.maxOfficersToAdd = add;
            FleetFactoryV3.addCommanderAndOfficersV2(this.playerFleet, fp, random);
        }
        this.playerFleet.forceSync();
        cargo = this.playerFleet.getCargo();
        int neededCrew = (int)((this.playerFleet.getFleetData().getMinCrew() + cargo.getMaxPersonnel()) / 2.0f - (float)cargo.getCrew());
        if (neededCrew > 0) {
            cargo.addCrew(neededCrew);
        }
        cargo.addFuel(cargo.getMaxFuel() - cargo.getFuel());
        cargo.addSupplies(cargo.getSpaceLeft() * 0.5f);
        this.playerFleet.forceSync();
        for (FleetMemberAPI member : this.playerFleet.getFleetData().getMembersListCopy()) {
            float max = member.getRepairTracker().getMaxCR();
            member.getRepairTracker().setCR(max);
        }
    }

    protected void initAvailable() {
        for (ShipHullSpecAPI shipHullSpecAPI : Global.getSettings().getAllShipHullSpecs()) {
            if (shipHullSpecAPI.isDefaultDHull() || shipHullSpecAPI.getHullSize() == ShipAPI.HullSize.FIGHTER || !shipHullSpecAPI.hasHullName() || shipHullSpecAPI.getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.STATION) || "shuttlepod".equals(shipHullSpecAPI.getHullId())) continue;
            this.ships.add(shipHullSpecAPI.getHullId());
        }
        for (WeaponSpecAPI weaponSpecAPI : Global.getSettings().getAllWeaponSpecs()) {
            if (weaponSpecAPI.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM)) continue;
            if (!weaponSpecAPI.hasTag("restricted")) {
                this.unrestrictedWeapons.add(weaponSpecAPI.getWeaponId());
            }
            this.weapons.add(weaponSpecAPI.getWeaponId());
        }
        for (FighterWingSpecAPI fighterWingSpecAPI : Global.getSettings().getAllFighterWingSpecs()) {
            if (!fighterWingSpecAPI.hasTag("restricted")) {
                this.unrestrictedFighters.add(fighterWingSpecAPI.getId());
            }
            this.fighters.add(fighterWingSpecAPI.getId());
        }
        for (HullModSpecAPI hullModSpecAPI : Global.getSettings().getAllHullModSpecs()) {
            this.hullmods.add(hullModSpecAPI.getId());
        }
    }

    protected void addNoSkillOfficer(int level) {
        PersonAPI p = Global.getSector().getPlayerFaction().createRandomPerson();
        p.getMemoryWithoutUpdate().set("$officerSkillPicksPerLevel", 10);
        p.getMemoryWithoutUpdate().set("$officerMaxLevel", level + 1);
        if (level >= 7) {
            p.getMemoryWithoutUpdate().set("$officerMaxEliteSkills", 4);
        }
        for (MutableCharacterStatsAPI.SkillLevelAPI sl : p.getStats().getSkillsCopy()) {
            p.getStats().setSkillLevel(sl.getSkill().getId(), 0.0f);
        }
        OfficerLevelupPlugin plugin = (OfficerLevelupPlugin)Global.getSettings().getPlugin("officerLevelUp");
        long xp = plugin.getXPForLevel(level + 1);
        OfficerDataAPI od = Global.getFactory().createOfficerData(p);
        od.addXP(xp);
        Global.getSector().getPlayerFleet().getFleetData().addOfficer(od);
        if (level >= 7) {
            this.textPanel.addPara("Added level " + (level + 1) + " officer with NO initial skill and 4 elite skills max.");
        } else {
            this.textPanel.addPara("Added level " + (level + 1) + " officer with NO initial skill.");
        }
    }

    public static class FleetGenData {
        public FactionProductionAPI prod = Global.getSector().getPlayerFaction().getProduction().clone();
        public FleetQuality quality;
        public boolean smodsOnAllShips = true;
        public boolean allowOmega = false;
        public boolean addOfficers = false;
        public boolean keepOfficerPointsFree = false;
        public boolean append = false;

        public FleetGenData() {
            this.prod.clear();
        }
    }

    protected static enum FleetQuality {
        MAX_DMODS,
        NO_DMODS,
        ONE_SMOD,
        TWO_SMODS,
        THREE_SMODS;

    }

    protected static enum OptionId {
        INIT,
        SELECT_SHIPS,
        ADD_UNSELECTED_OFFICERS,
        OFFICER_LEVEL_5,
        OFFICER_LEVEL_6,
        OFFICER_LEVEL_7,
        OFFICERS_GO_BACK,
        QUALITY_MAX_DMODS,
        QUALITY_NO_DMODS,
        QUALITY_1_SMODS,
        QUALITY_2_SMODS,
        QUALITY_2_SMODS_OMEGA,
        QUALITY_3_SMODS,
        QUALITY_3_SMODS_OMEGA,
        ADD_OFFICERS,
        ADD_OFFICERS_NO_SKILLS,
        NO_OFFICERS,
        CREATE_REPLACE,
        CREATE_ADD,
        LEAVE;

    }
}

