/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.CoronalTapParticleScript;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.econ.impl.PlanetaryShield;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflater;
import com.fs.starfarer.api.impl.campaign.fleets.DefaultFleetInflaterParams;
import com.fs.starfarer.api.impl.campaign.ids.Planets;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.DefenderDataOverride;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetConditionGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.ProcgenUsedNames;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenContext;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class MiscellaneousThemeGenerator
extends BaseThemeGenerator {
    public static String PK_SYSTEM_KEY = "$core_pkSystem";
    public static String PK_PLANET_KEY = "$core_pkPlanet";
    public static String PK_CACHE_KEY = "$core_pkCache";
    public static String PK_NEXUS_KEY = "$core_pkNexus";
    public static String PLANETARY_SHIELD_PLANET_KEY = "$core_planetaryShieldPlanet";
    public static String PLANETARY_SHIELD_PLANET = "$psi_planet";
    public static String LOCR_BLOCK_FIRST_SURVEY = "$locr_blockFirstSurvey";
    public static String LOCR_LUDDIC_PLANET_KEY = "$locr_luddicPlanet";
    public static String LOCR_LUDDIC_TRANSPORT_KEY = "$locr_luddicTransport";
    public static String LOCR_LUDDIC = "$locr_luddic";
    public static String LOCR_MINERS_PLANET_KEY = "$locr_minersPlanet";
    public static String LOCR_MINERS = "$locr_miners";
    public static String LOCR_PIRATE_PLANET_KEY = "$locr_piratePlanet";
    public static String LOCR_PIRATE = "$locr_pirate";
    public static float PROB_TO_ADD_SOMETHING = 0.5f;
    public static int MIN_GATES = Global.getSettings().getInt("minNonCoreGatesInSector");
    public static int MAX_GATES = Global.getSettings().getInt("maxNonCoreGatesInSector");
    public static int MIN_GATES_TO_ADD = Global.getSettings().getInt("minGatesToAddOnSecondPass");

    @Override
    public String getThemeId() {
        return "misc";
    }

    @Override
    public float getWeight() {
        return 0.0f;
    }

    @Override
    public int getOrder() {
        return 1000000;
    }

    @Override
    public void generateForSector(ThemeGenContext context, float allowedUnusedFraction) {
        if (DEBUG) {
            System.out.println("\n\n\n");
        }
        if (DEBUG) {
            System.out.println("Generating misc derelicts etc in all systems");
        }
        ArrayList<BaseThemeGenerator.StarSystemData> all = new ArrayList<BaseThemeGenerator.StarSystemData>();
        for (Constellation c : context.constellations) {
            String theme = context.majorThemes.get(c);
            ArrayList<BaseThemeGenerator.StarSystemData> systems = new ArrayList<BaseThemeGenerator.StarSystemData>();
            for (StarSystemAPI system : c.getSystems()) {
                BaseThemeGenerator.StarSystemData data = MiscellaneousThemeGenerator.computeSystemData(system);
                systems.add(data);
            }
            for (BaseThemeGenerator.StarSystemData data : systems) {
                boolean derelict = data.system.hasTag("theme_derelict");
                if (!derelict && theme != null && !data.system.getTags().isEmpty()) continue;
                if (this.random.nextFloat() > PROB_TO_ADD_SOMETHING || derelict && theme != null) {
                    data.system.addTag("theme_misc_skip");
                    continue;
                }
                this.populateNonMain(data);
                all.add(data);
                data.system.addTag("theme_misc");
                data.system.addTag("theme_interesting_minor");
            }
        }
        SalvageSpecialAssigner.SpecialCreationContext specialContext = new SalvageSpecialAssigner.SpecialCreationContext();
        specialContext.themeId = this.getThemeId();
        SalvageSpecialAssigner.assignSpecials(all, specialContext);
        if (DEBUG) {
            System.out.println("Finished generating misc derelicts\n\n\n\n\n");
        }
        this.addDerelicts(context, "legion_xiv_Elite", 2, 3, 1, 2, "theme_remnant");
        this.addDerelicts(context, "phantom_Elite", 1, 2, 0, 1, "theme_remnant", "theme_ruins", "theme_derelict", "theme_unsafe");
        this.addDerelicts(context, "revenant_Elite", 1, 2, 0, 1, "theme_remnant", "theme_ruins", "theme_derelict", "theme_unsafe");
        this.addRedPlanet(context);
        this.addPKSystem(context);
        this.addSolarShadesAndMirrors(context);
        this.addCoronalTaps(context);
        this.addExtraGates(context);
        this.addLOCRPiratePlanet(context);
        this.addLOCRLuddicPlanet(context);
        this.addLOCRMinersPlanet(context);
    }

    protected void addRedPlanet(ThemeGenContext context) {
        if (DEBUG) {
            System.out.println("Looking for planetary shield planet");
        }
        SectorEntityToken bestHab = null;
        SectorEntityToken bestNonHab = null;
        float habDist = 0.0f;
        float nonHabDist = 0.0f;
        int systemsChecked = 0;
        for (Constellation c : context.constellations) {
            for (StarSystemAPI system : c.getSystems()) {
                if (system.hasTag("theme_special") || !system.hasTag("theme_misc_skip") && !system.hasTag("theme_misc") || system.hasTag("theme_derelict")) continue;
                ++systemsChecked;
                for (PlanetAPI curr : system.getPlanets()) {
                    if (curr.isStar() || curr.isMoon() || !curr.getMarket().isPlanetConditionMarketOnly() || curr.hasTag("not_random_mission_target")) continue;
                    float dist = system.getLocation().length() + this.random.nextFloat() * 6000.0f;
                    if (curr.getMarket().hasCondition("habitable")) {
                        if (!(dist > habDist)) continue;
                        habDist = dist;
                        bestHab = curr;
                        continue;
                    }
                    if (!(dist > nonHabDist)) continue;
                    nonHabDist = dist;
                    bestNonHab = curr;
                }
            }
        }
        SectorEntityToken planet = bestHab;
        if (planet == null) {
            planet = bestNonHab;
        }
        if (planet != null) {
            if (DEBUG) {
                System.out.println("Adding Planetary Shield to [" + planet.getName() + "] in [" + planet.getContainingLocation().getNameWithLowercaseType() + "]");
            }
            PlanetaryShield.applyVisuals(planet);
            Global.getSector().getMemoryWithoutUpdate().set(PLANETARY_SHIELD_PLANET_KEY, planet);
            planet.getMemoryWithoutUpdate().set(PLANETARY_SHIELD_PLANET, true);
            planet.getStarSystem().addTag("theme_special");
            long seed = StarSystemGenerator.random.nextLong();
            planet.getMemoryWithoutUpdate().set("$salvageSeed", seed);
            planet.getMemoryWithoutUpdate().set("$salvageSpecId", "red_planet");
            planet.addTag("not_random_mission_target");
        } else if (DEBUG) {
            System.out.println("Failed to find a planet in remnant systems");
        }
        if (DEBUG) {
            System.out.println("Finished adding Planetary Shield planet\n\n\n\n\n");
        }
    }

    protected void addDerelicts(ThemeGenContext context, String variant, int minNonSalvageable, int maxNonSalvageable, int minSalvageable, int maxSalvageable, String ... allowedThemes) {
        if (Global.getSettings().getVariant(variant) != null) {
            if (DEBUG) {
                System.out.println("Adding " + variant + " to star systems");
            }
            HashSet<String> tags = new HashSet<String>(Arrays.asList(allowedThemes));
            int numSalvageable = minSalvageable + this.random.nextInt(maxSalvageable - minSalvageable + 1);
            int numNonSalvageable = minNonSalvageable + this.random.nextInt(maxNonSalvageable - minNonSalvageable + 1);
            ArrayList<Constellation> list = new ArrayList<Constellation>(context.constellations);
            Collections.shuffle(list, this.random);
            ArrayList<BaseThemeGenerator.StarSystemData> systems = new ArrayList<BaseThemeGenerator.StarSystemData>();
            for (Constellation c : list) {
                for (StarSystemAPI system : c.getSystems()) {
                    BaseThemeGenerator.StarSystemData data = MiscellaneousThemeGenerator.computeSystemData(system);
                    systems.add(data);
                }
            }
            Collections.shuffle(systems, this.random);
            for (BaseThemeGenerator.StarSystemData data : systems) {
                boolean matches = false;
                for (String tag : data.system.getTags()) {
                    if (!tags.contains(tag)) continue;
                    matches = true;
                    break;
                }
                if (!matches) continue;
                BaseThemeGenerator.EntityLocation loc = MiscellaneousThemeGenerator.pickAnyLocation(this.random, data.system, 70.0f, null);
                BaseThemeGenerator.AddedEntity ae = this.addDerelictShip(data, loc, variant);
                if (ae != null) {
                    if (numSalvageable > 0) {
                        --numSalvageable;
                        SalvageSpecialAssigner.ShipRecoverySpecialCreator creator = new SalvageSpecialAssigner.ShipRecoverySpecialCreator(this.random, 0, 0, false, null, null);
                        Object specialData = creator.createSpecial(ae.entity, new SalvageSpecialAssigner.SpecialCreationContext());
                        if (specialData != null) {
                            Misc.setSalvageSpecial(ae.entity, specialData);
                        }
                    } else {
                        --numNonSalvageable;
                        SalvageSpecialAssigner.assignSpecials(ae.entity, true);
                    }
                    if (DEBUG) {
                        System.out.println("      Added " + variant + " to " + data.system + "\n");
                    }
                }
                if (numSalvageable + numNonSalvageable <= 0) break;
            }
            if (DEBUG) {
                System.out.println("Finished adding " + variant + " to star systems\n\n\n\n\n");
            }
        }
    }

    protected void addSolarShadesAndMirrors(ThemeGenContext context) {
        int num = 2 + this.random.nextInt(3);
        if (DEBUG) {
            System.out.println("Adding up to " + num + " solar shades and mirrors");
        }
        ArrayList<Constellation> list = new ArrayList<Constellation>(context.constellations);
        WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>(this.random);
        for (Constellation c : list) {
            for (StarSystemAPI system : c.getSystems()) {
                if (system.hasTag("theme_core") || system.isNebula()) continue;
                for (PlanetAPI planet : system.getPlanets()) {
                    String cat;
                    PlanetGenDataSpec spec;
                    SectorEntityToken focus;
                    if (planet.isStar() || !((focus = planet.getOrbitFocus()) instanceof PlanetAPI) || !((PlanetAPI)focus).isNormalStar() || (spec = (PlanetGenDataSpec)Global.getSettings().getSpec(PlanetGenDataSpec.class, planet.getSpec().getPlanetType(), true)) == null || (cat = spec.getCategory()) == null) continue;
                    float weight = 0.0f;
                    if (Planets.CAT_HAB1.equals(cat)) {
                        weight = 1.0f;
                    } else if (Planets.CAT_HAB2.equals(cat)) {
                        weight = 1.0f;
                    } else if (Planets.CAT_HAB3.equals(cat)) {
                        weight = 1.0f;
                    }
                    if (weight <= 0.0f) continue;
                    weight = 0.0f;
                    if (planet.hasCondition("hot")) {
                        weight += 5.0f;
                    }
                    if (planet.hasCondition("poor_light")) {
                        weight += 5.0f;
                    }
                    if (planet.hasCondition("water_surface")) {
                        weight += 5.0f;
                    }
                    if (Misc.hasFarmland(planet.getMarket())) {
                        weight += 10.0f;
                    }
                    if (weight <= 0.0f) continue;
                    boolean enoughRoom = true;
                    for (PlanetAPI other : system.getPlanets()) {
                        if (other.getOrbitFocus() != planet || !(other.getCircularOrbitRadius() < planet.getRadius() + other.getRadius() + 320.0f)) continue;
                        enoughRoom = false;
                        break;
                    }
                    if (!enoughRoom) continue;
                    picker.add(planet, weight);
                }
            }
        }
        if (DEBUG) {
            System.out.println("Found " + picker.getItems().size() + " candidates");
        }
        int i = 0;
        while (i < num && !picker.isEmpty()) {
            StarSystemAPI system;
            PlanetAPI planet = (PlanetAPI)picker.pickAndRemove();
            if (DEBUG) {
                System.out.println("Adding solar shades and mirrors to [" + planet.getName() + "] in [" + planet.getStarSystem() + " located at " + planet.getLocationInHyperspace());
            }
            planet.getMarket().addCondition("solar_array");
            system = planet.getStarSystem();
            PlanetAPI star = (PlanetAPI)planet.getOrbitFocus();
            boolean shade = planet.hasCondition("hot") || planet.getTypeId().equals("desert") || planet.getTypeId().equals("desert1") || planet.getTypeId().equals("arid") || star.getTypeId().equals("star_blue_giant") || star.getTypeId().equals("star_blue_supergiant");
            boolean mirror = planet.hasCondition("poor_light") || planet.getTypeId().equals("terran-eccentric") || star.getTypeId().equals("star_red_dwarf") || star.getTypeId().equals("star_browndwarf");
            boolean forceFew = false;
            if (!shade && !mirror) {
                mirror = true;
                shade = true;
                forceFew = true;
            }
            String faction = "neutral";
            float period = planet.getCircularOrbitPeriod();
            float angle = planet.getCircularOrbitAngle();
            float radius = 270.0f + planet.getRadius();
            float xp = 300.0f;
            float profile = 2000.0f;
            if (mirror) {
                boolean manyMirrors = this.random.nextBoolean();
                CustomCampaignEntityAPI mirror2 = system.addCustomEntity(null, "Stellar Mirror Beta", "stellar_mirror", faction);
                CustomCampaignEntityAPI mirror3 = system.addCustomEntity(null, "Stellar Mirror Gamma", "stellar_mirror", faction);
                CustomCampaignEntityAPI mirror4 = system.addCustomEntity(null, "Stellar Mirror Delta", "stellar_mirror", faction);
                mirror2.setCircularOrbitPointingDown(planet, angle - 30.0f, radius, period);
                mirror3.setCircularOrbitPointingDown(planet, angle + 0.0f, radius, period);
                mirror4.setCircularOrbitPointingDown(planet, angle + 30.0f, radius, period);
                MiscellaneousThemeGenerator.makeDiscoverable(mirror2, xp, profile);
                MiscellaneousThemeGenerator.makeDiscoverable(mirror3, xp, profile);
                MiscellaneousThemeGenerator.makeDiscoverable(mirror4, xp, profile);
                if (manyMirrors && !forceFew) {
                    CustomCampaignEntityAPI mirror1 = system.addCustomEntity(null, "Stellar Mirror Alpha", "stellar_mirror", faction);
                    CustomCampaignEntityAPI mirror5 = system.addCustomEntity(null, "Stellar Mirror Epsilon", "stellar_mirror", faction);
                    mirror1.setCircularOrbitPointingDown(planet, angle - 60.0f, radius, period);
                    mirror5.setCircularOrbitPointingDown(planet, angle + 60.0f, radius, period);
                    MiscellaneousThemeGenerator.makeDiscoverable(mirror1, xp, profile);
                    MiscellaneousThemeGenerator.makeDiscoverable(mirror5, xp, profile);
                }
            }
            if (shade) {
                boolean manyShades = this.random.nextBoolean();
                CustomCampaignEntityAPI shade2 = system.addCustomEntity(null, "Stellar Shade Psi", "stellar_shade", faction);
                shade2.setCircularOrbitPointingDown(planet, angle + 180.0f + 0.0f, radius + 25.0f, period);
                MiscellaneousThemeGenerator.makeDiscoverable(shade2, xp, profile);
                if (manyShades && !forceFew) {
                    CustomCampaignEntityAPI shade1 = system.addCustomEntity(null, "Stellar Shade Omega", "stellar_shade", faction);
                    CustomCampaignEntityAPI shade3 = system.addCustomEntity(null, "Stellar Shade Chi", "stellar_shade", faction);
                    shade1.setCircularOrbitPointingDown(planet, angle + 180.0f - 26.0f, radius - 10.0f, period);
                    shade3.setCircularOrbitPointingDown(planet, angle + 180.0f + 26.0f, radius - 10.0f, period);
                    MiscellaneousThemeGenerator.makeDiscoverable(shade1, xp, profile);
                    MiscellaneousThemeGenerator.makeDiscoverable(shade3, xp, profile);
                }
            }
            ++i;
        }
        if (DEBUG) {
            System.out.println("Done adding solar shades and mirrors");
        }
    }

    public static void makeDiscoverable(SectorEntityToken entity, float xp, float sensorProfile) {
        entity.setDiscoverable(true);
        entity.setDiscoveryXP(Float.valueOf(xp));
        entity.setSensorProfile(Float.valueOf(sensorProfile));
    }

    public void populateNonMain(BaseThemeGenerator.StarSystemData data) {
        boolean special;
        if (DEBUG) {
            System.out.println(" Generating misc derelicts in system " + data.system.getName());
        }
        boolean bl = special = data.isBlackHole() || data.isNebula() || data.isPulsar();
        if (special) {
            this.addResearchStations(data, 0.25f, 1, 1, this.createStringPicker("station_research_remnant", Float.valueOf(10.0f)));
        }
        if (this.random.nextFloat() < 0.5f) {
            return;
        }
        WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(this.random, data.system.getCenter(), 15.0f, 10.0f, 10.0f);
        this.addShipGraveyard(data, 0.05f, 1, 1, factions);
        this.addDebrisFields(data, 0.25f, 1, 2);
        this.addDerelictShips(data, 0.5f, 0, 3, factions);
        this.addCaches(data, 0.25f, 0, 2, this.createStringPicker("weapons_cache", Float.valueOf(4.0f), "weapons_cache_small", Float.valueOf(10.0f), "weapons_cache_high", Float.valueOf(4.0f), "weapons_cache_small_high", Float.valueOf(10.0f), "weapons_cache_low", Float.valueOf(4.0f), "weapons_cache_small_low", Float.valueOf(10.0f), "supply_cache", Float.valueOf(4.0f), "supply_cache_small", Float.valueOf(10.0f), "equipment_cache", Float.valueOf(4.0f), "equipment_cache_small", Float.valueOf(10.0f)));
    }

    protected void addExtraGates(ThemeGenContext context) {
        ArrayList<StarSystemAPI> systems = new ArrayList<StarSystemAPI>(Global.getSector().getStarSystems());
        ArrayList<SectorEntityToken> gates = new ArrayList<SectorEntityToken>();
        for (StarSystemAPI system : new ArrayList<StarSystemAPI>(systems)) {
            boolean galatia = system.getBaseName().toLowerCase().equals("galatia");
            if (system.getTags().isEmpty() || galatia) {
                systems.remove(system);
                continue;
            }
            gates.addAll(system.getEntitiesWithTag("gate"));
        }
        int addGates = MIN_GATES + this.random.nextInt(MAX_GATES - MIN_GATES + 1) - gates.size();
        if (addGates < MIN_GATES_TO_ADD) {
            addGates = MIN_GATES_TO_ADD;
        }
        if (addGates <= 0) {
            if (DEBUG) {
                System.out.println("  Already have " + gates.size() + " gates, not adding any");
            }
            return;
        }
        ArrayList<BaseThemeGenerator.StarSystemData> all = new ArrayList<BaseThemeGenerator.StarSystemData>();
        if (DEBUG) {
            System.out.println("");
        }
        if (DEBUG) {
            System.out.println("");
        }
        if (DEBUG) {
            System.out.println("");
        }
        if (DEBUG) {
            System.out.println("  Adding " + addGates + " extra gates, for a total of " + (addGates + gates.size()));
        }
        int i = 0;
        while (i < addGates) {
            float maxDist = 0.0f;
            StarSystemAPI farthest = null;
            for (StarSystemAPI system : systems) {
                if (system.getPlanets().size() < 3) continue;
                float minDist = Float.MAX_VALUE;
                for (SectorEntityToken gate : gates) {
                    float dist = Misc.getDistanceLY(gate, system.getCenter());
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                }
                if (!(minDist > maxDist)) continue;
                maxDist = minDist;
                farthest = system;
            }
            if (farthest != null) {
                BaseThemeGenerator.StarSystemData data = new BaseThemeGenerator.StarSystemData();
                data.system = farthest;
                WeightedRandomPicker<String> factions = SalvageSpecialAssigner.getNearbyFactions(this.random, farthest.getCenter(), 15.0f, 5.0f, 5.0f);
                BaseThemeGenerator.AddedEntity gate = this.addInactiveGate(data, 1.0f, 0.5f, 0.5f, factions);
                if (gate != null && gate.entity != null) {
                    gates.add(gate.entity);
                }
            }
            ++i;
        }
        if (DEBUG) {
            System.out.println("  Done adding extra gates");
        }
        if (DEBUG) {
            System.out.println("");
        }
        if (DEBUG) {
            System.out.println("");
        }
        if (DEBUG) {
            System.out.println("");
        }
        SalvageSpecialAssigner.SpecialCreationContext specialContext = new SalvageSpecialAssigner.SpecialCreationContext();
        specialContext.themeId = this.getThemeId();
        SalvageSpecialAssigner.assignSpecials(all, specialContext);
    }

    protected void addCoronalTaps(ThemeGenContext context) {
        if (DEBUG) {
            System.out.println("Adding coronal taps...");
        }
        ArrayList<Constellation> list = new ArrayList<Constellation>(context.constellations);
        WeightedRandomPicker<StarSystemAPI> tapSystems = new WeightedRandomPicker<StarSystemAPI>(StarSystemGenerator.random);
        WeightedRandomPicker backup = new WeightedRandomPicker(StarSystemGenerator.random);
        for (Constellation c : list) {
            for (StarSystemAPI system : c.getSystems()) {
                if (system.hasTag("theme_special")) continue;
                float w = 0.0f;
                if (system.hasTag("theme_remnant")) {
                    w = 10.0f;
                } else if (system.hasTag("theme_derelict")) {
                    w = 10.0f;
                } else if (system.hasTag("theme_ruins")) {
                    w = 10.0f;
                } else if (system.hasTag("theme_misc")) {
                    w = 5.0f;
                }
                if (w <= 0.0f) continue;
                if (system.getType() == StarSystemGenerator.StarSystemType.TRINARY_2CLOSE) {
                    w *= 5.0f;
                }
                boolean hasBlueStar = false;
                boolean hasNormalStar = false;
                for (PlanetAPI planet : system.getPlanets()) {
                    if (!planet.isNormalStar()) continue;
                    if (planet.getTypeId().equals("star_blue_giant") || planet.getTypeId().equals("star_blue_supergiant")) {
                        hasBlueStar = true;
                    }
                    hasNormalStar = true;
                }
                if (!hasNormalStar) continue;
                WeightedRandomPicker<StarSystemAPI> use = tapSystems;
                if (!hasBlueStar) {
                    use = backup;
                }
                use.add(system, w);
            }
        }
        if (tapSystems.isEmpty()) {
            tapSystems.addAll(backup);
        }
        int numTaps = 2 + this.random.nextInt(2);
        numTaps = 2;
        int added = 0;
        while (added < numTaps && !tapSystems.isEmpty()) {
            StarSystemAPI pick = (StarSystemAPI)tapSystems.pickAndRemove();
            BaseThemeGenerator.AddedEntity tap = this.addCoronalTap(pick);
            if (tap == null) continue;
            ++added;
        }
        if (DEBUG) {
            System.out.println("Done adding coronal taps\n\n\n");
        }
    }

    protected BaseThemeGenerator.AddedEntity addCoronalTap(StarSystemAPI system) {
        if (DEBUG) {
            System.out.println("Adding coronal tap to [" + system.getNameWithLowercaseType() + ", " + system.getLocation());
        }
        String factionId = "neutral";
        BaseThemeGenerator.AddedEntity entity = null;
        if (system.getType() == StarSystemGenerator.StarSystemType.TRINARY_2CLOSE) {
            BaseThemeGenerator.EntityLocation loc = new BaseThemeGenerator.EntityLocation();
            loc.location = new Vector2f();
            entity = MiscellaneousThemeGenerator.addEntity(this.random, (LocationAPI)system, loc, "coronal_tap", factionId);
            if (entity != null) {
                system.addScript(new MakeCoronalTapFaceNearestStar(entity.entity));
            }
        } else {
            PlanetAPI star;
            WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>();
            WeightedRandomPicker<PlanetAPI> fallback = new WeightedRandomPicker<PlanetAPI>();
            for (PlanetAPI planet : system.getPlanets()) {
                if (!planet.isNormalStar()) continue;
                if (planet.getTypeId().equals("star_blue_giant") || planet.getTypeId().equals("star_blue_supergiant")) {
                    picker.add(planet);
                    continue;
                }
                fallback.add(planet);
            }
            if (picker.isEmpty()) {
                picker.addAll(fallback);
            }
            if ((star = (PlanetAPI)picker.pick()) != null) {
                CustomEntitySpecAPI spec = Global.getSettings().getCustomEntitySpec("coronal_tap");
                BaseThemeGenerator.EntityLocation loc = new BaseThemeGenerator.EntityLocation();
                float orbitRadius = star.getRadius() + spec.getDefaultRadius() + 100.0f;
                float orbitDays = orbitRadius / 20.0f;
                loc.orbit = Global.getFactory().createCircularOrbitPointingDown(star, this.random.nextFloat() * 360.0f, orbitRadius, orbitDays);
                entity = MiscellaneousThemeGenerator.addEntity(this.random, (LocationAPI)system, loc, "coronal_tap", factionId);
            }
        }
        if (entity != null) {
            system.addScript(new CoronalTapParticleScript(entity.entity));
            system.addTag("has_coronal_tap");
        }
        if (DEBUG) {
            if (entity != null) {
                System.out.println(String.format("  Added coronal tap to %s", system.getNameWithLowercaseType()));
            } else {
                System.out.println(String.format("  Failed to add coronal tap to %s", system.getNameWithLowercaseType()));
            }
        }
        return entity;
    }

    protected void addPKSystem(ThemeGenContext context) {
        if (DEBUG) {
            System.out.println("Looking for system to hide PK in");
        }
        ArrayList<StarSystemAPI> preferred = new ArrayList<StarSystemAPI>();
        ArrayList<StarSystemAPI> other = new ArrayList<StarSystemAPI>();
        for (Constellation c : context.constellations) {
            for (StarSystemAPI system : c.getSystems()) {
                boolean misc;
                if (system.hasTag("theme_special") || system.isNebula() || system.hasPulsar() || system.hasBlackHole()) continue;
                boolean bl = misc = system.hasTag("theme_misc_skip") || system.hasTag("theme_misc");
                if (system.hasTag("theme_derelict")) {
                    misc = false;
                }
                boolean nonLargeDerelict = system.hasTag("theme_derelict") && !system.hasTag("theme_derelict_mothership") && !system.hasTag("theme_derelict_cryosleeper") && !system.hasTag("theme_derelict_survey_ship");
                boolean secondaryRuins = system.hasTag("theme_ruins_secondary");
                boolean remnantNoFleets = system.hasTag("theme_remnant_no_fleets");
                boolean unsafe = system.hasTag("theme_unsafe");
                if (unsafe || !misc && !nonLargeDerelict && !secondaryRuins && !remnantNoFleets) continue;
                int count = 0;
                for (PlanetAPI curr : system.getPlanets()) {
                    if (curr.isStar() || curr.isMoon() || curr.isGasGiant() || !curr.getMarket().isPlanetConditionMarketOnly() || curr.getCircularOrbitRadius() < 6000.0f || curr.hasTag("not_random_mission_target")) continue;
                    ++count;
                }
                if (count > 0) {
                    preferred.add(system);
                    continue;
                }
                other.add(system);
            }
        }
        Comparator<StarSystemAPI> comp = new Comparator<StarSystemAPI>(){

            @Override
            public int compare(StarSystemAPI o1, StarSystemAPI o2) {
                return (int)Math.signum(o2.getLocation().length() - o1.getLocation().length());
            }
        };
        ArrayList<StarSystemAPI> sorted = new ArrayList<StarSystemAPI>();
        if (!preferred.isEmpty()) {
            sorted.addAll(preferred);
        } else {
            sorted.addAll(other);
        }
        if (sorted.isEmpty()) {
            if (DEBUG) {
                System.out.println("FAILED TO FIND SUITABLE SYSTEM FOR PK");
            }
            return;
        }
        Collections.sort(sorted, comp);
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(this.random);
        int i = 0;
        while (i < 20 && i < sorted.size()) {
            picker.add((StarSystemAPI)sorted.get(i), 1.0f);
            ++i;
        }
        StarSystemAPI system = (StarSystemAPI)picker.pick();
        if (DEBUG) {
            System.out.println("Adding PK to [" + system.getName() + "] at [" + system.getLocation() + "]");
        }
        this.setUpPKSystem(system);
        if (DEBUG) {
            System.out.println("Finished adding PK system\n\n\n\n\n");
        }
    }

    protected void setUpPKSystem(StarSystemAPI system) {
        float radius;
        system.addTag("theme_special");
        system.addTag("pk_system");
        Global.getSector().getPersistentData().put(PK_SYSTEM_KEY, system);
        Global.getSector().getMemoryWithoutUpdate().set(PK_SYSTEM_KEY, system.getId());
        SectorEntityToken tundra = null;
        for (PlanetAPI curr : system.getPlanets()) {
            if (curr.isStar() || curr.isGasGiant() || curr.getMarket() == null || !curr.getMarket().isPlanetConditionMarketOnly() || curr.getCircularOrbitRadius() < 6000.0f) continue;
            tundra = curr;
            break;
        }
        if (tundra == null) {
            List<BaseThemeGenerator.OrbitGap> gaps = BaseThemeGenerator.findGaps(system.getCenter(), 6000.0f, 20000.0f, 800.0f);
            float f = 7000.0f;
            if (!gaps.isEmpty()) {
                f = (gaps.get((int)0).start + gaps.get((int)0).end) * 0.5f;
            }
            float orbitDays = f / (20.0f + this.random.nextFloat() * 5.0f);
            radius = 100.0f + this.random.nextFloat() * 50.0f;
            float angle = this.random.nextFloat() * 360.0f;
            String type = "barren";
            ProcgenUsedNames.NamePick namePick = ProcgenUsedNames.pickName("planet", null, null);
            String name = namePick.nameWithRomanSuffixIfAny;
            tundra = system.addPlanet(Misc.genUID(), system.getStar(), name, type, angle, radius, f, orbitDays);
            if (tundra == null) {
                if (DEBUG) {
                    System.out.println("FAILED TO CREATE PLANET IN PK SYSTEM");
                }
                return;
            }
        }
        tundra.setName("Sentinel");
        tundra.getMarket().setName("Sentinel");
        tundra.addTag("not_random_mission_target");
        tundra.getMemoryWithoutUpdate().set(PK_PLANET_KEY, true);
        Global.getSector().getPersistentData().put(PK_PLANET_KEY, tundra);
        if (DEBUG) {
            System.out.println("Setting planet [" + tundra.getName() + "] to tundra");
        }
        tundra.changeType("tundra", this.random);
        tundra.getMarket().getConditions().clear();
        PlanetConditionGenerator.generateConditionsForPlanet(null, (PlanetAPI)tundra, system.getAge());
        tundra.getMarket().removeCondition("decivilized");
        tundra.getMarket().removeCondition("decivilized_subpop");
        tundra.getMarket().removeCondition("ruins_extensive");
        tundra.getMarket().removeCondition("ruins_scattered");
        tundra.getMarket().removeCondition("ruins_vast");
        tundra.getMarket().removeCondition("ruins_widespread");
        tundra.getMarket().removeCondition("inimical_biosphere");
        tundra.getMarket().removeCondition("farmland_poor");
        tundra.getMarket().removeCondition("farmland_adequate");
        tundra.getMarket().removeCondition("farmland_rich");
        tundra.getMarket().removeCondition("farmland_bountiful");
        tundra.getMarket().addCondition("farmland_poor");
        float pickHazard = tundra.getMarket().getHazardValue();
        for (PlanetAPI planetAPI : system.getPlanets()) {
            if (planetAPI.isStar() || planetAPI.isGasGiant() || planetAPI.getMarket() == null || !planetAPI.getMarket().isPlanetConditionMarketOnly() || planetAPI == tundra) continue;
            float h = planetAPI.getMarket().getHazardValue();
            if (!planetAPI.hasCondition("habitable") || !(h <= pickHazard)) continue;
            planetAPI.changeType("barren_venuslike", this.random);
            planetAPI.getMarket().getConditions().clear();
            PlanetConditionGenerator.generateConditionsForPlanet(null, planetAPI, system.getAge());
        }
        for (SectorEntityToken sectorEntityToken : system.getEntitiesWithTag("stable_location")) {
            system.removeEntity(sectorEntityToken);
        }
        for (SectorEntityToken sectorEntityToken : system.getEntitiesWithTag("objective")) {
            system.removeEntity(sectorEntityToken);
        }
        List<BaseThemeGenerator.OrbitGap> list = BaseThemeGenerator.findGaps(system.getCenter(), 2000.0f, 20000.0f, 800.0f);
        float orbitRadius = 7000.0f;
        if (!list.isEmpty()) {
            orbitRadius = (list.get((int)0).start + list.get((int)0).end) * 0.5f;
        }
        radius = 500.0f + 200.0f * this.random.nextFloat();
        float area = radius * radius * 3.14f;
        int count = (int)(area / 80000.0f);
        if ((count *= 2) < 10) {
            count = 10;
        }
        if (count > 100) {
            count = 100;
        }
        float angle = this.random.nextFloat() * 360.0f;
        float orbitDays = orbitRadius / (20.0f + this.random.nextFloat() * 5.0f);
        SectorEntityToken field = system.addTerrain("asteroid_field", new AsteroidFieldTerrainPlugin.AsteroidFieldParams(radius, radius + 100.0f, count, count, 4.0f, 16.0f, null));
        field.setCircularOrbit(system.getCenter(), angle, orbitRadius, orbitDays);
        SectorEntityToken cache = BaseThemeGenerator.addSalvageEntity(system, "hidden_cache", "neutral");
        cache.getMemoryWithoutUpdate().set(PK_CACHE_KEY, true);
        cache.addTag("not_random_mission_target");
        cache.setCircularOrbit(field, 0.0f, 0.0f, 100.0f);
        Misc.setDefenderOverride(cache, new DefenderDataOverride("hegemony", 1.0f, 20.0f, 20.0f, 1));
        BaseThemeGenerator.StarSystemData data = new BaseThemeGenerator.StarSystemData();
        WeightedRandomPicker<String> derelictShipFactions = new WeightedRandomPicker<String>(this.random);
        derelictShipFactions.add("luddic_path");
        WeightedRandomPicker<String> hulls = new WeightedRandomPicker<String>(this.random);
        hulls.add("prometheus2", 1.0f);
        hulls.add("colossus2", 1.0f);
        hulls.add("colossus2", 1.0f);
        hulls.add("colossus2", 1.0f);
        hulls.add("eradicator", 1.0f);
        hulls.add("enforcer", 1.0f);
        hulls.add("sunder", 1.0f);
        hulls.add("venture_pather", 1.0f);
        hulls.add("manticore_luddic_path", 1.0f);
        hulls.add("cerberus_luddic_path", 1.0f);
        hulls.add("hound_luddic_path", 1.0f);
        hulls.add("buffalo2", 1.0f);
        this.addShipGraveyard(data, field, derelictShipFactions, hulls);
        for (BaseThemeGenerator.AddedEntity ae : data.generated) {
            SalvageSpecialAssigner.assignSpecials(ae.entity, true);
        }
        float max = 0.0f;
        JumpPointAPI fringePoint = null;
        List points = system.getEntities(JumpPointAPI.class);
        for (JumpPointAPI curr : points) {
            float dist = curr.getCircularOrbitRadius();
            if (!(dist > max)) continue;
            max = dist;
            fringePoint = curr;
        }
        if (fringePoint != null) {
            data = new BaseThemeGenerator.StarSystemData();
            WeightedRandomPicker<String> remnantShipFactions = new WeightedRandomPicker<String>(this.random);
            remnantShipFactions.add("remnant");
            hulls = new WeightedRandomPicker(this.random);
            hulls.add("radiant", 0.25f);
            hulls.add("nova", 0.5f);
            hulls.add("brilliant", 1.0f);
            hulls.add("apex", 1.0f);
            hulls.add("scintilla", 1.0f);
            hulls.add("scintilla", 1.0f);
            hulls.add("fulgent", 1.0f);
            hulls.add("fulgent", 1.0f);
            hulls.add("glimmer", 1.0f);
            hulls.add("glimmer", 1.0f);
            hulls.add("lumen", 1.0f);
            hulls.add("lumen", 1.0f);
            this.addShipGraveyard(data, fringePoint, remnantShipFactions, hulls);
            this.addDebrisField(data, fringePoint, 400.0f);
            for (BaseThemeGenerator.AddedEntity ae : data.generated) {
                SalvageSpecialAssigner.assignSpecials(ae.entity, true);
                if (!(ae.entity.getCustomPlugin() instanceof DerelictShipEntityPlugin)) continue;
                DerelictShipEntityPlugin plugin = (DerelictShipEntityPlugin)ae.entity.getCustomPlugin();
                plugin.getData().ship.condition = ShipRecoverySpecial.ShipCondition.WRECKED;
            }
        }
        CustomCampaignEntityAPI dockyard = system.addCustomEntity("pk_dockyard", "Sentinel Gantries", "orbital_dockyard", "neutral");
        dockyard.setCircularOrbitPointingDown(tundra, 45.0f, 300.0f, 30.0f);
        dockyard.setCustomDescriptionId("pk_orbital_dockyard");
        dockyard.getMemoryWithoutUpdate().set("$pkDockyard", true);
        Misc.setAbandonedStationMarket("pk_dockyard", dockyard);
        CargoAPI cargo = dockyard.getMarket().getSubmarket("storage").getCargo();
        cargo.initMothballedShips("hegemony");
        CampaignFleetAPI temp = Global.getFactory().createEmptyFleet("hegemony", null, true);
        temp.getFleetData().addFleetMember("enforcer_XIV_Elite");
        temp.getFleetData().addFleetMember("enforcer_XIV_Elite");
        temp.getFleetData().addFleetMember("eagle_xiv_Elite");
        temp.getFleetData().addFleetMember("dominator_XIV_Elite");
        DefaultFleetInflaterParams p = new DefaultFleetInflaterParams();
        p.quality = -1.0f;
        temp.setInflater(new DefaultFleetInflater(p));
        temp.inflateIfNeeded();
        temp.setInflater(null);
        int index = 0;
        for (FleetMemberAPI member : temp.getFleetData().getMembersListCopy()) {
            for (String slotId : member.getVariant().getFittedWeaponSlots()) {
                String weaponId = member.getVariant().getWeaponId(slotId);
                if (this.random.nextFloat() < 0.5f) {
                    member.getVariant().clearSlot(slotId);
                }
                if (!(this.random.nextFloat() < 0.25f)) continue;
                cargo.addWeapons(weaponId, 1);
            }
            if (index == 0 || index == 2) {
                cargo.getMothballedShips().addFleetMember(member);
            }
            ++index;
        }
        cargo.addCommodity("metals", 50.0f + (float)this.random.nextInt(51));
        List<CampaignFleetAPI> stations = MiscellaneousThemeGenerator.getRemnantStations(true, false);
        float minDist = Float.MAX_VALUE;
        SectorEntityToken nexus = null;
        for (CampaignFleetAPI curr : stations) {
            float dist = Misc.getDistanceLY(tundra, curr);
            if (!(dist < minDist)) continue;
            minDist = dist;
            nexus = curr;
        }
        if (nexus != null) {
            if (DEBUG) {
                System.out.println("Found Remnant nexus in [" + nexus.getContainingLocation().getName() + "]");
            }
            nexus.getMemoryWithoutUpdate().set(PK_NEXUS_KEY, true);
            Global.getSector().getPersistentData().put(PK_NEXUS_KEY, nexus);
            Global.getSector().getMemoryWithoutUpdate().set(PK_NEXUS_KEY, nexus.getContainingLocation().getId());
            Misc.addDefeatTrigger((CampaignFleetAPI)nexus, "PKNexusDefeated");
        }
    }

    protected void addLOCRLuddicPlanet(ThemeGenContext context) {
        if (DEBUG) {
            System.out.println("Looking for LOCR_LUDDIC planet");
        }
        WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>(this.random);
        WeightedRandomPicker<PlanetAPI> picker_fallback = new WeightedRandomPicker<PlanetAPI>(this.random);
        for (Constellation c : context.constellations) {
            for (StarSystemAPI system : c.getSystems()) {
                if (system.hasTag("theme_special") || system.isNebula() || system.hasPulsar() || system.hasBlackHole() || !system.hasTag("theme_misc_skip") && !system.hasTag("theme_misc") || system.hasTag("theme_derelict")) continue;
                for (PlanetAPI curr : system.getPlanets()) {
                    if (curr.isStar() || !curr.getMarket().isPlanetConditionMarketOnly() || curr.hasTag("not_random_mission_target") || curr.getMarket().hasCondition("water_surface") || curr.isGasGiant() || curr.getMarket().hasCondition("decivilized_subpop")) continue;
                    if (curr.getMarket().hasCondition("farmland_rich") || curr.getMarket().hasCondition("farmland_bountiful")) {
                        picker.add(curr);
                        continue;
                    }
                    if (!curr.getMarket().hasCondition("farmland_adequate")) continue;
                    picker_fallback.add(curr);
                }
            }
        }
        PlanetAPI planet = (PlanetAPI)picker.pick();
        if (planet == null) {
            planet = (PlanetAPI)picker_fallback.pick();
        }
        if (planet != null) {
            DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(new ShipRecoverySpecial.PerShipData("nebula_Standard", ShipRecoverySpecial.ShipCondition.BATTERED, 0.0f), false);
            params.ship.shipName = "CGR Light of Exultation";
            params.ship.nameAlwaysKnown = true;
            SectorEntityToken ship = BaseThemeGenerator.addSalvageEntity(planet.getStarSystem(), "wreck", "neutral", params);
            ship.setDiscoverable(true);
            float orbitDays = 200.0f / (10.0f + (float)Math.random() * 5.0f);
            ship.setCircularOrbit(planet, (float)Math.random() * 360.0f, planet.getRadius() + 100.0f, orbitDays);
            SalvageSpecialAssigner.ShipRecoverySpecialCreator creator = new SalvageSpecialAssigner.ShipRecoverySpecialCreator(null, 0, 0, false, null, null);
            Misc.setSalvageSpecial(ship, creator.createSpecial(ship, null));
            Global.getSector().getMemoryWithoutUpdate().set(LOCR_LUDDIC_TRANSPORT_KEY, ship);
            if (DEBUG) {
                System.out.println("Adding LOCR_LUDDIC flag to [" + planet.getName() + "] in [" + planet.getContainingLocation().getNameWithLowercaseType() + "]");
            }
            Global.getSector().getMemoryWithoutUpdate().set(LOCR_LUDDIC_PLANET_KEY, planet);
            planet.getMemoryWithoutUpdate().set(LOCR_LUDDIC, true);
            planet.getMemoryWithoutUpdate().set(LOCR_BLOCK_FIRST_SURVEY, true);
            long seed = StarSystemGenerator.random.nextLong();
            planet.addTag("not_random_mission_target");
        } else if (DEBUG) {
            System.out.println("Failed to find a LOCR_LUDDIC planet, may Ludd forgive you.");
        }
        if (DEBUG) {
            System.out.println("Finished adding LOCR_LUDDIC  planet\n\n\n");
        }
    }

    protected void addLOCRMinersPlanet(ThemeGenContext context) {
        if (DEBUG) {
            System.out.println("Looking for LOCR_MINERS planet");
        }
        WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>(this.random);
        for (Constellation c : context.constellations) {
            for (StarSystemAPI system : c.getSystems()) {
                if (system.hasTag("theme_special") || system.hasPulsar() || !system.hasTag("theme_misc_skip") && !system.hasTag("theme_misc") || system.hasTag("theme_derelict")) continue;
                for (PlanetAPI curr : system.getPlanets()) {
                    if (curr.isStar() || !curr.getMarket().isPlanetConditionMarketOnly() || curr.hasTag("not_random_mission_target") || curr.getMarket().hasCondition("habitable") || curr.getMarket().hasCondition("extreme_tectonic_activity") || curr.getMarket().hasCondition("decivilized_subpop") || curr.getMarket().hasCondition("water_surface") || curr.isGasGiant() || !curr.getMarket().hasCondition("volatiles_plentiful") && !curr.getMarket().hasCondition("organics_plentiful") && !curr.getMarket().hasCondition("rare_ore_ultrarich")) continue;
                    picker.add(curr);
                }
            }
        }
        PlanetAPI planet = (PlanetAPI)picker.pick();
        if (planet != null) {
            if (DEBUG) {
                System.out.println("Adding LOCR_MINERS flag to [" + planet.getName() + "] in [" + planet.getContainingLocation().getNameWithLowercaseType() + "]");
            }
            Global.getSector().getMemoryWithoutUpdate().set(LOCR_MINERS_PLANET_KEY, planet);
            planet.getMemoryWithoutUpdate().set(LOCR_MINERS, true);
            planet.getMemoryWithoutUpdate().set(LOCR_BLOCK_FIRST_SURVEY, true);
            long seed = StarSystemGenerator.random.nextLong();
            planet.addTag("not_random_mission_target");
        } else if (DEBUG) {
            System.out.println("Failed to find a planet for LOCR_MINERS.");
        }
        if (DEBUG) {
            System.out.println("Finished adding LOCR_MINERS planet\n\n\n\n\n");
        }
    }

    protected void addLOCRPiratePlanet(ThemeGenContext context) {
        if (DEBUG) {
            System.out.println("Looking for LOCR_PIRATE planet");
        }
        WeightedRandomPicker<PlanetAPI> picker = new WeightedRandomPicker<PlanetAPI>(this.random);
        for (Constellation c : context.constellations) {
            for (StarSystemAPI system : c.getSystems()) {
                if (system.hasTag("theme_special") || system.hasPulsar() || !system.hasTag("theme_misc_skip") && !system.hasTag("theme_misc") || system.hasTag("theme_derelict")) continue;
                for (PlanetAPI curr : system.getPlanets()) {
                    if (curr.isStar() || !curr.getMarket().isPlanetConditionMarketOnly() || curr.hasTag("not_random_mission_target") || curr.getMarket().hasCondition("decivilized_subpop") || curr.getMarket().hasCondition("habitable") || curr.isGasGiant()) continue;
                    picker.add(curr);
                }
            }
        }
        PlanetAPI planet = (PlanetAPI)picker.pick();
        if (planet != null) {
            if (DEBUG) {
                System.out.println("Adding LOCR_PIRATE flag to [" + planet.getName() + "] in [" + planet.getContainingLocation().getNameWithLowercaseType() + "]");
            }
            Global.getSector().getMemoryWithoutUpdate().set(LOCR_PIRATE_PLANET_KEY, planet);
            planet.getMemoryWithoutUpdate().set(LOCR_PIRATE, true);
            planet.getMemoryWithoutUpdate().set(LOCR_BLOCK_FIRST_SURVEY, true);
            long seed = StarSystemGenerator.random.nextLong();
            planet.addTag("not_random_mission_target");
        } else if (DEBUG) {
            System.out.println("Failed to find a planet for LOCR_PIRATE; the dream is dead :( ");
        }
        if (DEBUG) {
            System.out.println("Finished adding LOCR_PIRATE planet\n\n\n");
        }
    }

    public static List<CampaignFleetAPI> getRemnantStations(boolean includeDamaged, boolean onlyDamaged) {
        ArrayList<CampaignFleetAPI> stations = new ArrayList<CampaignFleetAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            if (!system.hasTag("theme_remnant_main") || system.hasTag("theme_remnant_destroyed")) continue;
            for (CampaignFleetAPI fleet : system.getFleets()) {
                boolean damaged;
                if (!fleet.isStationMode() || !"remnant".equals(fleet.getFaction().getId()) || (damaged = fleet.getMemoryWithoutUpdate().getBoolean("$damagedStation")) && !includeDamaged || !damaged && onlyDamaged) continue;
                stations.add(fleet);
            }
        }
        return stations;
    }

    public static class MakeCoronalTapFaceNearestStar
    implements EveryFrameScript {
        protected SectorEntityToken tap;

        public MakeCoronalTapFaceNearestStar(SectorEntityToken tap) {
            this.tap = tap;
        }

        @Override
        public void advance(float amount) {
            if (!this.tap.isInCurrentLocation()) {
                return;
            }
            float minDist = Float.MAX_VALUE;
            SectorEntityToken closest = null;
            for (PlanetAPI star : this.tap.getContainingLocation().getPlanets()) {
                float dist;
                if (!star.isStar() || !((dist = Misc.getDistance(this.tap.getLocation(), star.getLocation())) < minDist)) continue;
                minDist = dist;
                closest = star;
            }
            if (closest != null) {
                this.tap.setFacing(Misc.getAngleInDegrees(this.tap.getLocation(), closest.getLocation()) + 180.0f);
            }
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean runWhilePaused() {
            return false;
        }
    }
}

