/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.rulecmd.AddRemoveCommodity;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ApplyCRDamage
extends BaseCommandPlugin {
    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        long seed;
        if (dialog == null) {
            return false;
        }
        if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
            return false;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        TextPanelAPI text = dialog.getTextPanel();
        float baseFP = params.get(0).getFloat(memoryMap);
        float fpMult = params.get(1).getFloat(memoryMap);
        float crMult = params.get(2).getFloat(memoryMap);
        String desc = params.get(3).getString(memoryMap);
        if (dialog.getInteractionTarget() != null) {
            seed = Misc.getSalvageSeed(dialog.getInteractionTarget());
            seed += (long)(ruleId == null ? 0 : ruleId.hashCode());
            seed /= 321L;
            seed = (long)((float)seed * ((float)(Global.getSector().getClock().getMonth() + 10) + baseFP * fpMult * crMult * 10.0f));
        } else {
            seed = Misc.genRandomSeed();
        }
        Random random = Misc.getRandom(seed, 7);
        ApplyCRDamage.applyCRDamage(playerFleet, baseFP * fpMult, crMult, desc, text, random);
        return true;
    }

    public static void applyCRDamage(CampaignFleetAPI fleet, float damageFP, float crMult, String desc, TextPanelAPI text, Random random) {
        ArrayList<FleetMemberAPI> shipsToDamage = new ArrayList<FleetMemberAPI>();
        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<FleetMemberAPI>(random);
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (member.isMothballed() && member.getRepairTracker().getBaseCR() < 0.2f) continue;
            picker.add(member, member.getFleetPointCost());
        }
        float totalDamage = damageFP;
        float picked = 0.0f;
        while (picked < totalDamage && !picker.isEmpty()) {
            FleetMemberAPI pick = (FleetMemberAPI)picker.pickAndRemove();
            shipsToDamage.add(pick);
            picked += (float)pick.getFleetPointCost();
        }
        for (FleetMemberAPI member : shipsToDamage) {
            float crLost = Math.min(member.getRepairTracker().getBaseCR(), member.getDeployCost() * 0.5f);
            crLost += 0.01f * (float)random.nextInt(10);
            if (!((crLost *= crMult) > 0.0f)) continue;
            member.getRepairTracker().applyCREvent(-crLost, desc);
            if (text == null) continue;
            AddRemoveCommodity.addCRLossText(member, text, crLost);
        }
    }
}

