/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.AuroraRenderer;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.FlareManager;
import com.fs.starfarer.api.impl.campaign.terrain.RangeBlockerUtil;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class MagneticFieldTerrainPlugin
extends BaseRingTerrain
implements AuroraRenderer.AuroraRendererDelegate,
FlareManager.FlareManagerDelegate {
    public static final float SENSOR_MULT_AURORA = 0.1f;
    public static final float DETECTED_MULT_AURORA = 0.0f;
    public static final float DETECTED_MULT = 0.25f;
    protected transient SpriteAPI texture = null;
    protected transient Color color;
    protected AuroraRenderer renderer;
    protected MagneticFieldParams params;
    protected FlareManager flareManager;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);

    public MagneticFieldParams getParams() {
        return this.params;
    }

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (MagneticFieldParams)param;
        this.name = this.params.name;
        if (this.name == null) {
            this.name = "Magnetic Field";
        }
    }

    @Override
    public String getNameForTooltip() {
        return "Magnetic Field";
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.texture = Global.getSettings().getSprite("terrain", "aurora");
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);
        if (this.renderer == null) {
            this.renderer = new AuroraRenderer(this);
        }
        if (this.flareManager == null) {
            this.flareManager = new FlareManager(this);
        }
        return this;
    }

    @Override
    Object writeReplace() {
        return this;
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        this.renderer.advance(amount);
        this.flareManager.advance(amount);
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        this.renderer.render(viewport.getAlphaMult());
    }

    @Override
    public float getRenderRange() {
        FlareManager.Flare curr = this.flareManager.getActiveFlare();
        if (curr != null) {
            float outerRadiusWithFlare = this.computeRadiusWithFlare(this.flareManager.getActiveFlare());
            return outerRadiusWithFlare + 200.0f;
        }
        return super.getRenderRange();
    }

    @Override
    protected boolean shouldPlayLoopOne() {
        return super.shouldPlayLoopOne() && !this.flareManager.isInActiveFlareArc(Global.getSector().getPlayerFleet());
    }

    @Override
    protected boolean shouldPlayLoopTwo() {
        return super.shouldPlayLoopTwo() && this.flareManager.isInActiveFlareArc(Global.getSector().getPlayerFleet());
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            if (this.flareManager.isInActiveFlareArc(fleet)) {
                fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_2", "Inside magnetic storm", 0.1f, fleet.getStats().getSensorRangeMod());
                fleet.getStats().removeTemporaryMod(String.valueOf(this.getModId()) + "_6");
                fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_5", "Inside magnetic storm", 0.0f, fleet.getStats().getDetectedRangeMod());
            } else {
                fleet.getStats().removeTemporaryMod(String.valueOf(this.getModId()) + "_5");
                fleet.getStats().addTemporaryModMult(0.1f, String.valueOf(this.getModId()) + "_6", "Inside strong magnetic field", 0.25f, fleet.getStats().getDetectedRangeMod());
            }
        }
    }

    protected float getAdjustedMult(CampaignFleetAPI fleet, float baseMult) {
        float skillMod = fleet.getCommanderStats().getDynamic().getValue("nav_penalty_mult");
        float penalty = 1.0f - baseMult;
        return 1.0f - (penalty *= skillMod);
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        if (this.flareManager.isInActiveFlareArc(point)) {
            float outerRadiusWithFlare = this.computeRadiusWithFlare(this.flareManager.getActiveFlare());
            float dist = Misc.getDistance(this.entity.getLocation(), point);
            if (dist > outerRadiusWithFlare + radius) {
                return false;
            }
            return !(dist + radius < this.params.middleRadius - this.params.bandWidthInEngine / 2.0f);
        }
        return super.containsPoint(point, radius);
    }

    private float computeRadiusWithFlare(FlareManager.Flare flare) {
        float inner = this.getAuroraInnerRadius();
        float outer = this.params.middleRadius + this.params.bandWidthInEngine * 0.5f;
        float thickness = outer - inner;
        thickness *= flare.extraLengthMult;
        return inner + (thickness += flare.extraLengthFlat);
    }

    @Override
    public Color getNameColor() {
        Color bad = Misc.getNegativeHighlightColor();
        Color base = super.getNameColor();
        return super.getNameColor();
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle("Magnetic Field");
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, pad);
            nextPad = small;
        }
        float detectedMult = 0.25f;
        if (this.flareManager.isInActiveFlareArc(Global.getSector().getPlayerFleet())) {
            detectedMult = 0.0f;
        }
        tooltip.addPara("Reduces the range at which fleets inside can be detected by %s.", nextPad, highlight, (int)((1.0f - detectedMult) * 100.0f) + "%");
        if (this.flareManager.isInActiveFlareArc(Global.getSector().getPlayerFleet())) {
            tooltip.addPara("The magnetic storm also blinds the sensors of a fleet within, reducing their range by %s.", pad, highlight, "90%");
        }
        if (expanded) {
            tooltip.addSectionHeading("Combat", Alignment.MID, pad);
            tooltip.addPara("No combat effects.", nextPad);
        }
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getTerrainName() {
        if (this.flareManager.isInActiveFlareArc(Global.getSector().getPlayerFleet())) {
            return "Magnetic Storm";
        }
        return super.getTerrainName();
    }

    @Override
    public String getEffectCategory() {
        return "magnetic_field-like";
    }

    @Override
    public float getAuroraAlphaMultForAngle(float angle) {
        return 1.0f;
    }

    @Override
    public float getAuroraBandWidthInTexture() {
        return 256.0f;
    }

    @Override
    public Vector2f getAuroraCenterLoc() {
        return this.params.relatedEntity.getLocation();
    }

    @Override
    public Color getAuroraColorForAngle(float angle) {
        if (this.flareManager.isInActiveFlareArc(angle)) {
            return this.flareManager.getColorForAngle(this.params.baseColor, angle);
        }
        return this.params.baseColor;
    }

    @Override
    public float getAuroraInnerRadius() {
        return this.params.innerRadius;
    }

    @Override
    public float getAuroraOuterRadius() {
        return this.params.outerRadius;
    }

    @Override
    public float getAuroraShortenMult(float angle) {
        return 0.0f + this.flareManager.getShortenMod(angle);
    }

    @Override
    public float getAuroraInnerOffsetMult(float angle) {
        return this.flareManager.getInnerOffsetMult(angle);
    }

    @Override
    public float getAuroraTexPerSegmentMult() {
        return 1.0f;
    }

    @Override
    public SpriteAPI getAuroraTexture() {
        return this.texture;
    }

    @Override
    public float getAuroraThicknessFlat(float angle) {
        if (this.flareManager.isInActiveFlareArc(angle)) {
            return this.flareManager.getExtraLengthFlat(angle);
        }
        return 0.0f;
    }

    @Override
    public float getAuroraThicknessMult(float angle) {
        if (this.flareManager.isInActiveFlareArc(angle)) {
            return this.flareManager.getExtraLengthMult(angle);
        }
        return 1.0f;
    }

    @Override
    public float getFlareArcMax() {
        return 80.0f;
    }

    @Override
    public float getFlareArcMin() {
        return 30.0f;
    }

    @Override
    public List<Color> getFlareColorRange() {
        return this.params.auroraColorRange;
    }

    @Override
    public float getFlareExtraLengthFlatMax() {
        return 0.0f;
    }

    @Override
    public float getFlareExtraLengthFlatMin() {
        return 0.0f;
    }

    @Override
    public float getFlareExtraLengthMultMax() {
        return 1.0f;
    }

    @Override
    public float getFlareExtraLengthMultMin() {
        return 1.0f;
    }

    @Override
    public float getFlareFadeInMax() {
        return 2.0f;
    }

    @Override
    public float getFlareFadeInMin() {
        return 1.0f;
    }

    @Override
    public float getFlareFadeOutMax() {
        return 5.0f;
    }

    @Override
    public float getFlareFadeOutMin() {
        return 2.0f;
    }

    @Override
    public float getFlareOccurrenceAngle() {
        return 0.0f;
    }

    @Override
    public float getFlareOccurrenceArc() {
        return 360.0f;
    }

    @Override
    public float getFlareProbability() {
        return this.params.auroraFrequency;
    }

    @Override
    public float getFlareSmallArcMax() {
        return 20.0f;
    }

    @Override
    public float getFlareSmallArcMin() {
        return 10.0f;
    }

    @Override
    public float getFlareSmallExtraLengthFlatMax() {
        return 0.0f;
    }

    @Override
    public float getFlareSmallExtraLengthFlatMin() {
        return 0.0f;
    }

    @Override
    public float getFlareSmallExtraLengthMultMax() {
        return 1.0f;
    }

    @Override
    public float getFlareSmallExtraLengthMultMin() {
        return 1.0f;
    }

    @Override
    public float getFlareSmallFadeInMax() {
        return 1.0f;
    }

    @Override
    public float getFlareSmallFadeInMin() {
        return 0.5f;
    }

    @Override
    public float getFlareSmallFadeOutMax() {
        return 1.0f;
    }

    @Override
    public float getFlareSmallFadeOutMin() {
        return 0.5f;
    }

    @Override
    public float getFlareShortenFlatModMax() {
        return 0.8f;
    }

    @Override
    public float getFlareShortenFlatModMin() {
        return 0.8f;
    }

    @Override
    public float getFlareSmallShortenFlatModMax() {
        return 0.8f;
    }

    @Override
    public float getFlareSmallShortenFlatModMin() {
        return 0.8f;
    }

    @Override
    public int getFlareMaxSmallCount() {
        return 2;
    }

    @Override
    public int getFlareMinSmallCount() {
        return 7;
    }

    @Override
    public float getFlareSkipLargeProbability() {
        return 0.0f;
    }

    @Override
    public SectorEntityToken getFlareCenterEntity() {
        return this.entity;
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.REDUCES_DETECTABILITY || flag == TerrainAIFlags.REDUCES_SENSOR_RANGE;
    }

    @Override
    public boolean canPlayerHoldStationIn() {
        return true;
    }

    @Override
    public RangeBlockerUtil getAuroraBlocker() {
        return null;
    }

    public AuroraRenderer getRenderer() {
        return this.renderer;
    }

    public FlareManager getFlareManager() {
        return this.flareManager;
    }

    public static class MagneticFieldParams
    extends BaseRingTerrain.RingParams {
        public Color baseColor;
        public transient List<Color> auroraColorRange = new ArrayList<Color>();
        public String c = null;
        public float auroraFrequency;
        public float innerRadius;
        public float outerRadius;

        public MagneticFieldParams(float bandWidthInEngine, float middleRadius, SectorEntityToken relatedEntity, float innerRadius, float outerRadius, Color baseColor, float auroraFrequency) {
            this(bandWidthInEngine, middleRadius, relatedEntity, innerRadius, outerRadius, baseColor, auroraFrequency, Color.red, Color.orange, Color.yellow, Color.green, Color.blue, new Color(75, 0, 130), new Color(127, 0, 255));
        }

        public MagneticFieldParams(float bandWidthInEngine, float middleRadius, SectorEntityToken relatedEntity, float innerRadius, float outerRadius, Color baseColor, float auroraFrequency, Color ... auroraColors) {
            super(bandWidthInEngine, middleRadius, relatedEntity);
            this.auroraFrequency = auroraFrequency;
            this.baseColor = baseColor;
            this.innerRadius = innerRadius;
            this.outerRadius = outerRadius;
            if (auroraColors != null) {
                Color[] colorArray = auroraColors;
                int n = auroraColors.length;
                int n2 = 0;
                while (n2 < n) {
                    Color curr = colorArray[n2];
                    this.auroraColorRange.add(curr);
                    ++n2;
                }
            }
        }

        Object readResolve() {
            this.auroraColorRange = this.c != null ? Misc.colorsFromString(this.c) : new ArrayList<Color>();
            return this;
        }

        Object writeReplace() {
            this.c = Misc.colorsToString(this.auroraColorRange);
            return this;
        }
    }
}

