/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class RingRenderer {
    private SpriteAPI texture;

    public RingRenderer(String cat, String key) {
        this.texture = Global.getSettings().getSprite(cat, key);
    }

    public void render(Vector2f loc, float minR, float maxR, Color color, boolean spiral, float factor, float alphaMult) {
        float imageWidth;
        float middleRadius = minR + (maxR - minR) / 2.0f;
        float angle = 0.0f;
        float circ = (float)(Math.PI * 2 * (double)(middleRadius *= factor));
        float pixelsPerSegment = 5.0f;
        float segments = Math.round(circ / pixelsPerSegment);
        float startRad = (float)Math.toRadians(0.0);
        float endRad = (float)Math.toRadians(360.0);
        float spanRad = Misc.normalizeAngle(endRad - startRad);
        float anglePerSegment = spanRad / segments;
        float x = loc.x;
        float y = loc.y;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x * factor), (float)(y * factor), (float)0.0f);
        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        this.texture.bindTexture();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
        float texWidth = this.texture.getTextureWidth();
        float bandWidthInTexture = imageWidth = this.texture.getWidth();
        float thickness = (maxR - minR) * 1.0f * factor;
        float radius = middleRadius - thickness / 2.0f;
        if (spiral) {
            float prev = radius + thickness;
            thickness = Math.min(thickness, (radius + thickness) * 0.25f);
            radius = prev - thickness;
        }
        float texProgress = 0.0f;
        float texHeight = this.texture.getTextureHeight();
        float imageHeight = this.texture.getHeight();
        float texPerSegment = pixelsPerSegment * texHeight / imageHeight * bandWidthInTexture / thickness;
        float totalTex = Math.max(1.0f, (float)Math.round(texPerSegment * segments));
        texPerSegment = totalTex / segments;
        float leftTX = 0.0f;
        float rightTX = 1.0f;
        float minSpiralRadius = radius * 0.01f;
        float spiralFactor = 1.25f;
        GL11.glBegin((int)8);
        if (!spiral) {
            float y2;
            float x2;
            float y1;
            float x1;
            float sin;
            float cos;
            float theta;
            float i = 0.0f;
            while (i < segments) {
                theta = anglePerSegment * i;
                cos = (float)Math.cos(theta);
                sin = (float)Math.sin(theta);
                x1 = cos * radius;
                y1 = sin * radius;
                x2 = cos * (radius + thickness);
                y2 = sin * (radius + thickness);
                GL11.glTexCoord2f((float)leftTX, (float)texProgress);
                GL11.glVertex2f((float)x1, (float)y1);
                GL11.glTexCoord2f((float)rightTX, (float)texProgress);
                GL11.glVertex2f((float)x2, (float)y2);
                texProgress += texPerSegment;
                i += 1.0f;
            }
            boolean i2 = false;
            theta = anglePerSegment * (float)i2;
            cos = (float)Math.cos(theta);
            sin = (float)Math.sin(theta);
            x1 = cos * radius;
            y1 = sin * radius;
            x2 = cos * (radius + thickness);
            y2 = sin * (radius + thickness);
            GL11.glTexCoord2f((float)leftTX, (float)texProgress);
            GL11.glVertex2f((float)x1, (float)y1);
            GL11.glTexCoord2f((float)rightTX, (float)texProgress);
            GL11.glVertex2f((float)x2, (float)y2);
        } else {
            float numSpirals = (radius - minSpiralRadius) / (thickness * spiralFactor);
            if (numSpirals < 2.0f) {
                numSpirals = 2.0f;
            }
            float distMult = 1.0f;
            float thicknessMult = 10.0f;
            float theta = 0.0f;
            float i = 0.0f;
            while (i < segments * numSpirals) {
                distMult = 1.0f - i / (segments * numSpirals);
                distMult = (float)Math.sqrt(distMult);
                thicknessMult = 1.0f;
                float alpha = i / segments;
                if (i > segments * (numSpirals - 1.0f)) {
                    alpha = (segments * numSpirals - i) / segments;
                }
                if (alpha > 1.0f) {
                    alpha = 1.0f;
                }
                if (alpha < 0.0f) {
                    alpha = 0.0f;
                }
                GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alpha * alphaMult)));
                theta = anglePerSegment * i;
                float cos = (float)Math.cos(theta);
                float sin = (float)Math.sin(theta);
                float x1 = cos * ((radius - minSpiralRadius) * distMult + minSpiralRadius);
                float y1 = sin * ((radius - minSpiralRadius) * distMult + minSpiralRadius);
                float x2 = cos * ((radius - minSpiralRadius) * distMult + thickness * thicknessMult + minSpiralRadius);
                float y2 = sin * ((radius - minSpiralRadius) * distMult + thickness * thicknessMult + minSpiralRadius);
                GL11.glTexCoord2f((float)leftTX, (float)texProgress);
                GL11.glVertex2f((float)x1, (float)y1);
                GL11.glTexCoord2f((float)rightTX, (float)texProgress);
                GL11.glVertex2f((float)x2, (float)y2);
                float circumferenceMult = ((radius - minSpiralRadius) * distMult + minSpiralRadius) / radius;
                texProgress += texPerSegment * circumferenceMult;
                if (i == 0.0f) {
                    GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
                }
                i += 1.0f;
            }
        }
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

