/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class ShoveFleetScript
implements EveryFrameScript {
    public static float IMPACT_SPEED_DELTA = Global.getSettings().getSpeedPerBurnLevel();
    public static float DURATION_SECONDS = 0.1f;
    protected CampaignFleetAPI fleet;
    protected float elapsed;
    protected float angle;
    protected float intensity;
    protected float impact = IMPACT_SPEED_DELTA;
    protected Vector2f dV;

    public ShoveFleetScript(CampaignFleetAPI fleet, float direction, float intensity) {
        this.fleet = fleet;
        this.intensity = intensity;
        this.angle = direction;
        this.dV = Misc.getUnitVectorAtDegreeAngle(this.angle);
        float fleetWeightFactor = (float)fleet.getFleetPoints() / 200.0f;
        if (fleetWeightFactor > 1.0f) {
            fleetWeightFactor = 1.0f;
        }
        fleetWeightFactor = 0.5f + 1.0f * (1.0f - fleetWeightFactor);
        float speed = IMPACT_SPEED_DELTA * 40.0f * intensity;
        float impact = speed * 1.0f * fleetWeightFactor;
        this.dV.scale(impact);
        this.dV.scale(1.0f / DURATION_SECONDS);
    }

    @Override
    public void advance(float amount) {
        this.fleet.setOrbit(null);
        Vector2f v = this.fleet.getVelocity();
        this.fleet.setVelocity(v.x + this.dV.x * amount, v.y + this.dV.y * amount);
        this.elapsed += amount;
    }

    @Override
    public boolean isDone() {
        return this.elapsed >= DURATION_SECONDS;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

