/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.loading.MuzzleFlashSpec;
import com.fs.starfarer.api.loading.ProjectileWeaponSpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class HeavyAdjudicatorEffect
implements OnFireEffectPlugin {
    public static HashMap<String, Vector2f> SECOND_MUZZLE_FLASH_OFFSET_MAP = new LinkedHashMap<String, Vector2f>();

    static {
        SECOND_MUZZLE_FLASH_OFFSET_MAP.put("onslaught_mk1_WS 016", new Vector2f(-39.0f, 17.0f));
        SECOND_MUZZLE_FLASH_OFFSET_MAP.put("onslaught_mk1_WS 017", new Vector2f(-39.0f, -18.0f));
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        ShipAPI ship = projectile.getSource();
        if (ship == null) {
            return;
        }
        MuzzleFlashSpec spec = ((ProjectileWeaponSpecAPI)weapon.getSpec()).getMuzzleFlashSpec().clone();
        spec.setLength(30.0f);
        spec.setParticleCount(30);
        spec.setSpread(90.0f);
        Vector2f p = projectile.getLocation();
        float angle = weapon.getCurrAngle();
        HeavyAdjudicatorEffect.spawnMuzzleFlash(((ProjectileWeaponSpecAPI)weapon.getSpec()).getMuzzleFlashSpec(), p, angle, ship.getVelocity(), 1.0f, 0.0f);
        String slotId = weapon.getSlot().getId();
        String id = String.valueOf(ship.getHullSpec().getBaseHullId()) + "_" + slotId;
        Vector2f offset = SECOND_MUZZLE_FLASH_OFFSET_MAP.get(id);
        if (offset != null) {
            float sign = Math.signum(offset.y);
            offset = new Vector2f((ReadableVector2f)offset);
            offset = Misc.rotateAroundOrigin(offset, angle);
            Vector2f.add((Vector2f)offset, (Vector2f)p, (Vector2f)offset);
            HeavyAdjudicatorEffect.spawnMuzzleFlash(spec, offset, angle + sign * 90.0f, ship.getVelocity(), 2.0f, 20.0f);
        }
    }

    public static void spawnMuzzleFlash(MuzzleFlashSpec spec, Vector2f point, float angle, Vector2f shipVel, float velMult, float velAdd) {
        if (spec == null) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        Color color = spec.getParticleColor();
        float min = spec.getParticleSizeMin();
        float range = spec.getParticleSizeRange();
        float spread = spec.getSpread();
        float length = spec.getLength();
        int i = 0;
        while (i < spec.getParticleCount()) {
            float size = range * (float)Math.random() + min;
            float theta = (float)(Math.random() * Math.toRadians(spread) + Math.toRadians(angle - spread / 2.0f));
            float r = (float)(Math.random() * (double)length);
            Vector2f dir = new Vector2f((float)Math.cos(theta), (float)Math.sin(theta));
            float x = dir.x * r;
            float y = dir.y * r;
            Vector2f loc = new Vector2f(point.x + x, point.y + y);
            Vector2f vel = new Vector2f(x * velMult + shipVel.x + dir.x * velAdd, y * velMult + shipVel.y + dir.y * velAdd);
            Vector2f rand = Misc.getPointWithinRadius(new Vector2f(), spec.getLength() * 0.5f);
            Vector2f.add((Vector2f)vel, (Vector2f)rand, (Vector2f)vel);
            float dur = spec.getParticleDuration();
            engine.addNebulaParticle(loc, vel, size *= 1.25f, 0.67f, 0.0f, 0.0f, dur *= 0.75f + (float)Math.random() * 0.5f, color);
            ++i;
        }
    }
}

