/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.impl.combat.NegativeExplosionVisual;
import com.fs.starfarer.api.impl.combat.RiftCascadeEffect;
import com.fs.starfarer.api.impl.combat.RiftCascadeMineExplosion;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.impl.combat.RiftTrailEffect;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.MissileSpecAPI;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class AssayingRiftEffect
implements OnFireEffectPlugin,
OnHitEffectPlugin,
EveryFrameWeaponEffectPlugin {
    public static String HUNGERING_RIFT_HEAL_MULT_STAT = "hungering_rift_heal_mult_stat";
    public static String HUNGERING_RIFT_HEAL_MOD_HUMAN_SHIPS = "hungering_rift_heal_mod";
    public static float HEAL_AMOUNT = 1000.0f;
    public static String ASSAYING_RIFT = "assaying_rift";
    public static int MAX_RIFTS = 10;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (weapon.getShip() != null && weapon.getShip().getHullSpec().hasTag("dweller")) {
            return;
        }
        String key = "AssayingRiftSharedDataKey";
        AssayingRiftCount data = (AssayingRiftCount)engine.getCustomData().get(key);
        if (data == null) {
            data = new AssayingRiftCount();
            engine.getCustomData().put(key, data);
        }
        data.update();
        boolean disable = data.count >= MAX_RIFTS;
        weapon.setForceDisabled(disable);
    }

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        Color color = RiftCascadeEffect.STANDARD_RIFT_COLOR;
        Object o = projectile.getWeapon().getSpec().getProjectileSpec();
        if (o instanceof MissileSpecAPI) {
            MissileSpecAPI spec = (MissileSpecAPI)o;
            color = spec.getExplosionColor();
        }
        if (!shieldHit && target instanceof ShipAPI) {
            ShipAPI targetShip = (ShipAPI)target;
            ShipAPI source = projectile.getSource();
            if (!targetShip.isHulk()) {
                WeightedRandomPicker<ShipAPI> healTargets = new WeightedRandomPicker<ShipAPI>();
                WeightedRandomPicker<ShipAPI> healNeedLess = new WeightedRandomPicker<ShipAPI>();
                for (ShipAPI other : Global.getCombatEngine().getShips()) {
                    DwellerShroud otherShroud;
                    if (other.isHulk() || other.isFighter() || other.getOwner() != source.getOwner() || AssayingRiftEffect.getHealMult(other) <= 0.0f || (otherShroud = DwellerShroud.getShroudFor(source)) == null) continue;
                    float missingHp = other.getMaxHitpoints() - other.getHitpoints();
                    if (missingHp < HEAL_AMOUNT * 0.7f && missingHp > 0.0f) {
                        healNeedLess.add(other, missingHp);
                        continue;
                    }
                    healTargets.add(other, missingHp);
                }
                ShipAPI toHeal = (ShipAPI)healTargets.pick();
                if (toHeal == null) {
                    toHeal = (ShipAPI)healNeedLess.pick();
                }
                if (toHeal != null) {
                    float healAmount = HEAL_AMOUNT;
                    toHeal.setHitpoints(Math.min(toHeal.getMaxHitpoints(), toHeal.getHitpoints() + (healAmount *= AssayingRiftEffect.getHealMult(toHeal))));
                }
            }
        }
        NegativeExplosionVisual.NEParams p = RiftCascadeMineExplosion.createStandardRiftParams(color, 15.0f);
        p.fadeOut = 1.0f;
        p.hitGlowSizeMult = 1.0f;
        RiftCascadeMineExplosion.spawnStandardRift(projectile, p);
        Vector2f vel = new Vector2f();
        if (target != null) {
            vel.set((ReadableVector2f)target.getVelocity());
        }
        Global.getSoundPlayer().playSound("assaying_rift_explosion", 1.0f, 1.0f, point, vel);
    }

    public static float getHealMult(ShipAPI toHeal) {
        float base = toHeal.getMutableStats().getDynamic().getValue(HUNGERING_RIFT_HEAL_MULT_STAT);
        return base += toHeal.getMutableStats().getDynamic().getValue(HUNGERING_RIFT_HEAL_MOD_HUMAN_SHIPS, 0.0f);
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, final CombatEngineAPI engine) {
        final MissileAIPlugin proxAI = Global.getCombatEngine().createProximityFuseAI((MissileAPI)projectile);
        RiftTrailEffect trail = new RiftTrailEffect((MissileAPI)projectile, null){
            boolean exploded;
            float elapsed;
            {
                super($anonymous0, $anonymous1);
                this.exploded = false;
                this.elapsed = 0.0f;
            }

            @Override
            public void advance(float amount, List<InputEventAPI> events) {
                super.advance(amount, events);
                proxAI.advance(amount);
                if (!this.exploded && !this.missile.didDamage() && this.missile.wasRemoved()) {
                    AssayingRiftEffect.this.onHit(this.missile, null, this.missile.getLocation(), false, null, engine);
                    this.exploded = true;
                }
            }

            @Override
            protected Color getUndercolor() {
                return DwellerShroud.SHROUD_COLOR;
            }

            @Override
            protected Color getDarkeningColor() {
                return RiftLanceEffect.getColorForDarkening(this.getUndercolor());
            }

            @Override
            protected float getBaseParticleDuration() {
                return 1.5f;
            }
        };
        MissileAPI missile = (MissileAPI)projectile;
        missile.setEmpResistance(1000);
        missile.setEccmChanceOverride(1.0f);
        missile.addTag(ASSAYING_RIFT);
        Global.getCombatEngine().addPlugin(trail);
    }

    public static class AssayingRiftCount {
        int count = 0;
        float totalElapsed = 0.0f;

        public void update() {
            float elapsed = Global.getCombatEngine().getTotalElapsedTime(false);
            if (this.totalElapsed >= elapsed) {
                return;
            }
            this.totalElapsed = elapsed;
            this.count = 0;
            for (MissileAPI m : Global.getCombatEngine().getMissiles()) {
                if (!m.hasTag(ASSAYING_RIFT)) continue;
                ++this.count;
            }
        }
    }
}

