/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.impl.combat.dweller.AssayingRiftEffect;
import com.fs.starfarer.api.impl.combat.dweller.ConvulsiveLungeSystemAI;
import com.fs.starfarer.api.impl.combat.dweller.ConvulsiveLungeSystemScript;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.dweller.HumanShipShroudedHullmod;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedMantleHullmod
extends HumanShipShroudedHullmod {
    public static float HEAL_MULT = 0.5f;
    public static float LUNGE_COOLDOWN = 10.0f;
    public static float LUNGE_DUR = 4.0f;
    public static float LUNGE_SPEED = 250.0f;
    public static String DATA_KEY = "core_ShroudedMantleHullmod_data_key";

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        super.applyEffectsBeforeShipCreation(hullSize, stats, id);
        boolean sMod = this.isSMod(stats);
        if (sMod) {
            stats.getDynamic().getMod(AssayingRiftEffect.HUNGERING_RIFT_HEAL_MOD_HUMAN_SHIPS).modifyFlat(id, HEAL_MULT);
        }
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)CREW_CASUALTIES + "%";
        }
        return null;
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return Math.round(HEAL_MULT * 100.0f) + "%";
        }
        return null;
    }

    @Override
    public CargoStackAPI getRequiredItem() {
        return Global.getSettings().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("shrouded_mantle", null), null);
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
        if (!ship.isAlive()) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        String key = String.valueOf(DATA_KEY) + "_" + ship.getId();
        ShroudedMantleHullmodData data = (ShroudedMantleHullmodData)engine.getCustomData().get(key);
        if (data == null) {
            data = new ShroudedMantleHullmodData();
            engine.getCustomData().put(key, data);
        }
        boolean forceUse = false;
        if (data.cooldown > 0.0f) {
            data.cooldown -= amount;
            if (data.cooldown < 0.0f) {
                data.cooldown = 0.0f;
            }
            if (data.cooldown > 0.0f) {
                return;
            }
        }
        if (ship.getFluxLevel() > 0.95f && ship.getHullLevel() > 0.25f && ship.getShield() != null && ship.getShield().isOn()) {
            forceUse = true;
        }
        if (ship.getFluxTracker().isOverloaded()) {
            forceUse = true;
        }
        data.interval.advance(amount * 2.0f);
        if ((data.interval.intervalElapsed() || forceUse) && !data.lunging) {
            float hull = ship.getHullLevel();
            data.hullAtPrevLunge = Math.max(hull, data.hullAtPrevLunge);
            if (hull <= data.hullAtPrevLunge - ConvulsiveLungeSystemAI.HULL_LOSS_FOR_PULLBACK || forceUse) {
                data.lunging = true;
                data.lungeElapsed = 0.0f;
                data.lungeDest = null;
                data.fadedFlash = false;
                data.hullAtPrevLunge = hull;
            }
        }
        this.doLunge(data, ship, amount);
    }

    protected void doLunge(ShroudedMantleHullmodData data, ShipAPI ship, float amount) {
        if (!data.lunging) {
            return;
        }
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        if (data.lungeElapsed < 1.0f || data.lungeDest == null) {
            if (data.lungeDest == null) {
                data.lungeDest = Misc.getUnitVectorAtDegreeAngle(Global.getSettings().getSafeMovementDir(ship));
                data.lungeDest.scale(ConvulsiveLungeSystemScript.PULL_DIST);
                Vector2f.add((Vector2f)data.lungeDest, (Vector2f)ship.getLocation(), (Vector2f)data.lungeDest);
            }
            if (data.lungeDest != null && shroud != null) {
                Vector2f dir = Misc.getUnitVector(ship.getLocation(), data.lungeDest);
                float accel = ConvulsiveLungeSystemScript.PARTICLE_WINDUP_ACCEL * amount * 1.0f;
                if (!ship.isFrigate()) {
                    accel *= 2.0f;
                }
                boolean affect = true;
                for (RoilingSwarmEffect.SwarmMember p : shroud.getMembers()) {
                    if (affect) {
                        p.vel.x += dir.x * accel;
                        p.vel.y += dir.y * accel;
                    }
                    if (!ship.isFrigate()) continue;
                    boolean bl = affect = !affect;
                }
            }
        } else if (data.lungeDest != null) {
            boolean slowdown;
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(ship.getLocation(), data.lungeDest));
            boolean bl = slowdown = data.lungeElapsed > LUNGE_DUR - 1.0f;
            if (slowdown) {
                dir = Misc.normalise(new Vector2f((ReadableVector2f)ship.getVelocity()));
                dir.negate();
            }
            if (!data.fadedFlash) {
                if (shroud != null) {
                    for (RoilingSwarmEffect.SwarmMember p : shroud.getMembers()) {
                        if (p.flash == null) continue;
                        p.flash.fadeOut();
                    }
                }
                data.fadedFlash = true;
            }
            Vector2f loc = ship.getLocation();
            float dist = Misc.getDistance(loc, data.lungeDest);
            float friction = ConvulsiveLungeSystemScript.FRICTION;
            float k = ConvulsiveLungeSystemScript.SPRING_CONSTANT;
            float freeLength = 0.0f;
            float stretch = dist - freeLength;
            float forceMag = k * Math.abs(stretch);
            float speedInDir = Vector2f.dot((Vector2f)dir, (Vector2f)ship.getVelocity());
            if (speedInDir > LUNGE_SPEED) {
                float mult = 1.0f - Math.min(1.0f, (speedInDir - LUNGE_SPEED) / 100.0f);
                forceMag *= mult;
            }
            float forceMagReduction = Math.min(Math.abs(forceMag), friction);
            forceMag -= forceMagReduction;
            friction -= forceMagReduction;
            Vector2f force = new Vector2f((ReadableVector2f)dir);
            if (slowdown) {
                forceMag = ship.getVelocity().length() * 2.0f;
                force.scale(forceMag);
            } else {
                force.scale(forceMag * Math.signum(stretch));
            }
            Vector2f acc = new Vector2f((ReadableVector2f)force);
            acc.scale(amount);
            Vector2f.add((Vector2f)ship.getVelocity(), (Vector2f)acc, (Vector2f)ship.getVelocity());
        }
        ship.giveCommand(ShipCommand.DECELERATE, null, 0);
        data.lungeElapsed += amount;
        if (data.lungeElapsed > LUNGE_DUR) {
            data.lunging = false;
            data.cooldown = LUNGE_COOLDOWN;
        }
    }

    public static class ShroudedMantleHullmodData {
        IntervalUtil interval = new IntervalUtil(0.75f, 1.25f);
        float hullAtPrevLunge = 1.0f;
        float cooldown = 0.0f;
        boolean lunging = false;
        Vector2f lungeDest;
        float lungeElapsed = 0.0f;
        boolean fadedFlash = false;
    }
}

