/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.Iterator;

public class EscortPackage
extends BaseHullMod {
    public static float MANEUVER_BONUS = 25.0f;
    public static float SPEED_BONUS = 10.0f;
    public static float RANGE_BONUS = 20.0f;
    public static float SHIELD_BONUS = 10.0f;
    public static float EFFECT_RANGE = 700.0f;
    public static float EFFECT_FADE = 500.0f;
    public static Object STATUS_KEY = new Object();
    public static String EP_DATA_KEY = "core_escort_package_data_key";

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "1000";
        }
        if (index == 1) {
            return Math.round(MANEUVER_BONUS) + "%";
        }
        if (index == 2) {
            return Math.round(SPEED_BONUS) + "%";
        }
        if (index == 3) {
            return Math.round(RANGE_BONUS) + "%";
        }
        if (index == 4) {
            return "doubled";
        }
        return null;
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return Math.round(SHIELD_BONUS) + "%";
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return this.getUnapplicableReason(ship) == null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && ship.isFrigate()) {
            return "Can not be installed on frigates";
        }
        if (ship != null && ship.isCapital()) {
            return "Can not be installed on capital ships";
        }
        return super.getUnapplicableReason(ship);
    }

    public void applyEPEffect(ShipAPI ship, ShipAPI other, float mag) {
        String id = "escort_package_bonus" + ship.getId();
        MutableShipStatsAPI stats = ship.getMutableStats();
        if (mag > 0.0f) {
            boolean sMod = this.isSMod(ship);
            float maneuver = MANEUVER_BONUS * mag;
            stats.getAcceleration().modifyPercent(id, maneuver);
            stats.getDeceleration().modifyPercent(id, maneuver);
            stats.getTurnAcceleration().modifyPercent(id, maneuver * 2.0f);
            stats.getMaxTurnRate().modifyPercent(id, maneuver);
            float speed = SPEED_BONUS * mag;
            stats.getMaxSpeed().modifyPercent(id, speed);
            float range = RANGE_BONUS * mag;
            stats.getBallisticWeaponRangeBonus().modifyPercent(id, range);
            stats.getEnergyWeaponRangeBonus().modifyPercent(id, range);
            if (sMod && ship.isDestroyer()) {
                float shields = SHIELD_BONUS * mag;
                stats.getShieldDamageTakenMult().modifyMult(id, 1.0f - shields / 100.0f);
            }
        } else {
            stats.getAcceleration().unmodify(id);
            stats.getDeceleration().unmodify(id);
            stats.getTurnAcceleration().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
            stats.getMaxSpeed().unmodify(id);
            stats.getBallisticWeaponRangeBonus().unmodify(id);
            stats.getEnergyWeaponRangeBonus().unmodify(id);
            stats.getShieldDamageTakenMult().unmodify(id);
        }
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
        if (!ship.isAlive()) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        String key = String.valueOf(EP_DATA_KEY) + "_" + ship.getId();
        EscortPackageData data = (EscortPackageData)engine.getCustomData().get(key);
        if (data == null) {
            data = new EscortPackageData();
            engine.getCustomData().put(key, data);
        }
        boolean playerShip = ship == Global.getCombatEngine().getPlayerShip();
        data.interval.advance(amount * 4.0f);
        if (data.interval.intervalElapsed() || playerShip) {
            float checkSize = EFFECT_RANGE + EFFECT_FADE + ship.getCollisionRadius() + 300.0f;
            Iterator<Object> iter = Global.getCombatEngine().getShipGrid().getCheckIterator(ship.getLocation(), checkSize *= 2.0f, checkSize);
            ShipAPI best = null;
            float bestMag = 0.0f;
            while (iter.hasNext()) {
                ShipAPI other;
                Object next = iter.next();
                if (!(next instanceof ShipAPI) || ship == (other = (ShipAPI)next) || other.getOwner() != ship.getOwner() || other.isHulk() || other.getHullSize().ordinal() <= ship.getHullSize().ordinal()) continue;
                float radSum = ship.getShieldRadiusEvenIfNoShield() + other.getShieldRadiusEvenIfNoShield();
                float dist = Misc.getDistance(ship.getShieldCenterEvenIfNoShield(), other.getShieldCenterEvenIfNoShield());
                dist -= (radSum *= 0.75f);
                float mag = 0.0f;
                if (dist < EFFECT_RANGE) {
                    mag = 1.0f;
                } else if (dist < EFFECT_RANGE + EFFECT_FADE) {
                    mag = 1.0f - (dist - EFFECT_RANGE) / EFFECT_FADE;
                }
                if (ship.isDestroyer() && other.isCapital()) {
                    mag *= 2.0f;
                }
                if (!(mag > bestMag)) continue;
                best = other;
                bestMag = mag;
            }
            this.applyEPEffect(ship, best, bestMag);
            data.mag = bestMag;
        }
        if (playerShip) {
            if (data.mag > 0.005f) {
                String icon = Global.getSettings().getSpriteName("ui", "icon_tactical_escort_package");
                String percent = Math.round(data.mag * 100.0f) + "%";
                Global.getCombatEngine().maintainStatusForPlayerShip(STATUS_KEY, icon, "Escort package", String.valueOf(percent) + " telemetry quality", false);
            } else {
                String icon = Global.getSettings().getSpriteName("ui", "icon_tactical_escort_package");
                Global.getCombatEngine().maintainStatusForPlayerShip(STATUS_KEY, icon, "Escort package", "no connection", true);
            }
        }
    }

    public static class EscortPackageData {
        IntervalUtil interval = new IntervalUtil(0.9f, 1.1f);
        float mag = 0.0f;
    }
}

