/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TimeoutTrackerMap<K, V> {
    private Map<K, ItemData<K, V>> items = new LinkedHashMap<K, ItemData<K, V>>();

    public void add(K key, V item, float time) {
        this.getData(key, item).remaining += time;
    }

    public void add(K key, V item, float time, float limit) {
        ItemData<K, V> d = this.getData(key, item);
        if (time > 0.0f && d.remaining + time > limit) {
            time = Math.max(0.0f, limit - d.remaining);
        }
        d.remaining += time;
        if (d.remaining < 0.0f) {
            d.remaining = 0.0f;
        }
    }

    public void set(K key, V item, float time) {
        this.getData(key, item).remaining = time;
    }

    public float getRemaining(K key) {
        return this.getData(key, null).remaining;
    }

    public V getItem(K key) {
        return this.getData(key, null).item;
    }

    public void remove(K key) {
        this.items.remove(key);
    }

    public void clear() {
        this.items.clear();
    }

    private ItemData<K, V> getData(K key, V item) {
        ItemData<K, V> data = this.items.get(key);
        if (data == null) {
            data = new ItemData();
            data.key = key;
            data.item = item;
            data.remaining = 0.0f;
            this.items.put(key, data);
        }
        return data;
    }

    public void advance(float amount) {
        ArrayList<K> remove = new ArrayList<K>();
        Set<Map.Entry<K, ItemData<K, V>>> entrySet = this.items.entrySet();
        for (Map.Entry<K, ItemData<K, V>> entry : entrySet) {
            entry.getValue().remaining -= amount;
            if (!(entry.getValue().remaining <= 0.0f)) continue;
            remove.add(entry.getKey());
        }
        for (Object key : remove) {
            this.items.remove(key);
        }
    }

    public boolean contains(K key) {
        return this.items.containsKey(key);
    }

    public static class ItemData<K, V> {
        public K key;
        public V item;
        public float remaining;
    }
}

