/*
 * Decompiled with CFR 0.152.
 */
package com.fs.graphics.util;

import com.fs.util.DoNotObfuscate;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.lwjgl.opengl.GL11;

public class GLListManager
implements DoNotObfuscate {
    private static Set<GLListToken> activeLists = new HashSet<GLListToken>();
    private static Set<GLListToken> allocatedLists = new HashSet<GLListToken>();
    private static LinkedList<Integer> freeLists = new LinkedList();
    public static boolean suspend = false;
    public static boolean buildingList = false;
    private static int currListId = 0;
    private static int maxListId = 0;

    public static void nextFrame() {
        HashSet<GLListToken> hashSet = new HashSet<GLListToken>(allocatedLists);
        hashSet.removeAll(activeLists);
        for (GLListToken gLListToken : hashSet) {
            GLListManager.invalidateList(gLListToken);
        }
        allocatedLists.removeAll(hashSet);
        activeLists.clear();
    }

    public static void invalidateList(GLListToken gLListToken) {
        if (gLListToken != null && allocatedLists.contains(gLListToken)) {
            freeLists.add(gLListToken.listId);
            allocatedLists.remove(gLListToken);
            activeLists.remove(gLListToken);
        }
    }

    public static boolean callList(GLListToken gLListToken) {
        if (suspend) {
            return false;
        }
        if (gLListToken != null && allocatedLists.contains(gLListToken)) {
            GL11.glCallList((int)gLListToken.listId);
            activeLists.add(gLListToken);
            return true;
        }
        return false;
    }

    public static GLListToken beginList() {
        int n;
        if (suspend) {
            return null;
        }
        if (buildingList) {
            throw new RuntimeException("Can't create nested lists using GLListManager");
        }
        if (currListId > maxListId || currListId == 0) {
            currListId = 0;
            n = 1024;
            while (currListId == 0 && n > 0) {
                currListId = GL11.glGenLists((int)n);
                maxListId = currListId + n - 1;
                n /= 2;
            }
            if (currListId == 0) {
                throw new RuntimeException("Unable to generate any gl lists");
            }
        }
        n = 0;
        int n2 = currListId;
        if (!freeLists.isEmpty()) {
            n2 = freeLists.removeFirst();
            n = 1;
        }
        GLListToken gLListToken = new GLListToken(n2);
        allocatedLists.add(gLListToken);
        activeLists.add(gLListToken);
        GL11.glNewList((int)n2, (int)4865);
        if (n == 0) {
            ++currListId;
        }
        buildingList = true;
        return gLListToken;
    }

    public static void endList() {
        if (suspend) {
            return;
        }
        buildingList = false;
        GL11.glEndList();
    }

    public static class GLListToken
    implements DoNotObfuscate {
        private int listId;
        private Object callerToken = new Object();

        public GLListToken(int n) {
            this.listId = n;
            this.callerToken = new Object();
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.callerToken == null ? 0 : this.callerToken.hashCode());
            n2 = 31 * n2 + this.listId;
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            GLListToken gLListToken = (GLListToken)object;
            if (this.callerToken == null ? gLListToken.callerToken != null : !this.callerToken.equals(gLListToken.callerToken)) {
                return false;
            }
            return this.listId == gLListToken.listId;
        }
    }
}

