/*
 * Decompiled with CFR 0.152.
 */
package com.fs.state;

import com.fs.state.AppState;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AppDriver
implements DoNotObfuscate {
    public static final String EXIT_STATE = "AppDriver.EXIT_STATE";
    private static AppDriver instance = null;
    protected Map session = new HashMap();
    protected Map<String, AppState> states = new HashMap<String, AppState>();
    protected List<AppState> statesInOrder = new ArrayList<AppState>();
    protected String startStateID = null;
    private AppState currState = null;

    public static AppDriver getInstance() {
        if (instance == null) {
            instance = new AppDriver();
        }
        return instance;
    }

    private AppDriver() {
    }

    public void begin() throws Exception {
        AppState appState;
        Iterator<AppState> iterator = this.statesInOrder.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            appState = iterator.next();
            appState.init(this.session);
        }
        if (this.startStateID == null) {
            throw new RuntimeException("Start state ID must be set before a call to begin()");
        }
        this.currState = appState = this.getState(this.startStateID);
        String string = appState.traverse();
        while (!string.equals(EXIT_STATE)) {
            this.currState = this.getState(string);
            string = this.currState.traverse();
        }
    }

    public AppState getCurrentState() {
        return this.currState;
    }

    public AppState getState(String string) {
        AppState appState = this.states.get(string);
        if (appState == null) {
            throw new RuntimeException("State [" + string + "] not found");
        }
        return appState;
    }

    public void addState(AppState appState) {
        String string = appState.getID();
        if (string.equals(EXIT_STATE)) {
            throw new RuntimeException("Invalid id: id [" + string + "] is reserved for EXIT_STATE");
        }
        if (this.states.containsKey(string)) {
            throw new RuntimeException("Invalid id: id [" + string + "] is already used for another state");
        }
        this.statesInOrder.add(appState);
        this.states.put(string, appState);
    }

    public void setStartState(String string) {
        this.startStateID = string;
    }

    public Map getSession() {
        return this.session;
    }
}

