/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.String.L;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.loading.CampaignPingSpec;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.loading.SpecStore;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;

public class PingScript
implements EveryFrameScript,
DoNotObfuscate {
    private transient CampaignPingSpec spec;
    private CampaignPingSpec custom;
    private SectorEntityToken entity;
    private String pingType;
    private int numLeft;
    private float timeLeft;
    private Color colorOverride;

    public PingScript(SectorEntityToken sectorEntityToken, CampaignPingSpec campaignPingSpec) {
        this.entity = sectorEntityToken;
        this.custom = campaignPingSpec;
        this.readResolve();
        this.numLeft = this.spec.getNum();
        this.firePing();
    }

    public PingScript(SectorEntityToken sectorEntityToken, String string) {
        this(sectorEntityToken, string, null);
    }

    public PingScript(SectorEntityToken sectorEntityToken, String string, Color color) {
        this.entity = sectorEntityToken;
        this.pingType = string;
        this.colorOverride = color;
        this.readResolve();
        this.numLeft = this.spec.getNum();
        this.firePing();
    }

    private void firePing() {
        if (this.entity.isInCurrentLocation()) {
            String string;
            int n2 = this.spec.getNum() - this.numLeft;
            if (this.spec.getSounds().size() > n2 && (string = (String)this.spec.getSounds().get(n2)) != null && !string.isEmpty()) {
                L.o00000(string, 1.0f, 1.0f, this.entity.getLocation(), this.entity.getVelocity());
            }
        }
        if (this.custom != null) {
            CampaignEngine.getInstance().addPingInternal(this.entity, this.custom);
        } else {
            CampaignEngine.getInstance().addPingInternal(this.entity, this.pingType, this.colorOverride);
        }
        --this.numLeft;
        this.timeLeft = this.spec.getDelay();
    }

    protected Object readResolve() {
        this.spec = this.pingType != null ? SpecStore.o00000(CampaignPingSpec.class, this.pingType) : this.custom;
        return this;
    }

    public void advance(float f2) {
        if (this.isDone()) {
            return;
        }
        this.timeLeft -= f2;
        if (this.timeLeft <= 0.0f) {
            float f3 = -this.timeLeft;
            this.firePing();
            this.timeLeft -= f3;
        }
    }

    public boolean isDone() {
        return this.numLeft <= 0;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

