/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.ai;

import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.NavigationModulePlugin;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class NavigationModule
implements DoNotObfuscate,
NavigationModulePlugin {
    private CampaignFleet fleet;
    private TimeoutTracker<AvoidData> avoiding = new TimeoutTracker();
    private TimeoutTracker<SectorEntityToken> doNotAvoid = new TimeoutTracker();
    private Vector2f destination = new Vector2f();
    private Vector2f clickLocation = new Vector2f();
    private boolean hasDest = false;

    public NavigationModule(CampaignFleet campaignFleet, ModularFleetAIAPI modularFleetAIAPI) {
        this.fleet = campaignFleet;
    }

    protected Object writeReplace() {
        return this;
    }

    public void doNotAvoid(SectorEntityToken sectorEntityToken, float f2) {
        this.getDoNotAvoid().set((Object)sectorEntityToken, f2);
    }

    public TimeoutTracker<SectorEntityToken> getDoNotAvoid() {
        if (this.doNotAvoid == null) {
            this.doNotAvoid = new TimeoutTracker();
        }
        return this.doNotAvoid;
    }

    public TimeoutTracker<AvoidData> getAvoiding() {
        return this.avoiding;
    }

    public void advance(float f2) {
        MemoryAPI memoryAPI;
        float f3;
        this.avoiding.advance(f2);
        this.getDoNotAvoid().advance(f2);
        Vector2f vector2f = new Vector2f();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        CampaignFleetAPI campaignFleetAPI = null;
        float f4 = f3 = 1000000.0f;
        float f5 = f3;
        for (AvoidData avoidData : this.avoiding.getItems()) {
            float f6;
            float f7;
            if (avoidData.containingLocation != null && avoidData.containingLocation != this.fleet.getContainingLocation() || this.getDoNotAvoid().contains((Object)avoidData.entity) || (f7 = Utils.void(this.fleet.getLocation(), avoidData.getLocation())) > avoidData.maxRange || avoidData.entity == this.fleet || avoidData.entity != null && this.fleet.getContainingLocation() != avoidData.entity.getContainingLocation()) continue;
            if (f7 < f4) {
                f4 = f7;
                f5 = Math.min(f5, avoidData.minRange);
            }
            if (f7 <= avoidData.minRange) {
                f6 = 1.0f;
                var15_19 = avoidData.maxRange - avoidData.minRange;
                if (var15_19 <= 1.0f) {
                    f6 = 2.0f;
                }
            } else {
                var15_19 = avoidData.maxRange - avoidData.minRange;
                f6 = var15_19 <= 1.0f ? 2.0f : 2.0f - (f7 - avoidData.minRange) / var15_19;
            }
            memoryAPI = Utils.\u00d300000(Utils.\u00d300000(avoidData.getLocation(), this.fleet.getLocation()));
            memoryAPI.scale(f6);
            if (avoidData.entity instanceof CampaignFleetAPI) {
                ++n2;
                campaignFleetAPI = (CampaignFleetAPI)avoidData.entity;
                bl = true;
                if (avoidData.entity.isPlayerFleet()) {
                    bl2 = true;
                }
            }
            ++n3;
            Vector2f.add((Vector2f)vector2f, (Vector2f)memoryAPI, (Vector2f)vector2f);
        }
        float f8 = Utils.void(this.fleet.getLocation(), this.destination);
        if (f8 <= 0.0f) {
            Misc.wiggle((Vector2f)this.destination, (float)1.0f);
        }
        Vector2f vector2f2 = Utils.\u00d300000(Utils.\u00d300000(this.fleet.getLocation(), this.destination));
        if (f4 < f3 && f4 > f5 + 1000.0f) {
            vector2f.set(0.0f, 0.0f);
        }
        Vector2f.add((Vector2f)vector2f, (Vector2f)vector2f2, (Vector2f)vector2f);
        if (f8 > 10000.0f) {
            f8 = 10000.0f;
        }
        if (!this.hasDest) {
            f8 = 2000.0f;
            if (this.avoiding.getItems().isEmpty()) {
                f8 = 0.0f;
            }
        } else if (this.hasDest && bl) {
            f8 = 2000.0f;
        }
        if (n3 <= 1 && campaignFleetAPI != null) {
            boolean bl3 = false;
            AbilityPlugin abilityPlugin = this.fleet.getAbility("emergency_burn");
            if (abilityPlugin != null && abilityPlugin.isActiveOrInProgress()) {
                bl3 = true;
            }
            memoryAPI = this.fleet.getMemoryWithoutUpdate();
            String string = "$cfai_avoidDir";
            String string2 = "$cfai_prevAvoidDir";
            String string3 = "$cfai_tempAvoidSlowly";
            float f9 = memoryAPI.getFloat(string);
            if (f9 == 0.0f) {
                float f10 = memoryAPI.getFloat(string2);
                f9 = (float)Math.random() < 0.5f ? 1.0f : -1.0f;
                memoryAPI.set(string, (Object)Float.valueOf(f9 *= 60.0f), 0.25f + (float)Math.random() * 0.5f);
                memoryAPI.set(string2, (Object)Float.valueOf(f9), 1.0f);
                if (Math.signum(f10) != Math.signum(f9)) {
                    memoryAPI.set(string3, (Object)true, 0.25f + (float)Math.random() * 0.25f);
                }
            }
            boolean bl4 = bl2 && Misc.isAvoidingPlayerHalfheartedly((CampaignFleetAPI)this.fleet);
            bl4 |= memoryAPI.getBoolean(string3);
            if (bl3) {
                bl4 = false;
            }
            float f11 = Misc.getAngleInDegrees((Vector2f)vector2f);
            vector2f = Misc.getUnitVectorAtDegreeAngle((float)(f11 += f9));
            if (bl4) {
                f8 = 50.0f;
            }
        }
        this.clickLocation = Utils.super(vector2f);
        this.clickLocation.scale(f8);
        Vector2f.add((Vector2f)this.clickLocation, (Vector2f)this.fleet.getLocation(), (Vector2f)this.clickLocation);
    }

    private AvoidData getDataForEntity(SectorEntityToken sectorEntityToken) {
        AvoidData avoidData2;
        for (AvoidData avoidData2 : this.avoiding.getItems()) {
            if (avoidData2.entity != sectorEntityToken) continue;
            return avoidData2;
        }
        avoidData2 = new AvoidData();
        avoidData2.entity = sectorEntityToken;
        return avoidData2;
    }

    public void avoidEntity(SectorEntityToken sectorEntityToken, float f2, float f3, float f4) {
        AvoidData avoidData = this.getDataForEntity(sectorEntityToken);
        avoidData.minRange = f2;
        avoidData.maxRange = f3;
        this.avoiding.set((Object)avoidData, f4);
    }

    public void unavoidEntity(SectorEntityToken sectorEntityToken) {
        AvoidData avoidData = this.getDataForEntity(sectorEntityToken);
        this.avoiding.remove((Object)avoidData);
    }

    public void avoidLocation(LocationAPI locationAPI, Vector2f vector2f, float f2, float f3, float f4) {
        AvoidData avoidData = new AvoidData();
        avoidData.minRange = f2;
        avoidData.maxRange = f3;
        avoidData.loc = vector2f;
        avoidData.containingLocation = locationAPI;
        this.avoiding.set((Object)avoidData, f4);
    }

    public void clearAvoidList() {
        this.avoiding.clear();
    }

    public float getCalculatedHeading() {
        return Utils.\u00d300000(this.fleet.getLocation(), this.clickLocation);
    }

    public float getPreferredHeading(float f2) {
        return Utils.\u00d300000(this.fleet.getLocation(), this.destination);
    }

    public void setDestination(Vector2f vector2f) {
        if (vector2f == null) {
            this.hasDest = false;
            this.destination.set((ReadableVector2f)this.fleet.getLocation());
        } else {
            this.hasDest = true;
            this.destination.set((ReadableVector2f)vector2f);
        }
    }

    public void setPreferredHeading(float f2) {
        Vector2f vector2f = Utils.\u00d300000(f2);
        vector2f.scale(10000.0f);
        Vector2f.add((Vector2f)vector2f, (Vector2f)this.fleet.getLocation(), (Vector2f)vector2f);
        this.destination.set((ReadableVector2f)vector2f);
    }

    public Vector2f getClickToMoveLocation() {
        return this.clickLocation;
    }

    public static class AvoidData
    implements DoNotObfuscate {
        Vector2f loc;
        SectorEntityToken entity;
        float minRange;
        float maxRange;
        LocationAPI containingLocation;

        public Vector2f getLocation() {
            if (this.loc != null) {
                return this.loc;
            }
            return this.entity.getLocation();
        }
    }
}

