/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.graphics.util.Fader;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.ui.dosuper;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class CampaignFloatingText
implements DoNotObfuscate {
    private SectorEntityToken entity;
    private Vector2f offset = new Vector2f();
    private Vector2f velocity = new Vector2f(0.0f, 50.0f);
    private Fader fader = new Fader(0.0f, 0.05f, 0.5f);
    private String text;
    private float duration;
    private transient dosuper label;
    private final Color color;
    private boolean showWhenContact = false;

    public CampaignFloatingText(SectorEntityToken sectorEntityToken, String string, Color color, float f2) {
        this.entity = sectorEntityToken;
        this.text = string;
        this.color = color;
        this.duration = f2;
        this.offset.set(0.0f, sectorEntityToken.getRadius() + 5.0f);
        this.fader.fadeIn();
        this.readResolve();
    }

    protected Object readResolve() {
        this.label = new dosuper(this.text, StarfarerSettings.float.new, this.color, true, Alignment.MID);
        this.label.autoSize();
        this.label.getRenderer().\u00f500000(true);
        return this;
    }

    public boolean isDone() {
        return this.fader.isFadedOut();
    }

    public boolean isShowWhenContact() {
        return this.showWhenContact;
    }

    public void setShowWhenContact(boolean bl) {
        this.showWhenContact = bl;
    }

    public void advance(float f2) {
        this.fader.advance(f2);
        if (this.fader.isFadingOut()) {
            this.offset.x += this.velocity.x * f2;
            this.offset.y += this.velocity.y * f2;
        }
        this.duration -= f2;
        if (this.duration <= 0.0f) {
            this.fader.fadeOut();
        }
    }

    public void renderInScreenCoords(float f2) {
        if (f2 <= 0.0f) {
            return;
        }
        f2 *= this.fader.getBrightness();
        CombatViewport combatViewport = CampaignEngine.getInstance().getViewport();
        float f3 = Math.round(combatViewport.convertWorldXtoScreenX(this.entity.getLocation().x + this.offset.x));
        float f4 = Math.round(combatViewport.convertWorldYtoScreenY(this.entity.getLocation().y + this.offset.y));
        float f5 = this.label.getWidth();
        float f6 = this.label.getHeight();
        float f7 = StarfarerSettings.while.new();
        float f8 = StarfarerSettings.\u00f6\u00d20000();
        f3 -= f5 / 2.0f;
        f4 -= f6 / 2.0f;
        if (f3 < -f5) {
            return;
        }
        if (f4 < -f6) {
            return;
        }
        if (f3 > f5 + f7) {
            return;
        }
        if (f4 > f6 + f8) {
            return;
        }
        this.label.getPosition().setRoundCoordinates(true);
        this.label.getPosition().setLocation(Math.round(f3 + f5 / 2.0f - this.label.getWidth() / 2.0f), Math.round(f4 + f6 / 2.0f + 2.0f));
        this.label.render(f2);
    }
}

