/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberStatusAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.ship.new;
import com.fs.starfarer.loading.specs.HullVariantSpec;
import com.fs.starfarer.renderers.damage.E;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class FleetMemberStatus
implements DoNotObfuscate,
FleetMemberStatusAPI {
    private ShipStatus[] status;
    private FleetMember member;
    private transient Random random;

    public FleetMemberStatus(FleetMember fleetMember) {
        this.member = fleetMember;
        if (fleetMember.isFighterWing()) {
            this.status = new ShipStatus[fleetMember.getWingSpec().getNumFighters()];
        } else {
            List<String> list = FleetMemberStatus.getModuleSlotsFor(fleetMember.getVariant());
            this.status = new ShipStatus[1 + list.size()];
        }
        int n2 = 0;
        while (n2 < this.status.length) {
            this.status[n2] = new ShipStatus(this);
            ++n2;
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public float getHullFraction() {
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < this.status.length) {
            f2 += this.status[n2].hullFraction;
            ++n2;
        }
        return f2 / (float)this.status.length;
    }

    public void setHullFraction(float f2) {
        this.status[0].hullFraction = f2;
    }

    public void setDetached(int n2, Boolean bl) {
        if (n2 >= this.status.length) {
            return;
        }
        if (bl != null && !bl.booleanValue()) {
            bl = null;
        }
        this.status[n2].detached = bl;
    }

    public void setPermaDetached(int n2, Boolean bl) {
        if (n2 >= this.status.length) {
            return;
        }
        if (bl != null && !bl.booleanValue()) {
            bl = null;
        }
        this.status[n2].permaDetached = bl;
    }

    public void setHullFraction(int n2, float f2) {
        if (n2 >= this.status.length) {
            return;
        }
        this.status[n2].setHullFraction(f2);
    }

    public float getHullFraction(int n2) {
        if (n2 >= this.status.length) {
            return 0.0f;
        }
        return this.status[n2].getHullFraction();
    }

    public boolean isDetached(int n2) {
        if (n2 >= this.status.length) {
            return false;
        }
        return this.status[n2].detached != null && this.status[n2].detached != false;
    }

    public boolean isPermaDetached(int n2) {
        if (n2 >= this.status.length) {
            return false;
        }
        return this.status[n2].permaDetached != null && this.status[n2].permaDetached != false;
    }

    public void disable() {
        int n2 = 0;
        while (n2 < this.status.length) {
            this.status[n2].disable();
            ++n2;
        }
    }

    public void repairDisabledABit() {
        int n2 = 0;
        while (n2 < this.status.length) {
            if (!this.status[n2].isPermaDetached()) {
                this.status[n2].detached = null;
                this.status[n2].hullFraction = n2 == 0 || (float)Math.random() > 0.67f ? Math.max(0.01f + 0.09f * (float)Math.random(), this.status[n2].hullFraction) : Math.max(0.01f + 0.09f * (float)Math.random(), this.status[n2].hullFraction);
            }
            ++n2;
        }
    }

    public void repairFully() {
        int n2 = 0;
        while (n2 < this.status.length) {
            if (!this.status[n2].isPermaDetached()) {
                this.status[n2].detached = null;
                this.status[n2].hullFraction = 1.0f;
                this.status[n2].armorCellFractions = null;
            }
            ++n2;
        }
    }

    public void repairFullyNoNewFighters() {
        int n2 = 0;
        while (n2 < this.status.length) {
            if (!this.status[n2].isPermaDetached() && this.status[n2].hullFraction > 0.0f) {
                this.status[n2].detached = null;
                this.status[n2].hullFraction = 1.0f;
                this.status[n2].armorCellFractions = null;
            }
            ++n2;
        }
    }

    public void applyHullFractionDamage(float f2) {
        this.applyHullFractionDamage(f2, 0);
    }

    public void applyHullFractionDamage(float f2, int n2) {
        this.status[n2].applyHullFractionDamage(f2);
    }

    public int getNumStatuses() {
        return this.status.length;
    }

    public int getNumExistingFighters() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.status.length) {
            if (this.status[n3].hullFraction > 0.0f) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public void applyDamage(float f2) {
        this.applyDamage(f2, 0.0f);
    }

    public void applyDamage(float f2, float f3) {
        if (this.status.length == 1) {
            this.status[0].applyDamage(f2, f3);
        } else {
            WeightedRandomPicker weightedRandomPicker = new WeightedRandomPicker();
            int n2 = 0;
            while (n2 < this.status.length) {
                if (this.status[n2].hullFraction > 0.0f) {
                    weightedRandomPicker.add((Object)n2);
                }
                ++n2;
            }
            Integer n3 = (Integer)weightedRandomPicker.pick();
            if (n3 != null) {
                this.status[n3].applyDamage(f2, f3);
            }
        }
    }

    public float getHullDamageTaken() {
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < this.status.length) {
            f2 += this.status[n2].hullDamageTaken;
            ++n2;
        }
        return f2 / (float)this.status.length;
    }

    public float getArmorDamageTaken() {
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < this.status.length) {
            f2 += this.status[n2].armorDamageTaken;
            ++n2;
        }
        return f2 / (float)this.status.length;
    }

    public void resetDamageTaken() {
        int n2 = 0;
        while (n2 < this.status.length) {
            this.status[n2].resetDamageTaken();
            ++n2;
        }
    }

    public void resetAmmoState() {
        int n2 = 0;
        while (n2 < this.status.length) {
            this.status[n2].resetAmmoState();
            ++n2;
        }
    }

    public boolean needsRepairs() {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.status.length) {
            bl |= this.status[n2].isDetached();
            ++n2;
        }
        return this.hullNeedsRepair() || this.armorNeedsRepair() || bl;
    }

    public boolean hullNeedsRepair() {
        return this.getHullFraction() < 1.0f;
    }

    public boolean armorNeedsRepair() {
        int n2 = 0;
        while (n2 < this.status.length) {
            if (this.status[n2].armorCellFractions != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void repair(float f2) {
        int n2 = 0;
        while (n2 < this.status.length) {
            if (this.status[n2].needsRepair()) {
                this.status[n2].repair(f2);
                return;
            }
            ++n2;
        }
    }

    public void repairArmorAllCells(float f2) {
        int n2 = 0;
        while (n2 < this.status.length) {
            this.status[n2].repairArmorAllCells(f2);
            ++n2;
        }
    }

    public void repairHullFraction(float f2) {
        int n2 = 0;
        while (n2 < this.status.length) {
            this.status[n2].repairHullFraction(f2);
            ++n2;
        }
    }

    public void repairFraction(float f2) {
        int n2 = 0;
        while (n2 < this.status.length) {
            this.status[n2].repairFraction(f2);
            ++n2;
        }
    }

    public void updateFromShip(Ship ship) {
        Ship[] shipArray;
        boolean[] blArray = new boolean[this.status.length];
        if (ship.isFighter() && ship.getWing() != null) {
            shipArray = new Ship[this.status.length];
            var4_4 = ship.getWing().getMembers();
            int n2 = 0;
            while (n2 < this.status.length) {
                if (n2 < var4_4.size()) {
                    shipArray[n2] = (Ship)var4_4.get(n2);
                    shipArray[n2].repairAndRearm();
                } else {
                    shipArray[n2] = null;
                }
                ++n2;
            }
        } else {
            var4_4 = FleetMemberStatus.getModuleSlotsFor(ship.getVariant());
            if (var4_4.isEmpty()) {
                shipArray = new Ship[]{ship};
            } else {
                shipArray = new Ship[1 + var4_4.size()];
                shipArray[0] = ship;
                Map<String, Ship> map = FleetMemberStatus.getAlreadyDeployedModulesFor(ship);
                int n3 = 0;
                while (n3 < var4_4.size()) {
                    Ship ship2;
                    String string = (String)var4_4.get(n3);
                    shipArray[n3 + 1] = ship2 = map.get(string);
                    blArray[n3 + 1] = this.status[n3 + 1].isDetached();
                    this.status[n3 + 1].detached = ship2 == null || ship2.getStationSlot() == null;
                    if (!this.status[n3 + 1].detached.booleanValue()) {
                        this.status[n3 + 1].detached = null;
                    }
                    this.status[n3 + 1].moduleSlotId = string;
                    ++n3;
                }
            }
        }
        int n4 = 0;
        while (n4 < this.status.length) {
            if (n4 < shipArray.length && !blArray[n4]) {
                this.status[n4].updateFromShip(shipArray[n4]);
            }
            ++n4;
        }
    }

    public void applyToShip(Ship ship, int n2) {
        this.status[n2].applyToShip(ship, n2);
    }

    public static List<String> getModuleSlotsFor(HullVariantSpec hullVariantSpec) {
        if (hullVariantSpec == null) {
            return new ArrayList<String>();
        }
        return hullVariantSpec.getModuleSlots();
    }

    public static Map<String, Ship> getAlreadyDeployedModulesFor(Ship ship) {
        HashMap<String, Ship> hashMap = new HashMap<String, Ship>();
        for (ShipAPI shipAPI : CombatEngine.getInstance().getShips()) {
            if (shipAPI == ship || shipAPI.getParentStation() != ship || shipAPI.getStationSlot() == null) continue;
            hashMap.put(shipAPI.getStationSlot().getId(), (Ship)shipAPI);
        }
        return hashMap;
    }

    public void updateFromAutoresolveData(com.fs.starfarer.campaign.OoOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.Object object) {
        if (object.\u00d4O0000() != this.member) {
            throw new RuntimeException("Member " + this.member + " is not equal to " + object.\u00d4O0000());
        }
        int n2 = 0;
        while (n2 < this.status.length) {
            this.status[n2].updateFromAutoresolveData(object, n2);
            ++n2;
        }
    }

    public void applyToAutoresolveData(com.fs.starfarer.campaign.OoOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.Object object) {
        float f2 = this.computeAverageArmorFraction();
        object.null(object.while() * this.getHullFraction() * f2);
    }

    public float computeAverageArmorFraction() {
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < this.status.length) {
            f2 += this.status[n2].computeAverageArmorFraction();
            ++n2;
        }
        return f2 / (float)this.status.length;
    }

    public ShipStatus getStatus(int n2) {
        return this.status[n2];
    }

    public int getStatusLength() {
        return this.status.length;
    }

    public static class ShipStatus
    implements DoNotObfuscate {
        private float hullFraction = 1.0f;
        private float[][] armorCellFractions;
        private int gridWidth;
        private int gridHeight;
        private FleetMemberStatus status;
        private Boolean detached = null;
        private Boolean permaDetached = null;
        private String moduleSlotId = null;
        private transient Map<String, Integer> ammoState = null;
        private float hullDamageTaken = 0.0f;
        private float armorDamageTaken = 0.0f;
        protected transient Boolean inactive = null;

        private ShipStatus(FleetMemberStatus fleetMemberStatus) {
            this.status = fleetMemberStatus;
        }

        protected void saveAmmoState(ShipAPI shipAPI) {
            if (shipAPI == null) {
                return;
            }
            this.ammoState = new LinkedHashMap<String, Integer>();
            for (WeaponAPI weaponAPI : shipAPI.getAllWeapons()) {
                if (!weaponAPI.usesAmmo() || !(weaponAPI.getAmmoPerSecond() <= 0.0f)) continue;
                this.ammoState.put(weaponAPI.getSlot().getId(), weaponAPI.getAmmo());
            }
        }

        protected void resetAmmoState() {
            this.ammoState = null;
        }

        public HullVariantSpec getVariant() {
            HullVariantSpec hullVariantSpec = this.status.member.getVariant();
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.status.status.length) {
                if (this.status.status[n3] == this) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (--n2 < 0 || n2 >= hullVariantSpec.getModuleSlots().size()) {
                return hullVariantSpec;
            }
            this.moduleSlotId = hullVariantSpec.getModuleSlots().get(n2);
            HullVariantSpec hullVariantSpec2 = hullVariantSpec.getModuleVariant(this.moduleSlotId);
            if (hullVariantSpec2 == null) {
                return hullVariantSpec;
            }
            return hullVariantSpec2;
        }

        public boolean isDetached() {
            return this.detached != null && this.detached != false;
        }

        public boolean isPermaDetached() {
            return this.permaDetached != null && this.permaDetached != false;
        }

        public String getModuleSlotId() {
            return this.moduleSlotId;
        }

        public float getHullFraction() {
            return this.hullFraction;
        }

        public float getHullDamageTaken() {
            return this.hullDamageTaken;
        }

        public float getArmorDamageTaken() {
            return this.armorDamageTaken;
        }

        public void resetDamageTaken() {
            this.hullDamageTaken = 0.0f;
            this.armorDamageTaken = 0.0f;
        }

        private boolean hasNoArmorData() {
            if (this.armorCellFractions == null) {
                return true;
            }
            if (this.armorCellFractions.length < 4 || this.armorCellFractions.length != this.gridWidth) {
                this.armorCellFractions = null;
                return true;
            }
            if (this.armorCellFractions[0].length < 4 || this.armorCellFractions[0].length != this.gridHeight) {
                this.armorCellFractions = null;
                return true;
            }
            return false;
        }

        public float computeAverageArmorFraction() {
            if (this.hasNoArmorData()) {
                return 1.0f;
            }
            float f2 = 0.0f;
            int n2 = 0;
            while (n2 < this.gridWidth) {
                int n3 = 0;
                while (n3 < this.gridHeight) {
                    f2 += this.armorCellFractions[n2][n3];
                    ++n3;
                }
                ++n2;
            }
            float f3 = f2 / (float)(this.gridWidth * this.gridHeight);
            return f3;
        }

        public void disable() {
            this.hullDamageTaken = this.hullFraction;
            this.hullFraction = 0.0f;
            if (this.hasNoArmorData()) {
                new new_ = new new(null, this.getVariant().getHullSpec());
                this.gridWidth = new_.getGridWidth();
                this.gridHeight = new_.getGridHeight();
                this.armorCellFractions = new float[this.gridWidth][this.gridHeight];
            }
            int n2 = 0;
            while (n2 < this.gridWidth) {
                int n3 = 0;
                while (n3 < this.gridHeight) {
                    this.armorCellFractions[n2][n3] = 0.0f;
                    ++n3;
                }
                ++n2;
            }
        }

        public void applyToShip(Ship ship, int n2) {
            Object object;
            if (ship == null) {
                return;
            }
            if (this.ammoState != null) {
                for (WeaponAPI weaponAPI : ship.getAllWeapons()) {
                    object = weaponAPI.getSlot().getId();
                    Integer n3 = this.ammoState.get(object);
                    if (n3 == null) continue;
                    weaponAPI.setAmmo(n3.intValue());
                }
            }
            ship.setHitpoints(ship.getMaxHitpoints() * this.hullFraction);
            ship.setHullLevelAtDeployment(ship.getHullLevel());
            if (this.hasNoArmorData()) {
                return;
            }
            int n4 = ship.getArmorGrid().getGridWidth();
            int n5 = ship.getArmorGrid().getGridHeight();
            if (n4 != this.gridWidth || n5 != this.gridHeight) {
                this.armorCellFractions = null;
                this.gridWidth = 0;
                this.gridHeight = 0;
                return;
            }
            object = ship.getArmorGrid().getGrid();
            float f2 = ship.getArmorGrid().getMaxArmorInCell();
            int n6 = 0;
            while (n6 < this.gridWidth) {
                int n7 = 0;
                while (n7 < this.gridHeight) {
                    object[n6][n7] = this.armorCellFractions[n6][n7] * f2;
                    ++n7;
                }
                ++n6;
            }
            ship.getDecalRenderer().\u00d800000();
            E.o00000(this.status.member, n2);
            ship.syncWithArmorGridState();
        }

        public void updateFromAutoresolveData(com.fs.starfarer.campaign.OoOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.Object object, int n2) {
            int n3;
            int n4;
            boolean bl;
            boolean bl2;
            FleetMember fleetMember = this.status.member;
            if (object.\u00d4O0000() != fleetMember) {
                throw new RuntimeException("Member " + fleetMember + " is not equal to " + object.\u00d4O0000());
            }
            float f2 = this.hullFraction;
            float f3 = object.new.super();
            if ((float)Math.random() > f3 && n2 != 0) {
                f3 = 0.0f;
            }
            if (f3 >= 1.0f) {
                return;
            }
            boolean bl3 = bl2 = f3 <= 0.0f;
            if (f3 > this.hullFraction) {
                f3 = this.hullFraction;
            }
            if (f3 > 0.75f) {
                this.hullFraction = 1.0f;
                bl = false;
            } else {
                this.hullFraction = f3 / 0.75f;
                bl = true;
            }
            if (this.hullFraction < 0.0f) {
                this.hullFraction = 0.0f;
            }
            if (this.hullFraction >= 1.0f) {
                this.hullFraction = 1.0f;
            }
            this.hullDamageTaken = Math.max(this.hullDamageTaken, f2 - this.hullFraction);
            new new_ = new new(null, this.getVariant().getHullSpec());
            this.gridWidth = new_.getGridWidth();
            this.gridHeight = new_.getGridHeight();
            if (this.hasNoArmorData()) {
                this.armorCellFractions = new float[this.gridWidth][this.gridHeight];
                n4 = 0;
                while (n4 < this.gridWidth) {
                    n3 = 0;
                    while (n3 < this.gridHeight) {
                        this.armorCellFractions[n4][n3] = 1.0f;
                        ++n3;
                    }
                    ++n4;
                }
            }
            n4 = 1 + (int)((float)Math.random() * (float)this.getVariant().getHullSpec().getHullSize().ordinal());
            if (this.getVariant().getHullSpec().getHullSize().ordinal() >= ShipAPI.HullSize.CRUISER.ordinal()) {
                ++n4;
            }
            if (bl2) {
                n4 = (int)((float)n4 * 2.0f);
            }
            if (this.gridWidth < 4 || this.gridHeight < 4) {
                return;
            }
            n3 = 0;
            while (n3 < n4) {
                float f4 = bl ? 1.0f : (1.0f - f3) / 0.25f * Math.max((float)Math.random() - 0.25f, 0.0f);
                int n5 = (int)(Math.random() * (double)(this.gridWidth - 4) + 2.0);
                int n6 = (int)(Math.random() * (double)(this.gridHeight - 4) + 2.0);
                if (n5 >= 2 && n6 >= 2 && n5 < this.gridWidth - 2 && n6 < this.gridHeight - 2) {
                    int n7 = n5 - 2;
                    while (n7 <= n5 + 2) {
                        int n8 = n6 - 2;
                        while (n8 <= n6 + 2) {
                            float f5 = this.armorCellFractions[n7][n8];
                            float f6 = n7 == 0 && n8 == 0 ? 1.0f - f4 : (n7 % 2 == 0 && n8 % 2 == 0 ? 1.0f - f4 * 0.5f : 1.0f - f4 * 1.0f);
                            if (f6 < 0.0f) {
                                f6 = 0.0f;
                            }
                            if (f6 < f5) {
                                this.armorCellFractions[n7][n8] = f6;
                            }
                            ++n8;
                        }
                        ++n7;
                    }
                }
                ++n3;
            }
        }

        public void applyHullFractionDamage(float f2) {
            float f3 = this.status.member.getStats().getArmorBonus().computeEffective(this.getVariant().getHullSpec().getArmorSpec().\u00d300000());
            this.applyDamage(f3 * 2.0f, f2);
        }

        public void applyDamage(float f2) {
            this.applyDamage(f2, 0.0f);
        }

        public void applyDamage(float f2, float f3) {
            if (this.gridWidth == 0 || this.gridHeight == 0) {
                new new_ = new new(null, this.getVariant().getHullSpec());
                this.gridWidth = new_.getGridWidth();
                this.gridHeight = new_.getGridHeight();
            }
            int n2 = (int)(Math.random() * (double)(this.gridWidth - 4) + 2.0);
            int n3 = (int)(Math.random() * (double)(this.gridHeight - 4) + 2.0);
            if (this.status.random != null) {
                n2 = (int)(this.status.random.nextDouble() * (double)(this.gridWidth - 4) + 2.0);
                n3 = (int)(this.status.random.nextDouble() * (double)(this.gridHeight - 4) + 2.0);
            }
            if (n2 < 2 || n3 < 2) {
                return;
            }
            if (n2 >= this.gridWidth - 2) {
                return;
            }
            if (n3 >= this.gridHeight - 2) {
                return;
            }
            if (this.hasNoArmorData()) {
                this.armorCellFractions = new float[this.gridWidth][this.gridHeight];
                int n4 = 0;
                while (n4 < this.gridWidth) {
                    int n5 = 0;
                    while (n5 < this.gridHeight) {
                        this.armorCellFractions[n4][n5] = 1.0f;
                        ++n5;
                    }
                    ++n4;
                }
            }
            float f4 = this.status.member.getStats().getArmorBonus().computeEffective(this.getVariant().getHullSpec().getArmorSpec().\u00d300000());
            float f5 = this.status.member.getStats().getArmorDamageTakenMult().getModifiedValue();
            f2 *= f5;
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            float f6 = this.armorCellFractions[n2][n3];
            float f7 = f6 * f4;
            float f8 = 0.0f;
            float f9 = new.computeDamageMultiplier(f2, f7) * f2;
            int n6 = n2 - 2;
            while (n6 <= n2 + 2) {
                int n7 = n3 - 2;
                while (n7 <= n3 + 2) {
                    if (n6 != n2 - 2 && n6 != n2 + 2 || n7 != n3 - 2 && n7 != n3 + 2) {
                        float f10 = f9;
                        f10 = n6 == 0 && n7 == 0 ? (f10 *= 0.06666667f) : (n6 % 2 == 0 && n7 % 2 == 0 ? (f10 *= 0.06666667f) : (f10 *= 0.033333335f));
                        float f11 = this.armorCellFractions[n6][n7];
                        float f12 = f11 * f4 * 0.06666667f;
                        f12 -= f10;
                        if (f12 < 0.0f) {
                            f8 -= f12;
                            f12 = 0.0f;
                        }
                        this.armorCellFractions[n6][n7] = f12 / f4;
                    }
                    ++n7;
                }
                ++n6;
            }
            float f13 = this.status.member.getStats().getHullBonus().computeEffective(this.getVariant().getHullSpec().getArmorSpec().o00000());
            if (f13 < 1.0f) {
                f13 = 1.0f;
            }
            float f14 = this.status.member.getStats().getHullDamageTakenMult().getModifiedValue();
            f8 *= f14;
            if (f3 > 0.0f) {
                f8 = f13 * f3;
            }
            this.hullDamageTaken += Math.min(this.hullFraction, f8 / f13);
            this.hullFraction -= f8 / f13;
            if (this.hullFraction < 0.0f) {
                this.hullFraction = 0.0f;
            }
        }

        public void updateFromShip(Ship ship) {
            if (ship != null) {
                this.saveAmmoState(ship);
                float f2 = this.hullFraction;
                float f3 = this.computeAverageArmorFraction();
                this.hullFraction = ship.getHitpoints() / ship.getMaxHitpoints();
                if (this.hullFraction <= 0.0f) {
                    this.hullFraction = 0.0f;
                }
                if (this.hullFraction >= 1.0f) {
                    this.hullFraction = 1.0f;
                }
                this.hullDamageTaken = Math.max(this.hullDamageTaken, f2 - this.hullFraction);
                this.gridWidth = ship.getArmorGrid().getGridWidth();
                this.gridHeight = ship.getArmorGrid().getGridHeight();
                float[][] fArray = ship.getArmorGrid().getGrid();
                float f4 = ship.getArmorGrid().getMaxArmorInCell();
                this.armorCellFractions = new float[this.gridWidth][this.gridHeight];
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.gridWidth) {
                    int n3 = 0;
                    while (n3 < this.gridHeight) {
                        this.armorCellFractions[n2][n3] = fArray[n2][n3] / f4;
                        if (this.armorCellFractions[n2][n3] != 1.0f) {
                            bl = true;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                this.armorDamageTaken = Math.max(this.armorDamageTaken, f3 - this.computeAverageArmorFraction());
                if (!bl) {
                    this.armorCellFractions = null;
                }
            } else {
                this.resetAmmoState();
                float f5 = this.hullFraction;
                this.hullFraction = 0.0f;
                this.hullDamageTaken = Math.max(this.hullDamageTaken, f5 - this.hullFraction);
                new new_ = new new(null, this.getVariant().getHullSpec());
                this.gridWidth = new_.getGridWidth();
                this.gridHeight = new_.getGridHeight();
                this.armorCellFractions = new float[this.gridWidth][this.gridHeight];
                boolean bl = false;
                int n4 = 0;
                while (n4 < this.gridWidth) {
                    int n5 = 0;
                    while (n5 < this.gridHeight) {
                        this.armorCellFractions[n4][n5] = 0.0f;
                        ++n5;
                    }
                    ++n4;
                }
            }
        }

        public void setHullFraction(float f2) {
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 >= 1.0f) {
                f2 = 1.0f;
            }
            this.hullFraction = f2;
        }

        public void repair(float f2) {
            if (this.isPermaDetached()) {
                return;
            }
            if (this.hullNeedsRepair()) {
                this.repairHull(f2);
            } else if (this.armorNeedsRepair()) {
                this.repairArmor(f2);
            }
        }

        public void repairFraction(float f2) {
            if (this.isPermaDetached()) {
                return;
            }
            if (this.hullNeedsRepair()) {
                this.repairHullFraction(f2);
            } else {
                this.detached = null;
            }
            if (this.armorNeedsRepair()) {
                this.repairArmorFraction(f2);
            }
        }

        public boolean needsRepair() {
            return this.hullNeedsRepair() || this.armorNeedsRepair();
        }

        public boolean hullNeedsRepair() {
            return this.hullFraction < 1.0f;
        }

        public boolean armorNeedsRepair() {
            return this.armorCellFractions != null;
        }

        public void repairHull(float f2) {
            if (this.isPermaDetached()) {
                return;
            }
            float f3 = 10.0f;
            this.setHullFraction(this.hullFraction + f3 * f2);
            if (this.hullFraction >= this.getAttachThreshold() && this.detached != null) {
                this.detached = null;
            }
        }

        public float getAttachThreshold() {
            if (this.isInactiveModule()) {
                return 0.75f;
            }
            return 0.25f;
        }

        public boolean isInactiveModule() {
            if (this.inactive == null) {
                HullVariantSpec hullVariantSpec = this.status.member.getVariant().getModuleVariant(this.moduleSlotId);
                this.inactive = hullVariantSpec != null ? Boolean.valueOf(!Misc.isActiveModule((ShipVariantAPI)hullVariantSpec)) : Boolean.valueOf(false);
            }
            return this.inactive;
        }

        public void repairArmor(float f2) {
            if (this.hasNoArmorData()) {
                return;
            }
            if (this.isPermaDetached()) {
                return;
            }
            float f3 = 10.0f;
            float f4 = f3 * f2 * (float)(this.gridWidth * this.gridHeight);
            this.repairArmorUsingCapacity(f4);
        }

        public void repairArmorFraction(float f2) {
            float f3 = f2 * (float)(this.gridWidth * this.gridHeight);
            this.repairArmorUsingCapacity(f3);
        }

        public void repairHullFraction(float f2) {
            this.setHullFraction(this.hullFraction + f2);
            if (this.hullFraction >= this.getAttachThreshold() && this.detached != null) {
                this.detached = null;
            }
        }

        public void repairArmorUsingCapacity(float f2) {
            if (this.isPermaDetached()) {
                return;
            }
            boolean bl = false;
            int n2 = this.gridHeight - 1;
            block0: while (n2 >= 0) {
                int n3 = 0;
                while (n3 < this.gridWidth) {
                    float f3 = 1.0f - this.armorCellFractions[n3][n2];
                    if (!(f3 <= 0.0f)) {
                        float f4 = Math.min(f3, f2);
                        float[] fArray = this.armorCellFractions[n3];
                        int n4 = n2;
                        fArray[n4] = fArray[n4] + f4;
                        if (this.armorCellFractions[n3][n2] > 1.0f) {
                            this.armorCellFractions[n3][n2] = 1.0f;
                        }
                        if ((f2 -= f4) <= 0.0f) {
                            bl = true;
                            break block0;
                        }
                    }
                    ++n3;
                }
                --n2;
            }
            if (!bl) {
                this.armorCellFractions = null;
                this.gridHeight = 0;
                this.gridWidth = 0;
            }
        }

        public void repairArmorAllCells(float f2) {
            if (this.armorCellFractions == null) {
                return;
            }
            boolean bl = false;
            float f3 = f2 * (float)(this.gridWidth * this.gridHeight);
            int n2 = this.gridHeight - 1;
            while (n2 >= 0) {
                int n3 = 0;
                while (n3 < this.gridWidth) {
                    float f4 = 1.0f - this.armorCellFractions[n3][n2];
                    if (!(f4 <= 0.0f)) {
                        float f5 = Math.min(f4, f2);
                        float[] fArray = this.armorCellFractions[n3];
                        int n4 = n2;
                        fArray[n4] = fArray[n4] + f5;
                        if (this.armorCellFractions[n3][n2] > 1.0f) {
                            this.armorCellFractions[n3][n2] = 1.0f;
                        }
                        bl |= f5 < f4;
                        f3 -= f5;
                    }
                    ++n3;
                }
                --n2;
            }
            if (!bl) {
                this.armorCellFractions = null;
                this.gridHeight = 0;
                this.gridWidth = 0;
            } else if (f3 > 0.0f) {
                this.repairArmorUsingCapacity(f3);
            }
        }
    }
}

