/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.E.new.C;
import com.fs.starfarer.String.L;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.combat.CombatReadinessPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.RepairTrackerAPI;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignState;
import com.fs.starfarer.campaign.comms.C;
import com.fs.starfarer.campaign.fleet.FleetMember;
import com.fs.starfarer.campaign.fleet.FleetMemberStatus;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class RepairTracker
implements DoNotObfuscate,
RepairTrackerAPI {
    private static Logger log = Logger.getLogger(RepairTracker.class);
    private float cr = 0.5f;
    private float crPriorToMothballing = 0.0f;
    private FleetMember member;
    private List<RepairTrackerAPI.CREvent> noSuppliesCRLoss = new ArrayList<RepairTrackerAPI.CREvent>();
    private List<RepairTrackerAPI.CREvent> recentEvents = new ArrayList<RepairTrackerAPI.CREvent>();
    private transient float recoveryRate;
    private transient float decreaseRate;
    private boolean suspendRepairs = false;
    private boolean mothballed = false;
    private transient boolean crashMothballed = false;
    private boolean losingCR = false;
    private transient Float crOverride = null;

    public RepairTracker(FleetMember fleetMember) {
        this.member = fleetMember;
    }

    Object readResolve() {
        if (this.noSuppliesCRLoss == null) {
            this.noSuppliesCRLoss = new ArrayList<RepairTrackerAPI.CREvent>();
        }
        return this;
    }

    Object writeReplace() {
        if (this.noSuppliesCRLoss != null && this.noSuppliesCRLoss.isEmpty()) {
            this.noSuppliesCRLoss = null;
        }
        if (this.recentEvents != null && this.member.getFleetData() != null && this.member.getFleetData().getFleet() != null && !this.member.getFleetData().getFleet().isPlayerFleet()) {
            this.recentEvents = null;
        }
        if (this.recentEvents != null && this.recentEvents.isEmpty()) {
            this.recentEvents = null;
        }
        return this;
    }

    public void updateRates() {
        float f2;
        this.recoveryRate = f2 = this.member.getStats().getBaseCRRecoveryRatePercentPerDay().getModifiedValue() * 0.01f;
        this.decreaseRate = this.member.getStats().getBaseCRRecoveryRatePercentPerDay().getBaseValue() * 0.01f * 0.5f;
    }

    public float getRecoveryRate() {
        return this.recoveryRate;
    }

    public float getDecreaseRate() {
        if (this.getBaseCR() <= 0.0f) {
            return 0.0f;
        }
        return this.decreaseRate;
    }

    public boolean suspendAndFighter() {
        return this.member.isFighterWing() && this.isSuspendRepairs();
    }

    public float getDaysToRecoverFullCR() {
        float f2 = this.getMaxCR() - this.cr;
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (this.recoveryRate <= 0.0f) {
            return 0.0f;
        }
        return f2 / this.recoveryRate;
    }

    public boolean isLosingCR() {
        return this.losingCR;
    }

    public void advanceCRAndRepairs(float f2, boolean bl) {
        float f3;
        if (this.member.getFleetData() == null) {
            return;
        }
        float f4 = this.getMaxCR();
        if (f2 > 0.0f) {
            this.crPriorToMothballing = 0.0f;
            this.crashMothballed = false;
        }
        this.updateRates();
        if (!this.member.isMothballed()) {
            f3 = 1.0f;
            if (f3 <= 0.0f) {
                f3 = 0.01f;
            }
            if (this.cr * f3 > f4 || !bl) {
                boolean bl2;
                float f5 = this.decreaseRate * f2;
                this.cr -= f5;
                if (!bl) {
                    RepairTrackerAPI.CREvent cREvent = null;
                    if (!this.getNoSuppliesCRLoss().isEmpty()) {
                        cREvent = this.getNoSuppliesCRLoss().get(this.getNoSuppliesCRLoss().size() - 1);
                    }
                    if (cREvent == null || cREvent.elapsed >= 1.0f) {
                        cREvent = new RepairTrackerAPI.CREvent(0.0f, "Lack of supplies for maintenance");
                        this.getNoSuppliesCRLoss().add(cREvent);
                    }
                    cREvent.crAmount -= f5 + Math.min(0.0f, this.cr);
                }
                boolean bl3 = bl2 = f2 > 0.0f && this.member.getCaptain() != null && this.member.getCaptain().isAICore();
                if (bl2 && this.cr * f3 > f4) {
                    this.cr = f4 / f3;
                }
                if (this.cr * f3 < f4 && bl) {
                    this.cr = f4 / f3;
                }
                this.losingCR = true;
            } else if (this.cr * f3 < f4 && bl && !this.member.isSuspendRepairs()) {
                this.cr += this.recoveryRate * f2;
                if (this.cr * f3 > f4) {
                    this.cr = f4 / f3;
                }
                this.losingCR = false;
            } else {
                this.losingCR = false;
            }
            if (this.cr < 0.0f) {
                this.cr = 0.0f;
            }
            if (this.cr > 1.0f) {
                this.cr = 1.0f;
            }
        }
        if (bl && this.member.needsRepairs() && this.member.canBeRepaired()) {
            f3 = this.getRepairRatePerDay();
            this.performRepairsFraction(f2 * f3);
        }
        Iterator<RepairTrackerAPI.CREvent> iterator = this.getRecentEvents().iterator();
        while (iterator.hasNext()) {
            RepairTrackerAPI.CREvent cREvent = iterator.next();
            cREvent.advance(f2);
            if (!cREvent.isExpired()) continue;
            iterator.remove();
        }
        iterator = this.getNoSuppliesCRLoss().iterator();
        while (iterator.hasNext()) {
            RepairTrackerAPI.CREvent cREvent = iterator.next();
            cREvent.advance(f2);
            if (!cREvent.isExpired()) continue;
            iterator.remove();
        }
    }

    private List<RepairTrackerAPI.CREvent> getNoSuppliesCRLoss() {
        if (this.noSuppliesCRLoss == null) {
            this.noSuppliesCRLoss = new ArrayList<RepairTrackerAPI.CREvent>();
        }
        return this.noSuppliesCRLoss;
    }

    public float getRepairRatePerDay() {
        float f2;
        float f3 = this.member.getStats().getRepairRatePercentPerDay().getModifiedValue() / 100.0f;
        if (this.member.getFleetCommander() != null) {
            f2 = this.member.getFleetCommander().getStats().getRepairRateMult().getModifiedValue();
            f3 *= f2;
        }
        f2 = this.member.getCrewFraction();
        return f3 *= f2;
    }

    public float getRepairRatePerDayAtFullCrew() {
        float f2 = this.member.getStats().getRepairRatePercentPerDay().getModifiedValue() / 100.0f;
        if (this.member.getFleetCommander() != null) {
            float f3 = this.member.getFleetCommander().getStats().getRepairRateMult().getModifiedValue();
            f2 *= f3;
        }
        return f2;
    }

    public float getMaxCR() {
        return Math.max(0.0f, Math.min(1.0f, this.member.getStats().getMaxCombatReadiness().getModifiedValue()));
    }

    public float getSuppliesFromScuttling() {
        float f2 = Math.round(this.member.getSuppliesPerPercentCR() * this.getBaseCR() * 100.0f);
        return Math.max(this.member.getUnmodifiedDeploymentPointsCost() + f2, 1.0f);
    }

    public float getFuelFromScuttling() {
        return Math.max(this.getSuppliesFromScuttling(), 1.0f);
    }

    public float getHeavyMachineryFromScuttling() {
        return Math.max(this.getSuppliesFromScuttling() * 0.25f, 1.0f);
    }

    public void applyCREvent(float f2, String string, String string2) {
        RepairTrackerAPI.CREvent cREvent = null;
        for (RepairTrackerAPI.CREvent cREvent2 : this.getRecentEvents()) {
            if (cREvent2.id == null || !cREvent2.id.equals(string)) continue;
            this.getRecentEvents().remove(cREvent2);
            this.getRecentEvents().add(cREvent2);
            cREvent = cREvent2;
            break;
        }
        if (cREvent == null) {
            cREvent = new RepairTrackerAPI.CREvent(0.0f, string2);
            cREvent.id = string;
            this.getRecentEvents().add(cREvent);
        }
        cREvent.crAmount += f2;
        cREvent.elapsed = 0.0f;
        this.cr += f2;
        if (this.cr < 0.0f) {
            this.cr = 0.0f;
        }
        if (this.cr > 1.0f) {
            this.cr = 1.0f;
        }
    }

    public void applyCREvent(float f2, String string) {
        RepairTrackerAPI.CREvent cREvent = new RepairTrackerAPI.CREvent(f2, string);
        this.getRecentEvents().add(cREvent);
        this.cr += f2;
        if (this.cr < 0.0f) {
            this.cr = 0.0f;
        }
        if (this.cr > 1.0f) {
            this.cr = 1.0f;
        }
    }

    public float getCR() {
        if (this.crOverride != null) {
            return this.crOverride.floatValue();
        }
        return this.cr * this.member.getCrewFraction();
    }

    public float getBaseCR() {
        return this.cr;
    }

    public Float getCROverride() {
        return this.crOverride;
    }

    public void setCROverride(Float f2) {
        this.crOverride = f2;
    }

    public void setCR(float f2) {
        this.cr = f2;
    }

    public FleetMember getMember() {
        return this.member;
    }

    public List<RepairTrackerAPI.CREvent> getRecentEvents() {
        if (this.recentEvents == null) {
            this.recentEvents = new ArrayList<RepairTrackerAPI.CREvent>();
        }
        return this.recentEvents;
    }

    public RepairTrackerAPI.CREvent getNoSupplyCRLossEvent() {
        if (this.getNoSuppliesCRLoss().isEmpty()) {
            return null;
        }
        RepairTrackerAPI.CREvent cREvent = new RepairTrackerAPI.CREvent(0.0f, this.getNoSuppliesCRLoss().get((int)0).text);
        for (RepairTrackerAPI.CREvent cREvent2 : this.getNoSuppliesCRLoss()) {
            cREvent.crAmount += cREvent2.crAmount;
        }
        if (cREvent.crAmount <= 0.0f) {
            return null;
        }
        return cREvent;
    }

    public static void applyCRToStats(float f2, MutableShipStatsAPI mutableShipStatsAPI, ShipAPI.HullSize hullSize) {
        CombatReadinessPlugin combatReadinessPlugin = (CombatReadinessPlugin)StarfarerSettings.\u00d600000("combatReadinessPlugin");
        combatReadinessPlugin.applyCRToStats(f2, mutableShipStatsAPI, hullSize);
    }

    public static void applyCRToShip(float f2, Ship ship) {
        CombatReadinessPlugin combatReadinessPlugin = (CombatReadinessPlugin)StarfarerSettings.\u00d600000("combatReadinessPlugin");
        combatReadinessPlugin.applyCRToShip(f2, (ShipAPI)ship);
    }

    public static List<C.Oo> getCRStatusDataForShip(Ship ship) {
        CombatReadinessPlugin combatReadinessPlugin = (CombatReadinessPlugin)StarfarerSettings.\u00d600000("combatReadinessPlugin");
        List list = combatReadinessPlugin.getCRStatusDataForShip((ShipAPI)ship);
        ArrayList<C.Oo> arrayList = new ArrayList<C.Oo>();
        for (CombatReadinessPlugin.CRStatusItemData cRStatusItemData : list) {
            C.Oo oo2 = new C.Oo(cRStatusItemData.getIdToken(), cRStatusItemData.getIconName(), cRStatusItemData.getTitle(), cRStatusItemData.getText(), cRStatusItemData.isDebuff());
            arrayList.add(oo2);
        }
        return arrayList;
    }

    public boolean isSuspendRepairs() {
        return this.suspendRepairs;
    }

    public void setSuspendRepairs(boolean bl) {
        this.suspendRepairs = bl;
    }

    public void performRepairsFraction(float f2) {
        FleetMemberStatus fleetMemberStatus = this.member.getStatus();
        if (!fleetMemberStatus.needsRepairs()) {
            return;
        }
        fleetMemberStatus.repairFraction(f2);
        if (this.member.getFleetData() == CampaignEngine.getInstance().getPlayerFleet().getFleetData() && !this.member.getStatus().needsRepairs()) {
            this.showRepairsCompleteMessage();
        }
    }

    public void showRepairsCompleteMessage() {
        CampaignState campaignState;
        String string = "repairs_finished";
        boolean bl = false;
        if (Global.getSector().getCampaignUI() instanceof CampaignState) {
            campaignState = (CampaignState)Global.getSector().getCampaignUI();
            for (C c2 : campaignState.getMessageList().getMessages()) {
                MessageIntel messageIntel;
                if (!(c2.getIntel() instanceof MessageIntel) || (messageIntel = (MessageIntel)c2.getIntel()).getExtra() == null || !messageIntel.getExtra().startsWith(string)) continue;
                try {
                    int n2 = Integer.parseInt(messageIntel.getExtra().split(":")[1]);
                    messageIntel.setExtra(String.valueOf(string) + ":" + ++n2);
                    messageIntel.clearLines();
                    messageIntel.addLine("Repairs completed (" + n2 + " ships)", Misc.getBasePlayerColor(), new String[]{"" + n2}, new Color[]{Misc.getHighlightColor()});
                    c2.setCustom(this.member);
                    c2.recreate();
                    c2.setElapsed(0.0f);
                    c2.getFader().forceIn();
                    bl = true;
                    String string2 = messageIntel.getCommMessageSound();
                    if (string2 == null) continue;
                    L.o00000(string2, 1.0f, 1.0f);
                }
                catch (Throwable throwable) {
                    log.error((Object)throwable.getMessage(), throwable);
                }
            }
        }
        if (!bl) {
            campaignState = new MessageIntel(String.valueOf(this.member.getShipName()) + " - repairs completed", Misc.getBasePlayerColor());
            campaignState.setExtra(String.valueOf(string) + ":1");
            campaignState.setIcon(Global.getSettings().getSpriteName("intel", "repairs_finished"));
            Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)campaignState, CommMessageAPI.MessageClickAction.REFIT_TAB, (Object)this.member);
        }
    }

    public float getRemainingRepairTime() {
        float f2 = this.member.getStatus().getHullFraction();
        float f3 = this.member.getStatus().computeAverageArmorFraction();
        return (1.0f - Math.min(f3, f2)) / this.getRepairRatePerDay();
    }

    public float getRemainingRepairTimeAtFullCrew() {
        float f2 = this.member.getStatus().getHullFraction();
        float f3 = this.member.getStatus().computeAverageArmorFraction();
        return (1.0f - Math.min(f3, f2)) / this.getRepairRatePerDayAtFullCrew();
    }

    public float getRemainingRepairAndRecoveryTime() {
        return Math.max(this.getRemainingRepairTime(), this.getDaysToRecoverFullCR());
    }

    public float getRecoveryTimeForCRFraction(float f2) {
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (this.recoveryRate <= 0.0f) {
            return 0.0f;
        }
        return f2 / this.recoveryRate;
    }

    public float getRemainingRepairAndRecoveryTimeIgnoringLR() {
        float f2 = 1000.0f;
        float f3 = Math.max(this.getRemainingRepairTimeAtFullCrew(), this.getDaysToRecoverFullCR());
        if (f2 < f3) {
            f3 = f2;
        }
        return f3;
    }

    public float computeRepairednessFraction() {
        return Math.min(this.member.getStatus().getHullFraction(), this.member.getStatus().computeAverageArmorFraction());
    }

    public boolean isMothballed() {
        return this.mothballed;
    }

    public void setMothballed(boolean bl) {
        boolean bl2 = this.mothballed ^ bl;
        this.mothballed = bl;
        if (bl2) {
            if (this.mothballed) {
                this.crPriorToMothballing = this.cr;
                this.cr = 0.0f;
            } else {
                this.cr = this.crPriorToMothballing;
            }
            this.member.updateStats();
            if (this.member.getFleetData() != null) {
                this.member.getFleetData().setSyncNeeded();
            }
        }
    }

    public float getCRPriorToMothballing() {
        return this.crPriorToMothballing;
    }

    public void setCRPriorToMothballing(float f2) {
        this.crPriorToMothballing = f2;
    }

    public boolean isCrashMothballed() {
        return this.crashMothballed;
    }

    public void setCrashMothballed(boolean bl) {
        this.crashMothballed = bl;
    }
}

