/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai.missile;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.TimeoutTrackerMap;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.E.B;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.ai.Oo0O;
import com.fs.starfarer.combat.ai.float;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.util.IntervalTracker;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MissileTwoStageSecondUnguidedAI
implements AI,
GuidedMissileAI,
MissileAIPlugin {
    private Missile missile;
    private Vector2f targetPoint;
    private float launchAngle;
    private B target;
    private o currTask = null;
    private float timeSpent = 0.0f;
    private float timeAlotted = 0.0f;
    private boolean isPd = false;
    private float projSpeedOverride = -1.0f;
    private boolean directAim = false;
    private float zeroOffsetRange = 100.0f;
    private IntervalTracker pcoTracker = new IntervalTracker(1.0f, 3.0f);
    private float pursueCourseOffset;
    private boolean pickedSpreadOffset = false;
    private float spreadOffsetMult = 0.0f;
    private float seekElapsed = 0.0f;
    private float fixedHeading;

    public MissileTwoStageSecondUnguidedAI(Missile missile, Vector2f vector2f, boolean bl) {
        Object object;
        TimeoutTrackerMap<Object, Object> timeoutTrackerMap;
        this.missile = missile;
        this.targetPoint = vector2f;
        this.isPd = bl;
        Ship ship = missile.getSource().getShipTarget();
        String string = "burstTarget_" + missile.getWeapon().getId() + "_" + missile.getWeapon().getSlot().getId();
        if (missile.getSource() != null) {
            string = missile.getSource() + "_" + string;
        }
        if ((timeoutTrackerMap = CombatEngine.getInstance().getCustomDataWithTimeout()).contains((Object)string) && ship == null && (object = timeoutTrackerMap.getItem((Object)string)) instanceof Ship) {
            ship = (Ship)object;
        }
        if (!bl) {
            this.target = ship;
        }
        if (this.target == null) {
            if (vector2f != null) {
                if (bl) {
                    this.target = Oo0O.o00000(vector2f, missile.getOwner(), CollisionClass.MISSILE_FF, CollisionClass.MISSILE_NO_FF, CollisionClass.FIGHTER, CollisionClass.SHIP);
                } else {
                    this.target = Oo0O.o00000(vector2f, missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP);
                    this.target = Oo0O.o00000(vector2f, missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP);
                }
            } else {
                this.target = Oo0O.o00000(missile.getLocation(), missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP);
            }
        }
        if (this.target != null && missile.getWeapon().getSpec().getBurstSize() > 1 && this.target instanceof Ship) {
            timeoutTrackerMap.add((Object)string, (Object)this.target, 1.0f, 1.0f);
        }
        this.updateCourseOffset();
    }

    public float getZeroOffsetRange() {
        return this.zeroOffsetRange;
    }

    public void setZeroOffsetRange(float f2) {
        this.zeroOffsetRange = f2;
    }

    public boolean isDirectAim() {
        return this.directAim;
    }

    public void setDirectAim(boolean bl) {
        this.directAim = bl;
    }

    private void updateCourseOffset() {
        float f2 = 15.0f;
        this.pursueCourseOffset = (f2 + f2 * (float)Math.random()) * Utils.super();
        if (this.directAim) {
            this.pursueCourseOffset = 0.0f;
        }
        if (this.target != null) {
            float f3 = Math.max(10.0f, this.missile.getAcceleration());
            float f4 = this.missile.getMaxSpeed();
            float f5 = f4 * f4 / f3 / 2.0f + this.zeroOffsetRange;
            float f6 = Utils.void(this.target.getLocation(), this.missile.getLocation());
            if (f6 + this.target.getCollisionRadius() < f5) {
                this.pursueCourseOffset = 0.0f;
            }
        }
    }

    @Override
    public void advance(float f2) {
        if (this.missile.isFizzling()) {
            return;
        }
        this.pcoTracker.advance(f2);
        if (this.pcoTracker.intervalElapsed()) {
            this.updateCourseOffset();
        }
        if (this.currTask == null) {
            this.currTask = o.\u00d500000;
        }
        if (this.currTask == o.return) {
            this.initialStage();
        } else if (this.currTask == o.\u00d500000) {
            this.acquireAndPrepare();
        } else if (this.currTask == o.Object || this.currTask == o.\u00d400000) {
            this.seekTarget(f2);
        } else if (this.currTask == o.\u00d200000) {
            if ((float)Math.random() < 0.016f) {
                this.currTask = o.\u00d500000;
            }
            this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
        }
        this.timeSpent += f2;
        if (this.timeSpent >= this.timeAlotted && this.currTask == o.return) {
            this.currTask = o.\u00d500000;
        }
    }

    private void seekTarget(float f2) {
        float f3;
        float f4;
        float f5;
        if (this.target instanceof Ship && ((Ship)this.target).isPhased()) {
            this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
            this.currTask = o.\u00d400000;
            this.fixedHeading = this.missile.getFacing();
        }
        if (!this.isTargetValid() || this.currTask == o.\u00d400000) {
            this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
            Oo0O.o00000((float)this.missile, 0.0f, this.fixedHeading, 0.0f);
            return;
        }
        this.seekElapsed += f2;
        Vector2f vector2f = new Vector2f((ReadableVector2f)this.target.getLocation());
        float f6 = Math.min(1.0f, this.missile.getGuidanceBonus());
        vector2f = this.projSpeedOverride > 0.0f ? Oo0O.o00000((B)this.missile, 1.5f - f6 * 0.5f, this.target, this.projSpeedOverride, true) : Oo0O.o00000((B)this.missile, 1.5f - f6 * 0.5f, this.target, this.missile.getMaxSpeed(), true);
        if (this.missile.getWeapon() != null && this.missile.getWeapon().hasAIHint(WeaponAPI.AIHints.MISSILE_SPREAD)) {
            f5 = Misc.getAngleInDegrees((Vector2f)this.target.getLocation(), (Vector2f)this.missile.getLocation());
            Vector2f vector2f2 = Misc.getUnitVectorAtDegreeAngle((float)(f5 += 90.0f));
            vector2f2.scale(this.target.getCollisionRadius() + 1000.0f);
            Vector2f.add((Vector2f)vector2f2, (Vector2f)vector2f, (Vector2f)vector2f2);
            f4 = Oo0O.o00000(vector2f2, this.target, false);
            f3 = f4 * 0.67f;
            if (!this.pickedSpreadOffset) {
                this.pickedSpreadOffset = true;
                this.spreadOffsetMult = ((float)Math.random() - 0.5f) * 2.0f;
            }
            Vector2f vector2f3 = Misc.getUnitVectorAtDegreeAngle((float)f5);
            vector2f3.scale(this.spreadOffsetMult * f3);
            Vector2f.add((Vector2f)vector2f, (Vector2f)vector2f3, (Vector2f)vector2f);
        }
        if ((f5 = Utils.\u00d200000(this.missile.getFacing(), this.missile.getLocation(), vector2f)) < 1.0f && this.seekElapsed > 0.5f || this.seekElapsed > 3.0f) {
            this.currTask = o.\u00d400000;
            this.fixedHeading = this.missile.getFacing();
            this.seekTarget(f2);
            return;
        }
        this.missile.setFlightTime(0.0f);
        float f7 = Utils.\u00d200000(this.missile.getFacing(), new Vector2f(0.0f, 0.0f), this.missile.getVelocity());
        f4 = Utils.void(this.target.getLocation(), this.missile.getLocation());
        f3 = Math.max(10.0f, this.missile.getAcceleration());
        float f8 = this.missile.getMaxSpeed();
        float f9 = Oo0O.o00000(this.target, this.missile.getLocation(), new Vector2f());
        if (f9 > 0.0f) {
            f8 += f9;
        }
        float f10 = f8 * f8 / f3 / 2.0f + this.zeroOffsetRange;
        float f11 = f8 * f8 / f3 * 2.0f + this.zeroOffsetRange;
        float f12 = Utils.\u00d300000(this.missile.getLocation(), vector2f);
        float f13 = f4 / this.missile.getMaxSpeed();
        if (this.directAim) {
            f12 = Utils.\u00d300000(this.missile.getLocation(), this.target.getLocation());
        }
        Oo0O.o00000((float)this.missile, 0.0f, f12, 0.0f);
        boolean bl = false;
    }

    public void setProjSpeedOverride(float f2) {
        this.projSpeedOverride = f2;
    }

    private void acquireAndPrepare() {
        if (!this.isTargetValid()) {
            if (this.targetPoint != null) {
                if (this.isPd) {
                    this.target = Oo0O.o00000(this.targetPoint, this.missile.getOwner(), CollisionClass.MISSILE_FF, CollisionClass.MISSILE_NO_FF, CollisionClass.FIGHTER, CollisionClass.SHIP);
                } else {
                    this.target = Oo0O.o00000(this.targetPoint, this.missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP);
                    this.target = Oo0O.o00000(this.targetPoint, this.missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP);
                }
            } else {
                this.target = Oo0O.o00000(this.missile.getLocation(), this.missile.getOwner(), CollisionClass.FIGHTER, CollisionClass.SHIP);
            }
        }
        if (!this.isTargetValid()) {
            this.currTask = o.\u00d200000;
            return;
        }
        this.currTask = o.Object;
    }

    private void initialStage() {
        float f2 = Utils.\u00d200000(this.missile.getFacing(), this.launchAngle);
        float f3 = Utils.super(this.missile.getFacing(), this.launchAngle);
        if (f3 > 5.0f) {
            if (f2 < 0.0f) {
                this.missile.giveCommand(new Ship.Oo(Ship.oo.return, null));
            } else if (f2 > 0.0f) {
                this.missile.giveCommand(new Ship.Oo(Ship.oo.for, null));
            }
        } else if (this.missile.getVelocity().length() < this.missile.getMaxSpeed()) {
            this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
        } else {
            float f4 = Utils.\u00d200000(this.missile.getFacing(), new Vector2f(0.0f, 0.0f), this.missile.getVelocity());
            if (f4 > 20.0f) {
                this.missile.giveCommand(new Ship.Oo(Ship.oo.\u00d200000, null));
            } else if (f4 > 5.0f) {
                this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
            } else if (this.missile.getVelocity().length() < this.missile.getMaxSpeed()) {
                this.missile.giveCommand(new Ship.Oo(Ship.oo.this.super, null));
            }
        }
    }

    public void setTargetPoint(Vector2f vector2f) {
        this.targetPoint = vector2f;
    }

    public void setTarget(CombatEntityAPI combatEntityAPI) {
        this.target = (B)combatEntityAPI;
    }

    public void setLaunchAngle(float f2) {
        this.launchAngle = f2;
    }

    private boolean isTargetValid() {
        if (this.target == null) {
            return false;
        }
        if (this.target != null && this.target instanceof Ship && ((Ship)this.target).isHulk()) {
            return false;
        }
        return this.target != null && !this.target.wasRemoved() && this.target.getOwner() != this.missile.getOwner();
    }

    @Override
    public void render() {
    }

    public CombatEntityAPI getTarget() {
        if (this.isTargetValid()) {
            return this.target;
        }
        return null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static enum o {
        return,
        \u00d500000,
        Object,
        \u00d400000,
        \u00d200000;

    }
}

