/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai.missile;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.MoteControlScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.E.B;
import com.fs.starfarer.combat.E.oOoO;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.ai.Oo0O;
import com.fs.starfarer.combat.entities.BaseEntity;
import com.fs.starfarer.combat.entities.Missile;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.terrain.Asteroid;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.util.IntervalTracker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MoteAI
implements AI,
MissileAIPlugin {
    public static float MAX_FLOCK_RANGE = 500.0f;
    public static float MAX_HARD_AVOID_RANGE = 200.0f;
    public static float AVOID_RANGE = 50.0f;
    public static float COHESION_RANGE = 100.0f;
    public static float ATTRACTOR_LOCK_STOP_FLOCKING_ADD = 300.0f;
    protected Missile missile;
    protected IntervalTracker tracker = new IntervalTracker(0.05f, 0.1f);
    protected IntervalTracker updateListTracker = new IntervalTracker(0.05f, 0.1f);
    protected List<MissileAPI> missileList = new ArrayList<MissileAPI>();
    protected List<CombatEntityAPI> hardAvoidList = new ArrayList<CombatEntityAPI>();
    protected float r;
    protected B target;
    private MoteControlScript.SharedMoteAIData data;
    protected float elapsed = 0.0f;

    public MoteAI(Missile missile) {
        this.missile = missile;
        this.r = (float)Math.random();
        this.elapsed = -((float)Math.random()) * 0.5f;
        this.data = MoteControlScript.getSharedData((ShipAPI)missile.getSource());
        this.updateList();
    }

    public void updateList() {
        this.updateHardAvoidList();
    }

    public void updateHardAvoidList() {
        BaseEntity baseEntity;
        Object object;
        this.hardAvoidList.clear();
        oOoO oOoO2 = CombatEngine.getInstance().getAiGridShips();
        Iterator<Object> iterator = oOoO2.getCheckIterator(this.missile.getLocation(), MAX_HARD_AVOID_RANGE * 2.0f, MAX_HARD_AVOID_RANGE * 2.0f);
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof Ship) || (baseEntity = (Ship)object).isFighter()) continue;
            this.hardAvoidList.add(baseEntity);
        }
        oOoO2 = CombatEngine.getInstance().getAiGridAsteroids();
        iterator = oOoO2.getCheckIterator(this.missile.getLocation(), MAX_HARD_AVOID_RANGE * 2.0f, MAX_HARD_AVOID_RANGE * 2.0f);
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof Asteroid)) continue;
            baseEntity = (Asteroid)object;
            this.hardAvoidList.add(baseEntity);
        }
    }

    public void doFlocking() {
        float f2;
        float f3;
        if (this.missile.getSource() == null) {
            return;
        }
        Ship ship = this.missile.getSource();
        float f4 = AVOID_RANGE;
        float f5 = COHESION_RANGE;
        float f6 = ship.getCollisionRadius() + 200.0f;
        float f7 = ship.getCollisionRadius() + 50.0f;
        float f8 = ship.getCollisionRadius() + 600.0f;
        float f9 = (float)Math.sin(this.data.elapsed * 1.0f);
        float f10 = 1.0f + f9 * 0.25f;
        f4 *= f10;
        Vector2f vector2f = new Vector2f();
        Vector2f vector2f2 = this.getAttractorLoc();
        if (vector2f2 != null) {
            float f11 = Utils.void(this.missile.getLocation(), vector2f2);
            Vector2f vector2f3 = Utils.\u00d300000(Utils.\u00d300000(this.missile.getLocation(), vector2f2));
            float f12 = f11 / 200.0f;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            vector2f3.scale(f12 * 3.0f);
            Vector2f.add((Vector2f)vector2f, (Vector2f)vector2f3, (Vector2f)vector2f);
            f4 *= 3.0f;
        }
        boolean bl = false;
        for (CombatEntityAPI f17 : this.hardAvoidList) {
            f3 = Utils.void(this.missile.getLocation(), f17.getLocation());
            if (!(f3 < (f2 = f17.getCollisionRadius() + f4 + 50.0f))) continue;
            Vector2f vector2f3 = Utils.\u00d300000(Utils.\u00d300000(f17.getLocation(), this.missile.getLocation()));
            float f13 = 1.0f - f3 / f2;
            vector2f3.scale(f13 * 5.0f);
            Vector2f.add((Vector2f)vector2f, (Vector2f)vector2f3, (Vector2f)vector2f);
            boolean bl2 = bl = f13 > 0.5f;
        }
        for (MissileAPI missileAPI : this.data.motes) {
            float f14;
            if (missileAPI == this.missile) continue;
            f3 = Utils.void(this.missile.getLocation(), missileAPI.getLocation());
            f2 = missileAPI.getMaxHitpoints();
            f2 = 1.0f;
            float f15 = f5;
            if (f3 < f4 && missileAPI != this.missile && !bl) {
                Vector2f vector2f4 = Utils.\u00d300000(Utils.\u00d300000(missileAPI.getLocation(), this.missile.getLocation()));
                f14 = 1.0f - f3 / f4;
                vector2f4.scale(f14 * f2);
                Vector2f.add((Vector2f)vector2f, (Vector2f)vector2f4, (Vector2f)vector2f);
            }
            if (!(f3 < f15)) continue;
            Vector2f vector2f5 = new Vector2f((ReadableVector2f)missileAPI.getVelocity());
            Utils.super(vector2f5);
            f14 = 1.0f - f3 / f15;
            vector2f5.scale(f14 * f2);
            Vector2f.add((Vector2f)vector2f, (Vector2f)vector2f5, (Vector2f)vector2f);
        }
        if (this.missile.getSource() != null) {
            Iterator<Object> iterator;
            float f16 = Utils.void(this.missile.getLocation(), ship.getLocation());
            if (f16 > f6) {
                iterator = Utils.\u00d300000(Utils.\u00d300000(this.missile.getLocation(), ship.getLocation()));
                f3 = f16 / f6 - 1.0f;
                iterator.scale(f3 * 0.5f);
                Vector2f.add((Vector2f)vector2f, iterator, (Vector2f)vector2f);
            }
            if (f16 < f7) {
                iterator = Utils.\u00d300000(Utils.\u00d300000(ship.getLocation(), this.missile.getLocation()));
                f3 = 1.0f - f16 / f7;
                iterator.scale(f3 * 10.0f);
                Vector2f.add((Vector2f)vector2f, iterator, (Vector2f)vector2f);
            }
            if (f16 < f8 && ship.getVelocity().length() > 20.0f) {
                iterator = new Vector2f((ReadableVector2f)ship.getVelocity());
                Utils.super(iterator);
                f3 = 1.0f - f16 / f8;
                iterator.scale(f3 * 1.0f);
                Vector2f.add((Vector2f)vector2f, iterator, (Vector2f)vector2f);
            }
        }
        if (vector2f.length() > 0.0f) {
            float f17 = Misc.getAngleInDegrees((Vector2f)vector2f);
            Oo0O.new(this.missile, f17, 10000.0f);
            if (this.r > 0.5f) {
                this.missile.giveCommand(new Ship.Oo(Ship.oo.for, null));
            } else {
                this.missile.giveCommand(new Ship.Oo(Ship.oo.return, null));
            }
            this.missile.getEngineController().getEngineGlow().\u00f500000();
        }
    }

    @Override
    public void advance(float f2) {
        if (this.missile.isFizzling()) {
            return;
        }
        if (this.missile.getSource() == null) {
            return;
        }
        this.elapsed += f2;
        this.updateListTracker.advance(f2);
        if (this.updateListTracker.intervalElapsed()) {
            this.updateList();
        }
        if (this.elapsed >= 0.5f) {
            float f3;
            boolean bl;
            boolean bl2 = bl = !this.isTargetValid();
            if (this.data.attractorLock != null && (f3 = Utils.void(this.missile.getLocation(), this.data.attractorLock.getLocation())) > this.data.attractorLock.getCollisionRadius() + ATTRACTOR_LOCK_STOP_FLOCKING_ADD) {
                bl = true;
            }
            if (bl) {
                this.doFlocking();
            } else {
                Vector2f vector2f = Oo0O.o00000((B)this.missile, 1.5f, this.target, 50.0f);
                Oo0O.new(this.missile, Utils.\u00d300000(this.missile.getLocation(), vector2f), 10000.0f);
                if (this.r > 0.5f) {
                    this.missile.giveCommand(new Ship.Oo(Ship.oo.for, null));
                } else {
                    this.missile.giveCommand(new Ship.Oo(Ship.oo.return, null));
                }
                this.missile.getEngineController().getEngineGlow().\u00f500000();
            }
        }
        this.tracker.advance(f2);
        if (this.tracker.intervalElapsed() && this.elapsed >= 0.5f) {
            this.acquireNewTargetIfNeeded();
        }
    }

    protected boolean isTargetValid() {
        if (this.target == null || this.target instanceof Ship && ((Ship)this.target).isPhased()) {
            return false;
        }
        CombatEngine combatEngine = CombatEngine.getInstance();
        List list = combatEngine.getObjects().getList(B.class);
        if (this.target != null && this.target instanceof Ship && ((Ship)this.target).isHulk()) {
            return false;
        }
        return this.target != null && list.contains(this.target) && this.target.getOwner() != this.missile.getOwner();
    }

    protected void acquireNewTargetIfNeeded() {
        float f2;
        float f3;
        float f4;
        if (this.data.attractorLock != null) {
            this.target = (B)this.data.attractorLock;
            return;
        }
        CombatEngine combatEngine = CombatEngine.getInstance();
        int n2 = this.missile.getOwner();
        int n3 = 2;
        float f5 = MoteControlScript.MAX_DIST_FROM_SOURCE_TO_ENGAGE_AS_PD;
        float f6 = MoteControlScript.MAX_DIST_FROM_ATTRACTOR_TO_ENGAGE_AS_PD;
        float f7 = Float.MAX_VALUE;
        MissileAPI missileAPI = null;
        for (MissileAPI missileAPI2 : combatEngine.getMissiles()) {
            if (missileAPI2.getOwner() == n2 || missileAPI2.getOwner() == 100 || (f4 = Utils.void(this.missile.getLocation(), missileAPI2.getLocation())) > f7 || f4 > 3000.0f && !Oo0O.o00000(n2, (B)missileAPI2)) continue;
            f3 = Float.MAX_VALUE;
            if (this.data.attractorTarget != null) {
                f3 = Utils.void(missileAPI2.getLocation(), this.data.attractorTarget);
            }
            if ((f2 = Utils.void(missileAPI2.getLocation(), this.missile.getSource().getLocation())) > f5 && f3 > f6 || this.getNumMotesTargeting((CombatEntityAPI)missileAPI2) >= n3 || !(f4 < f7)) continue;
            missileAPI = missileAPI2;
            f7 = f4;
        }
        for (ShipAPI shipAPI : combatEngine.getShips()) {
            if (shipAPI.getOwner() == n2 || shipAPI.getOwner() == 100 || !shipAPI.isFighter() || (f4 = Utils.void(this.missile.getLocation(), shipAPI.getLocation())) > f7 || f4 > 3000.0f && !Oo0O.o00000(n2, (B)shipAPI)) continue;
            f3 = Float.MAX_VALUE;
            if (this.data.attractorTarget != null) {
                f3 = Utils.void(shipAPI.getLocation(), this.data.attractorTarget);
            }
            if ((f2 = Utils.void(shipAPI.getLocation(), this.missile.getSource().getLocation())) > f5 && f3 > f6 || this.getNumMotesTargeting((CombatEntityAPI)shipAPI) >= n3 || !(f4 < f7)) continue;
            missileAPI = shipAPI;
            f7 = f4;
        }
        this.target = (B)missileAPI;
    }

    protected int getNumMotesTargeting(CombatEntityAPI combatEntityAPI) {
        int n2 = 0;
        for (MissileAPI missileAPI : this.data.motes) {
            MoteAI moteAI;
            if (missileAPI == this.missile || !(missileAPI.getAI() instanceof MoteAI) || (moteAI = (MoteAI)missileAPI.getAI()).getTarget() != combatEntityAPI) continue;
            ++n2;
        }
        return n2;
    }

    public Vector2f getAttractorLoc() {
        Vector2f vector2f = null;
        if (this.data.attractorTarget != null) {
            vector2f = this.data.attractorTarget;
            if (this.data.attractorLock != null) {
                vector2f = this.data.attractorLock.getLocation();
            }
        }
        return vector2f;
    }

    public B getTarget() {
        return this.target;
    }

    public void setTarget(B b2) {
        this.target = b2;
    }

    @Override
    public void render() {
    }
}

