/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.loading.specs;

import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.campaign.DModManager;
import com.fs.starfarer.api.loading.VariantSource;
import com.fs.starfarer.api.loading.WeaponGroupSpec;
import com.fs.starfarer.api.loading.WeaponGroupType;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CharacterStats;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.ship.o0OO;
import com.fs.starfarer.loading.M;
import com.fs.starfarer.loading.OoOO;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.String;
import com.fs.starfarer.loading.specs.BaseWeaponSpec;
import com.fs.starfarer.loading.specs.FighterWingSpec;
import com.fs.starfarer.loading.specs.Oo0O;
import com.fs.starfarer.loading.specs.Q;
import com.fs.starfarer.loading.specs.Y;
import com.fs.starfarer.loading.specs.g;
import com.fs.starfarer.loading.specs.ooOO;
import com.fs.starfarer.loading.specs.public;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lwjgl.util.vector.Vector2f;

public class HullVariantSpec
implements Cloneable,
DoNotObfuscate,
ShipVariantAPI {
    private java.lang.String hullId;
    private transient g hullSpec;
    private Map<java.lang.String, java.lang.String> weapons = new HashMap<java.lang.String, java.lang.String>();
    private LinkedHashMap<java.lang.String, java.lang.String> stationModules = new LinkedHashMap();
    private List<java.lang.String> wings = new ArrayList<java.lang.String>();
    private List<WeaponGroupSpec> weaponGroups = new ArrayList<WeaponGroupSpec>();
    private int numFluxVents;
    private int numFluxCapacitors;
    private LinkedHashSet<java.lang.String> hullMods = new LinkedHashSet();
    private LinkedHashSet<java.lang.String> permaMods = new LinkedHashSet();
    private LinkedHashSet<java.lang.String> sMods = new LinkedHashSet();
    private LinkedHashSet<java.lang.String> sModdedBuiltIns = new LinkedHashSet();
    private LinkedHashSet<java.lang.String> suppressedMods = new LinkedHashSet();
    private java.lang.String hullVariantId;
    private java.lang.String variantDisplayName = "Strike";
    private VariantSource source;
    private java.lang.String sourceDetail;
    private boolean mayAutoAssignWeapons = true;
    private boolean goalVariant = false;
    private java.lang.String originalVariant = null;
    private transient java.lang.String sourcePath = null;
    private LinkedHashSet<java.lang.String> tags = null;
    public static int RANGE = 0;
    public static int FRONT = 1;
    public static int HARDPOINT = 2;
    public static int KINETIC = 3;
    public static int PD = 4;
    public static int ROCKET = 5;
    public static int MISSILE = 6;
    public static int LINKED = 7;
    public static int ALT = 8;
    public static int BEAM = 9;
    public static int BIGGEST = 10;
    public static int NO_MANUAL_FIRE = 11;
    public static int NUM_DIMENSIONS = 12;
    private transient o0OO statsForOpCosts = null;
    private transient Boolean hasOpAffectingMods = null;
    private transient Map<java.lang.String, HullVariantSpec> moduleVariants = null;
    private Map<java.lang.String, HullVariantSpec> savedModuleVariants = null;

    Object readResolve() {
        if (this.wings == null) {
            this.wings = new ArrayList<java.lang.String>();
        }
        if (this.permaMods == null) {
            this.permaMods = new LinkedHashSet();
        }
        if (this.sMods == null) {
            this.sMods = new LinkedHashSet();
        }
        if (this.sModdedBuiltIns == null) {
            this.sModdedBuiltIns = new LinkedHashSet();
        }
        if (this.suppressedMods == null) {
            this.suppressedMods = new LinkedHashSet();
        }
        if (this.stationModules == null) {
            this.stationModules = new LinkedHashMap();
        }
        this.setHullSpec(M.o00000(this.hullId));
        this.moduleVariants = this.savedModuleVariants;
        this.savedModuleVariants = null;
        return this;
    }

    Object writeReplace() {
        if (this.tags != null && this.tags.isEmpty()) {
            this.tags = null;
        }
        if (this.moduleVariants != null) {
            boolean bl = false;
            this.savedModuleVariants = new HashMap<java.lang.String, HullVariantSpec>(this.moduleVariants);
            int n2 = 0;
            for (java.lang.String string : this.moduleVariants.keySet()) {
                HullVariantSpec hullVariantSpec = this.moduleVariants.get(string);
                if (hullVariantSpec != null && !hullVariantSpec.isStockVariant()) {
                    bl = true;
                    this.savedModuleVariants.put(string, hullVariantSpec);
                }
                ++n2;
            }
            if (!bl) {
                this.savedModuleVariants = null;
            }
        }
        return this;
    }

    public boolean hasTag(java.lang.String string) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.contains(string);
    }

    public void addTag(java.lang.String string) {
        if (this.tags == null) {
            this.tags = new LinkedHashSet();
        }
        this.tags.add(string);
    }

    public void removeTag(java.lang.String string) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(string);
        if (this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    public Collection<java.lang.String> getTags() {
        if (this.tags == null) {
            return new ArrayList<java.lang.String>();
        }
        return this.tags;
    }

    public void clearTags() {
        if (this.tags != null) {
            this.tags.clear();
        }
        this.tags = null;
    }

    public int getUnusedOP(MutableCharacterStatsAPI mutableCharacterStatsAPI) {
        int n2 = this.computeOPCost(mutableCharacterStatsAPI);
        int n3 = this.getHullSpec().getOrdnancePoints(mutableCharacterStatsAPI);
        int n4 = n3 - n2;
        return n4;
    }

    public Set<java.lang.String> getSuppressedMods() {
        return this.suppressedMods;
    }

    public void addSuppressedMod(java.lang.String string) {
        this.suppressedMods.add(string);
        this.removeMod(string);
    }

    public void removeSuppressedMod(java.lang.String string) {
        this.suppressedMods.remove(string);
        if (this.hullSpec.isBuiltInMod(string) || this.permaMods.contains(string)) {
            this.addMod(string);
        }
    }

    public void clearSuppressedMods() {
        for (java.lang.String string : new ArrayList<java.lang.String>(this.suppressedMods)) {
            this.removeSuppressedMod(string);
        }
    }

    public Set<java.lang.String> getPermaMods() {
        return this.permaMods;
    }

    public void addPermaMod(java.lang.String string) {
        this.addPermaMod(string, false);
    }

    public void addPermaMod(java.lang.String string, boolean bl) {
        this.permaMods.add(string);
        if (bl) {
            this.sMods.add(string);
        }
        this.addMod(string);
        this.hasOpAffectingMods = null;
    }

    public void removePermaMod(java.lang.String string) {
        this.permaMods.remove(string);
        this.sMods.remove(string);
        this.removeMod(string);
    }

    public LinkedHashSet<java.lang.String> getSMods() {
        return this.sMods;
    }

    public void clearPermaMods() {
        for (java.lang.String string : new ArrayList<java.lang.String>(this.permaMods)) {
            this.removePermaMod(string);
        }
    }

    public java.lang.String getVariantFilePath() {
        return this.sourcePath;
    }

    public void setSourcePath(java.lang.String string) {
        this.sourcePath = string;
    }

    public EnumSet<ShipHullSpecAPI.ShipTypeHints> getHints() {
        return this.hullSpec.getHints();
    }

    public boolean isNonCombat() {
        return (this.isCarrier() || this.isCivilian()) && !this.isCombat();
    }

    public boolean isCarrier() {
        return this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.CARRIER);
    }

    public boolean isCombat() {
        return this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.COMBAT);
    }

    public Q getSizeWithModules() {
        if (this.getModuleSlots().isEmpty()) {
            return this.hullSpec.getSpriteSpec();
        }
        Q q = new Q();
        float f2 = this.hullSpec.getSpriteSpec().\u00d500000();
        float f3 = this.hullSpec.getSpriteSpec().\u00d200000();
        q.super(f2, f3);
        float f4 = -f2;
        float f5 = -f3;
        float f6 = this.hullSpec.getSpriteSpec().\u00f400000() - f2;
        float f7 = this.hullSpec.getSpriteSpec().super() - f3;
        float f8 = f4;
        float f9 = f5;
        float f10 = f6;
        float f11 = f7;
        for (java.lang.String string : this.getModuleSlots()) {
            float f12;
            Y y2 = (Y)this.getSlot(string);
            HullVariantSpec hullVariantSpec = this.getModuleVariant(string);
            Q q2 = hullVariantSpec.getHullSpec().getSpriteSpec();
            Vector2f vector2f = hullVariantSpec.getHullSpec().getModuleAnchor();
            Vector2f vector2f2 = y2.computeRelativePosition(90.0f, vector2f);
            vector2f = vector2f == null ? new Vector2f(q2.\u00d500000() - q2.\u00f400000() / 2.0f, q2.\u00d200000() - q2.super() / 2.0f) : new Vector2f(-vector2f.y, vector2f.x);
            vector2f.set(0.0f, 0.0f);
            float f13 = Math.max(q2.\u00f400000() / 2.0f + Math.abs(vector2f.x), q2.super() / 2.0f + Math.abs(vector2f.y));
            float f14 = q2.\u00f400000() / 2.0f + Math.abs(vector2f.x);
            float f15 = q2.super() / 2.0f + Math.abs(vector2f.y);
            if (y2.getAngle() != 0.0f) {
                f14 = f15 = f13;
            }
            if ((f12 = vector2f2.x + f14) > f6) {
                f6 = f12;
            }
            if ((f12 = vector2f2.x - f14) < f4) {
                f4 = f12;
            }
            if ((f12 = vector2f2.y + f15) > f7) {
                f7 = f12;
            }
            if (!((f12 = vector2f2.y - f15) < f5)) continue;
            f5 = f12;
        }
        float f16 = f8 - f4;
        float f17 = f6 - f10;
        float f18 = f9 - f5;
        float f19 = f7 - f11;
        float f20 = 1.2f;
        f20 = 0.5f;
        f20 = 1.0f;
        float f21 = 0.0f;
        q.\u00d200000(f10 - f8 + (f16 + f17) * f20 + f21, f11 - f9 + (f18 + f19) * f20 + f21);
        q.super(f2 + f16, f3 + f18);
        return q;
    }

    public boolean isTransport() {
        return this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.TRANSPORT);
    }

    public boolean isLiner() {
        return this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.LINER);
    }

    public boolean isFreighter() {
        return this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.FREIGHTER);
    }

    public boolean isTanker() {
        return this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.TANKER);
    }

    public boolean isCivilian() {
        if (this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.CIVILIAN)) {
            return true;
        }
        if (this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.STATION)) {
            return false;
        }
        if (this.getHints().contains(ShipHullSpecAPI.ShipTypeHints.SHIP_WITH_MODULES)) {
            return false;
        }
        if (this.isFighter()) {
            return false;
        }
        return this.weapons.isEmpty() && this.getFittedWings().isEmpty();
    }

    public List<java.lang.String> getModuleSlots() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>();
        if (this.getStationModules() == null) {
            throw new RuntimeException("stationModules is null for variant [" + this.getHullVariantId() + "]");
        }
        if (this.getHullSpec() == null) {
            throw new RuntimeException("hullSpec is null for variant [" + this.getHullVariantId() + "]");
        }
        for (java.lang.String string : this.getStationModules().keySet()) {
            Y y2 = this.getHullSpec().getWeaponSlot(string);
            if (y2.getWeaponType() != WeaponAPI.WeaponType.STATION_MODULE || !this.getStationModules().containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<java.lang.String> getLaunchBaysSlotIds() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>();
        for (Y y2 : this.getHullSpec().getAllWeaponSlots()) {
            if (y2.getWeaponType() != WeaponAPI.WeaponType.LAUNCH_BAY) continue;
            java.lang.String string = y2.getId();
            arrayList.add(string);
        }
        return arrayList;
    }

    public FighterWingSpec getWing(int n2) {
        java.lang.String string = this.getWingId(n2);
        if (string == null) {
            return null;
        }
        return SpecStore.o00000(FighterWingSpec.class, string);
    }

    public java.lang.String getWingId(int n2) {
        if (n2 >= this.wings.size()) {
            return null;
        }
        if (n2 < 0) {
            return null;
        }
        java.lang.String string = this.wings.get(n2);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return string;
    }

    public void setWingId(int n2, java.lang.String string) {
        if (this.hullSpec.isBuiltInWing(n2)) {
            string = this.hullSpec.getBuiltInWings().get(n2);
        }
        if (string == null) {
            string = "";
        }
        while (this.wings.size() < n2 + 1) {
            this.wings.add("");
        }
        this.wings.set(n2, string);
    }

    public List<java.lang.String> getWings() {
        return this.wings;
    }

    public List<java.lang.String> getFittedWings() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>();
        for (java.lang.String string : this.wings) {
            if (string == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<java.lang.String> getNonBuiltInWings() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>();
        int n2 = 0;
        for (java.lang.String string : this.wings) {
            if (string == null || string.isEmpty() || n2++ < this.getHullSpec().getBuiltInWings().size()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean bl) {
        this.weapons.clear();
        if (bl) {
            this.hullMods.clear();
        }
        this.wings.clear();
        this.setHullSpec(this.hullSpec);
        if (bl) {
            this.clearHullMods();
        } else {
            for (java.lang.String string : this.hullSpec.getBuiltInMods()) {
                this.addMod(string);
            }
            for (java.lang.String string : this.permaMods) {
                this.addMod(string);
            }
        }
        this.numFluxVents = 0;
        this.numFluxCapacitors = 0;
        int n2 = 0;
        for (java.lang.String string : this.getStationModules().keySet()) {
            HullVariantSpec hullVariantSpec = this.getModuleVariant(string);
            if (hullVariantSpec == null) continue;
            if (hullVariantSpec.isStockVariant()) {
                hullVariantSpec = hullVariantSpec.clone();
                hullVariantSpec.setSource(VariantSource.REFIT);
                hullVariantSpec.setHullVariantId(java.lang.String.valueOf(hullVariantSpec.getHullSpec().getHullId()) + "_" + n2);
                this.setModuleVariant(string, hullVariantSpec);
            }
            ++n2;
            hullVariantSpec.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject toJSONObject() throws JSONException {
        WeaponGroupSpec weaponGroupSpec2;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("displayName", (Object)this.variantDisplayName);
        jSONObject.put("hullId", (Object)this.hullSpec.getHullId());
        jSONObject.put("variantId", (Object)this.hullVariantId);
        jSONObject.put("fluxVents", this.numFluxVents);
        jSONObject.put("fluxCapacitors", this.numFluxCapacitors);
        if (this.goalVariant) {
            jSONObject.put("goalVariant", this.goalVariant);
        }
        JSONArray jSONArray = new JSONArray();
        for (WeaponGroupSpec weaponGroupSpec2 : this.weaponGroups) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("mode", (Object)weaponGroupSpec2.getType().name());
            jSONObject2.put("autofire", weaponGroupSpec2.isAutofireOnByDefault());
            JSONObject jSONObject3 = new JSONObject();
            for (java.lang.String string : weaponGroupSpec2.getSlots()) {
                BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, this.weapons.get(string));
                if (baseWeaponSpec == null) continue;
                jSONObject3.put(string, (Object)baseWeaponSpec.getWeaponId());
            }
            jSONObject2.put("weapons", (Object)jSONObject3);
            jSONArray.put((Object)jSONObject2);
        }
        if (!this.stationModules.isEmpty()) {
            weaponGroupSpec2 = new JSONArray();
            for (java.lang.String string : this.stationModules.keySet()) {
                JSONObject jSONObject4 = new JSONObject();
                jSONObject4.put(string, (Object)this.stationModules.get(string));
                weaponGroupSpec2.put((Object)jSONObject4);
            }
            jSONObject.put("modules", (Object)weaponGroupSpec2);
        }
        jSONObject.put("weaponGroups", (Object)jSONArray);
        if (!this.wings.isEmpty()) {
            weaponGroupSpec2 = new JSONArray();
            boolean jSONArray2 = false;
            if (this.getFittedWings().isEmpty()) {
                this.wings.clear();
            }
            for (java.lang.String string : this.wings) {
                void var4_7;
                if (this.hullSpec.isBuiltInWing((int)(++var4_7)) || string == null) continue;
                weaponGroupSpec2.put((Object)string);
            }
            jSONObject.put("wings", (Object)weaponGroupSpec2);
        }
        weaponGroupSpec2 = new JSONArray();
        for (java.lang.String string : this.hullMods) {
            if (this.hullSpec.isBuiltInMod(string)) continue;
            weaponGroupSpec2.put((Object)string);
        }
        jSONObject.put("hullMods", (Object)weaponGroupSpec2);
        JSONArray jSONArray2 = new JSONArray();
        for (java.lang.String string : this.permaMods) {
            jSONArray2.put((Object)string);
        }
        jSONObject.put("permaMods", (Object)jSONArray2);
        JSONArray jSONArray3 = new JSONArray();
        for (java.lang.String string : this.sMods) {
            jSONArray3.put((Object)string);
        }
        jSONObject.put("sMods", (Object)jSONArray3);
        if (this.tags != null && !this.tags.isEmpty()) {
            JSONArray jSONArray4 = new JSONArray();
            for (java.lang.String string : this.tags) {
                jSONArray4.put((Object)string);
            }
            jSONObject.put("tags", (Object)jSONArray4);
        }
        return jSONObject;
    }

    public boolean isMayAutoAssignWeapons() {
        return this.mayAutoAssignWeapons;
    }

    public void setMayAutoAssignWeapons(boolean bl) {
        this.mayAutoAssignWeapons = bl;
    }

    private boolean shouldTurnAutofireOn(WeaponGroupSpec weaponGroupSpec) {
        for (java.lang.String string : weaponGroupSpec.getSlots()) {
            BaseWeaponSpec baseWeaponSpec = this.getWeaponSpec(string);
            if (baseWeaponSpec.getAIHints().contains(WeaponAPI.AIHints.PD)) continue;
            if (baseWeaponSpec.getAIHints().contains(WeaponAPI.AIHints.STRIKE)) {
                return false;
            }
            Y y2 = this.getHullSpec().getWeaponSlot(string);
            if (y2.isHardpoint()) {
                ooOO ooOO2;
                if (baseWeaponSpec instanceof ooOO && !(ooOO2 = (ooOO)baseWeaponSpec).isBurstBeam()) continue;
                return false;
            }
            if (baseWeaponSpec.getType() != WeaponAPI.WeaponType.MISSILE) continue;
            return false;
        }
        return true;
    }

    public void autoGenerateWeaponGroups() {
        this.autoGenerateWeaponGroupsV2();
    }

    public void autoGenerateWeaponGroupsV2() {
        Cloneable cloneable;
        Object object;
        WeaponAPI.WeaponSize weaponSize = WeaponAPI.WeaponSize.SMALL;
        for (java.lang.String string : this.weapons.keySet()) {
            object = this.getWeaponSpec(string);
            if (object == null || (cloneable = this.getHullSpec().getWeaponSlot(string)) == null || cloneable.isDecorative() || ((BaseWeaponSpec)object).getAIHints().contains(WeaponAPI.AIHints.NO_MANUAL_FIRE) || ((BaseWeaponSpec)object).getSize().ordinal() <= weaponSize.ordinal()) continue;
            weaponSize = ((BaseWeaponSpec)object).getSize();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (java.lang.String string : this.weapons.keySet()) {
            float f2;
            o o22;
            Y y2;
            cloneable = this.getWeaponSpec(string);
            if (cloneable == null || (y2 = this.getHullSpec().getWeaponSlot(string)) == null || y2.isDecorative()) continue;
            o o3 = new o(y2, (BaseWeaponSpec)cloneable, weaponSize);
            if (arrayList.isEmpty()) {
                arrayList.add(o3);
                continue;
            }
            o o4 = null;
            float f3 = Float.MAX_VALUE;
            for (o o22 : arrayList) {
                f2 = o22.super(o3);
                if (!(f2 < f3)) continue;
                o4 = o22;
                f3 = f2;
            }
            if (o4 != null && f3 <= 0.01f) {
                o4.\u00d200000(o3);
                continue;
            }
            if (arrayList.size() < 7) {
                arrayList.add(o3);
                continue;
            }
            o22 = null;
            Object object2 = null;
            f2 = Float.MAX_VALUE;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                o o5 = (o)arrayList.get(n2);
                int n3 = n2 + 1;
                while (n3 < arrayList.size()) {
                    o o6 = (o)arrayList.get(n3);
                    float f4 = o5.super(o6);
                    if (f4 < f2) {
                        o22 = o5;
                        object2 = o6;
                        f2 = f4;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (f3 < f2 || o22 == null || object2 == null) {
                o4.\u00d200000(o3);
                continue;
            }
            o22.\u00d200000((o)object2);
            arrayList.remove(object2);
            arrayList.add(o3);
        }
        Collections.sort(arrayList, new Comparator<o>(){

            public int o00000(o o2, o o3) {
                float f2 = o2.\u00d300000[PD] * 1000.0f - ((o2.\u00d300000[MISSILE] + o2.\u00d300000[ROCKET]) * 2.0f + o2.\u00d300000[HARDPOINT] + o2.\u00d300000[BIGGEST]);
                float f3 = o3.\u00d300000[PD] * 1000.0f - ((o3.\u00d300000[MISSILE] + o3.\u00d300000[ROCKET]) * 2.0f + o3.\u00d300000[HARDPOINT] + o3.\u00d300000[BIGGEST]);
                f2 += o2.\u00d300000[NO_MANUAL_FIRE] * 10000.0f;
                f3 += o3.\u00d300000[NO_MANUAL_FIRE] * 10000.0f;
                if (!o2.\u00d500000.isEmpty()) {
                    f2 -= 100.0f;
                }
                if (!o3.\u00d500000.isEmpty()) {
                    f3 -= 100.0f;
                }
                return (int)Math.signum(f2 - f3);
            }
        });
        if (arrayList.size() >= 2) {
            o o7 = (o)arrayList.get(0);
            object = (o)arrayList.get(1);
            if (((o)object).\u00d300000[MISSILE] + ((o)object).\u00d300000[ROCKET] <= 0.0f && o7.\u00d300000[MISSILE] + o7.\u00d300000[ROCKET] > 0.0f) {
                arrayList.set(0, object);
                arrayList.set(1, o7);
            }
        }
        if (arrayList.size() >= 3) {
            o o8 = (o)arrayList.get(2);
            object = (o)arrayList.get(1);
            if (((o)object).\u00d300000[MISSILE] + ((o)object).\u00d300000[ROCKET] <= 0.0f && o8.\u00d300000[MISSILE] + o8.\u00d300000[ROCKET] > 0.0f) {
                arrayList.set(2, object);
                arrayList.set(1, o8);
            }
        }
        this.weaponGroups.clear();
        for (o o9 : arrayList) {
            cloneable = new WeaponGroupSpec(o9.super(this) ? WeaponGroupType.ALTERNATING : WeaponGroupType.LINKED);
            for (Y y2 : o9.\u00d200000) {
                cloneable.addSlot(y2.getId());
            }
            cloneable.setAutofireOnByDefault(this.shouldTurnAutofireOn((WeaponGroupSpec)cloneable));
            this.addWeaponGroup((WeaponGroupSpec)cloneable);
        }
    }

    public boolean hasUnassignedWeapons() {
        for (java.lang.String string : this.weapons.keySet()) {
            Y y2 = this.hullSpec.getWeaponSlot(string);
            if (y2 != null && y2.isDecorative()) continue;
            boolean bl = false;
            for (WeaponGroupSpec weaponGroupSpec : this.weaponGroups) {
                if (!weaponGroupSpec.getSlots().contains(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    public void assignUnassignedWeapons() {
        boolean bl;
        boolean bl2 = this.weaponGroups.isEmpty();
        if (bl2) {
            this.autoGenerateWeaponGroups();
            return;
        }
        for (java.lang.String object2 : this.weapons.keySet()) {
            WeaponGroupSpec weaponGroupSpec;
            bl = false;
            for (WeaponGroupSpec weaponGroupSpec2 : this.weaponGroups) {
                if (!weaponGroupSpec2.getSlots().contains(object2)) continue;
                bl = true;
                break;
            }
            Y y2 = this.hullSpec.getWeaponSlot(object2);
            if (y2 != null && y2.isDecorative()) {
                bl = true;
            }
            if (bl) continue;
            boolean bl3 = false;
            if (this.weaponGroups.size() == 7) {
                weaponGroupSpec = this.weaponGroups.get(6);
            } else {
                weaponGroupSpec = new WeaponGroupSpec(WeaponGroupType.LINKED);
                bl3 = true;
            }
            weaponGroupSpec.addSlot(object2);
            if (!bl3) continue;
            this.addWeaponGroup(weaponGroupSpec);
        }
        Iterator<WeaponGroupSpec> iterator = this.weaponGroups.iterator();
        while (iterator.hasNext()) {
            WeaponGroupSpec weaponGroupSpec = iterator.next();
            bl = false;
            for (java.lang.String string : this.weapons.keySet()) {
                if (!weaponGroupSpec.getSlots().contains(string)) continue;
                bl = true;
                break;
            }
            if (!weaponGroupSpec.getSlots().isEmpty() && bl) continue;
            iterator.remove();
        }
    }

    public WeaponGroupSpec getGroup(int n2) {
        WeaponGroupSpec weaponGroupSpec;
        if (this.weaponGroups.size() > n2) {
            weaponGroupSpec = this.weaponGroups.get(n2);
        } else {
            weaponGroupSpec = new WeaponGroupSpec(WeaponGroupType.LINKED);
            this.weaponGroups.add(weaponGroupSpec);
        }
        return weaponGroupSpec;
    }

    public int computeOPCost(MutableCharacterStatsAPI mutableCharacterStatsAPI) {
        int n2 = this.computeWeaponOPCost(mutableCharacterStatsAPI) + this.computeHullModOPCost(mutableCharacterStatsAPI);
        n2 += this.numFluxVents;
        return n2 += this.numFluxCapacitors;
    }

    public int computeWeaponOPCost(MutableCharacterStatsAPI mutableCharacterStatsAPI) {
        Object object;
        int n2 = 0;
        for (java.lang.String string : this.weapons.keySet()) {
            Object object2;
            if (this.hullSpec.isBuiltIn(string) || (object2 = this.weapons.get(string)) == null || ((java.lang.String)object2).isEmpty()) continue;
            object = SpecStore.o00000(BaseWeaponSpec.class, (java.lang.String)object2);
            if (object == null) {
                throw new RuntimeException("Weapon spec with id [" + (java.lang.String)object2 + " not found");
            }
            this.updateStatsForOpCosts();
            n2 = (int)((float)n2 + ((BaseWeaponSpec)object).getOrdnancePointCost(mutableCharacterStatsAPI, this.statsForOpCosts));
        }
        int n3 = 0;
        for (java.lang.String string : this.wings) {
            if (this.hullSpec.isBuiltInWing(n3++) || string == null || string.isEmpty()) continue;
            object = SpecStore.o00000(FighterWingSpec.class, string);
            if (object == null) {
                throw new RuntimeException("Fighter wing spec with id [" + string + " not found");
            }
            this.updateStatsForOpCosts();
            n2 = (int)((float)n2 + ((FighterWingSpec)object).getOpCost(this.statsForOpCosts));
        }
        return n2;
    }

    public MutableShipStatsAPI getStatsForOpCosts() {
        this.updateStatsForOpCosts();
        return this.statsForOpCosts;
    }

    private void updateStatsForOpCosts() {
        if (this.hasOpAffectingMods == null) {
            this.statsForOpCosts = o0OO.create(this);
            this.hasOpAffectingMods = false;
            for (java.lang.String string : this.getHullMods()) {
                public public_ = SpecStore.o00000(public.class, string);
                if (!public_.getEffect().affectsOPCosts()) continue;
                this.hasOpAffectingMods = true;
                public_.getEffect().applyEffectsBeforeShipCreation(this.hullSpec.getHullSize(), (MutableShipStatsAPI)this.statsForOpCosts, public_.getId());
            }
            if (!this.hasOpAffectingMods.booleanValue()) {
                this.statsForOpCosts = null;
            }
        }
    }

    public int computeHullModOPCost() {
        return this.computeHullModOPCost(null);
    }

    public int computeHullModOPCost(MutableCharacterStatsAPI mutableCharacterStatsAPI) {
        int n2 = 0;
        for (java.lang.String string : this.hullMods) {
            if (this.hullSpec.isBuiltInMod(string) || this.permaMods.contains(string)) continue;
            public public_ = SpecStore.o00000(public.class, string);
            n2 += public_.getCostFor(this);
        }
        return n2;
    }

    public HullVariantSpec clone() {
        HullVariantSpec hullVariantSpec = null;
        try {
            hullVariantSpec = (HullVariantSpec)super.clone();
            hullVariantSpec.weapons = new HashMap<java.lang.String, java.lang.String>();
            hullVariantSpec.weapons.putAll(this.weapons);
            hullVariantSpec.weaponGroups = new ArrayList<WeaponGroupSpec>();
            for (WeaponGroupSpec object : this.weaponGroups) {
                hullVariantSpec.weaponGroups.add(object.clone());
            }
            hullVariantSpec.hullMods = new LinkedHashSet();
            hullVariantSpec.hullMods.addAll(this.hullMods);
            hullVariantSpec.permaMods = new LinkedHashSet();
            hullVariantSpec.permaMods.addAll(this.permaMods);
            hullVariantSpec.sMods = new LinkedHashSet();
            hullVariantSpec.sMods.addAll(this.sMods);
            hullVariantSpec.sModdedBuiltIns = new LinkedHashSet();
            hullVariantSpec.sModdedBuiltIns.addAll(this.sModdedBuiltIns);
            hullVariantSpec.suppressedMods = new LinkedHashSet();
            hullVariantSpec.suppressedMods.addAll(this.suppressedMods);
            hullVariantSpec.stationModules = new LinkedHashMap();
            hullVariantSpec.stationModules.putAll(this.stationModules);
            hullVariantSpec.wings = new ArrayList<java.lang.String>();
            hullVariantSpec.wings.addAll(this.wings);
            if (hullVariantSpec.tags != null && this.tags != null) {
                hullVariantSpec.tags = new LinkedHashSet();
                hullVariantSpec.tags.addAll(this.tags);
            }
            if (this.moduleVariants != null) {
                hullVariantSpec.moduleVariants = new HashMap<java.lang.String, HullVariantSpec>();
                for (java.lang.String string : this.moduleVariants.keySet()) {
                    hullVariantSpec.moduleVariants.put(string, this.moduleVariants.get(string).clone());
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return hullVariantSpec;
    }

    public void addMod(java.lang.String string) {
        if (this.suppressedMods.contains(string)) {
            return;
        }
        if (this.hullMods.contains(string)) {
            return;
        }
        this.hasOpAffectingMods = null;
        this.hullMods.add(string);
    }

    public List<public> getAllSortedMods() {
        ArrayList<public> arrayList = new ArrayList<public>();
        for (java.lang.String string : this.getSortedMods()) {
            public public_ = SpecStore.o00000(public.class, string);
            if (public_ != null) {
                arrayList.add(public_);
                continue;
            }
            throw new RuntimeException("Hullmod " + string + " not found!");
        }
        return arrayList;
    }

    public List<java.lang.String> getSortedMods() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>(this.getVisibleHullMods());
        ArrayList<java.lang.String> arrayList2 = new ArrayList<java.lang.String>();
        ArrayList<java.lang.String> arrayList3 = new ArrayList<java.lang.String>();
        for (java.lang.String string : arrayList) {
            boolean bl = this.getHullSpec().isBuiltInMod(string);
            boolean bl2 = this.getPermaMods().contains(string);
            boolean bl3 = DModManager.getMod((java.lang.String)string).hasTag("dmod");
            if (bl && !bl3 || bl2 && !bl3) {
                arrayList2.add(string);
                continue;
            }
            if (!bl3) continue;
            arrayList3.add(string);
        }
        arrayList.removeAll(arrayList2);
        arrayList.addAll(0, arrayList2);
        arrayList.removeAll(arrayList3);
        arrayList.addAll(arrayList3);
        return arrayList;
    }

    public void removeMod(java.lang.String string) {
        if (!this.suppressedMods.contains(string)) {
            if (this.hullSpec.isBuiltInMod(string)) {
                return;
            }
            if (this.permaMods.contains(string)) {
                return;
            }
        }
        if (this.hullMods.remove(string)) {
            this.hasOpAffectingMods = null;
        }
    }

    public Collection<java.lang.String> getNonBuiltInHullmods() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>();
        for (java.lang.String string : this.getHullMods()) {
            if (this.getHullSpec().isBuiltInMod(string) || this.getPermaMods().contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Collection<java.lang.String> getHullMods() {
        return this.hullMods;
    }

    public Collection<java.lang.String> getVisibleHullMods() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>();
        for (java.lang.String string : this.hullMods) {
            public public_ = SpecStore.o00000(public.class, string);
            if (public_.isHiddenEverywhere()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean hasHullMod(java.lang.String string) {
        return this.getHullMods().contains(string);
    }

    public void clearHullMods() {
        this.hullMods.clear();
        for (java.lang.String string : this.hullSpec.getBuiltInMods()) {
            this.addMod(string);
        }
        for (java.lang.String string : this.permaMods) {
            this.addMod(string);
        }
    }

    public List<public> getAllVisibleMods() {
        ArrayList<public> arrayList = new ArrayList<public>();
        for (java.lang.String string : this.getVisibleHullMods()) {
            public public_ = SpecStore.o00000(public.class, string);
            if (public_ != null) {
                arrayList.add(public_);
                continue;
            }
            throw new RuntimeException("Hullmod " + string + " not found!");
        }
        return arrayList;
    }

    public List<public> getAllMods() {
        ArrayList<public> arrayList = new ArrayList<public>();
        for (java.lang.String string : this.hullMods) {
            public public_ = SpecStore.o00000(public.class, string);
            if (public_ != null) {
                arrayList.add(public_);
                continue;
            }
            throw new RuntimeException("Hullmod " + string + " not found!");
        }
        return arrayList;
    }

    public static HullVariantSpec createEmptyVariant(java.lang.String string) {
        g g2 = M.o00000(string);
        HullVariantSpec hullVariantSpec = new HullVariantSpec("empty_" + string, g2);
        return hullVariantSpec;
    }

    public HullVariantSpec(java.lang.String string, g g2) {
        this.hullVariantId = string;
        this.setHullSpec(g2);
    }

    public HullVariantSpec(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray;
        java.lang.String string;
        Object object;
        WeaponGroupSpec weaponGroupSpec;
        Object object2;
        java.lang.String string2;
        java.lang.String string3;
        int n2;
        this.variantDisplayName = jSONObject.getString("displayName");
        java.lang.String string4 = jSONObject.getString("hullId");
        this.setHullSpec(SpecStore.o00000(g.class, string4));
        this.hullVariantId = jSONObject.getString("variantId");
        this.numFluxVents = jSONObject.getInt("fluxVents");
        this.numFluxCapacitors = jSONObject.getInt("fluxCapacitors");
        JSONArray jSONArray2 = jSONObject.optJSONArray("hullMods");
        if (jSONArray2 != null) {
            n2 = 0;
            while (n2 < jSONArray2.length()) {
                this.addMod(jSONArray2.getString(n2));
                ++n2;
            }
        }
        if ((jSONArray2 = jSONObject.optJSONArray("permaMods")) != null) {
            n2 = 0;
            while (n2 < jSONArray2.length()) {
                string3 = jSONArray2.getString(n2);
                this.permaMods.add(string3);
                this.addMod(string3);
                ++n2;
            }
        }
        if ((jSONArray2 = jSONObject.optJSONArray("sMods")) != null) {
            n2 = 0;
            while (n2 < jSONArray2.length()) {
                string3 = jSONArray2.getString(n2);
                this.addPermaMod(string3, true);
                ++n2;
            }
        }
        if ((jSONArray2 = jSONObject.optJSONArray("sModdedBuiltIns")) != null) {
            n2 = 0;
            while (n2 < jSONArray2.length()) {
                string3 = jSONArray2.getString(n2);
                this.sModdedBuiltIns.add(string3);
                ++n2;
            }
        }
        if ((jSONArray2 = jSONObject.optJSONArray("suppressedMods")) != null) {
            n2 = 0;
            while (n2 < jSONArray2.length()) {
                string3 = jSONArray2.getString(n2);
                this.addSuppressedMod(string3);
                ++n2;
            }
        }
        if (jSONObject.has("wings")) {
            JSONArray jSONArray3 = jSONObject.getJSONArray("wings");
            int n3 = 0;
            while (n3 < jSONArray3.length()) {
                string2 = jSONArray3.optString(n3, "");
                this.setWingId(n3 + this.hullSpec.getBuiltInWings().size(), string2);
                if (!string2.isEmpty()) {
                    object2 = SpecStore.o00000(FighterWingSpec.class, string2);
                }
                ++n3;
            }
        }
        this.goalVariant = jSONObject.optBoolean("goalVariant", false);
        JSONArray jSONArray4 = jSONObject.getJSONArray("weaponGroups");
        int n4 = 0;
        while (n4 < jSONArray4.length()) {
            string2 = jSONArray4.getJSONObject(n4);
            object2 = String.super((JSONObject)string2, "mode", WeaponGroupType.class, null);
            weaponGroupSpec = new WeaponGroupSpec(object2);
            weaponGroupSpec.setAutofireOnByDefault(string2.optBoolean("autofire", false));
            object = string2.getJSONObject("weapons");
            if (JSONObject.getNames((JSONObject)object) != null) {
                java.lang.String[] stringArray = JSONObject.getNames((JSONObject)object);
                int n5 = stringArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    string = stringArray[n6];
                    java.lang.String string5 = object.getString(string);
                    Y y2 = (Y)this.getSlot(string);
                    BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, string5);
                    this.addWeapon(string, baseWeaponSpec);
                    weaponGroupSpec.addSlot(string);
                    ++n6;
                }
            }
            if (!weaponGroupSpec.getSlots().isEmpty()) {
                this.addWeaponGroup(weaponGroupSpec);
            }
            ++n4;
        }
        if (jSONObject.has("modules")) {
            JSONObject jSONObject2 = jSONObject.optJSONObject("modules");
            if (jSONObject2 != null && JSONObject.getNames((JSONObject)jSONObject2) != null) {
                object = JSONObject.getNames((JSONObject)jSONObject2);
                int n7 = ((java.lang.String[])object).length;
                int n8 = 0;
                while (n8 < n7) {
                    string2 = object[n8];
                    string = jSONObject2.getString(string2);
                    this.stationModules.put(string2, string);
                    ++n8;
                }
            }
            if (jSONObject2 == null) {
                string2 = jSONObject.getJSONArray("modules");
                int n9 = 0;
                while (n9 < string2.length()) {
                    weaponGroupSpec = string2.getJSONObject(n9);
                    object = JSONObject.getNames((JSONObject)weaponGroupSpec)[0];
                    string = weaponGroupSpec.getString((java.lang.String)object);
                    this.stationModules.put((java.lang.String)object, string);
                    ++n9;
                }
            }
        }
        if ((jSONArray = jSONObject.optJSONArray("tags")) != null) {
            int n10 = 0;
            while (n10 < jSONArray.length()) {
                java.lang.String string6 = jSONArray.optString(n10);
                if (string6 != null && !string6.isBlank()) {
                    this.addTag(string6);
                }
                ++n10;
            }
        }
        this.mayAutoAssignWeapons = false;
    }

    public Map<java.lang.String, java.lang.String> getStationModules() {
        return this.stationModules;
    }

    public java.lang.String getStationModuleId(java.lang.String string) {
        return this.stationModules.get(string);
    }

    public boolean isGoalVariant() {
        return this.goalVariant;
    }

    public void setGoalVariant(boolean bl) {
        this.goalVariant = bl;
    }

    public VariantSource getSource() {
        return this.source;
    }

    public void setSource(VariantSource variantSource) {
        this.source = variantSource;
    }

    public java.lang.String getSourceDetail() {
        return this.sourceDetail;
    }

    public void setSourceDetail(java.lang.String string) {
        this.sourceDetail = string;
    }

    public boolean isStockVariant() {
        return this.source == VariantSource.STOCK;
    }

    public boolean isEmptyHullVariant() {
        boolean bl = false;
        for (java.lang.String string : this.hullMods) {
            if (this.hullSpec.isBuiltInMod(string)) continue;
            bl = true;
        }
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.wings.size()) {
            if (!this.hullSpec.isBuiltInWing(n2)) {
                bl2 = true;
            }
            ++n2;
        }
        return !bl && !bl2 && this.getNonBuiltInWeaponSlots().isEmpty() && this.source == VariantSource.HULL;
    }

    public boolean isCommonMissionVariant() {
        return this.source == VariantSource.MISSION_DESIGN;
    }

    public void setHullSpecAPI(ShipHullSpecAPI shipHullSpecAPI) {
        this.setHullSpec((g)shipHullSpecAPI);
    }

    public void setHullSpec(g g2) {
        this.hullSpec = g2;
        this.hullId = g2.getHullId();
        this.hasOpAffectingMods = null;
        for (java.lang.String string : g2.getBuiltInWeapons().keySet()) {
            java.lang.String string2 = g2.getBuiltInWeapons().get(string);
            BaseWeaponSpec baseWeaponSpec = SpecStore.o00000(BaseWeaponSpec.class, string2);
            this.addWeapon(string, baseWeaponSpec, true);
        }
        for (java.lang.String string : g2.getBuiltInMods()) {
            this.addMod(string);
        }
        int n2 = 0;
        for (java.lang.String string : g2.getBuiltInWings()) {
            this.setWingId(n2++, string);
        }
    }

    public void refreshBuiltInWings() {
        int n2 = 0;
        for (java.lang.String string : this.hullSpec.getBuiltInWings()) {
            this.setWingId(n2++, string);
        }
    }

    public void setHullVariantId(java.lang.String string) {
        this.hullVariantId = string;
    }

    public java.lang.String getFullDesignationForShip() {
        if (!this.getHullSpec().hasDesignation()) {
            if (!this.getHullSpec().hasHullName()) {
                return this.variantDisplayName;
            }
            return java.lang.String.valueOf(this.variantDisplayName) + " " + this.getHullSpec().getHullName();
        }
        java.lang.String string = this.getHullSpec().getDesignation();
        if (this.variantDisplayName.startsWith("damaged") || this.variantDisplayName.startsWith("Damaged")) {
            return java.lang.String.valueOf(this.variantDisplayName) + " " + string;
        }
        if (string.startsWith("Heavy ") || string.startsWith("Phase ") || string.startsWith("Dextral ") || string.startsWith("Sinistral ") || string.startsWith("Advanced ") || string.startsWith("Fast ") || string.startsWith("Light ")) {
            int n2 = string.indexOf(32);
            return java.lang.String.valueOf(string.substring(0, n2)) + " " + this.variantDisplayName + " " + string.substring(n2 + 1);
        }
        if (this.variantDisplayName.isEmpty()) {
            return string;
        }
        return java.lang.String.valueOf(this.variantDisplayName) + " " + string;
    }

    public java.lang.String getFullDesignationWithHullName() {
        if (this.isFighter()) {
            return this.getFullDesignationForFighter();
        }
        if (!this.getHullSpec().hasHullName()) {
            return this.getFullDesignationForShip();
        }
        if (!this.getHullSpec().hasDesignation()) {
            if (this.variantDisplayName.isEmpty()) {
                return this.getDesignation();
            }
            return java.lang.String.valueOf(this.variantDisplayName) + " " + this.getHullSpec().getHullName();
        }
        return this.getFullDesignationWithHullNameForShip();
    }

    public java.lang.String getFirstPartOfDesignation() {
        if (!this.getHullSpec().hasDesignation()) {
            return null;
        }
        java.lang.String string = this.getHullSpec().getDesignation();
        if (string.startsWith("Heavy ")) {
            return "Heavy";
        }
        if (string.startsWith("Light ")) {
            return "Light";
        }
        if (string.startsWith("Phase ")) {
            return "Phase";
        }
        if (string.startsWith("Dextral ")) {
            return "Dextral";
        }
        if (string.startsWith("Sinistral ")) {
            return "Sinistral";
        }
        if (string.startsWith("Advanced ")) {
            return "Advanced";
        }
        return null;
    }

    public java.lang.String getDesignation() {
        java.lang.String string = this.getHullSpec().getDesignation();
        return string;
    }

    public java.lang.String getLastPartOfDesignation() {
        if (!this.getHullSpec().hasDesignation()) {
            return null;
        }
        java.lang.String string = this.getHullSpec().getDesignation();
        if (string.startsWith("Heavy ") || string.startsWith("Light ") || string.startsWith("Dextral ") || string.startsWith("Sinistral ") || string.startsWith("Advanced ") || string.startsWith("Phase ")) {
            int n2 = string.indexOf(32);
            return string.substring(n2 + 1);
        }
        return string;
    }

    public java.lang.String getFullDesignationWithHullNameForShip() {
        if (this.isStation()) {
            return this.getHullSpec().getDesignation();
        }
        if (!this.getHullSpec().hasHullName()) {
            return this.getFullDesignationForShip();
        }
        java.lang.String string = this.getHullSpec().getHullNameWithDashClass();
        if (this.isEmptyHullVariant()) {
            return java.lang.String.valueOf(string) + " " + this.getHullSpec().getDesignation() + " Hull";
        }
        return java.lang.String.valueOf(string) + " " + this.getFullDesignationForShip();
    }

    public java.lang.String getFullDesignationForFighter() {
        if (!this.getHullSpec().hasDesignation()) {
            return java.lang.String.valueOf(this.getHullSpec().getHullName()) + " " + this.variantDisplayName + " Wing";
        }
        if (this.variantDisplayName.isEmpty()) {
            return java.lang.String.valueOf(this.hullSpec.getHullName()) + " Wing";
        }
        return java.lang.String.valueOf(this.hullSpec.getHullName()) + " " + this.variantDisplayName + " Wing";
    }

    public java.lang.String getWingTypeDesignationForFighter() {
        if (this.variantDisplayName.isEmpty()) {
            return "Wing";
        }
        return java.lang.String.valueOf(this.variantDisplayName) + " Wing";
    }

    public java.lang.String getHullVariantId() {
        return this.hullVariantId;
    }

    public List<WeaponGroupSpec> getWeaponGroups() {
        return this.weaponGroups;
    }

    public void addWeaponGroup(WeaponGroupSpec weaponGroupSpec) {
        if (weaponGroupSpec.getSlots().isEmpty()) {
            return;
        }
        this.weaponGroups.add(weaponGroupSpec);
    }

    public void addWeapon(java.lang.String string, java.lang.String string2) {
        this.addWeapon(string, com.fs.starfarer.loading.Q.String(string2));
    }

    public void addWeapon(java.lang.String string, BaseWeaponSpec baseWeaponSpec) {
        this.addWeapon(string, baseWeaponSpec, false);
    }

    public void addWeapon(java.lang.String string, BaseWeaponSpec baseWeaponSpec, boolean bl) {
        if (!bl && this.hullSpec.isBuiltIn(string)) {
            return;
        }
        this.weapons.put(string, baseWeaponSpec.getWeaponId());
    }

    public void clearSlot(java.lang.String string) {
        this.weapons.remove(string);
    }

    public g getHullSpec() {
        return this.hullSpec;
    }

    public BaseWeaponSpec getWeaponSpec(java.lang.String string) {
        if (string == null) {
            return null;
        }
        return SpecStore.o00000(BaseWeaponSpec.class, this.weapons.get(string));
    }

    public java.lang.String getWeaponId(java.lang.String string) {
        if (string == null) {
            return null;
        }
        if (!this.weapons.containsKey(string)) {
            return null;
        }
        return this.weapons.get(string);
    }

    public Collection<java.lang.String> getFittedWeaponSlots() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>();
        for (java.lang.String string : this.weapons.keySet()) {
            Y y2 = this.hullSpec.getWeaponSlot(string);
            if (y2 != null && y2.isDecorative()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public WeaponSlotAPI getSlot(java.lang.String string) {
        return this.hullSpec.getWeaponSlot(string);
    }

    public Collection<java.lang.String> getAllFittedSlots() {
        return this.weapons.keySet();
    }

    public List<java.lang.String> getNonBuiltInWeaponSlots() {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>(this.weapons.keySet());
        arrayList.removeAll(this.hullSpec.getBuiltInWeapons().keySet());
        return arrayList;
    }

    public int getNumFluxVents() {
        return this.numFluxVents;
    }

    public void setNumFluxVents(int n2) {
        this.numFluxVents = n2;
    }

    public int getNumFluxCapacitors() {
        return this.numFluxCapacitors;
    }

    public void setNumFluxCapacitors(int n2) {
        this.numFluxCapacitors = n2;
    }

    public java.lang.String getDisplayName() {
        return this.variantDisplayName;
    }

    public void setVariantDisplayName(java.lang.String string) {
        this.variantDisplayName = string;
    }

    public ShipAPI.HullSize getHullSize() {
        return this.hullSpec.getHullSize();
    }

    public boolean isFighter() {
        return this.hullSpec.getHullSize() == ShipAPI.HullSize.FIGHTER;
    }

    public static float computeVariantDiffCRImpact(CharacterStats characterStats, MutableShipStatsAPI mutableShipStatsAPI, float f2, HullVariantSpec hullVariantSpec, HullVariantSpec hullVariantSpec2) {
        float f3 = StarfarerSettings.float.String().getMalfunctionThreshold(null);
        float f4 = HullVariantSpec.computeVariantDiff(characterStats, hullVariantSpec, hullVariantSpec2, true);
        float f5 = HullVariantSpec.computeVariantDiff(characterStats, hullVariantSpec, hullVariantSpec2, false);
        float f6 = 1.0f;
        float f7 = hullVariantSpec2.getHullSpec().getOrdnancePoints(characterStats);
        if (f7 <= 0.0f) {
            return 0.0f;
        }
        float f8 = f4 / f7;
        float f9 = f5 / f7;
        float f10 = Math.max(0.0f, f2 - f3);
        f9 = Math.min(f10, f9);
        float f11 = Math.max(f8, f9);
        return f11 * f6;
    }

    public static float computeVariantDiff(CharacterStats characterStats, HullVariantSpec hullVariantSpec, HullVariantSpec hullVariantSpec2, boolean bl) {
        Object object;
        Object object2;
        java.lang.String string;
        float f2 = StarfarerSettings.\u00f600000("crLossMultForRefit");
        float f3 = StarfarerSettings.\u00f600000("crLossMultForRefitWeapons");
        float f4 = StarfarerSettings.\u00f600000("crLossMultForRefitHullmods");
        float f5 = 0.0f;
        for (Y y2 : hullVariantSpec.getHullSpec().getAllWeaponSlots()) {
            string = y2.getId();
            object2 = hullVariantSpec.getWeaponSpec(string);
            if (object2 == (object = hullVariantSpec2.getWeaponSpec(string))) continue;
            if (object2 != null) {
                f5 += ((BaseWeaponSpec)object2).getOrdnancePointCost(characterStats, hullVariantSpec.getStatsForOpCosts()) * f3;
                continue;
            }
            if (bl) continue;
            f5 += ((BaseWeaponSpec)object).getOrdnancePointCost(characterStats) * f3;
        }
        int n2 = 0;
        while (n2 < 20) {
            Iterator<public> iterator = hullVariantSpec.getWingId(n2);
            string = hullVariantSpec2.getWingId(n2);
            object2 = null;
            if (iterator != null && !((java.lang.String)((Object)iterator)).isEmpty()) {
                object2 = SpecStore.o00000(FighterWingSpec.class, (java.lang.String)((Object)iterator));
            }
            object = null;
            if (string != null && !string.isEmpty()) {
                object = SpecStore.o00000(FighterWingSpec.class, string);
            }
            if (iterator != string) {
                if (iterator != null) {
                    f5 += ((FighterWingSpec)object2).getOpCost(hullVariantSpec.getStatsForOpCosts()) * f3;
                } else if (!bl) {
                    f5 += ((FighterWingSpec)object).getOpCost(hullVariantSpec2.getStatsForOpCosts()) * f3;
                }
            }
            ++n2;
        }
        if (bl) {
            f5 += (float)Math.max(0, hullVariantSpec.getNumFluxCapacitors() - hullVariantSpec2.getNumFluxCapacitors());
            f5 += (float)Math.max(0, hullVariantSpec.getNumFluxVents() - hullVariantSpec2.getNumFluxVents());
        } else {
            f5 += (float)Math.abs(hullVariantSpec.getNumFluxCapacitors() - hullVariantSpec2.getNumFluxCapacitors());
            f5 += (float)Math.abs(hullVariantSpec.getNumFluxVents() - hullVariantSpec2.getNumFluxVents());
        }
        for (public public_ : hullVariantSpec.getAllMods()) {
            if (hullVariantSpec2.getHullMods().contains(public_.getId())) continue;
            f5 += (float)public_.getCostFor(hullVariantSpec.getHullSize()) * f4;
        }
        if (!bl) {
            for (public public_ : hullVariantSpec2.getAllMods()) {
                if (hullVariantSpec.getHullMods().contains(public_.getId())) continue;
                f5 += (float)public_.getCostFor(hullVariantSpec.getHullSize()) * f4;
            }
        }
        return f5 * f2;
    }

    public boolean isStation() {
        return this.hullSpec.getHints().contains(ShipHullSpecAPI.ShipTypeHints.STATION);
    }

    public java.lang.String getFighterNameWithoutWing() {
        if (this.variantDisplayName.isEmpty()) {
            return this.getHullSpec().getHullName();
        }
        return java.lang.String.valueOf(this.getHullSpec().getHullName()) + " " + this.getDisplayName();
    }

    public boolean hasDMods() {
        for (java.lang.String string : this.hullMods) {
            public public_ = SpecStore.o00000(public.class, string);
            if (!public_.hasTag("dmod")) continue;
            return true;
        }
        return false;
    }

    public boolean isDHull() {
        if (this.hullSpec.isRestoreToBase()) {
            return true;
        }
        for (java.lang.String string : this.hullMods) {
            public public_ = SpecStore.o00000(public.class, string);
            if (!public_.hasTag("dmod")) continue;
            return true;
        }
        return false;
    }

    public java.lang.String getOriginalVariant() {
        if (this.originalVariant == null && OoOO.String(this.hullVariantId)) {
            return this.hullVariantId;
        }
        return this.originalVariant;
    }

    public void setOriginalVariant(java.lang.String string) {
        this.originalVariant = string;
    }

    public void setModuleVariant(java.lang.String string, ShipVariantAPI shipVariantAPI) {
        if (shipVariantAPI == null) {
            if (this.moduleVariants != null) {
                this.moduleVariants.remove(string);
                if (this.moduleVariants.isEmpty()) {
                    this.moduleVariants = null;
                }
            }
            return;
        }
        if (shipVariantAPI.isStockVariant()) {
            if (this.moduleVariants != null) {
                this.moduleVariants.remove(string);
                boolean bl = false;
                for (HullVariantSpec hullVariantSpec : this.moduleVariants.values()) {
                    if (hullVariantSpec == null || hullVariantSpec.isStockVariant()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.moduleVariants = null;
                }
            }
            return;
        }
        if (this.moduleVariants == null) {
            this.moduleVariants = new HashMap<java.lang.String, HullVariantSpec>();
        }
        this.moduleVariants.put(string, (HullVariantSpec)shipVariantAPI);
        this.stationModules.put(string, shipVariantAPI.getHullVariantId());
    }

    public HullVariantSpec getModuleVariant(java.lang.String string) {
        if (this.moduleVariants == null || !this.moduleVariants.containsKey(string)) {
            for (java.lang.String string2 : this.getModuleSlots()) {
                if (!string2.equals(string)) continue;
                java.lang.String string3 = this.getStationModuleId(string);
                if (string3 == null) {
                    return null;
                }
                HullVariantSpec hullVariantSpec = SpecStore.o00000(HullVariantSpec.class, string3);
                return hullVariantSpec;
            }
            return null;
        }
        return this.moduleVariants.get(string);
    }

    public Map<java.lang.String, HullVariantSpec> getModuleVariants() {
        return this.moduleVariants;
    }

    public void setModuleVariants(Map<java.lang.String, HullVariantSpec> map) {
        this.moduleVariants = map;
    }

    public int getModuleIndex(java.lang.String string) {
        ArrayList<java.lang.String> arrayList = new ArrayList<java.lang.String>(this.stationModules.keySet());
        return arrayList.indexOf(string) + 1;
    }

    public Map<java.lang.String, java.lang.String> getWeapons() {
        return this.weapons;
    }

    public LinkedHashSet<java.lang.String> getSModdedBuiltIns() {
        return this.sModdedBuiltIns;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class o {
        static float[] String = new float[NUM_DIMENSIONS];
        public float[] \u00d300000 = new float[NUM_DIMENSIONS];
        public List<Y> \u00d200000 = new ArrayList<Y>();
        public List<BaseWeaponSpec> super = new ArrayList<BaseWeaponSpec>();
        public java.lang.String \u00d500000;

        static {
            o.String[HullVariantSpec.RANGE] = 0.025f;
            o.String[HullVariantSpec.FRONT] = 3.0f;
            o.String[HullVariantSpec.HARDPOINT] = 1.0f;
            o.String[HullVariantSpec.KINETIC] = 1.1f;
            o.String[HullVariantSpec.PD] = 7.0f;
            o.String[HullVariantSpec.ROCKET] = 3.0f;
            o.String[HullVariantSpec.MISSILE] = 6.0f;
            o.String[HullVariantSpec.LINKED] = 20.0f;
            o.String[HullVariantSpec.ALT] = 30.0f;
            o.String[HullVariantSpec.BEAM] = 1.0f;
            o.String[HullVariantSpec.BIGGEST] = 11.0f;
            o.String[HullVariantSpec.NO_MANUAL_FIRE] = 100.0f;
        }

        public void \u00d200000(o o2) {
            float f2 = this.\u00d200000.size();
            float f3 = o2.\u00d200000.size();
            this.\u00d200000.addAll(o2.\u00d200000);
            this.super.addAll(o2.super);
            int n2 = 0;
            while (n2 < this.\u00d300000.length) {
                this.\u00d300000[n2] = (this.\u00d300000[n2] * f2 + o2.\u00d300000[n2] * f3) / (f2 + f3);
                ++n2;
            }
            if (this.\u00d500000.isEmpty() && !o2.\u00d500000.isEmpty() || f3 > f2) {
                this.\u00d500000 = o2.\u00d500000;
            }
        }

        public o() {
        }

        public o(Y y2, BaseWeaponSpec baseWeaponSpec, WeaponAPI.WeaponSize weaponSize) {
            this.\u00d200000.add(y2);
            this.super.add(baseWeaponSpec);
            EnumSet<WeaponAPI.AIHints> enumSet = baseWeaponSpec.getAIHints();
            this.\u00d300000[HullVariantSpec.KINETIC] = baseWeaponSpec.getDamageType() == DamageType.KINETIC ? 1 : 0;
            this.\u00d300000[HullVariantSpec.PD] = enumSet.contains(WeaponAPI.AIHints.PD) ? 1 : 0;
            this.\u00d300000[HullVariantSpec.FRONT] = Misc.isInArc((float)y2.getAngle(), (float)(y2.getArc() * 0.95f), (float)0.0f) && this.\u00d300000[PD] <= 0.0f ? 1 : 0;
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE && baseWeaponSpec.getAIHints().contains(WeaponAPI.AIHints.DO_NOT_AIM)) {
                this.\u00d300000[HullVariantSpec.FRONT] = 1.0f;
            }
            this.\u00d300000[HullVariantSpec.HARDPOINT] = y2.isHardpoint() && this.\u00d300000[FRONT] > 0.0f ? 1 : 0;
            this.\u00d300000[HullVariantSpec.BIGGEST] = weaponSize.ordinal() <= baseWeaponSpec.getSize().ordinal() ? 1 : 0;
            if (this.\u00d300000[PD] > 0.0f) {
                int n2 = BIGGEST;
                this.\u00d300000[n2] = this.\u00d300000[n2] * 0.05f;
            }
            if (this.\u00d300000[BIGGEST] > 0.0f) {
                int n3 = HARDPOINT;
                this.\u00d300000[n3] = this.\u00d300000[n3] * 5.0f;
            }
            this.\u00d300000[HullVariantSpec.RANGE] = baseWeaponSpec.getMaxRange();
            if (this.\u00d300000[RANGE] > 2000.0f) {
                this.\u00d300000[HullVariantSpec.RANGE] = 2000.0f;
            }
            if (this.\u00d300000[PD] > 0.0f && baseWeaponSpec.getMaxRange() <= 500.0f) {
                this.\u00d300000[HullVariantSpec.RANGE] = 500.0f;
            }
            if (baseWeaponSpec.getType() == WeaponAPI.WeaponType.MISSILE) {
                if (!(baseWeaponSpec.getMaxAmmo() < 20 || enumSet.contains(WeaponAPI.AIHints.STRIKE) || enumSet.contains(WeaponAPI.AIHints.DO_NOT_AIM) || enumSet.contains(WeaponAPI.AIHints.GUIDED_POOR))) {
                    this.\u00d300000[HullVariantSpec.ROCKET] = 1.0f;
                } else {
                    this.\u00d300000[HullVariantSpec.MISSILE] = 1.0f;
                }
            }
            this.\u00d300000[HullVariantSpec.LINKED] = enumSet.contains(WeaponAPI.AIHints.GROUP_LINKED) ? 1 : 0;
            this.\u00d300000[HullVariantSpec.ALT] = enumSet.contains(WeaponAPI.AIHints.GROUP_ALTERNATING) ? 1 : 0;
            this.\u00d300000[HullVariantSpec.BEAM] = baseWeaponSpec.isBeam() ? 1.0f : 0.0f;
            this.\u00d300000[HullVariantSpec.NO_MANUAL_FIRE] = baseWeaponSpec.getAIHints().contains(WeaponAPI.AIHints.NO_MANUAL_FIRE) ? 1.0f : 0.0f;
            this.\u00d500000 = baseWeaponSpec.getWeaponGroupTag();
            if (this.\u00d500000 == null) {
                this.\u00d500000 = "";
            }
        }

        public float super(o o2) {
            float f2 = 0.0f;
            if (!this.\u00d500000.equals(o2.\u00d500000)) {
                f2 += 100000.0f;
            }
            int n2 = 0;
            while (n2 < this.\u00d300000.length) {
                f2 += Math.abs(this.\u00d300000[n2] - o2.\u00d300000[n2]) * String[n2];
                ++n2;
            }
            return f2;
        }

        public boolean super(HullVariantSpec hullVariantSpec) {
            boolean bl;
            if (this.super.size() == 1) {
                return false;
            }
            if (this.\u00d300000[ALT] > this.\u00d300000[LINKED]) {
                return true;
            }
            boolean bl2 = bl = this.\u00d300000[ROCKET] + this.\u00d300000[MISSILE] > 0.0f && this.\u00d300000[LINKED] <= 0.0f && this.\u00d300000[BEAM] <= 0.0f;
            if (!bl && this.\u00d300000[LINKED] <= 0.0f && this.\u00d300000[FRONT] >= 1.0f) {
                float f2 = 0.0f;
                for (BaseWeaponSpec baseWeaponSpec : this.super) {
                    float f3;
                    BaseWeaponSpec baseWeaponSpec2;
                    if (baseWeaponSpec instanceof Oo0O) {
                        baseWeaponSpec2 = (Oo0O)baseWeaponSpec;
                        int n2 = ((Oo0O)baseWeaponSpec2).getBurstSize();
                        if (((Oo0O)baseWeaponSpec2).isInterruptibleBurst()) {
                            n2 = 1;
                        }
                        f3 = ((Oo0O)baseWeaponSpec2).getChargeTime() * ((Oo0O)baseWeaponSpec2).getEnergyPerSecond() + ((Oo0O)baseWeaponSpec2).getEnergyPerShot() * (float)n2;
                        f2 += f3;
                        continue;
                    }
                    if (!(baseWeaponSpec instanceof ooOO) || !((ooOO)(baseWeaponSpec2 = (ooOO)baseWeaponSpec)).isBurstBeam()) continue;
                    float f4 = ((ooOO)baseWeaponSpec2).getBurstDuration() + ((ooOO)baseWeaponSpec2).getChargeupTime();
                    f3 = ((ooOO)baseWeaponSpec2).getEnergyPerSecond() * f4;
                    f2 += f3;
                }
                float f5 = (float)hullVariantSpec.getNumFluxCapacitors() * Ship.FLUX_PER_CAPACITOR;
                float f6 = (float)hullVariantSpec.getNumFluxVents() * Ship.DISSIPATION_PER_VENT;
                return f2 >= (f5 += hullVariantSpec.getHullSpec().getFluxCapacity()) * 0.33f + (f6 += hullVariantSpec.getHullSpec().getFluxDissipation()) * 1.0f;
            }
            return bl;
        }
    }
}

