/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.campaign;

import com.fs.starfarer.api.fleet.FleetMemberAPI;
import java.util.List;

public interface BuffManagerAPI {
    public Buff getBuff(String var1);

    public void addBuff(Buff var1);

    public void removeBuff(String var1);

    public void addBuffOnlyUpdateStat(Buff var1);

    public List<Buff> getBuffs();

    public void advance(float var1);

    public static interface Buff {
        public void apply(FleetMemberAPI var1);

        public String getId();

        public boolean isExpired();

        public void advance(float var1);
    }

    public static class TempBuff
    implements Buff {
        private Buff buff;
        private float dur;

        public TempBuff(Buff buff, float dur) {
            this.buff = buff;
            this.dur = dur;
        }

        @Override
        public void advance(float days) {
            this.dur -= days;
        }

        @Override
        public void apply(FleetMemberAPI member) {
            this.buff.apply(member);
        }

        @Override
        public String getId() {
            return this.buff.getId();
        }

        @Override
        public boolean isExpired() {
            return this.buff.isExpired() || this.dur <= 0.0f;
        }
    }
}

