/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.fleet.FleetGoal;

public class BattleCreationContext {
    private float initialStepSize = 1.0f;
    private float initialNumSteps = 0.0f;
    private float initialDeploymentBurnDuration = 1.0f;
    private float normalDeploymentBurnDuration = 6.0f;
    private float escapeDeploymentBurnDuration = 1.5f;
    private float standoffRange = 6000.0f;
    private float initialEscapeRange = Global.getSettings().getFloat("escapeStartDistance");
    private float flankDeploymentDistance = Global.getSettings().getFloat("escapeFlankDistance");
    private CampaignFleetAPI playerFleet;
    private FleetGoal playerGoal;
    private CampaignFleetAPI otherFleet;
    private FleetGoal otherGoal;
    private float pursuitRangeModifier = 0.0f;
    public float extraEnemyStandoffRange = 0.0f;
    private int playerCommandPoints = 0;
    public boolean aiRetreatAllowed = true;
    public boolean objectivesAllowed = true;
    public boolean forceObjectivesOnMap = false;
    public boolean enemyDeployAll = false;
    public boolean fightToTheLast = false;

    public BattleCreationContext(CampaignFleetAPI playerFleet, FleetGoal playerGoal, CampaignFleetAPI otherFleet, FleetGoal otherGoal) {
        this.playerFleet = playerFleet;
        this.playerGoal = playerGoal;
        this.otherFleet = otherFleet;
        this.otherGoal = otherGoal;
        if (otherFleet != null && otherFleet.getFaction() != null) {
            boolean ftl = otherFleet.getFaction().getCustomBoolean("fightToTheLast");
            if (otherFleet.getMemoryWithoutUpdate().contains("$core_fightToTheLast")) {
                ftl = otherFleet.getMemoryWithoutUpdate().getBoolean("$core_fightToTheLast");
            }
            this.fightToTheLast = ftl;
        }
    }

    public int getPlayerCommandPoints() {
        return this.playerCommandPoints;
    }

    public void setPlayerCommandPoints(int playerCommandPoints) {
        this.playerCommandPoints = playerCommandPoints;
    }

    public CampaignFleetAPI getPlayerFleet() {
        return this.playerFleet;
    }

    public FleetGoal getPlayerGoal() {
        return this.playerGoal;
    }

    public CampaignFleetAPI getOtherFleet() {
        return this.otherFleet;
    }

    public FleetGoal getOtherGoal() {
        return this.otherGoal;
    }

    public float getPursuitRangeModifier() {
        return this.pursuitRangeModifier;
    }

    public void setPursuitRangeModifier(float pursuitRangeModifier) {
        this.pursuitRangeModifier = pursuitRangeModifier;
    }

    public float getInitialDeploymentBurnDuration() {
        return this.initialDeploymentBurnDuration;
    }

    public void setInitialDeploymentBurnDuration(float initialDeploymentBurnDuration) {
        this.initialDeploymentBurnDuration = initialDeploymentBurnDuration;
    }

    public float getNormalDeploymentBurnDuration() {
        return this.normalDeploymentBurnDuration;
    }

    public void setNormalDeploymentBurnDuration(float normalDeploymentBurnDuration) {
        this.normalDeploymentBurnDuration = normalDeploymentBurnDuration;
    }

    public float getEscapeDeploymentBurnDuration() {
        return this.escapeDeploymentBurnDuration;
    }

    public void setEscapeDeploymentBurnDuration(float escapeDeploymentBurnDuration) {
        this.escapeDeploymentBurnDuration = escapeDeploymentBurnDuration;
    }

    public float getStandoffRange() {
        return this.standoffRange;
    }

    public void setStandoffRange(float standoffRange) {
        this.standoffRange = standoffRange;
    }

    public float getInitialEscapeRange() {
        return this.initialEscapeRange;
    }

    public void setInitialEscapeRange(float initialEscapeRange) {
        this.initialEscapeRange = initialEscapeRange;
    }

    public float getFlankDeploymentDistance() {
        return this.flankDeploymentDistance;
    }

    public void setFlankDeploymentDistance(float sideDeploymentDistance) {
        this.flankDeploymentDistance = sideDeploymentDistance;
    }

    public float getInitialStepSize() {
        return this.initialStepSize;
    }

    public void setInitialStepSize(float initialStepSize) {
        this.initialStepSize = initialStepSize;
    }

    public float getInitialNumSteps() {
        return this.initialNumSteps;
    }

    public void setInitialNumSteps(float initialNumSteps) {
        this.initialNumSteps = initialNumSteps;
    }

    public float getExtraEnemyStandoffRange() {
        return this.extraEnemyStandoffRange;
    }
}

