/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.BaseCampaignObjectivePlugin;
import com.fs.starfarer.api.impl.campaign.econ.CommRelayCondition;
import com.fs.starfarer.api.impl.campaign.intel.misc.CommSnifferIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;

public class CommRelayEntityPlugin
extends BaseCampaignObjectivePlugin {
    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    @Override
    public void advance(float amount) {
        if (this.entity.getContainingLocation() == null || this.entity.isInHyperspace()) {
            return;
        }
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) {
            return;
        }
        for (MarketAPI market : Misc.getMarketsInLocation(this.entity.getContainingLocation())) {
            CommRelayCondition mc = CommRelayCondition.get(market);
            if (mc == null) {
                market.addCondition("comm_relay");
                mc = CommRelayCondition.get(market);
            }
            if (mc == null) continue;
            mc.getRelays().add(this.entity);
        }
        this.checkIntelFromCommSniffer();
    }

    protected boolean isMakeshift() {
        return this.entity.hasTag("makeshift");
    }

    @Override
    public void printNonFunctionalAndHackDescription(TextPanelAPI text) {
        if (this.entity.getMemoryWithoutUpdate().getBoolean("$objectiveNonFunctional")) {
            text.addPara("This one, however, is not connected to the Sector-wide network and is not emitting the hyperwave radiation typically indicative of relay operation. The cause of its lack of function is unknown.");
        }
        if (this.isHacked().booleanValue()) {
            text.addPara("You have a comm sniffer running on this relay.");
        }
    }

    @Override
    public void printEffect(TooltipMakerAPI text, float pad) {
        int bonus = Math.abs(Math.round(CommRelayCondition.COMM_RELAY_BONUS));
        if (this.isMakeshift()) {
            bonus = Math.abs(Math.round(CommRelayCondition.MAKESHIFT_COMM_RELAY_BONUS));
        }
        text.addPara("      %s stability for same-faction colonies in system", pad, Misc.getHighlightColor(), "+" + bonus);
    }

    @Override
    public void addHackStatusToTooltip(TooltipMakerAPI text, float pad) {
        int bonus = Math.abs(Math.round(CommRelayCondition.COMM_RELAY_BONUS));
        if (this.isMakeshift()) {
            bonus = Math.abs(Math.round(CommRelayCondition.MAKESHIFT_COMM_RELAY_BONUS));
        }
        if (this.isHacked().booleanValue()) {
            text.addPara("%s stability for in-system colonies", pad, Misc.getHighlightColor(), "+" + bonus);
            text.addPara("Comm sniffer installed", Misc.getTextColor(), pad);
        } else {
            text.addPara("%s stability for same-faction colonies in-system", pad, Misc.getHighlightColor(), "+" + bonus);
        }
    }

    @Override
    public void setHacked(boolean hacked) {
        if (hacked) {
            boolean found;
            this.setHacked(hacked, -1.0f);
            boolean bl = found = CommSnifferIntel.getExistingSnifferIntelForRelay(this.entity) != null;
            if (!found) {
                CommSnifferIntel intel = new CommSnifferIntel(this.entity);
                InteractionDialogAPI dialog = Global.getSector().getCampaignUI().getCurrentInteractionDialog();
                if (dialog != null) {
                    Global.getSector().getIntelManager().addIntelToTextPanel(intel, dialog.getTextPanel());
                }
            }
        } else {
            this.setHacked(hacked, -1.0f);
        }
    }

    private void checkIntelFromCommSniffer() {
        if (!this.isHacked().booleanValue()) {
            return;
        }
        boolean playerInRelayRange = Global.getSector().getIntelManager().isPlayerInRangeOfCommRelay();
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getCommQueue()) {
            CommSnifferReadableIntel csi;
            if (!(intel instanceof CommSnifferReadableIntel) || !(csi = (CommSnifferReadableIntel)((Object)intel)).canMakeVisibleToCommSniffer(playerInRelayRange, this.entity)) continue;
            intel.setForceAddNextFrame(true);
        }
    }

    public static interface CommSnifferReadableIntel {
        public boolean canMakeVisibleToCommSniffer(boolean var1, SectorEntityToken var2);
    }
}

