/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.MarketImmigrationModifier;
import com.fs.starfarer.api.impl.campaign.econ.ResourceDepositsCondition;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.population.PopulationComposition;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import java.awt.Color;

public class Mining
extends BaseIndustry
implements MarketImmigrationModifier {
    protected boolean shownPlasmaNetVisuals = false;

    @Override
    public void apply() {
        super.apply(true);
        int size = this.market.getSize();
        this.demand("heavy_machinery", size - 3);
        this.demand("drugs", size);
        Pair<String, Integer> deficit = this.getMaxDeficit("heavy_machinery");
        this.applyDeficitToProduction(0, deficit, "ore", "rare_ore", "organics", "volatiles");
        if (!this.isFunctional()) {
            this.supply.clear();
        }
    }

    @Override
    public void unapply() {
        super.unapply();
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        Pair<String, Integer> deficit = this.getMaxDeficit("drugs");
        if ((Integer)deficit.two <= 0) {
            return false;
        }
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            Color h = Misc.getHighlightColor();
            float opad = 10.0f;
            float pad = 3.0f;
            Pair<String, Integer> deficit = this.getMaxDeficit("drugs");
            if ((Integer)deficit.two > 0) {
                tooltip.addPara(String.valueOf(Mining.getDeficitText("drugs")) + ": %s units. Reduced colony growth.", pad, h, "" + deficit.two);
            }
        }
    }

    @Override
    public boolean isAvailableToBuild() {
        if (!super.isAvailableToBuild()) {
            return false;
        }
        for (MarketConditionAPI mc : this.market.getConditions()) {
            String commodity = ResourceDepositsCondition.COMMODITY.get(mc.getId());
            if (commodity == null) continue;
            String industry = ResourceDepositsCondition.INDUSTRY.get(commodity);
            if (!this.getId().equals(industry)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUnavailableReason() {
        if (!super.isAvailableToBuild()) {
            return super.getUnavailableReason();
        }
        return "Requires resource deposits";
    }

    @Override
    public void modifyIncoming(MarketAPI market, PopulationComposition incoming) {
        Pair<String, Integer> deficit = this.getMaxDeficit("drugs");
        if ((Integer)deficit.two > 0) {
            incoming.getWeight().modifyFlat(this.getModId(), -((Integer)deficit.two).intValue(), "Mining: drug shortage");
        }
    }

    @Override
    public String getCurrentImage() {
        float size = this.market.getSize();
        if (this.market.getPlanetEntity() != null && this.market.getPlanetEntity().isGasGiant()) {
            return Global.getSettings().getSpriteName("industry", "mining_gas_giant");
        }
        if (size <= (float)SIZE_FOR_SMALL_IMAGE) {
            return Global.getSettings().getSpriteName("industry", "mining_low");
        }
        return super.getCurrentImage();
    }

    @Override
    public float getPatherInterest() {
        return 1.0f + super.getPatherInterest();
    }

    @Override
    protected boolean canImproveToIncreaseProduction() {
        return true;
    }

    public void applyVisuals(PlanetAPI planet) {
        if (planet == null) {
            return;
        }
        planet.getSpec().setShieldTexture2(Global.getSettings().getSpriteName("industry", "plasma_net_texture"));
        planet.getSpec().setShieldThickness2(0.15f);
        planet.getSpec().setShieldColor2(new Color(255, 255, 255, 255));
        planet.applySpecChanges();
        this.shownPlasmaNetVisuals = true;
    }

    public void unapplyVisuals(PlanetAPI planet) {
        if (planet == null) {
            return;
        }
        planet.getSpec().setShieldTexture2(null);
        planet.getSpec().setShieldThickness2(0.0f);
        planet.getSpec().setShieldColor2(null);
        planet.applySpecChanges();
        this.shownPlasmaNetVisuals = false;
    }

    @Override
    public void setSpecialItem(SpecialItemData special) {
        super.setSpecialItem(special);
        if (this.shownPlasmaNetVisuals && (special == null || !special.getId().equals("plasma_dynamo"))) {
            this.unapplyVisuals(this.market.getPlanetEntity());
        }
        if (special != null && special.getId().equals("plasma_dynamo")) {
            this.applyVisuals(this.market.getPlanetEntity());
        }
    }
}

