/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.graid;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.campaign.econ.CommodityIconCounts;
import com.fs.starfarer.api.impl.campaign.graid.BaseGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.graid.CommodityGroundRaidObjectivePluginImpl;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.loading.WithSourceMod;
import com.fs.starfarer.api.ui.IconGroupAPI;
import com.fs.starfarer.api.ui.IconRenderMode;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Iterator;
import java.util.Random;

public class ShipWeaponsGroundRaidObjectivePluginImpl
extends BaseGroundRaidObjectivePluginImpl {
    public static float CARGO_SPACE_PER_LARGE = 8.0f;
    public static float CARGO_SPACE_PER_MEDIUM = 4.0f;
    public static float CARGO_SPACE_PER_SMALL = 2.0f;
    public static float SELL_MULT = Global.getSettings().getFloat("shipWeaponSellPriceMult");
    public static float VALUE_NORMAL = 1.0f;
    public static float VALUE_EXCESS = 2.0f;
    public static float VALUE_DEFICIT = -1.0f;
    public static float VALUE_OVERALL = 1000.0f;
    protected CommodityOnMarketAPI com;
    protected CargoAPI looted = Global.getFactory().createCargo(true);

    public ShipWeaponsGroundRaidObjectivePluginImpl(MarketAPI market) {
        super(market, "ships");
        this.com = market.getCommodityData(this.id);
        this.setSource(CommodityGroundRaidObjectivePluginImpl.computeCommoditySource(market, this.com));
    }

    @Override
    public void addIcons(IconGroupAPI iconGroup) {
        CommodityIconCounts counts = new CommodityIconCounts(this.com);
        int deficit = counts.deficit;
        int available = Math.max(0, counts.available - counts.extra);
        int extra = counts.extra;
        if (available > 0) {
            iconGroup.addIconGroup("ship_weapons", IconRenderMode.NORMAL, available, null);
        }
        if (deficit > 0) {
            iconGroup.addIconGroup("ship_weapons", IconRenderMode.RED, deficit, null);
        }
        if (extra > 0) {
            iconGroup.addIconGroup("ship_weapons", IconRenderMode.GREEN, extra, null);
        }
    }

    @Override
    public int getProjectedCreditsValue() {
        return (int)this.getQuantity(this.getMarinesAssigned());
    }

    public CommoditySpecAPI getWeaponsCommoditySpec() {
        return Global.getSettings().getCommoditySpec("ship_weapons");
    }

    @Override
    public MarketCMD.RaidDangerLevel getDangerLevel() {
        MarketCMD.RaidDangerLevel danger = this.getWeaponsCommoditySpec().getBaseDanger();
        CommodityIconCounts counts = new CommodityIconCounts(this.com);
        if (counts.production >= counts.available) {
            danger = danger.prev();
        }
        if (counts.deficit > 0) {
            return danger.next();
        }
        if (counts.extra > 0) {
            return danger.prev();
        }
        if (this.source != null) {
            danger = this.source.adjustCommodityDangerLevel(this.id, danger);
        }
        return danger;
    }

    @Override
    public float getQuantitySortValue() {
        CommoditySpecAPI spec = this.getWeaponsCommoditySpec();
        float add = 0.0f;
        if (spec != null) {
            add = spec.getOrder();
        }
        return 1000000.0f + add;
    }

    @Override
    public String getQuantityString(int marines) {
        return "";
    }

    @Override
    public String getValueString(int marines) {
        int value = (int)this.getQuantity(Math.max(1, marines));
        return Misc.getDGSCredits(value);
    }

    @Override
    public int getValue(int marines) {
        return (int)this.getQuantity(marines);
    }

    @Override
    public float getQuantity(int marines) {
        float base = Math.round(this.getBaseRaidValue());
        return base * (float)marines;
    }

    public float getBaseRaidValue() {
        CommodityOnMarketAPI com = this.market.getCommodityData(this.id);
        float unit = 1.0f;
        CommodityIconCounts counts = new CommodityIconCounts(com);
        float result = 0.0f;
        result += (float)Math.max(0, counts.available - counts.extra) * unit * VALUE_NORMAL;
        result += (float)counts.extra * unit * VALUE_EXCESS;
        result += (float)counts.deficit * unit * VALUE_DEFICIT;
        if ((result *= VALUE_OVERALL) < 0.0f) {
            result = 0.0f;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.getWeaponsCommoditySpec().getName();
    }

    @Override
    public CargoStackAPI getStackForIcon() {
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, "ship_weapons", null);
        return stack;
    }

    @Override
    public String getCommodityIdForDeficitIcons() {
        return this.com.getId();
    }

    protected float getQMult(int tier) {
        if (tier <= 0) {
            return 0.0f;
        }
        if (tier <= 1) {
            return 0.25f;
        }
        if (tier <= 2) {
            return 0.5f;
        }
        return 0.75f;
    }

    @Override
    public int performRaid(CargoAPI loot, Random random, float lootMult, TextPanelAPI text) {
        int num;
        float val;
        int max;
        int min;
        float p;
        WithSourceMod spec;
        Object spec2;
        if (this.marinesAssigned <= 0) {
            return 0;
        }
        WeightedRandomPicker<Object> pickerW = new WeightedRandomPicker<Object>(random);
        WeightedRandomPicker<Object> pickerF = new WeightedRandomPicker<Object>(random);
        WeightedRandomPicker<HullModSpecAPI> pickerH = new WeightedRandomPicker<HullModSpecAPI>(random);
        WeightedRandomPicker<Iterator<String>> weaponSubset = new WeightedRandomPicker<Iterator<String>>(random);
        WeightedRandomPicker<Object> fighterSubset = new WeightedRandomPicker<Object>(random);
        String factionId = this.market.getFactionId();
        float quality = Misc.getShipQuality(this.market, factionId);
        FactionAPI faction = Global.getSector().getFaction(factionId);
        int maxTier = 0;
        if (this.market.getSize() >= 6) {
            maxTier = 1;
        }
        if (Misc.hasHeavyIndustry(this.market) || Misc.isMilitary(this.market)) {
            maxTier = 1000;
        }
        float numSmall = 0.0f;
        float numMedium = 0.0f;
        float numLarge = 0.0f;
        for (String id : faction.getKnownWeapons()) {
            spec2 = Global.getSettings().getWeaponSpec(id);
            switch (spec2.getSize()) {
                case LARGE: {
                    numLarge += 1.0f;
                    break;
                }
                case MEDIUM: {
                    numMedium += 1.0f;
                    break;
                }
                case SMALL: {
                    numSmall += 1.0f;
                }
            }
        }
        float numTotal = numSmall + numMedium + numLarge + 1.0f;
        for (String id : faction.getKnownWeapons()) {
            spec = Global.getSettings().getWeaponSpec(id);
            if (spec.getAIHints().contains((Object)WeaponAPI.AIHints.SYSTEM) || spec.getTier() > maxTier) continue;
            p = 1.0f * spec.getRarity() + quality * this.getQMult(spec.getTier());
            switch (spec.getSize()) {
                case LARGE: {
                    p *= 1.0f - numLarge / numTotal;
                    p *= 2.0f;
                    break;
                }
                case MEDIUM: {
                    p *= 1.0f - numMedium / numTotal;
                    p *= 3.0f;
                    break;
                }
                case SMALL: {
                    p *= 1.0f - numSmall / numTotal;
                    p *= 4.0f;
                }
            }
            pickerW.add(spec, p);
        }
        int i = 0;
        while (i < 4 + this.marinesAssigned) {
            spec2 = (WeaponSpecAPI)pickerW.pick();
            if (spec2 != null) {
                float w = pickerW.getWeight(spec2);
                weaponSubset.add((Iterator<String>)spec2, w);
                pickerW.remove(spec2);
            }
            ++i;
        }
        for (String id : faction.getKnownFighters()) {
            spec = Global.getSettings().getFighterWingSpec(id);
            if (spec.getTier() > maxTier) continue;
            p = 1.0f * spec.getRarity() + quality * this.getQMult(spec.getTier());
            pickerF.add(spec, p);
        }
        i = 0;
        while (i < 2 + this.marinesAssigned / 2) {
            spec2 = (FighterWingSpecAPI)pickerF.pick();
            if (spec2 != null) {
                float w = pickerF.getWeight(spec2);
                fighterSubset.add(spec2, w);
                pickerF.remove(spec2);
            }
            ++i;
        }
        for (String id : faction.getKnownHullMods()) {
            HullModSpecAPI spec3 = Global.getSettings().getHullModSpec(id);
            if (spec3.isHidden() || spec3.isAlwaysUnlocked() || spec3.hasTag("no_drop") || spec3.getTier() > maxTier) continue;
            p = 1.0f * spec3.getRarity();
            if (Global.getSector().getPlayerFaction().knowsHullMod(id)) {
                p *= 0.2f;
            }
            pickerH.add(spec3, p);
        }
        float targetValue = this.getQuantity(this.marinesAssigned);
        targetValue *= lootMult;
        float mult = 0.9f + random.nextFloat() * 0.2f;
        this.quantityLooted = (int)(targetValue *= mult);
        float weaponWeight = faction.getDoctrine().getWarships() + faction.getDoctrine().getPhaseShips();
        float fighterWeight = 1.0f + (float)faction.getDoctrine().getCarriers();
        float hullmodWeight = 1.0f + quality * 1.0f;
        float totalWeight = weaponWeight + fighterWeight + hullmodWeight;
        float weaponValue = targetValue * weaponWeight / totalWeight;
        float fighterValue = targetValue * fighterWeight / totalWeight;
        float hullmodValue = targetValue * hullmodWeight / totalWeight;
        float totalValue = 0.0f;
        this.looted.clear();
        int tries = 0;
        while (weaponValue > 0.0f && tries < 100) {
            ++tries;
            WeaponSpecAPI weapon = (WeaponSpecAPI)weaponSubset.pick();
            if (weapon == null) break;
            min = 1;
            max = 2;
            val = weapon.getBaseValue() * SELL_MULT;
            num = min + random.nextInt(max - min + 1);
            if ((num = (int)Math.min((float)num, weaponValue / val)) == 0 && random.nextFloat() < weaponValue / val) {
                num = 1;
            }
            if (num <= 0) break;
            this.looted.addWeapons(weapon.getWeaponId(), num);
            weaponValue -= val * (float)num;
            totalValue += val * (float)num;
        }
        fighterValue += Math.max(0.0f, weaponValue);
        tries = 0;
        while (fighterValue > 0.0f && tries < 100) {
            ++tries;
            FighterWingSpecAPI fighter = (FighterWingSpecAPI)fighterSubset.pick();
            if (fighter == null) break;
            min = 1;
            max = 2;
            switch (fighter.getRole()) {
                case BOMBER: 
                case ASSAULT: 
                case SUPPORT: {
                    min = 1;
                    max = 2;
                    break;
                }
                case FIGHTER: {
                    min = 1;
                    max = 3;
                    break;
                }
                case INTERCEPTOR: {
                    min = 1;
                    max = 4;
                }
            }
            val = fighter.getBaseValue() * SELL_MULT;
            num = min + random.nextInt(max - min + 1);
            num = (int)Math.min((float)num, fighterValue / val);
            if (num == 0 && random.nextFloat() < fighterValue / val) {
                num = 1;
            }
            if (num <= 0) break;
            this.looted.addFighters(fighter.getId(), num);
            fighterValue -= val * (float)num;
            totalValue += val * (float)num;
        }
        hullmodValue += Math.max(0.0f, fighterValue);
        tries = 0;
        while (hullmodValue > 0.0f && tries < 100) {
            ++tries;
            HullModSpecAPI mod = (HullModSpecAPI)pickerH.pickAndRemove();
            if (mod == null) break;
            float val2 = mod.getBaseValue();
            int num2 = 0;
            if (random.nextFloat() < hullmodValue / val2) {
                num2 = 1;
            }
            if (num2 <= 0) break;
            this.looted.addHullmods(mod.getId(), num2);
            hullmodValue -= val2 * (float)num2;
            totalValue += val2 * (float)num2;
        }
        loot.addAll(this.looted);
        this.xpGained = (int)(totalValue * 0.2f);
        return this.xpGained;
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI t, boolean expanded) {
        float opad = 10.0f;
        float pad = 3.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color good = Misc.getPositiveHighlightColor();
        CommodityOnMarketAPI com = this.market.getCommodityData("ships");
        t.addPara("Ship weapons, fighter LPCs, and hullmod specs. Availability is based on the \"" + com.getCommodity().getName() + "\" commodity.", 0.0f);
        t.addPara("The colony faction's doctrine affects the number of weapons vs fighter LPCs acquired. Higher ship quality increases the probability of finding modspecs..", opad);
        if (Misc.hasHeavyIndustry(this.market) || Misc.isMilitary(this.market)) {
            if (Misc.hasHeavyIndustry(this.market)) {
                t.addPara("This colony has heavy industry and high-tier equipment may be found.", good, opad);
            } else if (Misc.isMilitary(this.market)) {
                t.addPara("This colony has a military presence and high-tier equipment may be found.", good, opad);
            }
        } else {
            t.addPara("This colony does not have heavy industry or a military presence and has no access to high-tier ship equipment.", bad, opad);
        }
    }

    public CargoAPI getLooted() {
        return this.looted;
    }
}

