/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Set;

public class BreadcrumbIntelV2
extends FleetLogIntel {
    protected SectorEntityToken target;
    protected String title;
    protected String text;
    protected Boolean showSpecificEntity = null;

    public BreadcrumbIntelV2(SectorEntityToken target) {
        this.target = target;
        this.setRemoveTrigger(target);
    }

    @Override
    public void reportRemovedIntel() {
        super.reportRemovedIntel();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void createIntelInfo(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode) {
        Color c = this.getTitleColor(mode);
        info.addPara(this.getName(), c, 0.0f);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        info.addImage(Global.getSettings().getSpriteName("illustrations", "space_wreckage"), width, opad);
        info.addPara(this.text, opad);
        this.addLogTimestamp(info, tc, opad);
        this.addDeleteButton(info, width);
    }

    @Override
    public String getIcon() {
        return super.getIcon();
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        tags.remove("Fleet log");
        tags.add("Exploration");
        return tags;
    }

    @Override
    public String getSortString() {
        return super.getSortString();
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public FactionAPI getFactionForUIColors() {
        return super.getFactionForUIColors();
    }

    @Override
    public String getSmallDescriptionTitle() {
        return this.getName();
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        if (this.target.getStarSystem() != null && this.showSpecificEntity == null) {
            return this.target.getStarSystem().createToken(0.0f, 0.0f);
        }
        return this.target;
    }

    @Override
    public boolean shouldRemoveIntel() {
        return super.shouldRemoveIntel();
    }

    @Override
    public String getCommMessageSound() {
        if (this.sound != null) {
            return this.sound;
        }
        return BreadcrumbIntelV2.getSoundMinorMessage();
    }

    public Boolean getShowSpecificEntity() {
        return this.showSpecificEntity;
    }

    public void setShowSpecificEntity(Boolean showPlanet) {
        if (showPlanet != null && !showPlanet.booleanValue()) {
            showPlanet = null;
        }
        this.showSpecificEntity = showPlanet;
    }
}

