/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.ids.Voices;
import com.fs.starfarer.api.impl.campaign.missions.academy.GACelestialObject;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithBarEvent;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;

public class AngryVIPTransport
extends HubMissionWithBarEvent {
    public static float MISSION_DAYS = 75.0f;
    public static int MIN_VALUE = 24000;
    public static int MAX_VALUE = 36000;
    protected MarketAPI sourceMarket;
    protected MarketAPI destination_market;
    protected int quantity;
    protected String destinationId;
    protected GACelestialObject.Variation variation;
    protected PersonAPI person;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$avipt_ref", "$avipt_inProgress")) {
            return false;
        }
        if (createdAt == null) {
            return false;
        }
        if ("pirates".equals(createdAt.getFaction().getId())) {
            return false;
        }
        this.sourceMarket = createdAt;
        String[] planet_whitelist = new String[]{"eventide", "kazeron", "fikenhild", "culann_starforge", "eochu_bres", "eldfell", "salamanca", "yesod", "olinadu", "station_tse_enterprise", "coatl"};
        ArrayList<String> withoutSource = new ArrayList<String>();
        String[] stringArray = planet_whitelist;
        int n = planet_whitelist.length;
        int n2 = 0;
        while (n2 < n) {
            String curr = stringArray[n2];
            withoutSource.add(curr);
            ++n2;
        }
        if (!withoutSource.remove(this.sourceMarket.getId())) {
            return false;
        }
        this.destinationId = this.pickOne(withoutSource);
        if (this.destinationId == null) {
            System.out.print("AVIPT failed on destinationId");
            return false;
        }
        this.setGiverRank(Ranks.CITIZEN);
        this.setGiverPost(Ranks.ARISTOCRAT);
        this.findOrCreateGiver(createdAt, false, false);
        this.person = this.getPerson();
        if (this.person == null) {
            return false;
        }
        this.person.setVoice(Voices.ARISTO);
        if (!this.setPersonMissionRef(this.person, "$avipt_ref")) {
            return false;
        }
        this.setRepFactionChangesNone();
        this.setIconName("campaignMissions", "shuttle_vip");
        this.destination_market = Global.getSector().getEconomy().getMarket(this.destinationId);
        if (!this.setMarketMissionRef(this.destination_market, "$avipt_ref")) {
            return false;
        }
        this.makeImportant(this.destination_market, "$avipt_target", Stage.TRANSPORT);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.setStartingStage((Object)Stage.TRANSPORT);
        this.setSuccessStage((Object)Stage.COMPLETED);
        this.setFailureStage((Object)Stage.FAILED);
        this.setStageOnMemoryFlag((Object)Stage.COMPLETED, this.destination_market, "$avipt_completed");
        this.setNoAbandon();
        this.setTimeLimit((Object)Stage.FAILED, MISSION_DAYS, null, new Object[0]);
        this.setCreditReward(MIN_VALUE, MAX_VALUE);
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$avipt_barEvent", this.isBarEvent());
        this.set("$avipt_reward", Misc.getWithDGS(this.getCreditsReward()));
        this.set("$avipt_timelimit", Misc.getWithDGS(MISSION_DAYS));
        this.set("$avipt_manOrWoman", this.getPerson().getManOrWoman());
        this.set("$avipt_heOrShe", this.getPerson().getHeOrShe());
        this.set("$avipt_hisOrHer", this.getPerson().getHisOrHer());
        this.set("$avipt_himOrHer", this.getPerson().getHimOrHer());
        this.set("$avipt_HeOrShe", String.valueOf(this.getPerson().getHeOrShe().substring(0, 1).toUpperCase()) + this.getPerson().getHeOrShe().substring(1));
        this.set("$avipt_HisOrHer", String.valueOf(this.getPerson().getHisOrHer().substring(0, 1).toUpperCase()) + this.getPerson().getHisOrHer().substring(1));
        this.set("$avipt_HimOrHer", String.valueOf(this.getPerson().getHimOrHer().substring(0, 1).toUpperCase()) + this.getPerson().getHimOrHer().substring(1));
        this.set("$avipt_personName", this.getPerson().getNameString());
        this.set("$avipt_systemName", this.destination_market.getStarSystem().getNameWithLowercaseTypeShort());
        this.set("$avipt_marketName", this.destination_market.getName());
        this.set("$avipt_sourceName", this.sourceMarket.getName());
        this.set("$avipt_dist", this.getDistanceLY(this.destination_market));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TRANSPORT) {
            info.addPara("Transport an angry, yet wealthy, VIP to " + this.destination_market.getName() + " in the " + this.destination_market.getStarSystem().getNameWithLowercaseTypeShort() + ".", opad, h, Misc.getWithDGS(this.quantity));
            info.addPara("The VIP has made it clear that " + this.getPerson().getHeOrShe() + " is to arrive within " + MISSION_DAYS + " days.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TRANSPORT) {
            info.addPara("Transport an angry, yet wealthy, VIP to " + this.destination_market.getName() + " in the " + this.destination_market.getStarSystem().getNameWithLowercaseTypeShort(), pad, tc, h, Misc.getWithDGS(this.quantity));
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Angry VIP Transport";
    }

    public static enum Stage {
        TRANSPORT,
        COMPLETED,
        FAILED;

    }
}

